/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class RptAdjustContinueHisPlugin
extends AbstractBaseListPlugin {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(RptAdjustContinueHisPlugin.class);
    private static final String ctl_billlistap = "billlistap";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.addPackageDataListener(evt -> this.packData((PackageDataEvent)evt));
        billList.addSetFilterListener(this::setFilter);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("KEY_MODEL_ID", (String)this.getFormCustomParam("KEY_MODEL_ID"));
        this.refreshBillList();
    }

    private void refreshBillList() {
        List ids = (List)this.getFormCustomParam("asjustIds");
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        FilterParameter fp = new FilterParameter();
        if (ids != null && ids.size() > 0) {
            fp.setFilter(new QFilter("adjust.id", "in", (Object)ids));
        } else {
            fp.setFilter(new QFilter("1", "=", (Object)0));
        }
        billList.setFilterParameter(fp);
        billList.addPackageDataListener(e -> this.packData((PackageDataEvent)e));
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        List ids = (List)this.getFormCustomParam("asjustIds");
        List qFilters = e.getQFilters();
        if (ids != null && ids.size() > 0) {
            qFilters.add(new QFilter("adjust.id", "in", (Object)ids));
        } else {
            qFilters.add(new QFilter("1", "=", (Object)0));
        }
    }

    private void packData(PackageDataEvent e) {
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            String value;
            String key = ((ColumnDesc)e.getSource()).getKey();
            if ("sourceadjust.number".equals(key) || "sourceadjust.year.name".equals(key) || "sourceadjust.period.name".equals(key)) {
                String value2 = e.getRowData().getString(key);
                if (value2 == null) {
                    e.setFormatValue((Object)"");
                }
            } else if ("sourceadjust.name".equals(key) && (value = e.getRowData().getString(key)) == null) {
                e.setFormatValue((Object)ResManager.loadKDString((String)"\u5206\u5f55\u5df2\u88ab\u5220\u9664", (String)"RptAdjustContinueHisPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pkId = list.getFocusRowPkId();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_adjustcontinuehis", (String)"id,adjust.id,lastadjust.id,sourceadjust.id,createtime", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
        if (dynamicObject != null) {
            String fieldName;
            switch (fieldName = args.getFieldName()) {
                case "adjust_number": {
                    this.getView().returnDataToParent((Object)dynamicObject.getLong("adjust.id"));
                    this.getView().close();
                    break;
                }
                case "sourceadjust_number": {
                    this.getView().returnDataToParent((Object)dynamicObject.getLong("sourceadjust.id"));
                    this.getView().close();
                    break;
                }
            }
        }
    }
}

