/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustBaseEntry;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.model.AdjustTemplateModel;
import kd.fi.bcm.business.adjust.model.CommDimensionEntry;
import kd.fi.bcm.business.adjust.model.SpreadDimensionEntry;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.util.AdjustDimRedirectHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.BaseEditElement;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.PageBasicInfo;
import kd.fi.bcm.business.page.model.util.DragUtil;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.adjust.provider.AdjustDimensionScopeProvider;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class RptAdjustDimDesignPlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    private static final String COMMON_PANEL = "commompanel";
    private static final String SPREAD_PANEL = "spreadpanel";
    private static final String ADJUST_ID = "ADJUST_ID";
    private static final String COMMON_ELEMENT_JOIN = "COMMON_ELEMENT";
    private static final String SPREAD_ELEMENT_JOIN = "SPREAD_ELEMENT";
    private SpreadManager spread;
    private DynaEntityObject model;
    private AdjustOperationContext ctx;
    protected static final List<String> dimKeys = Collections.singletonList(DimTypesEnum.AUDITTRIAL.getNumber().toLowerCase(Locale.ENGLISH));
    public static final Set<String> COMMON_DIM_SET = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber().toLowerCase(Locale.ENGLISH), DimTypesEnum.YEAR.getNumber().toLowerCase(Locale.ENGLISH), DimTypesEnum.PERIOD.getNumber().toLowerCase(Locale.ENGLISH), DimTypesEnum.PROCESS.getNumber().toLowerCase(Locale.ENGLISH)});
    public static final Set<String> SPREAD_DIM_SET = Sets.newHashSet((Object[])new String[]{DimTypesEnum.ENTITY.getNumber().toLowerCase(Locale.ENGLISH), DimTypesEnum.ACCOUNT.getNumber().toLowerCase(Locale.ENGLISH)});
    private Map<String, Set<Long>> singleMemeber;

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_confirm");
        this.addF7SelectListener("bcm_mergenode");
    }

    private void addF7SelectListener(String ... f7Keys) {
        for (String f7Key : f7Keys) {
            BasedataEdit periodCol = (BasedataEdit)this.getControl(f7Key);
            if (periodCol == null) continue;
            periodCol.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void registerTreeF7() {
        HashMap map = new HashMap(16);
        Map<String, String> dimIgnoreCaseMap = DimensionUtil.getDimIgnoreCaseMapByModelId(this.getModelId());
        if (dimIgnoreCaseMap != null) {
            this.asMapF7toType(Lists.newArrayList(dimIgnoreCaseMap.keySet()), SingleF7TypeEnum.LEAF, map);
            this.asMapF7toType(Lists.newArrayList((Object[])new String[]{"bcm_mergenode"}), SingleF7TypeEnum.NOLEAF, map);
            this.initSingleMemberF7(map);
        }
    }

    private Pair<String, String> getDimSign(AdjustBaseEntry dim) {
        String sign = dim.getDimension().getNumber();
        String name = dim.getDimension().getName();
        if ("bcm_mergenode".equals(dim.getNumber())) {
            sign = dim.getNumber();
            name = ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"RptAdjustDimDesignPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return Pair.onePair((Object)sign.toLowerCase(Locale.ENGLISH), (Object)name);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isAdjustTemplate()) {
            String objString = (String)this.getFormCustomParam("adjusttmp_model");
            AdjustTemplateModel adjustTemplate = (AdjustTemplateModel)this.deSerializedBytes(objString);
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(adjustTemplate.getModelId()));
            this.getPageCache().put(ADJUST_ID, String.valueOf(adjustTemplate.getId()));
            this.buildAllData((DynaEntityObject)adjustTemplate);
        } else {
            String objString = (String)this.getFormCustomParam("adjust_model");
            AdjustModel adjust = (AdjustModel)this.deSerializedBytes(objString);
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(adjust.getModelId()));
            this.getPageCache().put(ADJUST_ID, String.valueOf(adjust.getId()));
            this.buildAllData((DynaEntityObject)adjust);
        }
        this.registerTreeF7();
        this.setDefaultValue();
    }

    private void setDefaultValue() {
        if (this.isAdjustPaperTemplate()) {
            this.getModel().setValue(DimTypesEnum.SCENARIO.getNumber(), null);
            this.getModel().setValue(DimTypesEnum.YEAR.getNumber(), null);
            this.getModel().setValue(DimTypesEnum.PERIOD.getNumber(), null);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject temp;
        super.propertyChanged(e);
        List<String> connonSignList = Arrays.asList(this.getCommonElementEntityJoin().split(";"));
        if (connonSignList.contains(e.getProperty().getName()) && AdjustDimRedirectHelper.isSupportRedirct((String)e.getProperty().getName()) && (temp = (DynamicObject)this.getModel().getValue(e.getProperty().getName())) != null) {
            String entityNumber = DimensionServiceHelper.getDimMembEntityNumByDimNum((String)e.getProperty().getName());
            IDNumberTreeNode node = AdjustDimRedirectHelper.getParentRedirectChildMember((long)this.getModelId(), (String)entityNumber, (DynamicObject)temp);
            if (node == IDNumberTreeNode.NotFoundTreeNode || !node.isLeaf()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u6210\u5458\u3002", (String)"RptAdjustDimDesignPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(e.getProperty().getName(), null);
            } else if (DimTypesEnum.MYCOMPANY.getNumber().equals(node.getDimNumber()) && SystemVarsEnum.isDimVarsByNumber((String)node.getNumber()) && !SystemVarsEnum.RELATE_ENTITY.getNumber().equals(node.getNumber())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u5458\u65e0\u6cd5\u7528\u4e8e\u5206\u5f55\u89e3\u6790\u3002", (String)"RptAdjustTemplateEditPlugin_54", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(e.getProperty().getName(), null);
            } else if (node.getId().longValue() != temp.getLong("id")) {
                this.getModel().setValue(e.getProperty().getName(), (Object)node.getId());
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String eventArgs = e.getEventArgs();
            Page page = this.getPage(this.getView());
            String[] msg = DragUtil.translateMessage((String)eventArgs);
            Element source = (Element)page.seaechSign(msg[1]);
            boolean success = this.rebuildPage(page, eventArgs);
            if (success) {
                this.batchSetStyle(page);
                this.setPage(this.getView(), page);
                DragUtil.allDrag((IFormView)this.getView(), (Page)page);
                String lowerCaseStr = "currency";
                if (lowerCaseStr.equals(msg[1])) {
                    BusinessTypeEnum buss = BusinessTypeEnum.searchByName((String)this.getView().getFormShowParameter().getCustomParam("bussinessType").toString());
                    QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId()).and("number", "=", (Object)(BusinessTypeEnum.RADJ == buss ? "DC" : "EC"));
                    DynamicObject memDim = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (memDim != null) {
                        this.setValue(msg[1], memDim.getLong("id"));
                    }
                } else if ("bcm_mergenode".equals(msg[1])) {
                    this.setValue("bcm_mergenode", this.getView().getFormShowParameter().getCustomParam("merge"));
                } else if (source.getArea().getSign().equals(COMMON_PANEL)) {
                    this.singleMemeber = this.findSingleMember();
                    if (this.singleMemeber.get(msg[1]) != null && !this.singleMemeber.get(msg[1]).isEmpty()) {
                        this.setValue(msg[1], this.singleMemeber.get(msg[1]).iterator().next());
                    } else {
                        DynamicObject member = (DynamicObject)this.getValue(msg[1]);
                        if (member != null && msg[1].equalsIgnoreCase(member.getString("number"))) {
                            this.getModel().getDataEntity().set(msg[1], null);
                            this.getView().updateView(msg[1]);
                        }
                    }
                } else if (source.getArea().getSign().equals(SPREAD_PANEL)) {
                    this.setSpreadMemberDefaultValue(this.getAdjustModel().getSpreadDimensionEntries());
                }
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_confirm".equals(key)) {
            if (!this.checkCommonElement()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u7528\u7ef4\u6240\u6709\u7ef4\u5ea6\u5747\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptAdjustDimDesignPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.checkDimSettingChange()) {
                this.getView().returnDataToParent((Object)this.getReturnParentData());
            }
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "btn_ok": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.getView().returnDataToParent((Object)this.getReturnParentData());
                }
                this.getView().close();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }

    private void buildAllData(DynaEntityObject dynaEntityObject) {
        List spreadDimensionEntryList;
        List commDimensionEntryList;
        long modelId = 0L;
        if (this.isAdjustTemplate()) {
            AdjustTemplateModel adjustTemplateModel = (AdjustTemplateModel)dynaEntityObject;
            commDimensionEntryList = adjustTemplateModel.getCommDimensionEntries();
            spreadDimensionEntryList = adjustTemplateModel.getSpreadDimensionEntries();
            modelId = adjustTemplateModel.getModelId();
        } else {
            Optional<SpreadDimensionEntry> first1;
            kd.fi.bcm.business.template.model.Dimension dimension2;
            AdjustModel adjustModel = (AdjustModel)dynaEntityObject;
            commDimensionEntryList = adjustModel.getCommDimensionEntries();
            spreadDimensionEntryList = adjustModel.getSpreadDimensionEntries();
            modelId = adjustModel.getModelId();
            if (commDimensionEntryList != null) {
                Optional<CommDimensionEntry> first = commDimensionEntryList.stream().filter(commonDim -> DimTypesEnum.AUDITTRIAL.getNumber().equals(commonDim.getDimension().getNumber())).findFirst();
                if (first.isPresent()) {
                    CommDimensionEntry commDimensionEntry = first.get();
                    dimension2 = commDimensionEntry.getDimension();
                    this.getPageCache().put(DimTypesEnum.AUDITTRIAL.getNumber(), this.toByteSerialized(dimension2));
                }
            } else if (spreadDimensionEntryList != null && (first1 = spreadDimensionEntryList.stream().filter(dimension -> DimTypesEnum.AUDITTRIAL.getNumber().equals(dimension.getDimension().getNumber())).findFirst()).isPresent()) {
                SpreadDimensionEntry spreadDimensionEntry = first1.get();
                dimension2 = spreadDimensionEntry.getDimension();
                this.getPageCache().put(DimTypesEnum.AUDITTRIAL.getNumber(), this.toByteSerialized(dimension2));
            }
        }
        Map userDefineDimSet = AdjustmentServiceHelper.getUserDefineDimSet((long)modelId, (Object)dynaEntityObject.getPermClass());
        Page page = new Page();
        page.setChangeable(true);
        Area commonArea = new Area(COMMON_PANEL);
        Style style = this.getF7Style();
        if (commDimensionEntryList != null) {
            for (CommDimensionEntry commonDim2 : commDimensionEntryList) {
                kd.fi.bcm.business.template.model.Dimension dimension3 = commonDim2.getDimension();
                Pair<String, String> signPair = this.getDimSign((AdjustBaseEntry)commonDim2);
                BaseEditElement f7 = new BaseEditElement((String)signPair.p2, (String)signPair.p1, dimension3.getMemberEntityNumber());
                f7.setFieldTextAlign("center");
                f7.setHeight(new LocaleString("40px"));
                f7.addUserObject("dimId", (Object)dimension3.getId());
                f7.addUserObject("memberEntity", (Object)dimension3.getMemberEntityNumber());
                f7.setTextAlign("left");
                f7.setStyle(style);
                if (((Boolean)((Pair)userDefineDimSet.get((Object)dimension3.getNumber())).p1).booleanValue()) {
                    f7.setVisible("");
                }
                f7.addUserObject("id", (Object)commonDim2.getId());
                commonArea.addElement((Element)f7);
            }
        }
        page.addArea(commonArea);
        Area spreadArea = new Area(SPREAD_PANEL);
        if (spreadDimensionEntryList != null) {
            for (SpreadDimensionEntry spreadDim : spreadDimensionEntryList) {
                kd.fi.bcm.business.template.model.Dimension dimension4 = spreadDim.getDimension();
                Pair<String, String> signPair = this.getDimSign((AdjustBaseEntry)spreadDim);
                BaseEditElement f7 = new BaseEditElement((String)signPair.p2, (String)signPair.p1, dimension4.getMemberEntityNumber());
                f7.setFieldTextAlign("center");
                f7.setHeight(new LocaleString("40px"));
                f7.addUserObject("id", (Object)spreadDim.getId());
                f7.addUserObject("dimId", (Object)dimension4.getId());
                f7.addUserObject("memberEntity", (Object)dimension4.getMemberEntityNumber());
                f7.setTextAlign("left");
                f7.setStyle(style);
                if (((Boolean)((Pair)userDefineDimSet.get((Object)dimension4.getNumber())).p1).booleanValue()) {
                    f7.setVisible("");
                }
                spreadArea.addElement((Element)f7);
            }
        }
        page.addArea(spreadArea);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        DragUtil.allDrag((IFormView)this.getView(), (Page)page);
        this.cacheCommonElementJoin();
        this.cacheSpreadElementJoin();
        if (commDimensionEntryList != null) {
            this.setCommonDimMemberDefaultValue(commDimensionEntryList);
        }
        if (spreadDimensionEntryList != null) {
            this.setSpreadMemberDefaultValue(spreadDimensionEntryList);
        }
    }

    private void setCommonDimMemberDefaultValue(List<CommDimensionEntry> commDimensionEntryList) {
        for (CommDimensionEntry commonDim : commDimensionEntryList) {
            kd.fi.bcm.business.template.model.Dimension dimension = commonDim.getDimension();
            String dimNumber = dimension.getNumber();
            String sign = (String)this.getDimSign((AdjustBaseEntry)commonDim).p1;
            String entity = dimension.getMemberEntityNumber();
            Member member = commonDim.getMember();
            Object memberId = member == null ? null : member.get("id");
            this.setValue(sign, memberId);
            if (this.isAdjustTemplate()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{sign});
                continue;
            }
            if (COMMON_DIM_SET.contains(dimNumber.toLowerCase(Locale.ENGLISH))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{sign});
                continue;
            }
            if ("Currency".equalsIgnoreCase(dimNumber)) {
                String bussnesstype = this.isAdjustTemplate() ? this.getAdjustPaperTemplate().getBussnesstype() : this.getAdjustModel().getBussnesstype();
                this.getView().setEnable(Boolean.valueOf(BusinessTypeEnum.RADJ.getName().equals(bussnesstype)), new String[]{sign});
                continue;
            }
            if ("bcm_mergenode".equals(sign) && !ConfigServiceHelper.isHwApp()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{sign});
                continue;
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{sign});
        }
    }

    private void setSpreadMemberDefaultValue(List<SpreadDimensionEntry> spreadDimensionEntryList) {
        for (SpreadDimensionEntry spreadDim : spreadDimensionEntryList) {
            kd.fi.bcm.business.template.model.Dimension dimension = spreadDim.getDimension();
            String dimNumber = dimension.getNumber();
            String sign = (String)this.getDimSign((AdjustBaseEntry)spreadDim).p1;
            String entity = dimension.getMemberEntityNumber();
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId()).and("number", "=", (Object)dimNumber);
            DynamicObject memDim = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"id,name,number", (QFilter[])new QFilter[]{qFilter});
            if (memDim != null) {
                long memberId = memDim.getLong("id");
                this.setValue(sign, memberId);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{sign});
        }
    }

    private boolean isCanDrop(String sign, String signName, String sourcePanel, String targetPanel) {
        if (!sourcePanel.equals(targetPanel)) {
            if (COMMON_PANEL.equals(targetPanel)) {
                if (SPREAD_DIM_SET.contains(sign)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ef4\u5ea6\u4e0d\u53ef\u62d6\u5230\u901a\u7528\u7ef4\u5ea6\u3002", (String)"RptAdjustDimDesignPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (!this.isSingleMemeber(sign)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5c06\u201c%s\u201d\u79fb\u52a8\u5230\u9875\u9762\u7ef4\uff0c\u8bf7\u786e\u4fdd\u6240\u6709\u884c\u4e2d\u662f\u76f8\u540c\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"RptAdjustDimDesignPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), signName));
                    return false;
                }
            } else if (COMMON_DIM_SET.contains(sign) || "bcm_mergenode".equals(sign) && !ConfigServiceHelper.isHwApp()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ef4\u5ea6\u4e0d\u53ef\u62d6\u5230\u8868\u683c\u5185\u7ef4\u5ea6\u3002", (String)"RptAdjustDimDesignPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private Map<String, Set<Long>> findSingleMember() {
        if (this.singleMemeber == null) {
            String singleMemCache = this.getPageCache().get("singleMemCache");
            if (StringUtils.isNotEmpty((String)singleMemCache)) {
                this.singleMemeber = (Map)this.deSerializedBytes(singleMemCache);
            } else {
                this.singleMemeber = new HashMap<String, Set<Long>>();
                SchemeContext ctx = new SchemeContext(this.getAdjustModel().getModelId());
                Sheet effectSheet = this.getEffectSheet();
                if (effectSheet != null) {
                    Map<String, Integer> indexMap = AdjustModelUtil.createOrGetIndexMap(effectSheet);
                    if (effectSheet.getTable().size() > 1) {
                        int maxRow = effectSheet.getMaxRowCount();
                        ctx.getDimensions().forEach(dimension -> {
                            Integer dimIndex = (Integer)indexMap.get(dimension.getNumber());
                            if (dimIndex != null) {
                                this.singleMemeber.put(dimension.getNumber().toLowerCase(Locale.ENGLISH), new HashSet());
                                for (int i = 1; i <= maxRow; ++i) {
                                    long membid;
                                    Cell cell = effectSheet.getCell(i, dimIndex.intValue());
                                    long l = membid = cell.getUserObject("membid") == null ? 0L : (Long)cell.getUserObject("membid");
                                    if (membid == 0L) continue;
                                    this.singleMemeber.get(dimension.getNumber().toLowerCase(Locale.ENGLISH)).add(membid);
                                    if (!dimension.getNumber().equalsIgnoreCase("entity") || indexMap.get("bcm_mergenode") == null) continue;
                                    cell = effectSheet.getCell(i, ((Integer)indexMap.get("bcm_mergenode")).intValue());
                                    membid = cell.getUserObject("membid") == null ? 0L : (Long)cell.getUserObject("membid");
                                    this.singleMemeber.putIfAbsent("bcm_mergenode", new HashSet());
                                    this.singleMemeber.get("bcm_mergenode").add(membid);
                                }
                            }
                        });
                    }
                }
            }
        }
        return this.singleMemeber;
    }

    private boolean isSingleMemeber(String sign) {
        this.singleMemeber = this.findSingleMember();
        return !this.singleMemeber.containsKey(sign) || this.singleMemeber.get(sign).size() < 2;
    }

    private void batchSetStyle(Page page) {
        Style f7Style = this.getF7Style();
        page.getAreaList().forEach(a -> a.getElementListList().forEach(e -> e.setStyle(f7Style)));
        page.updatePage(this.getView());
    }

    private Style getF7Style() {
        Style style = new Style();
        Margin margin = new Margin();
        Padding padding = new Padding();
        padding.setRight("14px");
        padding.setLeft("14px");
        padding.setTop("14px");
        margin.setLeft("10px");
        margin.setRight("1px");
        margin.setTop("1px");
        margin.setBottom("10px");
        style.setMargin(margin);
        style.setPadding(padding);
        return style;
    }

    private boolean rebuildPage(Page page, String command) {
        Area targetArea;
        String[] msg = DragUtil.translateMessage((String)command);
        PageBasicInfo target = page.seaechSign(msg[0]);
        Element source = (Element)page.seaechSign(msg[1]);
        String dropSign = source.getSign();
        Area sourceArea = source.getArea();
        boolean targetIsArea = true;
        if (target instanceof Area) {
            targetArea = (Area)target;
        } else {
            targetArea = ((Element)target).getArea();
            targetIsArea = false;
        }
        String sourceAreaSign = sourceArea.getSign();
        String targetAreaSign = targetArea.getSign();
        boolean canDrop = this.isCanDrop(dropSign, source.getName(), sourceAreaSign, targetAreaSign);
        if (canDrop) {
            targetArea.getElementListList().remove(source);
            sourceArea.removeElememt(dropSign);
            if (targetIsArea) {
                targetArea.addElement(source);
            } else {
                int index = targetArea.getElementListList().indexOf(target);
                source.setArea(targetArea);
                targetArea.getElementListList().add(index, source);
            }
            boolean isCommonSource = sourceAreaSign.equals(COMMON_PANEL);
            this.rebuildAdjustModel(isCommonSource ? sourceArea : targetArea, isCommonSource ? targetArea : sourceArea);
            if (COMMON_PANEL.equals(targetAreaSign)) {
                BusinessTypeEnum buss = BusinessTypeEnum.searchByName((String)this.getView().getFormShowParameter().getCustomParam("bussinessType").toString());
                if (COMMON_DIM_SET.contains(dropSign) || BusinessTypeEnum.RADJ != buss && DimTypesEnum.CURRENCY.getNumber().toLowerCase(Locale.ENGLISH).equals(dropSign)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{dropSign});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{dropSign});
                }
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{dropSign});
            }
        }
        return true;
    }

    private DynaEntityObject getReturnParentData() {
        Page page = this.getPage(this.getView());
        Area commonArea = page.findAreaBySign(COMMON_PANEL);
        List commonElementList = commonArea.getElementListList();
        Area spreadArea = page.findAreaBySign(SPREAD_PANEL);
        List spreadElementList = spreadArea.getElementListList();
        if (this.isAdjustTemplate()) {
            String objString = (String)this.getFormCustomParam("adjusttmp_model");
            AdjustTemplateModel adjustTemplate = (AdjustTemplateModel)this.deSerializedBytes(objString);
            List<CommDimensionEntry> commDimensionEntryList = this.genCommDimensionEntry((DynaEntityObject)adjustTemplate, commonElementList);
            List<SpreadDimensionEntry> spreadDimensionEntryList = this.genSpreadDimensionEntry((DynaEntityObject)adjustTemplate, spreadElementList);
            adjustTemplate.getCommDimensionEntries().clear();
            adjustTemplate.getCommDimensionEntries().addAll(commDimensionEntryList);
            adjustTemplate.getSpreadDimensionEntries().clear();
            adjustTemplate.getSpreadDimensionEntries().addAll(spreadDimensionEntryList);
            return adjustTemplate;
        }
        this.rebuildAdjustModel(commonArea, spreadArea);
        return this.getAdjustModel();
    }

    private void rebuildAdjustModel(Area commonArea, Area spreadArea) {
        List commonElementList = commonArea.getElementListList();
        List spreadElementList = spreadArea.getElementListList();
        List<CommDimensionEntry> commDimensionEntryList = this.genCommDimensionEntry((DynaEntityObject)this.getAdjustModel(), commonElementList);
        List<SpreadDimensionEntry> spreadDimensionEntryList = this.genSpreadDimensionEntry((DynaEntityObject)this.getAdjustModel(), spreadElementList);
        this.getAdjustModel().getCommDimensionEntries().clear();
        this.getAdjustModel().getCommDimensionEntries().addAll(commDimensionEntryList);
        this.getAdjustModel().getSpreadDimensionEntries().clear();
        this.getAdjustModel().getSpreadDimensionEntries().addAll(spreadDimensionEntryList);
        this.cacheAdjustModel(this.getAdjustModel());
    }

    @SDKMark
    private void dealSpecialDimensionFilter(String number, QFilter qf) {
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        this.getBcmControl(e);
        String f7Key = e.getKey().toLowerCase(Locale.ENGLISH);
        String pageKey = e.getKey().toLowerCase(Locale.ENGLISH);
        List<String> connonSignList = Arrays.asList(this.getCommonElementEntityJoin().split(";"));
        if (connonSignList.contains(f7Key)) {
            BasedataEditSingleMemberF7 f7 = null;
            if (this.isAdjustTemplate() || this.isAdjustPaperTemplate()) {
                f7 = SingleMemberF7Util.getBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), f7Key, pageKey, ev -> this.getSingleMemberF7Handle(Lists.newArrayList(this.getDimKeysFromCache().keySet())).beforeSingleMemberF7Select(ev), false, "bcm_mergenode".equals(f7Key) ? SingleF7TypeEnum.NOLEAF : AdjustDimRedirectHelper.getSingeF7Type((String)f7Key));
                if ("mycompany".equals(f7Key)) {
                    f7.setSystemVariables(SystemVarsEnum.getAdjustVars());
                }
                HashMap<String, Object> customParam = new HashMap<String, Object>(16);
                String entity = DimensionUtil.getDimMembEntityNumByDimNum(f7Key);
                if ("bcm_mergenode".equals(f7Key)) {
                    f7.setType(SingleF7TypeEnum.NOLEAF);
                    entity = "bcm_entitymembertree";
                    f7.setEntity(entity);
                    f7.setDimNumber("Entity");
                    f7.setCustomFilter(new QFilter("isleaf", "=", (Object)"0"));
                    customParam.put("cslscheme", this.getView().getFormShowParameter().getCustomParam("cslscheme"));
                    customParam.put("enableScheme", false);
                    customParam.put("periodId", this.getView().getFormShowParameter().getCustomParam("periodId"));
                    customParam.put("yearNum", this.getView().getFormShowParameter().getCustomParam("yearNum"));
                } else if (f7Key.equals(DimTypesEnum.AUDITTRIAL.getNumber().toLowerCase(Locale.ENGLISH))) {
                    QFilter qf2 = new QFilter("model", "=", (Object)this.getModelId());
                    qf2.and("isleaf", "=", (Object)"1");
                    qf2.and("datasource", "=", (Object)"3");
                    QFilter[] filters = new QFilter[]{qf2};
                    DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_audittrialmembertree", (String)"id,parent", (QFilter[])filters);
                    ArrayList<Long> idList = new ArrayList<Long>(10);
                    if (null != data && data.size() > 0) {
                        for (int i = 0; i < data.size(); ++i) {
                            this.getALLParent(idList, (DynamicObject)data.get(i));
                        }
                    }
                    HashSet result = new HashSet(idList);
                    customParam.put("fifterId", new ArrayList(result));
                    customParam.put("ifFifterDataSource", "true");
                }
                f7.setEntity(entity);
                f7.setCustomData(customParam);
            } else {
                Dimension dim = this.getCtx().getSctx().getDimensionByNumber("bcm_mergenode".equals(f7Key) ? "Entity" : f7Key);
                f7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dim.getId(), f7Key, this, false, AdjustDimRedirectHelper.getSingeF7Type((String)dim.getNumber()));
                f7.setCustomFilter(AdjustDimensionScopeProvider.getManualDimensionScopeQFilter(this.getCtx(), this.getAdjustModel(), dim.getId(), false, true, qf -> this.dealSpecialDimensionFilter(dim.getNumber(), (QFilter)qf)));
                if ("MyCompany".equals(dim.getNumber())) {
                    f7.setSystemVariables(SystemVarsEnum.getAdjustVars());
                }
                f7.setEntity(dim.getEntity());
            }
            f7.setDisplayProp("name");
            e.setControl((Control)f7);
        }
    }

    public AdjustOperationContext getCtx() {
        if (this.ctx == null) {
            try {
                this.ctx = (AdjustOperationContext)SerializationUtils.deSerializeFromBase64((String)((String)this.getFormCustomParam("ctx")));
            }
            catch (Throwable t) {
                if (this.isAdjustPaperTemplate()) {
                    this.ctx = new AdjustOperationContext(Long.valueOf(this.getAdjustPaperTemplate().getModelId()));
                }
                this.ctx = new AdjustOperationContext(Long.valueOf(0L));
            }
        }
        return this.ctx;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        super.beforeF7Select(arg0);
        if (arg0.getSource() instanceof BasedataEditSingleMemberF7) {
            BasedataEditSingleMemberF7 sf7 = (BasedataEditSingleMemberF7)((Object)arg0.getSource());
            arg0.getCustomQFilters().add(AdjustDimensionScopeProvider.getManualDimensionScopeQFilter(this.getCtx(), this.getAdjustModel(), sf7.getDimId(), true, false, qf -> this.dealSpecialDimensionFilter(sf7.getDimNumber(), (QFilter)qf)));
        }
    }

    void getALLParent(List<Long> idList, DynamicObject data) {
        Long id = data.getLong("id");
        Long parentId = data.getLong("parent");
        idList.add(id);
        if (parentId != 0L) {
            idList.add(parentId);
            QFilter qf = new QFilter("id", "=", (Object)parentId);
            QFilter[] filters = new QFilter[]{qf};
            DynamicObject parentData = QueryServiceHelper.queryOne((String)"bcm_audittrialmembertree", (String)"id,parent", (QFilter[])filters);
            this.getALLParent(idList, parentData);
        }
    }

    private List<CommDimensionEntry> genCommDimensionEntry(DynaEntityObject dynaEntityObject, List<Element> commonElementList) {
        ArrayList<CommDimensionEntry> commDimensionEntryList = new ArrayList<CommDimensionEntry>(16);
        for (int i = 0; i < commonElementList.size(); ++i) {
            Element element = commonElementList.get(i);
            CommDimensionEntry entry = new CommDimensionEntry(dynaEntityObject);
            entry.setId(((Long)element.getUserObject("id")).longValue());
            entry.setSeq(i + 1);
            kd.fi.bcm.business.template.model.Dimension dimension = new kd.fi.bcm.business.template.model.Dimension();
            DynamicObject dimDy = BusinessDataServiceHelper.loadSingle((Object)element.getUserObject("dimId"), (String)"bcm_dimension");
            this.loadSimpleDynamicObject((DynaEntityObject)dimension, dimDy);
            if (dimDy != null) {
                dimension.setMemberEntityNumber(dimDy.getString("membermodel"));
            }
            entry.setDimension(dimension);
            Member member = new Member();
            DynamicObject memberValue = (DynamicObject)this.getValue(element.getSign());
            if (memberValue != null) {
                DynamicObject memberDy = BusinessDataServiceHelper.loadSingle((Object)memberValue.getLong("id"), (String)((String)element.getUserObject("memberEntity")));
                this.loadSimpleDynamicObject((DynaEntityObject)member, memberDy);
            }
            member.setDimension(dimension);
            member.setDataEntityNumber(dimension.getMemberEntityNumber());
            entry.setMember(member);
            entry.setNumber("bcm_mergenode".equals(element.getSign()) ? "bcm_mergenode" : dimension.getMemberEntityNumber());
            commDimensionEntryList.add(entry);
        }
        return commDimensionEntryList;
    }

    private List<SpreadDimensionEntry> genSpreadDimensionEntry(DynaEntityObject dynaEntityObject, List<Element> spreadElementList) {
        ArrayList<SpreadDimensionEntry> spreadDimensionEntryList = new ArrayList<SpreadDimensionEntry>(16);
        for (int i = 0; i < spreadElementList.size(); ++i) {
            Element element = spreadElementList.get(i);
            SpreadDimensionEntry entry = new SpreadDimensionEntry(dynaEntityObject);
            entry.setId(((Long)element.getUserObject("id")).longValue());
            entry.setSeq(i + 1);
            kd.fi.bcm.business.template.model.Dimension dimension = new kd.fi.bcm.business.template.model.Dimension();
            DynamicObject dimDy = BusinessDataServiceHelper.loadSingle((Object)element.getUserObject("dimId"), (String)"bcm_dimension");
            this.loadSimpleDynamicObject((DynaEntityObject)dimension, dimDy);
            if (dimDy != null) {
                dimension.setMemberEntityNumber(dimDy.getString("membermodel"));
                dimension.setFieldmapped(dimDy.getString("fieldmapped"));
            }
            entry.setName(dimension.getName());
            entry.setDimension(dimension);
            entry.setNumber("bcm_mergenode".equals(element.getSign()) ? "bcm_mergenode" : dimension.getMemberEntityNumber());
            spreadDimensionEntryList.add(entry);
        }
        return spreadDimensionEntryList;
    }

    private void loadSimpleDynamicObject(DynaEntityObject dynaEntityObject, DynamicObject d) {
        if (d != null) {
            dynaEntityObject.setId(d.getLong("id"));
            dynaEntityObject.setName(d.getString("name"));
            dynaEntityObject.setNumber(d.getString("number"));
            dynaEntityObject.setDataEntityNumber(d.getDataEntityType().getName());
        }
    }

    private boolean isAdjustTemplate() {
        String parentViewEntityId = this.getView().getParentView().getEntityId();
        return "bcm_adjusttemplate_edit".equals(parentViewEntityId);
    }

    private boolean isAdjustPaperTemplate() {
        String parentViewEntityId = this.getView().getParentView().getEntityId();
        return "bcm_adjustpapertempedit".equals(parentViewEntityId);
    }

    private String getCommonElementEntityJoin() {
        Area area = this.getPage(this.getView()).findAreaBySign(COMMON_PANEL);
        HashSet<String> set = new HashSet<String>(area.getElementListList().size());
        for (Element element : area.getElementListList()) {
            set.add(element.getSign());
        }
        return set.stream().sorted(Comparator.reverseOrder()).collect(Collectors.joining(";"));
    }

    private String getSpreadElementEntityJoin() {
        Area area = this.getPage(this.getView()).findAreaBySign(SPREAD_PANEL);
        HashSet<String> set = new HashSet<String>(area.getElementListList().size());
        for (Element element : area.getElementListList()) {
            set.add(element.getSign());
        }
        return set.stream().sorted(Comparator.reverseOrder()).collect(Collectors.joining(";"));
    }

    private void cacheCommonElementJoin() {
        String joinStr = this.getCommonElementEntityJoin();
        this.getPageCache().put(COMMON_ELEMENT_JOIN, joinStr);
    }

    private void cacheSpreadElementJoin() {
        String joinStr = this.getCommonElementEntityJoin();
        this.getPageCache().put(SPREAD_ELEMENT_JOIN, joinStr);
    }

    private String getCommonElementJoinFormCache() {
        return this.getPageCache().get(COMMON_ELEMENT_JOIN);
    }

    private String getSpreadElementJoinFormCache() {
        return this.getPageCache().get(SPREAD_ELEMENT_JOIN);
    }

    private boolean checkDimSettingChange() {
        String startCommonJoin = this.getCommonElementJoinFormCache();
        String endCommonJoin = this.getCommonElementEntityJoin();
        String startSpreadJoin = this.getSpreadElementJoinFormCache();
        String endSpreadJoin = this.getSpreadElementEntityJoin();
        return !startCommonJoin.equals(endCommonJoin) || !startSpreadJoin.equals(endSpreadJoin);
    }

    private boolean checkCommonElement() {
        Area area = this.getPage(this.getView()).findAreaBySign(COMMON_PANEL);
        for (Element element : area.getElementListList()) {
            Object value = this.getValue(element.getSign());
            if (value == null) {
                if (this.isAdjustPaperTemplate() && ("scenario".equals(element.getSign()) || "year".equals(element.getSign()) || "period".equals(element.getSign()))) continue;
                return false;
            }
            if (!element.getSign().equalsIgnoreCase(((DynamicObject)value).getString("number"))) continue;
            return false;
        }
        return true;
    }

    private AdjustModel getAdjustModel() {
        Predicate<String> p = StringUtils::isEmpty;
        String cacheKey = "adjust_model";
        if (this.model == null) {
            String schema = this.getPageCache().get(cacheKey);
            if (p.test(schema)) {
                schema = (String)this.getFormCustomParam(cacheKey);
            }
            if (!p.test(schema)) {
                this.model = (DynaEntityObject)this.deSerializedBytes(schema);
            }
        }
        return (AdjustModel)this.model;
    }

    private AdjustTemplateModel getAdjustPaperTemplate() {
        Predicate<String> p = StringUtils::isEmpty;
        String cacheKey = "adjusttmp_model";
        if (this.model == null) {
            String schema = this.getPageCache().get(cacheKey);
            if (p.test(schema)) {
                schema = (String)this.getFormCustomParam(cacheKey);
            }
            if (!p.test(schema)) {
                this.model = (DynaEntityObject)this.deSerializedBytes(schema);
            }
        }
        return (AdjustTemplateModel)this.model;
    }

    private void cacheAdjustModel(AdjustModel adjust) {
        this.getPageCache().put("adjust_model", adjust == null ? null : this.toByteSerialized(adjust));
    }

    public SpreadManager getSpreadModel() {
        String schema;
        Predicate<String> p;
        if (this.spread == null && !(p = t -> StringUtils.isEmpty((String)t)).test(schema = (String)this.getView().getFormShowParameter().getCustomParam("effectSheet"))) {
            this.spread = (SpreadManager)ObjectSerialUtil.deSerializedBytesAdjust((String)schema);
        }
        return this.spread;
    }

    private Sheet getEffectSheet() {
        if (this.getSpreadModel() != null) {
            return this.getSpreadModel().getBook().getSheet(0);
        }
        return null;
    }
}

