/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.link.LinkageMappingService;
import kd.fi.bcm.business.adjust.link.LinkageMappingServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.convert.convertor.ConvertDifferenceHandle;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.report.TemplateTreeNode;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.config.ChildConfigEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.adjust.model.AdjustPostmanByTemplate;
import kd.fi.bcm.formplugin.adjust.model.AdjustSpreadActionHandlerProxy;
import kd.fi.bcm.formplugin.adjust.model.AdjustSpreadDataCacheManager;
import kd.fi.bcm.formplugin.adjust.model.AdjustTabDataInfo;
import kd.fi.bcm.formplugin.adjust.model.ITreePage;
import kd.fi.bcm.formplugin.adjust.websocket.AdjustWebSocketCommandProcessor;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.report.AbstractMultiReportPlugin;
import kd.fi.bcm.formplugin.report.formula.ReportFormulaUtil;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.report.multi.ReportTabInfo;
import kd.fi.bcm.formplugin.report.multi.ReportTabModel;
import kd.fi.bcm.formplugin.report.postman.AbstractReportPostman;
import kd.fi.bcm.formplugin.report.style.ReportStyleHandle;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.util.MarkSpecialCell;
import kd.fi.bcm.formplugin.websocket.IAdjustSpiltScrean;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.util.DynamicUtils;
import org.apache.commons.collections4.CollectionUtils;

public class RptAdjustOffsetTemplatePlugin
extends AbstractMultiReportPlugin
implements ITreePage,
IAdjustSpiltScrean {
    private static final String CMDNAMEKEY = "closeTab";
    private static final String querylinktmpl = "querylinktmpl";
    private static final String[] tag = new String[]{"", "A", "T", "S"};
    private static final String[] needHide = new String[]{"copy", "cut", "pasteOptions", "clearContents", "filter", "sort", "pasteAll", "pasteFormula", "pasteValues", "pasteFormatting", "pasteValuesFormatting", "pasteFormulaFormatting", "insertComment"};
    private AdjustOperationContext ctx;
    private AdjustSpreadDataCacheManager manager;
    private AdjustSpreadActionHandlerProxy adjustSpreadActionHandlerProxy;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((Tab)this.getControl("reporttab")).addItemClickListener((ItemClickListener)this);
        this.registerBeforeEvent(EventConstant.ActionName.UPDATE_FORMULA, e1 -> {
            e1.setCancel(true);
            this.putValueInCache((Cell)e1.getSource(), null);
        });
        this.registerAfterEvent(EventConstant.ActionName.CELL_SELECT, a -> {});
    }

    @Override
    public void rptAdjustOffsetTemplateUpdateNullValue(Cell selectCell) {
        super.rptAdjustOffsetTemplateUpdateNullValue(selectCell);
        this.putValueInCache(selectCell, null);
    }

    @Override
    public void rptAdjustOffsetTemplateUpdateValue(Cell selectCell) {
        super.rptAdjustOffsetTemplateUpdateValue(selectCell);
        this.putValueInCache(selectCell, selectCell.getValue());
    }

    private void putValueInCache(Cell selectCell, Object value) {
        if (((Boolean)selectCell.getUserObject("floatmember", (Object)Boolean.FALSE)).booleanValue()) {
            return;
        }
        BigDecimal cacheValue = this.getSpreadDataCacheManager().putValueInCache(this.getCurrentReportTabInfo().getTabKey(), selectCell.getRow(), selectCell.getCol(), value);
        if (cacheValue == null) {
            this.getAdjustSheetHandler().setCellColorStyle(selectCell.getRow(), 1, selectCell.getCol(), 1, "#ffffff", 2);
        }
        this.getAdjustSheetHandler().setFormula(selectCell.getRow(), selectCell.getCol(), null);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        if (Boolean.TRUE.equals(this.getFormCustomParam("viewType"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"reporttab", "flexpanelap1"});
        }
        if (this.isMockCreateNewData()) {
            return;
        }
        super.afterCreateNewData(e);
        this.showAdjustTemplateTreeView();
        this.setPageRelation(this.getView().getPageId(), (String)this.getFormCustomParam("mainview_pageId"));
    }

    private void showAdjustTemplateTreeView() {
        FormShowParameter fs = new FormShowParameter();
        fs.getOpenStyle().setShowType(ShowType.InContainer);
        fs.getOpenStyle().setTargetKey("splitpanelap2");
        fs.setFormId("bcm_adjusttree_bottom");
        fs.setPageId(this.getPageIdAndCache(this.getPageCache(), "bcm_adjusttree_bottom"));
        fs.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        fs.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        fs.setCustomParam("viewType", this.getFormCustomParam("viewType"));
        this.getView().showForm(fs);
    }

    @Override
    public void dealMsg(CommandParam com) {
        if ("getEntry".equals(com.getOperation())) {
            this.sendToMainPage();
        } else if ("closeSpiltScreanPage".equals(com.getOperation()) && this.isSpiltScreanModel()) {
            if (this.getView().getParentView() != null) {
                this.getView().getParentView().close();
            } else {
                this.getView().close();
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.refreshAdjustSpreadstyle();
    }

    @Override
    public void orgTreeNodeClick(TreeNodeEvent e) {
        ITreePage.super.orgTreeNodeClick(e);
        this.setSelectOrgId(e.getNodeId().toString());
        if (this.needUpdateListToMainPage()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u7ecf\u5728\u62a5\u8868\u4e2d\u586b\u5199\u4e86\u6570\u636e\uff0c\u662f\u5426\u8981\u751f\u6210\u5206\u5f55\uff1f", (String)"RptAdjustOffsetTemplatePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("addEntry_comfirm", (IFormPlugin)this));
        } else {
            CommandParam newCom = new CommandParam(this.getSender(), "bcm_adjustoffset_entry", "changeOrg", this.getSelectOrgId());
            this.sendMsg(this.getView(), newCom);
            this.loadReport();
        }
    }

    public boolean needUpdateListToMainPage() {
        return this.getReportTabInfoManager().getTabs().stream().anyMatch(tab -> {
            AdjustTabDataInfo tabInfo = this.getSpreadDataCacheManager().queryInfoByTabKey(tab.getTabKey());
            return tabInfo != null && !tabInfo.isEmpty();
        });
    }

    @Override
    public void templateTreeNodeClick(TreeNodeEvent e) {
        ITreePage.super.templateTreeNodeClick(e);
        this.setSelectTmpId((String)e.getNodeId());
        TemplateModel tmpModel = ModelDataProvider.getTemplateModel(LongUtil.toLong((Object)this.getSelectTmpId()));
        if (tmpModel == null) {
            return;
        }
        this.increaseTemplateTab(this.getSelectTmpId());
        HashMap<String, BigDecimal> params = new HashMap<String, BigDecimal>(16);
        params.put("zoom", this.getZoom());
        SpreadClientInvoker.invokeZoomSetChange(this.getClientViewProxy(), this.getSpreadKey(), params);
        CommandParam newCom = new CommandParam(this.getSender(), null, "addSelectedTap", this.getReportTabInfoManager());
        this.sendMsg(this.getView(), newCom);
    }

    @Override
    protected Consumer<EntryFieldAp> getEntryFieldApConsumer(FlexPanelAp morefieldsetpanelap, TreeMap<Integer, EntryFieldAp> defaultDisplayField, Map<String, Integer> displaySequenceMap) {
        Consumer<EntryFieldAp> defaultConsumer = super.getEntryFieldApConsumer(morefieldsetpanelap, defaultDisplayField, displaySequenceMap);
        return field -> {
            defaultConsumer.accept((EntryFieldAp)field);
            if ("bcm_fymembertree".equals(field.getKey()) || "bcm_periodmembertree".equals(field.getKey()) || "bcm_scenemembertree".equals(field.getKey()) || "bcm_currencymembertree".equals(field.getKey())) {
                field.setVisible("audit");
            }
        };
    }

    @Override
    protected void reportTabSelected(TabSelectEvent evt) {
        super.reportTabSelected(evt);
        this.sendMsg(this.getView(), new CommandParam(this.getSender(), "bcm_adjustoffset_entry", "addSelectedTap", this.getReportTabInfoManager()));
        this.templateTreeNodeCheck(LongUtil.toLong((Object)this.getReportTabInfoManager().getCurrSelectReportTabInfo().getTemplateId()));
    }

    @Override
    public void templateTreeNodeCheck(Long templateId) {
        ITreePage.super.templateTreeNodeCheck(templateId);
        CommandParam newCom = new CommandParam(this.getSender(), "bcm_adjusttree_bottom", "templateTreeNodeCheck", templateId);
        newCom.setReFlect(true);
        this.sendMsg(this.getView(), newCom);
    }

    @Override
    public void disPatchMsg(IFormView curview, CommandParam com) {
        String spiltScreanPageId = this.getSpiltScreanPageId();
        String receiver = com.getReceiver();
        if (spiltScreanPageId == null || StringUtils.isEmpty((String)receiver) || "bcm_adjusttree_bottom".equals(receiver) || this.getSender().equals(receiver)) {
            ITreePage.super.disPatchMsg(curview, com);
        } else {
            AdjustWebSocketCommandProcessor.sendCommandParam(GuidePageUtils.isFromGuide(this.getView()) ? "GUIDE" : "CONSOLE", receiver, spiltScreanPageId, "", com);
        }
    }

    @Override
    public String getSender() {
        return this.getView().getFormShowParameter().getFormId();
    }

    private void increaseTemplateTab(String selectTmpId) {
        this.setSelectTmpId(selectTmpId);
        this.increaseReportTab(this.getCurrentPostman());
    }

    @Override
    public void increaseReportTab(AbstractReportPostman postman) {
        this.collectCommonDimensionInfo(postman);
        super.increaseReportTab(postman);
    }

    @Override
    protected void dealReportTabInfo(AbstractReportPostman postman, ReportTabInfo tabInfo) {
        super.dealReportTabInfo(postman, tabInfo);
        tabInfo.setTabName(ModelDataProvider.getTemplateModel(tabInfo.getTemplateId()).getName());
        tabInfo.setSourcetype("adjust");
    }

    @Override
    protected void loadReport() {
        ReportTabInfo tabModel = this.getCurrentReportTabInfo();
        if (tabModel != null) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)this.getCtx().getModelId(), (Long)LongUtil.toLong((Object)this.getSelectOrgId()));
            Map orgMap = MapInitHelper.ofMap((Object)"id", (Object)orgNode.getId(), (Object)"number", (Object)orgNode.getNumber(), (Object)"name", (Object)orgNode.getName(), (Object)"isleaf", (Object)orgNode.isLeaf());
            tabModel.putFilter("bcm_entitymembertree", orgMap);
            tabModel.putCommonParam("bcm_entitymembertree", orgMap);
            this.cacherReportTabManager();
            super.loadReport();
        }
    }

    private void updateFloatCellCornerMark() {
        List tempIdList = TemplateUtil.getTemplateIds((Long)this.getTemplateModel().getId());
        DynamicObject[] linkages = BusinessDataServiceHelper.load((String)"bcm_linkagemapping", (String)this.getLinkSelectFieldStr(), (QFilter[])new QFilter("entryentity.template", "in", (Object)tempIdList).and("status", "=", (Object)"1").toArray());
        if (linkages.length != 0) {
            HashMap pageViewMembers = new HashMap(16);
            this.getSpreadModel().getFilter().getPageDomain().getDimensions().forEach(p -> pageViewMembers.put(this.getCtx().getSctx().getDimensionByNumber(p.getNumber()), BcmThreadCache.findMemberByNum((String)this.ctx.getModelNum(), (String)p.getNumber(), (String)((IDimMember)p.getMembers().get(0)).getNumber())));
            this.getSpreadModel().getFilter().getViewPointDomain().getDimensions().forEach(p -> pageViewMembers.put(this.getCtx().getSctx().getDimensionByNumber(p.getNumber()), BcmThreadCache.findMemberByNum((String)this.ctx.getModelNum(), (String)p.getNumber(), (String)((IDimMember)p.getMembers().get(0)).getNumber())));
            this.getSpreadModel().getFilter().getFilterDomain().getDimensions().forEach(p -> pageViewMembers.put(this.getCtx().getSctx().getDimensionByNumber(p.getNumber()), BcmThreadCache.findMemberByNum((String)this.ctx.getModelNum(), (String)p.getNumber(), (String)((IDimMember)p.getMembers().get(0)).getNumber())));
            ArrayList<Dimension> toCheckDimList = new ArrayList<Dimension>(this.getSchemeContext(this.getModelId(), 0L).getDimensions());
            toCheckDimList.removeIf(dim -> {
                if (LinkageMappingService.toCheckDimSet.contains(dim.getNumber()) || !dim.isIssys()) {
                    return pageViewMembers.containsKey(dim);
                }
                pageViewMembers.remove(dim);
                return true;
            });
            ArrayList yearIdsList = new ArrayList(MemberReader.getAllNodeFromCache((String)"bcm_fymembertree", (String)this.getCtx().getModelNum()).keySet());
            HashMap id2LinktypeMap = new HashMap();
            HashMap entry2linkMap = new HashMap();
            List applySceneLinkIds = LinkageMappingServiceHelper.queryIds((long)this.getCtx().getModelId(), (long)this.ctx.getScenarioId());
            List applyEntityLinkIds = LinkageMappingServiceHelper.queryIdsByOrgId((long)this.getCtx().getModelId(), (long)this.getOrgIdByBusinessType(), Arrays.asList(linkages));
            HashMultimap linkConfigGyCt = HashMultimap.create();
            Arrays.stream(linkages).filter(linkage -> ConvertDifferenceHandle.isApply((Long)this.getCtx().getFyId(), (Long)this.getCtx().getPeriodId(), (DynamicObjectCollection)linkage.getDynamicObjectCollection("effective"), (List)yearIdsList)).filter(linkage -> applySceneLinkIds.contains(linkage.getLong("id"))).filter(linkage -> applyEntityLinkIds.contains(linkage.getLong("id"))).forEach(linkage -> {
                for (DynamicObject linkEntry : linkage.getDynamicObjectCollection("entryentity")) {
                    if (!tempIdList.contains(linkEntry.getLong("template.id")) || !pageViewMembers.entrySet().stream().allMatch(e -> {
                        IDNumberTreeNode linkNode = BcmThreadCache.findNodeById((String)this.getCtx().getModelNum(), (String)((Dimension)e.getKey()).getNumber(), (long)DynUtils.getBaseId((DynamicObject)linkEntry, (String)LinkageMappingService.findRealFieldKey((Dimension)((Dimension)e.getKey()))));
                        return LinkageMappingServiceHelper.checkIsMatch((VersionParam)AdjustOperationHelper.createVersionParam((long)this.getCtx().getModelId(), (long)this.getCtx().getScenarioId(), (long)this.getCtx().getFyId(), (long)this.getCtx().getPeriodId()), (IDNumberTreeNode)linkNode, (IDNumberTreeNode)((IDNumberTreeNode)e.getValue()), (boolean)false);
                    })) continue;
                    Long ctId = DynUtils.getBaseId((DynamicObject)linkEntry, (String)LinkageMappingService.findRealFieldKey((Dimension)this.getCtx().getSctx().getDimensionByNumber("ChangeType")));
                    IDNumberTreeNode ctNode = BcmThreadCache.findNodeById((String)this.getCtx().getModelNum(), (String)"ChangeType", (long)ctId);
                    HashMap configDetailMap = new HashMap();
                    toCheckDimList.forEach(e -> configDetailMap.put(e.getNumber(), BcmThreadCache.findNodeById((String)this.getCtx().getModelNum(), (String)e.getNumber(), (long)DynUtils.getBaseId((DynamicObject)linkEntry, (String)LinkageMappingService.findRealFieldKey((Dimension)e)))));
                    linkConfigGyCt.put((Object)ctNode.getNumber(), (Object)Pair.onePair((Object)linkEntry.getLong("id"), configDetailMap));
                    id2LinktypeMap.put(linkEntry.getLong("id"), linkEntry.getInt("linkagetype"));
                    entry2linkMap.put(linkEntry.getLong("id"), linkage.getLong("id"));
                }
            });
            this.getEffectiveSheet().iteratorCells(cell -> {});
            ConcurrentHashMap<String, List> cornerMarkMap = new ConcurrentHashMap<String, List>();
            RequestContext rc = ThreadPoolService.createRequestContext();
            Map<String, Map> allDimNodeCacheMap = toCheckDimList.stream().collect(Collectors.toMap(Dimension::getNumber, p -> (Map)MemberReader.getAllNodeByNumberFromCache((String)p.getEntity(), (String)this.ctx.getModelNum()).get(p.getNumber())));
            this.getEffectiveSheet().getTable().forEach(rowList -> rowList.forEach(cell -> {
                if (cell != null && cell.getUserObject() != null && CollectionUtils.isNotEmpty((Collection)cell.getMemberFromUserObject())) {
                    HashMap<String, Object> cellDimMemNodeMap = new HashMap<String, Object>(cell.getMemberFromUserObject().size());
                    for (IDimMember dimMember : cell.getMemberFromUserObject()) {
                        IDimension iDimension = dimMember.getDimension();
                        Map dimNodeCacheMap = (Map)allDimNodeCacheMap.get(iDimension.getNumber());
                        if (dimNodeCacheMap == null) continue;
                        cellDimMemNodeMap.put(iDimension.getNumber(), BcmThreadCache.get((Object)"allDimNodeCacheMap", (Object)iDimension.getNumber(), (Object)dimMember.getNumber(), () -> (IDNumberTreeNode)dimNodeCacheMap.get(dimMember.getNumber())));
                    }
                    IDNumberTreeNode changetype = (IDNumberTreeNode)cellDimMemNodeMap.get("ChangeType");
                    Stream<Object> linkConfigStream = changetype == null ? linkConfigGyCt.entries().stream().map(Map.Entry::getValue) : linkConfigGyCt.get((Object)changetype.getNumber()).stream();
                    List configList = linkConfigStream.filter(linkConfig -> toCheckDimList.stream().allMatch(dim -> {
                        IDNumberTreeNode linkNode = (IDNumberTreeNode)((Map)linkConfig.p2).get(dim.getNumber());
                        IDNumberTreeNode cellNode = (IDNumberTreeNode)cellDimMemNodeMap.get(dim.getNumber());
                        return LinkageMappingServiceHelper.checkIsMatch((VersionParam)AdjustOperationHelper.createVersionParam((long)this.getModelId(), (long)this.getCtx().getScenarioId(), (long)this.getCtx().getFyId(), (long)this.getCtx().getPeriodId()), (IDNumberTreeNode)linkNode, (IDNumberTreeNode)cellNode, (boolean)false);
                    })).map(p -> (Long)p.p1).collect(Collectors.toList());
                    if (cell.getUserObject().containsKey((Object)"linkIds") || !configList.isEmpty()) {
                        cornerMarkMap.put(ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()), configList);
                    }
                }
            }));
            if (!cornerMarkMap.isEmpty()) {
                cornerMarkMap.forEach((key, value) -> {
                    Point pos = ExcelUtils.pos2Point((String)key);
                    Cell cell = this.getEffectiveSheet().getCell(pos.y, pos.x);
                    if (CollectionUtil.isEmpty((Collection)value)) {
                        cell.getUserObject().remove((Object)"linkIds");
                        this.setFloatLinkTag(cell, 0, false);
                    } else {
                        cell.setUserObject("linkIds", (Object)value.stream().map(p -> entry2linkMap.getOrDefault(p, 0L).toString()).distinct().collect(Collectors.joining(",")));
                        this.setFloatLinkTag(cell, (Integer)id2LinktypeMap.get(value.get(0)), true);
                    }
                });
            }
            this.doAfterSpreadEventHandle();
        }
    }

    private long getOrgIdByBusinessType() {
        if (this.getFormCustomParam("isRADJ", false).booleanValue()) {
            return LongUtil.toLong((Object)this.getSelectOrgId());
        }
        return LongUtil.toLong((Object)this.getFormCustomParam("selectedNodeId"));
    }

    private String getLinkSelectFieldStr() {
        HashSet<String> linkSelectField = new HashSet<String>(16);
        linkSelectField.add("id");
        linkSelectField.add("effective.applytype");
        linkSelectField.add("effective.yearscope");
        linkSelectField.add("effective.effectiveyear");
        linkSelectField.add("effective.effectiveperiod");
        linkSelectField.add("effective.effectiveyear.id");
        linkSelectField.add("effective.effectiveperiod.id");
        this.getCtx().getSctx().getDimensions().forEach(dim -> {
            if (LinkageMappingService.toCheckDimSet.contains(dim.getNumber()) || !dim.isIssys()) {
                linkSelectField.add("entryentity." + LinkageMappingService.findRealFieldKey((Dimension)dim));
            }
        });
        linkSelectField.add("entryentity.template");
        linkSelectField.add("entryentity.linkagetype");
        linkSelectField.add("applyentity.entityisexcept");
        linkSelectField.add("applyentity.entitymeb");
        linkSelectField.add("applyentity.property");
        linkSelectField.add("applyentity.propertyvalue");
        linkSelectField.add("applyentity.entityrange");
        return String.join((CharSequence)",", linkSelectField);
    }

    @Override
    public void doAfterNotify(NotifyEvent event) {
        super.doAfterNotify(event);
        if (EventConstant.ActionName.UPDATE_MULVALUE == event.getActionName() || EventConstant.ActionName.UPDATE_MULFORMULA == event.getActionName()) {
            this.cacheSpreadDataCacheManager();
            this.updateCellValue2CoclorCache();
            this.doAfterSpreadEventHandle();
        }
    }

    private void updateCellValue2CoclorCache() {
        AdjustTabDataInfo currentTabInfo = this.getSpreadDataCacheManager().getInfoByTabKey(this.getCurrentReportTabInfo().getTabKey());
        currentTabInfo.forEach((pos, value) -> {
            Point p = ExcelUtils.pos2Point((String)pos);
            this.getAdjustSheetHandler().setCellValue(p.y, p.x, value, true);
            this.getAdjustSheetHandler().setCellColorStyle(p.y, 1, p.x, 1, "#ADD8E6", 2);
        });
        this.doAfterSpreadEventHandle();
    }

    private AdjustPostmanByTemplate getCurrentPostman() {
        IDNumberTreeNode curNode = MemberReader.findCurrencyMemberByNum((String)this.getCtx().getModelNum(), (String)"DC");
        AdjustPostmanByTemplate postman = new AdjustPostmanByTemplate(LongUtil.toLong((Object)this.getSelectTmpId()), this.getCtx().getScenarioId(), this.getCtx().getFyId(), this.getCtx().getPeriodId(), curNode.getId(), this.getModelId());
        postman.addEntityAndRptPair(LongUtil.toLong((Object)this.getSelectOrgId()), 0L);
        return postman;
    }

    @Override
    protected void setSpreadCommonStyle(SpreadEasyInvoker invoker) {
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), "report", MapInitHelper.ofMap((Object)"isHide", (Object)false));
        SpreadClientInvoker.invokeUnLockOrShowSpreadMenuItems(this.getClientViewProxy(), "report");
        SpreadClientInvoker.invokeLockLockCells(this.getClientViewProxy(), "report");
        SpreadEasyInvoker adjInvoker = new SpreadEasyInvoker(this.getClientViewProxy(), "report");
        adjInvoker.setWorksheetOptions(SpreadProperties.SetWorkSheetOptions.CLIPBOARDOPTIONS.k(), 1);
        adjInvoker.addContextMenuItem("clearCellFormula", ResManager.loadKDString((String)"\u6e05\u9664\u516c\u5f0f", (String)"RptAdjustOffsetTemplatePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport"});
        adjInvoker.addContextMenuItem("fetchCellInfo", ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f", (String)"RptAdjustOffsetTemplatePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport"});
        this.addLinkageMenu(this.getPageCache().get("linkageEntryIdsMaybe") != null);
        this.hideContextMenuItem();
    }

    @Override
    protected void invokeAddOrRemove(NotifyEvent e) {
        super.invokeAddOrRemove(e);
        this.adjustSpreadDataCacheManager((AskExcuteInfo)e.getSource());
    }

    private void adjustSpreadDataCacheManager(AskExcuteInfo excuteinfo) {
        if (this.getCurrentReportTabInfo() == null) {
            return;
        }
        AdjustTabDataInfo adjustTabDataInfo = this.getSpreadDataCacheManager().getInfoByTabKey(this.getCurrentReportTabInfo().getTabKey());
        if (!adjustTabDataInfo.isEmpty()) {
            Map countMap = excuteinfo.getOperationdata().stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            Map<String, BigDecimal> oldUpdateEntries = adjustTabDataInfo.getUpdateEntryList();
            LinkedHashMap<String, BigDecimal> newUpdateEntries = new LinkedHashMap<String, BigDecimal>(oldUpdateEntries.size());
            AtomicInteger newX = new AtomicInteger();
            AtomicInteger newY = new AtomicInteger();
            oldUpdateEntries.forEach((pos, val) -> {
                Long curAdjustIndex = 0L;
                Point point = ExcelUtils.pos2Point((String)pos);
                newX.set(point.x);
                newY.set(point.y);
                switch (excuteinfo.getMethod()) {
                    case INSERTCOL: {
                        curAdjustIndex = countMap.getOrDefault(point.x, 0L);
                        countMap.forEach((col, adjustIndex) -> {
                            if (point.x > col) {
                                newX.addAndGet(adjustIndex.intValue());
                            }
                        });
                        if (curAdjustIndex == 0L) break;
                        this.getAdjustSheetHandler().setCellColorStyle(point.y, 1, newX.get() + 1, curAdjustIndex.intValue() - 1, "#ffffff", 2);
                        break;
                    }
                    case DELETECOL: {
                        countMap.forEach((col, adjustIndex) -> {
                            if (point.x > col) {
                                newX.addAndGet(~adjustIndex.intValue());
                            }
                        });
                        break;
                    }
                    case INSERTROW: {
                        curAdjustIndex = countMap.getOrDefault(point.y, 0L);
                        countMap.forEach((row, adjustIndex) -> {
                            if (point.y > row) {
                                newY.addAndGet(adjustIndex.intValue());
                            }
                        });
                        if (curAdjustIndex == 0L) break;
                        this.getAdjustSheetHandler().setCellColorStyle(newY.get() + 1, curAdjustIndex.intValue(), point.x, 1, "#ffffff", 2);
                        break;
                    }
                    case DELETEROW: {
                        countMap.forEach((row, adjustIndex) -> {
                            if (point.y > row) {
                                newY.addAndGet(~adjustIndex.intValue());
                            }
                        });
                        break;
                    }
                }
                newUpdateEntries.put(ExcelUtils.xy2Pos((int)newX.get(), (int)newY.get()), (BigDecimal)val);
            });
            adjustTabDataInfo.setUpdateEntryList(newUpdateEntries);
            this.getSpreadDataCacheManager().updateCache();
            this.doAfterSpreadEventHandle();
        }
    }

    private void setFloatLinkTag(Cell cell, int tagType, boolean visible) {
        this.getAdjustSheetHandler().setCornerMark(cell.getRow(), cell.getCol(), 1, 1, visible, tag[tagType], "#5582f3", "white", new int[]{0});
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "querylinktmpl": {
                if (evt.getReturnData() == null) {
                    return;
                }
                this.templateTreeNodeClick(new TreeNodeEvent((Object)evt, null, evt.getReturnData()));
                break;
            }
        }
    }

    private Long getCommonParam(String param) {
        if (this.getView().getFormShowParameter().getCustomParam(param) == null || "0".equals(this.getView().getFormShowParameter().getCustomParam(param).toString())) {
            return 0L;
        }
        return Long.parseLong(this.getView().getFormShowParameter().getCustomParam(param).toString());
    }

    @Override
    public void customEvent(CustomEventArgs e) {
        if (CMDNAMEKEY.equalsIgnoreCase(e.getEventName())) {
            if (this.getReportTabInfoManager().getTabCount() == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u4e2a\u9875\u7b7e\u65e0\u6cd5\u5173\u95ed\u3002", (String)"RptAdjustOffsetTemplatePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                super.customEvent(e);
            }
        }
    }

    @Override
    protected void closeTab(String key) {
        super.closeTab(key);
        if (key != null && !key.isEmpty()) {
            CommandParam newCom = new CommandParam(this.getSender(), "bcm_adjustoffset_entry", "addSelectedTap", this.getReportTabInfoManager());
            this.sendMsg(this.getView(), newCom);
            this.getSpreadDataCacheManager().clearInfoByTabKey(key);
            this.cacheSpreadDataCacheManager();
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("addEntry_comfirm".equals(callBackId)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.sendToMainPage();
            } else {
                this.clearSpreadDataCacheManager();
                this.loadReport();
            }
            CommandParam newCom = new CommandParam(this.getSender(), "bcm_adjustoffset_entry", "changeOrg", this.getSelectOrgId());
            this.sendMsg(this.getView(), newCom);
        }
    }

    private void sendToMainPage() {
        List<Map<String, Object>> entryList = this.getUpdateListFromCache();
        if (!entryList.isEmpty()) {
            this.sendMsg(this.getView(), new CommandParam(this.getSender(), "bcm_adjustoffset_entry", "returnEntry", entryList));
            this.clearSpreadDataCacheManager();
        } else {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u586b\u5199\u4efb\u4f55\u503c\u3002", (String)"RptAdjustOffsetTemplatePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @SDKMark
    protected void clearSpreadDataCacheManager() {
        this.getReportTabInfoManager().getTabs().forEach(tab -> {
            AdjustTabDataInfo tabDataInfo;
            if (tab.isSelected() && (tabDataInfo = this.getSpreadDataCacheManager().queryInfoByTabKey(tab.getTabKey())) != null) {
                tabDataInfo.forEach((pos, val) -> {
                    Point point = ExcelUtils.pos2Point((String)pos);
                    this.getAdjustSheetHandler().setCellColorStyle(point.y, 1, point.x, 1, "#ffffff", 2);
                    this.getAdjustSheetHandler().setCellValue(point.y, point.x, null);
                });
            }
            this.getSpreadDataCacheManager().clearInfoByTabKey(tab.getTabKey());
        });
        this.cacheSpreadDataCacheManager();
    }

    private void cacheSpreadDataCacheManager() {
        this.getSpreadDataCacheManager().updateCache();
        this.pushCache();
    }

    @SDKMark
    protected List<Map<String, Object>> getUpdateListFromCache() {
        ArrayList<Map<String, Object>> updateEntryList = new ArrayList<Map<String, Object>>(16);
        for (ReportTabInfo reportTabInfo : this.getReportTabInfoManager().getTabs()) {
            AdjustTabDataInfo tabDataInfo = this.getSpreadDataCacheManager().queryInfoByTabKey(reportTabInfo.getTabKey());
            ReportTabModel reportTabModel = this.cacheService.getReportTabModel(reportTabInfo);
            reportTabModel.setPageCache(this.getPageCache());
            if (tabDataInfo == null || tabDataInfo.isEmpty()) continue;
            SpreadManager sm = this.getSpreadModel(reportTabInfo.getTabKey());
            HashMap<String, Object> filterViewMap = this.initFilterViewMap(sm);
            tabDataInfo.forEach((pos, value) -> {
                Point point = ExcelUtils.pos2Point((String)pos);
                Cell cell = sm.getBook().getSheet(0).getCell(point.y, point.x);
                if (cell.getUserObject("KEY_DIM_FLAG") != null) {
                    Map entryData = (Map)filterViewMap.clone();
                    ((List)cell.getUserObject("KEY_DIM_FLAG")).forEach(dim -> {
                        if (!"$Cur".equalsIgnoreCase(dim.getNumber())) {
                            entryData.put(dim.getDimension().getNumber(), dim.getNumber());
                        }
                    });
                    entryData.put("summoney", value);
                    cell.setValue(null);
                    updateEntryList.add(entryData);
                }
            });
            reportTabModel.setSpreadModel(sm);
            reportTabModel.cache();
        }
        return updateEntryList;
    }

    @SDKMark
    protected HashMap<String, Object> initFilterViewMap(SpreadManager sm) {
        HashMap<String, Object> filterViewMap = new HashMap<String, Object>(10);
        sm.getFilter().getViewPointDomain().getDimIterator().forEachRemaining(dim -> filterViewMap.put(dim.getNumber(), ((IDimMember)dim.getMembers().get(0)).getNumber()));
        sm.getFilter().getPageDomain().getDimIterator().forEachRemaining(dim -> filterViewMap.put(dim.getNumber(), ((IDimMember)dim.getMembers().get(0)).getNumber()));
        sm.getFilter().getFilterDomain().getDimIterator().forEachRemaining(dim -> filterViewMap.put(dim.getNumber(), ((IDimMember)dim.getMembers().get(0)).getNumber()));
        return filterViewMap;
    }

    @Override
    public boolean isAdjust() {
        return true;
    }

    @Override
    protected void afterLoadReport() {
        super.afterLoadReport();
        ReportTabInfo tabModel = this.getCurrentReportTabInfo();
        if (tabModel != null) {
            Long tmpId = LongUtil.toLong((Object)tabModel.getTemplateId());
            if (!Boolean.TRUE.equals(this.getFormCustomParam("viewType"))) {
                Map source2Right = TemplateUtil.getRightTplIdByVersioned((Long)this.getModelId(), (Long)this.getCommonParam("yearId"), (Long)this.getCommonParam("perioId"), Collections.singleton(tmpId));
                if (source2Right.isEmpty() || source2Right.get(tmpId) == null) {
                    this.loadEmptyReport();
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5728\u5df2\u9009\u8d22\u5e74\u671f\u95f4\u4e0d\u5b58\u5728\u751f\u6548\u7684\u7248\u672c\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u7248\u672c\u5316\u4fe1\u606f\u3002", (String)"RptAdjustOffsetTemplatePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)this.getCtx().getModelNum(), (String)"Entity", (long)LongUtil.toLong((Object)this.getSelectOrgId()));
                Map distributeMap = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense((Long)this.getModelId(), Collections.singleton(tmpId));
                if (!distributeMap.getOrDefault(tmpId, Collections.EMPTY_SET).contains(orgNode.getBaseTreeNode().getId())) {
                    this.loadEmptyReport();
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u5206\u914d\u62a5\u8868\u6a21\u677f\uff0c\u65e0\u6cd5\u5c55\u793a\u3002", (String)"RptAdjustOffsetTemplatePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            this.refreshAdjustSpreadstyle();
        }
    }

    private void loadEmptyReport() {
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "report", this.getInitSpreadJson());
        SpreadClientInvoker.invokeLockSheetMethod(this.getClientViewProxy(), this.getSpreadKey(), Collections.singletonList(this.getEffectiveSheet().getSheetName()));
        SpreadClientInvoker.invokeLockOrUnlockWholeToolbar(this.getClientViewProxy(), "report", true);
        FlexPanelAp emptyFlex = new FlexPanelAp();
        emptyFlex.setKey("fieldsetpanelap");
        this.getView().updateControlMetadata("fieldsetpanelap", emptyFlex.createControl());
        emptyFlex.setKey("morefieldsetpanel");
        this.getView().updateControlMetadata("morefieldsetpanel", emptyFlex.createControl());
    }

    private void refreshAdjustSpreadstyle() {
        if (DynamicUtils.isDynamicReport((SpreadManager)this.getSpreadModel())) {
            this.setFloatF7Cell();
            MarkSpecialCell.drawMarkPoint(this.getPageCache(), this.getView(), this.getSpreadModel(), "report");
        }
        new ReportStyleHandle(this).statusAdjustControl();
        this.updateCellValue2CoclorCache();
        this.updateFloatCellCornerMark();
    }

    public void clearAllSpreadFormula() {
        this.getEffectiveSheet().iteratorCells(cell -> {
            if (cell.hasFormula()) {
                Object value = this.getAdjustSheetHandler().getCellValue(cell.getRow(), cell.getCol(), Object.class);
                if (value instanceof JSONObject) {
                    this.getAdjustSheetHandler().setCellValue(cell.getRow(), cell.getCol(), null);
                }
                this.getAdjustSheetHandler().setFormula(cell.getRow(), cell.getCol(), null);
            }
        });
        this.doAfterSpreadEventHandle();
    }

    private String getInitSpreadJson() {
        return "{\"version\":\"10.0.1\",\"sheetCount\":1,\"sheets\":{\"null\":{\"name\":\"null\",\"rowCount\":\"150\",\"columnCount\":\"20\",\"data\": {\"dataTable\": {}}}}}";
    }

    private void addLinkageMenu(boolean ishide) {
        HashMap<String, Object> tmplParameter = new HashMap<String, Object>(16);
        tmplParameter.put("callback", "invokeAction");
        HashMap<String, Object> tmplItems = new HashMap<String, Object>(16);
        tmplItems.put("name", "queryLinkageEntryTemplate");
        tmplItems.put("text", ResManager.loadKDString((String)"\u8054\u52a8\u6a21\u677f\u6e05\u5355", (String)"RptAdjustOffsetTemplatePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        tmplItems.put("workArea", new String[]{"viewport"});
        tmplParameter.put("items", new Map[]{tmplItems});
        SpreadClientInvoker.invokeMethod(this.getClientViewProxy(), "addContextMenuItems", "report", tmplParameter);
        HashMap<String, Object> parameter = new HashMap<String, Object>(16);
        parameter.put("callback", "invokeAction");
        HashMap<String, Object> items = new HashMap<String, Object>(16);
        items.put("name", "queryLinkageEntry");
        items.put("text", ResManager.loadKDString((String)"\u67e5\u770b\u8054\u52a8\u4fe1\u606f", (String)"RptAdjustOffsetTemplatePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        items.put("workArea", new String[]{"viewport"});
        parameter.put("items", new Map[]{items});
        SpreadClientInvoker.invokeMethod(this.getClientViewProxy(), "addContextMenuItems", "report", parameter);
        HashMap<String, Boolean> param = new HashMap<String, Boolean>(16);
        param.put("isHide", ishide);
        SpreadClientInvoker.invokeMethod(this.getClientViewProxy(), "hideContextMenuItems", "report", param);
        if (!ishide) {
            Map[] paramsHide = new Map[needHide.length];
            for (int i = 0; i < needHide.length; ++i) {
                HashMap<String, Object> pa = new HashMap<String, Object>(16);
                pa.put("name", needHide[i]);
                pa.put("isHide", true);
                paramsHide[i] = pa;
            }
            SpreadClientInvoker.invokeMethod(this.getClientViewProxy(), "hideContextMenuItems", "report", paramsHide);
        }
    }

    public void queryLinkageEntryTemplate() {
        Cell selectedCell = this.getEffectiveSheet().getCell(this.getSelectorStartRow(), this.getSelectorStartCol());
        if (selectedCell.getUserObject("linkIds") != null) {
            String linkIds = (String)selectedCell.getUserObject("linkIds");
            Map<Long, String> tmplIds2name = this.getEffectiveTmpl(this.getTemplateId(), linkIds, this.getTreeModel(this.getView(), "cache_treetemplate"));
            if (tmplIds2name.size() > 0) {
                ListShowParameter param = new ListShowParameter();
                param.setFormId("bcm_linkagerpttmplquery");
                param.setBillFormId("bcm_linkagerpttmplquery");
                param.setCustomParam("tmplIds2name", tmplIds2name);
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, querylinktmpl));
                param.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm((FormShowParameter)param);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5355\u5143\u683c\u4e0d\u5b58\u5728\u7b26\u5408\u6761\u4ef6\u7684\u8054\u52a8\u6a21\u677f", (String)"RptAdjustOffsetTemplatePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5355\u5143\u683c\u4e0d\u5b58\u5728\u7b26\u5408\u6761\u4ef6\u7684\u8054\u52a8\u6a21\u677f", (String)"RptAdjustOffsetTemplatePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void queryLinkageEntry() {
        Cell selectedCell = this.getEffectiveSheet().getCell(this.getSelectorStartRow(), this.getSelectorStartCol());
        if (selectedCell.getUserObject("linkIds") != null) {
            String linkIds = (String)selectedCell.getUserObject("linkIds");
            ListShowParameter listparam = new ListShowParameter();
            listparam.setFormId("bcm_showlinkageentry");
            listparam.setBillFormId("bcm_linkagemapping_layout");
            listparam.setCustomParam("modelid", (Object)this.getModelId());
            listparam.setCustomParam("linkageIds", (Object)linkIds);
            listparam.getOpenStyle().setShowType(ShowType.Modal);
            listparam.setMultiSelect(false);
            this.getView().showForm((FormShowParameter)listparam);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5355\u5143\u683c\u65e0\u4e3b\u9644\u8054\u52a8\u4fe1\u606f", (String)"RptAdjustOffsetTemplatePlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private Map<Long, String> getEffectiveTmpl(Long currentTmplId, String linkIds, TreeModel<?> treeModel) {
        HashMap<Long, String> id2name = new HashMap<Long, String>(16);
        String[] linkageIds = linkIds.split(",");
        ArrayList<Long> linkageIsList = new ArrayList<Long>(linkageIds.length);
        for (String s : linkageIds) {
            linkageIsList.add(Long.valueOf(s));
        }
        if (linkageIsList.size() > 0) {
            Set<Integer> types;
            Long id;
            QFilter qf = new QFilter("id", "in", linkageIsList);
            DynamicObjectCollection linkMappingCol = QueryServiceHelper.query((String)"bcm_linkagemapping", (String)"entryentity.template.id,entryentity.template.number, entryentity.template.name, entryentity.linkagetype", (QFilter[])new QFilter[]{qf});
            HashMap id2type = new HashMap(16);
            for (DynamicObject dyn : linkMappingCol) {
                id = dyn.getLong("entryentity.template.id");
                String number = dyn.getString("entryentity.template.number");
                if (treeModel.searchByNodeAttribute(tree -> ((TemplateTreeNode)tree).getNumber().equals(number)) == null) continue;
                if (id2type.get(id) == null) {
                    types = new HashSet(16);
                    types.add(dyn.getInt("entryentity.linkagetype"));
                } else {
                    types = (Set)id2type.get(id);
                    types.add(dyn.getInt("entryentity.linkagetype"));
                }
                id2type.put(id, types);
                id2name.put(id, dyn.getString("entryentity.template.name"));
            }
            for (Map.Entry entry : id2name.entrySet()) {
                id = (Long)entry.getKey();
                String showname = (String)entry.getValue();
                types = (HashSet)id2type.get(id);
                showname = types.contains(1) || types.contains(2) && types.contains(3) ? ResManager.loadKDString((String)"\u6e90\u3001\u76ee\u6807", (String)"RptAdjustOffsetTemplatePlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : (types.contains(2) ? ResManager.loadKDString((String)"\u76ee\u6807", (String)"RptAdjustOffsetTemplatePlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6e90", (String)"RptAdjustOffsetTemplatePlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                id2name.put(id, showname);
            }
        }
        return id2name;
    }

    @Override
    protected Set<Long> getPeriodMemberIds() {
        DynamicObject scene = BusinessDataServiceHelper.newDynamicObject((String)"bcm_scenemembertree");
        scene.set("id", this.getView().getFormShowParameter().getCustomParam("scenarioId"));
        this.getModel().getDataEntity().set("bcm_scenemembertree", (Object)scene);
        return super.getPeriodMemberIds();
    }

    @Override
    protected void afterInitPage() {
        super.afterInitPage();
        Predicate<String> testControl = t -> this.getModel().getProperty(t) != null;
        if (testControl.test("bcm_fymembertree")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bcm_fymembertree"});
        }
        if (testControl.test("bcm_periodmembertree")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bcm_periodmembertree"});
        }
        if (testControl.test("bcm_scenemembertree")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bcm_scenemembertree"});
        }
        if (testControl.test("bcm_entitymembertree")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bcm_entitymembertree"});
        }
    }

    public SpreadManager getSpreadModel(String tabKey) {
        return this.cacheService.getReportTabModel(this.getReportTabInfoManager().searchTab(tabKey)).getSpreadModel();
    }

    @Override
    protected void registSpreadShortcutKey() {
    }

    @Override
    public void setSelectTmpId(String selectTmpId) {
        this.getPageCache().put("templateselectedNodeId", selectTmpId);
    }

    @Override
    public String getSelectTmpId() {
        return this.getPageCache().get("templateselectedNodeId");
    }

    @Override
    public String getSelectOrgId() {
        return this.getPageCache().get("selectOrgId");
    }

    @Override
    public void setSelectOrgId(String selectOrgId) {
        this.getPageCache().put("selectOrgId", selectOrgId);
    }

    public BigDecimal getZoom() {
        String zoom = (String)this.getView().getFormShowParameter().getCustomParam("zoomChange");
        return StringUtils.isNotEmpty((String)zoom) ? new BigDecimal(zoom) : BigDecimal.ONE;
    }

    @Override
    public void zoomChange(BigDecimal zoomChange) {
        CommandParam com = new CommandParam(this.getSender(), "bcm_adjustoffset_entry", "zoomChange", zoomChange);
        this.sendMsg(this.getView(), com);
    }

    @Override
    public boolean isOpenZoomChange() {
        return true;
    }

    public AdjustOperationContext getCtx() {
        if (this.ctx == null) {
            this.ctx = new AdjustOperationContext(this.getModelId(), this.getCommonParam("scenarioId").longValue(), this.getCommonParam("yearId").longValue(), this.getCommonParam("perioId").longValue());
        }
        return this.ctx;
    }

    @Override
    public long getModelId() {
        return this.getCommonParam("model");
    }

    @Override
    public void afterDealMsg(CommandParam com) {
        this.doAfterSpreadEventHandle();
    }

    public void afterItemClick(ItemClickEvent evt) {
        super.afterItemClick(evt);
        this.doAfterSpreadEventHandle();
    }

    @Override
    public void afterSpreadEventHandle(EventConstant.ActionName actionName) {
        super.afterSpreadEventHandle(actionName);
        if (EventConstant.ActionName.UPDATE_MULVALUE == actionName || EventConstant.ActionName.UPDATE_MULFORMULA == actionName) {
            this.doAfterSpreadEventHandle();
            this.cacheSpreadDataCacheManager();
        }
    }

    protected void doAfterSpreadEventHandle() {
        this.getAdjustSheetHandler().invokeCommands(false);
    }

    public AdjustSpreadActionHandlerProxy getAdjustSheetHandler() {
        if (this.adjustSpreadActionHandlerProxy == null) {
            this.adjustSpreadActionHandlerProxy = new AdjustSpreadActionHandlerProxy(this.getView(), this.getSpreadKey());
        }
        if (this.getCurrentReportTabInfo() != null) {
            this.adjustSpreadActionHandlerProxy.setSpreadManager(this.getSpreadModel());
        }
        return this.adjustSpreadActionHandlerProxy;
    }

    public AdjustSpreadDataCacheManager getSpreadDataCacheManager() {
        if (this.manager == null) {
            this.manager = new AdjustSpreadDataCacheManager(this.getPageCache());
        }
        return this.manager;
    }

    @Override
    protected boolean willExecuteBizRule() {
        return false;
    }

    @Override
    public int getReportUnitInfo() {
        return 0;
    }

    @Override
    protected void controlFloatStyle(List<String> numbers, RangeModel rangeModel) {
        this.refreshAdjustSpreadstyle();
    }

    @Override
    protected void controlSpreadStyle(Map<String, Object> spreadStyle) {
    }

    @Override
    protected void mergeInvokeUpdateValueCommands(Map<String, Object> e) {
        this.getAdjustSheetHandler().setCellValue((Integer)e.get(SpreadProperties.UpdataValueMethod.R.k()), (Integer)e.get(SpreadProperties.UpdataValueMethod.C.k()), e.get(SpreadProperties.UpdataValueMethod.V.k()));
    }

    @Override
    protected void mergeInvokeUpdateValueCommands(List<Map<String, Object>> item) {
        item.forEach(e -> this.getAdjustSheetHandler().setCellValue((Integer)e.get(SpreadProperties.UpdataValueMethod.R.k()), (Integer)e.get(SpreadProperties.UpdataValueMethod.C.k()), e.get(SpreadProperties.UpdataValueMethod.V.k())));
    }

    @Override
    protected void refreshReport() {
        this.clearAllSpreadFormula();
        boolean showReportData = ConfigServiceHelper.getBoolChildParam((Long)this.getModelId(), (String)"CM045", (String)ChildConfigEnum.BOTTOMREFRESH.getBusinesstypevalue());
        if (showReportData) {
            super.refreshReport();
        } else {
            this.getEffectiveSheet().iteratorCells(cell -> {
                if (cell.isMdDataDomain()) {
                    this.getAdjustSheetHandler().setCellValue(cell.getRow(), cell.getCol(), null);
                }
            });
            if (this.noEntity()) {
                return;
            }
            this.refreshClientRptValue();
            this.transOrgEcValue();
            ReportFormulaUtil.copyExcel(this.getSpreadModel(), (IClientViewProxy)this.getView().getService(IClientViewProxy.class), "report");
            ReportFormulaUtil.getMemberGroupCell(this.getSpreadModel());
            this.setModified(false);
        }
    }

    @Override
    protected String getReportDataSelectSchemeType() {
        return "3";
    }

    @Override
    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        if (this.isSpiltScreanModel()) {
            CommandParam com = new CommandParam(this.getSender(), "bcm_adjustoffset_entry", "closedSpiltScreanModel", this.getMainPageId());
            this.sendMsg(this.getView(), com);
        }
    }

    @Override
    public boolean isSpiltScreanModel() {
        return StringUtils.isNotEmpty((String)this.getSpiltScreanPageId());
    }
}

