/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Control;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustTemplateHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class RptAdjustPaperTmplOrderPlugin
extends AbstractBaseListPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        DynamicObject dy;
        super.afterCreateNewData(e);
        JSONArray ids = (JSONArray)this.getFormCustomParam("ids");
        if (ids != null && ids.size() == 1 && (dy = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"id,executeorder", (QFilter[])new QFilter[]{new QFilter("id", "=", ids.get(0))})) != null) {
            this.getModel().setValue("executeorder", (Object)dy.getBigDecimal("executeorder"));
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            JSONArray ids = (JSONArray)this.getFormCustomParam("ids");
            BigDecimal executeorder = (BigDecimal)this.getModel().getValue("executeorder");
            if (executeorder == null) {
                executeorder = new BigDecimal(99999);
            } else if (executeorder.compareTo(new BigDecimal("1")) < 0 || executeorder.compareTo(new BigDecimal("99998")) > 0 || executeorder.scale() > 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u53ea\u80fd\u8f93\u5165\u8303\u56f4\u4e3a[1,99998]\u5185\u6700\u591a2\u4f4d\u5c0f\u6570\u7684\u6570\u5b57\u3002", (String)"RptAdjustPaperTmplOrderPlugin_01", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,model.shownumber,scenario.number,number,name,executeorder", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
            if (ids != null && ids.size() > 0) {
                Long userId = LongUtil.toLong((Object)RequestContext.getOrCreate().getUserId());
                Date now = TimeServiceHelper.now();
                String updateSql = "update t_bcm_papertemplate set fexecuteorder = ?,fmodifierid = ? ,fmodifytime =? where fid = ?";
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
                for (Object id : ids) {
                    Object[] params = new Object[]{executeorder, userId, now, id};
                    paramsList.add(params);
                }
                DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)updateSql, paramsList);
                Object secneId = this.getFormCustomParam("KEY_SCENARIO_ID");
                AdjustTemplateHelper.clearDistributeMapFromAllCache((Long)((Long)this.getFormCustomParam("KEY_MODEL_ID")), (Long)LongUtil.toLong((Object)secneId));
                this.recordLog(dynamicObjects, executeorder);
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RptAdjustTemplateEditPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.getView().close();
        }
    }

    private void recordLog(DynamicObjectCollection dynamicObjects, BigDecimal executeorder) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        ArrayList<AppLogInfo> logList = new ArrayList<AppLogInfo>(16);
        if (dynamicObjects != null) {
            for (DynamicObject dyn : dynamicObjects) {
                StringBuilder des = new StringBuilder(16);
                des.append(dyn.getString("scenario.number")).append(" ").append(dyn.getString("number")).append(" ").append(dyn.getString("name")).append(" ").append(dyn.getBigDecimal("executeorder").stripTrailingZeros().toPlainString()).append("\u2014>").append(executeorder.stripTrailingZeros().toPlainString()).append(" ").append(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RptAdjustTemplateEditPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)ResManager.loadKDString((String)"\u901a\u7528\u5206\u5f55\u6a21\u7248-\u8bbe\u7f6e\u6267\u884c\u987a\u5e8f", (String)"RptAdjustTemplateEditPlugin_51", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)des.toString(), (Long)((Long)this.getFormCustomParam("KEY_MODEL_ID")), (String)"bcm_papertemplate");
                logList.add(logInfo);
            }
        }
        if (!CollectionUtils.isEmpty(logList)) {
            BatchProcessHelper.batchConsume(logList, (int)1000, arg_0 -> ((ILogService)logService).addBatchLog(arg_0));
        }
    }
}

