/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.util.AdjustBusinessTypeUtil;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AdjustTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.adjust.report.AbstractRptAdjustQueryPlugin;
import org.apache.commons.collections.CollectionUtils;

public class RptAdjustQueryEditPlugin
extends AbstractRptAdjustQueryPlugin {
    private static final String f7KeyPrefix = "bcm_";
    private static final List<String> defaultF7Number = Collections.unmodifiableList(Arrays.asList("scenario", "year", "period", "Process"));
    public static final String OPENTYPE_EDIT = "EDIT";
    public static final String OPENTYPE_ADDNEW = "ADDNEW";
    private static final String KEY_ICMEMBERTREE_INTERNALCOMPANY = "bcm_icmembertree_internalcompany";

    @Override
    public void initialize() {
        super.initialize();
        this.bindCtrlMapping();
        HashMap map = new HashMap(16);
        this.asMapF7toType(Collections.singletonList("entity"), SingleF7TypeEnum.NOLEAF, map);
        this.initSingleMemberF7(map);
        String isCollapse = this.getPageCache().get("isCollapse");
        if (null == isCollapse) {
            Container container = (Container)this.getView().getControl("flexpanelap3");
            container.setCollapse(true);
            this.getPageCache().put("isCollapse", "true");
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getView().getFormShowParameter().getCustomParam("model") != null) {
            this.getPageCache().put("KEY_MODEL_ID", this.getView().getFormShowParameter().getCustomParam("model").toString());
        }
        HashMap f7KeyDim = new HashMap(16);
        this.getPageCache().put("f7Key2Dim", this.toByteSerialized(f7KeyDim));
        this.setEnable();
        this.initPageViewPanel();
        this.bindCtrlMapping();
        ((ComboEdit)this.getControl("bussnesstype")).setComboItems(AdjustBusinessTypeUtil.getConfigCM005ComboEditList((long)this.getModelId(), (boolean)false, (boolean)false));
        if (this.getView().getFormShowParameter().getCustomParam("datatrace") != null) {
            this.getModel().setValue("status", (Object)RptAdjustStatusEnum.AUDIT.status());
            this.initDefaultMemberFromDataTrace();
        } else {
            this.initDefaultMemberFromModel();
        }
        this.showDiffView(null);
    }

    private void initDefaultMemberFromDataTrace() {
        LinkedHashMap<String, List> f7data = new LinkedHashMap<String, List>(16);
        Map<String, DimensionScope> f7keys = this.getF7ModelCache();
        boolean fromExcel = "excel".equals(this.getView().getFormShowParameter().getCustomParam("sourceFrom"));
        String processNum = MemberReader.findProcessMemberById((String)this.getCurModelNumber(), (Long)(fromExcel ? LongUtil.toLong((Object)this.getFormCustomParam("process")) : (Long)this.getFormCustomParam("process"))).getNumber();
        for (Map.Entry<String, DimensionScope> f7Model : f7keys.entrySet()) {
            boolean isValidScope;
            String dimNumber = f7Model.getValue().getDimension().getNumber().toLowerCase(Locale.ENGLISH);
            if (this.getView().getFormShowParameter().getCustomParam(dimNumber) == null) continue;
            String scope = (String)this.getView().getFormShowParameter().getCustomParam(dimNumber + "Scope");
            String showName = (String)this.getView().getFormShowParameter().getCustomParam(dimNumber + "Name");
            long memId = 0L;
            if (fromExcel) {
                memId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam(dimNumber));
                showName = MemberReader.findMemberById((long)this.getModelId(), (String)f7Model.getValue().getDimension().getMembermodel(), (Long)memId).getName();
            } else {
                memId = (Long)this.getView().getFormShowParameter().getCustomParam(dimNumber);
            }
            boolean bl = isValidScope = StringUtils.isNotEmpty((String)scope) && !scope.equals(String.valueOf(RangeEnum.VALUE_10.getValue()));
            if (isValidScope) {
                showName = String.format(ResManager.loadKDString((String)"%1$s\u7684%2$s", (String)"RptAdjustQueryEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), showName, RangeEnum.getRangeByVal((int)Integer.parseInt(scope)).getName());
            }
            f7data.computeIfAbsent(f7Model.getKey(), e -> new ArrayList(10)).add(memId);
            f7Model.getValue().addDimeMemRange(memId, Integer.parseInt(scope));
            if ("process".equalsIgnoreCase(dimNumber)) {
                List<String> processNums = null;
                if (this.getView().getFormShowParameter().getCustomParam("specialAdjt") != null) {
                    processNums = Arrays.asList("ADJ", "DADJ");
                } else if ("RAdj".equals(processNum)) {
                    processNums = Arrays.asList("RAdj", "ERAdj");
                }
                IDNumberTreeNode node = null;
                if (processNums != null) {
                    for (String num : processNums) {
                        node = MemberReader.findProcessMemberByNum((String)this.getAdjustQueryService().getCxt().getModelNumber(), (String)num);
                        f7Model.getValue().addDimeMemRange(node.getId().longValue(), RangeEnum.VALUE_10.getValue());
                        if (showName == null) {
                            showName = "";
                        }
                        showName = showName.concat(node.getName()).concat(";");
                    }
                } else {
                    node = MemberReader.findProcessMemberById((String)this.getAdjustQueryService().getCxt().getModelNumber(), (Long)memId);
                    f7Model.getValue().addDimeMemRange(node.getId().longValue(), RangeEnum.VALUE_10.getValue());
                    showName = node.getName();
                }
            } else {
                f7Model.getValue().addDimeMemRange(memId, isValidScope ? Integer.parseInt(scope) : RangeEnum.VALUE_10.getValue());
            }
            this.getModel().setValue(f7Model.getKey(), (Object)showName);
            this.getView().updateView(f7Model.getKey());
        }
        this.getPageCache().put("f7MapCacheKey", SerializationUtils.serializeToBase64(this.getF7ModelCache()));
    }

    private void initDefaultMemberFromModel() {
        this.buildDefaultF7Data();
        this.getF7ModelCache().forEach((f7Key, dimScop) -> {
            if (!CollectionUtils.isEmpty((Collection)dimScop.getDimensionMembers())) {
                this.getModel().setValue(f7Key, (Object)dimScop.toString());
                if (f7Key.startsWith("bcm_audittrialmembertree") || f7Key.startsWith("bcm_processmembertree")) {
                    this.getModel().setValue(dimScop.getDimension().getNumber().toUpperCase(Locale.ENGLISH), (Object)dimScop.getDimensionMembers().stream().map(e -> e.getId()).toArray());
                }
                this.getView().updateView(f7Key);
            }
        });
        this.setDefaultProcessValue();
        this.getPageCache().put("f7MapCacheKey", SerializationUtils.serializeToBase64(this.getF7ModelCache()));
    }

    private void buildDefaultF7Data() {
        Map<String, DimensionScope> f7Models = this.getF7ModelCache();
        if (OPENTYPE_EDIT.equals(this.getView().getFormShowParameter().getCustomParam("pageopentype"))) {
            String selectProperties = this.getHeadSelector() + "commembentry,commembentry.comdimension,commembentry.comdimension.membermodel,commembentry.comdimension.number,commembentry.commembid,commembentry.range,commembentry.pid,commembentry.commonfield";
            DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)this.getFormCustomParam("pkId"), (String)"bcm_rptadjustqueryplan", (String)selectProperties);
            this.getPageCache().put("pkId", "" + this.getFormCustomParam("pkId"));
            this.setHeadData(plan);
            for (DynamicObject dd : plan.getDynamicObjectCollection("commembentry")) {
                DynamicObject dimension = dd.getDynamicObject("comdimension");
                String memberModel = dimension.getString("membermodel");
                String dimNumebr = dimension.getString("number");
                String commonfields = dd.getString("commonfield");
                String key = this.sugarF7Key(dimNumebr, f7Models.keySet());
                DimensionScope dimScope = this.getF7ModelCache().get(key);
                long pid = dd.getLong("pid");
                Long mid = dd.getLong("commembid");
                int range = dd.getInt("range");
                if (StringUtils.isNotEmpty((String)commonfields)) {
                    for (String str : commonfields.split(";")) {
                        dimScope.addDimPreAttribute(str, range);
                    }
                    continue;
                }
                dimScope.addDimeMemRange(pid == 0L ? mid : pid, range);
            }
        } else {
            Set orgSet;
            Map orgMap;
            String opentype = (String)this.getFormCustomParam("opentype");
            String orgCahce = (String)this.getFormCustomParam("orgRange");
            Map f7KeyMap = null;
            if (StringUtils.isNotEmpty((String)opentype) || this.getFormCustomParam("f7Cache") != null) {
                f7KeyMap = (Map)SerializationUtils.fromJsonString((String)((String)this.getFormCustomParam("f7Cache")), Map.class);
            }
            if (StringUtils.isNotEmpty((String)orgCahce) && (orgMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"isleaf,id,number,name,currency.number", (QFilter[])new QFilter("id", "in", (Object)(orgSet = (Set)ObjectSerialUtil.deSerializedBytes((String)orgCahce))).toArray())).size() == 1) {
                DynamicObject orgDy = (DynamicObject)orgMap.values().iterator().next();
                if (orgDy.getBoolean("isleaf")) {
                    String key = this.sugarF7Key("Entity", f7Models.keySet());
                    DimensionScope dimensionScope = f7Models.get(key);
                    dimensionScope.addDimeMemRange(orgDy.getLong("id"), RangeEnum.VALUE_10.getValue());
                } else {
                    this.getModel().setValue("entity", (Object)orgDy);
                }
                QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
                qf.and("number", "=", (Object)orgDy.getString("currency.number"));
                DynamicObject curr = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (String)"id,number,name", (QFilter[])qf.toArray());
                if (curr != null) {
                    String key = this.sugarF7Key("Currency", f7Models.keySet());
                    DimensionScope dimensionScope = f7Models.get(key);
                    dimensionScope.addDimeMemRange(curr.getLong("id"), RangeEnum.VALUE_10.getValue());
                }
            }
            if (f7KeyMap != null) {
                for (String dimNumebr : defaultF7Number) {
                    String key = this.sugarF7Key(dimNumebr, f7Models.keySet());
                    DimensionScope dimensionScope = f7Models.get(key);
                    if (f7KeyMap.get(dimNumebr) == null) continue;
                    long membid = LongUtil.toLong((Object)String.valueOf(f7KeyMap.get(dimNumebr)));
                    dimensionScope.addDimeMemRange(membid, RangeEnum.VALUE_10.getValue());
                }
            }
            this.getModel().setValue("journaltype", this.getFormCustomParam("journaltype"));
        }
        this.bussnessTypeControl(this.getModel());
    }

    private void bussnessTypeControl(IDataModel dataModel) {
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"bussnesstype"});
    }

    private void setDefaultProcessValue() {
        String opentype = (String)this.getFormCustomParam("opentype");
        if (StringUtils.isEmpty((String)opentype)) {
            return;
        }
        AdjustTypeEnum type = AdjustTypeEnum.getAdjustTypeByVal((String)opentype);
        String key = this.sugarF7Key(DimEntityNumEnum.PROCESS.getNumber(), this.getF7ModelCache().keySet());
        DimensionScope dimensionScope = this.getF7ModelCache().get(key);
        type.getNumbers().stream().forEach(e -> {
            IDNumberTreeNode node = MemberReader.findProcessMemberByNum((String)this.getAdjustQueryService().getCxt().getModelNumber(), (String)e);
            if (node != IDNumberTreeNode.NotFoundTreeNode) {
                dimensionScope.addDimeMemRange(node.getId().longValue(), RangeEnum.VALUE_10.getValue());
            }
        });
        this.getModel().setValue(key, (Object)dimensionScope.toString());
        this.getView().updateView(key);
    }

    private String getHeadSelector() {
        return "name,number,applyscope,description,model,status,journaltype,modifier,modifytime,creator,createtime,bussnesstype,entity,";
    }

    private void setHeadData(DynamicObject dyob) {
        this.getModel().setValue("name", (Object)dyob.getLocaleString("name"));
        this.getModel().setValue("number", (Object)dyob.getString("number"));
        this.getModel().setValue("applyscope", (Object)dyob.getString("applyscope"));
        this.getModel().setValue("description", (Object)dyob.getLocaleString("description"));
        this.getModel().setValue("model", (Object)dyob.getDynamicObject("model"));
        this.getModel().setValue("status", dyob.get("status"));
        this.getModel().setValue("journaltype", dyob.get("journaltype"));
        this.getModel().setValue("creator", dyob.get("creator"));
        this.getModel().setValue("createtime", dyob.get("createtime"));
        this.getModel().setValue("bussnesstype", dyob.get("bussnesstype"));
        this.getModel().setValue("entity", dyob.get("entity"));
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String ctrlKey = e.getKey();
        if (ctrlKey.startsWith(f7KeyPrefix)) {
            TextEdit edit = new TextEdit();
            edit.setKey(ctrlKey);
            edit.setModel(this.getModel());
            edit.setView(this.getView());
            edit.setDraggable(true);
            edit.setDroppable(true);
            edit.addClickListener((ClickListener)this);
            e.setControl((Control)edit);
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        }
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.endsWith("_audittrail")) {
            MulBasedataEdit ed = (MulBasedataEdit)this.getControl("audittrail");
            this.setAuditTrailDefaultFilter((BasedataEdit)ed);
            ed.click();
        } else if (key.endsWith("_process")) {
            MulBasedataEdit ed = (MulBasedataEdit)this.getControl("process");
            ed.setQFilter(this.setProcessDefaultFilter());
            ed.click();
        } else if (key.startsWith(f7KeyPrefix)) {
            FormShowParameter para = null;
            para = new FormShowParameter();
            if (!key.contains("bcm_icmembertree")) {
                para.setFormId("bcm_multiplememberf7_adj");
            } else {
                para.setFormId("bcm_mulmemberf7_tem_ic");
            }
            para.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> params = new HashMap<String, String>(16);
            int paramvalue = this.getF7ModelCache().get(key).getDimension().getSeq();
            params.put("dimension", paramvalue + "");
            params.put("sign", key);
            params.put(key, SerializationUtils.toJsonString((Object)this.getF7ModelCache().get(key).getdimMembers()));
            if (this.getModel().getValue("entity") != null) {
                params.put("opentype", "adjust,elim");
            }
            para.setCustomParams(params);
            if (key.contains(KEY_ICMEMBERTREE_INTERNALCOMPANY)) {
                StyleCss inlineStyleCss = new StyleCss();
                inlineStyleCss.setHeight("730");
                inlineStyleCss.setWidth("1380");
                para.getOpenStyle().setInlineStyleCss(inlineStyleCss);
            }
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String modelId = pageCache.get("KEY_MODEL_ID");
            para.setCaption(String.format("%1$s - %2$s", QueryDimensionServiceHelper.getDimByDseq((int)paramvalue, (String)modelId).getString("name"), ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"RptAdjustQueryEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            para.setCloseCallBack(closeCallBack);
            this.getView().showForm(para);
        }
    }

    private QFilter setProcessDefaultFilter() {
        QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter spFilter = new QFilter("number", "in", (Object)new String[]{"DADJ", "DEJE"});
        QFilter ccTotalFilter = new QFilter("model", "=", (Object)this.getModelId());
        ccTotalFilter.and("number", "=", (Object)"CCTotal");
        DynamicObjectCollection realCol = QueryServiceHelper.query((String)"bcm_processmembertree", (String)"id,number,longnumber", (QFilter[])new QFilter[]{ccTotalFilter});
        if (realCol.size() == 1) {
            QFilter adjFilter = new QFilter("model", "=", (Object)this.getModelId());
            adjFilter.and("isleaf", "=", (Object)"1");
            adjFilter.and("longnumber", "like", (Object)(((DynamicObject)realCol.get(0)).getString("longnumber") + "!%"));
            spFilter.or(adjFilter);
        }
        QFilter readOrWritePermFilter = PermissionServiceImpl.getInstance((Long)this.getModelId()).getReadOrWritePermFilter(MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)"Process"), "bcm_processmembertree", "id");
        modelFilter.and(readOrWritePermFilter);
        return modelFilter.and(spFilter);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.startsWith(f7KeyPrefix)) {
            if (e.getChangeSet()[0].getNewValue() instanceof String && StringUtils.isEmpty((String)((String)e.getChangeSet()[0].getNewValue()))) {
                DimensionScope dimScope = this.getF7ModelCache().get(key);
                dimScope.clear();
                this.getPageCache().put("f7MapCacheKey", SerializationUtils.serializeToBase64(this.getF7ModelCache()));
                if (key.startsWith("bcm_audittrialmembertree") || key.startsWith("bcm_processmembertree")) {
                    this.getView().getModel().setValue(key.startsWith("bcm_audittrialmembertree") ? "audittrail" : "process", null);
                }
                return;
            }
        } else if ("audittrail".equals(key) || "process".equals(key)) {
            String realkey = this.sugarF7Key(key, this.getF7ModelCache().keySet());
            DimensionScope dimScope = this.getF7ModelCache().get(realkey);
            dimScope.clear();
            DynamicObjectCollection doc = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
            StringBuilder sb = new StringBuilder();
            if (doc != null && doc.size() > 0) {
                for (DynamicObject obj : doc) {
                    String name = ((DynamicObject)obj.get("fbasedataid")).getString("name");
                    sb.append(name).append(';');
                    DynamicObject mem1 = (DynamicObject)obj.get("fbasedataid");
                    dimScope.addDimeMemRange(mem1.getLong("id"), RangeEnum.VALUE_10.getValue());
                }
                sb = new StringBuilder(sb.substring(0, sb.length() - 1));
                this.getPageCache().put("f7MapCacheKey", SerializationUtils.serializeToBase64(this.getF7ModelCache()));
            } else {
                this.getPageCache().put("f7MapCacheKey", SerializationUtils.serializeToBase64(this.getF7ModelCache()));
            }
            this.getModel().setValue(realkey, (Object)sb.toString());
        } else if ("bussnesstype".equals(key)) {
            // empty if block
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String key = evt.getActionId();
        String actionId = evt.getActionId();
        if (key.startsWith(f7KeyPrefix)) {
            Object returnData = evt.getReturnData();
            if (returnData == null) {
                return;
            }
            if (ObjectUtils.isEmpty((Object)returnData)) {
                this.getModel().setValue(actionId, null);
                this.getF7ModelCache().get(key).clear();
                this.getPageCache().put("f7MapCacheKey", SerializationUtils.serializeToBase64(this.getF7ModelCache()));
                return;
            }
            DynamicObjectCollection doc = (DynamicObjectCollection)evt.getReturnData();
            if (doc != null) {
                DimensionScope dimScope = this.getF7ModelCache().get(key);
                dimScope.clear();
                doc.stream().forEach(e -> {
                    long pid = e.getLong(6);
                    long id = e.getLong(4);
                    int scope = e.getInt(5);
                    String number = e.getString(2);
                    if ("Process".equals(dimScope.getDimension().getNumber()) && "ADJT".equalsIgnoreCase(number)) {
                        Arrays.asList("ADJ", "DADJ").stream().forEach(a -> {
                            IDNumberTreeNode node = MemberReader.findProcessMemberByNum((String)this.getAdjustQueryService().getCxt().getModelNumber(), (String)a);
                            if (node != IDNumberTreeNode.NotFoundTreeNode) {
                                dimScope.addDimeMemRange(node.getId().longValue(), RangeEnum.VALUE_10.getValue());
                            }
                        });
                    } else if (id != 0L && Long.valueOf(id).toString().length() < 4) {
                        dimScope.addDimPreAttribute(number, scope);
                    } else {
                        dimScope.addDimeMemRange(id, scope);
                    }
                });
                this.getModel().setValue(actionId, (Object)dimScope.toString());
                this.getPageCache().put("f7MapCacheKey", SerializationUtils.serializeToBase64(this.getF7ModelCache()));
            }
        }
    }

    private void setAuditTrailDefaultFilter(BasedataEdit ed) {
        QFilter filter1 = new QFilter("model", "=", (Object)this.getModelId());
        filter1.and("isleaf", "=", (Object)"1");
        filter1.and("datasource", "=", (Object)"3");
        QFilter readOrWritePermFilter = PermissionServiceImpl.getInstance((Long)this.getModelId()).getReadOrWritePermFilter(MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)"AuditTrail"), "bcm_audittrialmembertree", "id");
        filter1.and(readOrWritePermFilter);
        ed.setQFilter(filter1);
    }

    private Dimension[] sortDynaCollection(List<Dimension> coll) {
        Dimension[] darrays = new Dimension[coll.size()];
        Iterator<Dimension> iter = coll.iterator();
        int index = 3;
        block10: while (iter.hasNext()) {
            Dimension dd = iter.next();
            switch (dd.getNumber().toLowerCase(Locale.ENGLISH)) {
                case "scenario": {
                    darrays[0] = dd;
                    continue block10;
                }
                case "year": {
                    darrays[1] = dd;
                    continue block10;
                }
                case "period": {
                    darrays[2] = dd;
                    continue block10;
                }
            }
            darrays[index++] = dd;
        }
        return darrays;
    }

    private void bindCtrlMapping() {
        String f7MapFields = this.getPageCache().get("f7MapFields");
        if (StringUtils.isEmpty((String)f7MapFields)) {
            return;
        }
        String[] fields = f7MapFields.split(";");
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        for (String field : fields) {
            if (props.containsKey((Object)field)) continue;
            TextEditElement.addTextFieldToMainEntity((Container)((Container)this.getControl("fieldsetpanelap")), (MainEntityType)mainEntityType, null, (String)field, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
        }
    }

    private void addF7Items(ContainerAp<Container> pageviewpanel) {
        HashMap<String, DimensionScope> f7keys = new HashMap<String, DimensionScope>(16);
        for (Dimension e : this.sortDynaCollection(this.getAdjustQueryService().getCxt().getDimensions())) {
            EntryFieldAp f7Field = new EntryFieldAp();
            f7Field.setName(new LocaleString(e.getName()));
            if ("bcm_entitymembertree".equals(e.getMembermodel())) {
                f7Field.setName(ResManager.getLocaleString((String)"\u5165\u5e93\u7ec4\u7ec7", (String)"RptAdjustQueryEditPlugin_5", (String)"fi-bcm-formplugin"));
            }
            String f7Key = e.getMembermodel() + '_' + e.getNumber().toLowerCase(Locale.ENGLISH);
            f7keys.put(f7Key, new DimensionScope(this.getModelId() + "", e));
            f7Field.setKey(f7Key);
            f7Field.setLabelDirection("v");
            f7Field.setShowTitle(false);
            TextField basedata = new TextField();
            if ("Scenario".equals(e.getNumber()) || "Period".equals(e.getNumber()) || "Year".equals(e.getNumber())) {
                basedata.setMustInput(true);
            }
            basedata.setEditStyle(1);
            f7Field.setShowTitle(true);
            f7Field.setField((Field)basedata);
            f7Field.setFieldTextAlign("center");
            f7Field.setAlignSelf("center");
            f7Field.setTextAlign("left");
            f7Field.setFontSize(12);
            Style style = new Style();
            Margin margin = new Margin();
            margin.setRight("10px");
            margin.setTop("20px");
            margin.setBottom("10px");
            style.setMargin(margin);
            f7Field.setStyle(style);
            f7Field.setFireUpdEvt(true);
            pageviewpanel.getItems().add(f7Field);
        }
        this.setF7DimModels(f7keys);
    }

    private void initPageViewPanel() {
        FieldsetPanelAp fieldsetpanelap = new FieldsetPanelAp();
        fieldsetpanelap.setKey("fieldsetpanelap");
        fieldsetpanelap.setGrow(0);
        fieldsetpanelap.setName(new LocaleString(ResManager.loadKDString((String)"\u901a\u7528\u7ef4\u5ea6", (String)"RptAdjustQueryEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        this.addF7Items((ContainerAp<Container>)fieldsetpanelap);
        this.getView().updateControlMetadata("fieldsetpanelap", fieldsetpanelap.createControl());
        StringBuilder sb = new StringBuilder();
        for (ControlAp ap : fieldsetpanelap.getItems()) {
            if (!ap.getKey().startsWith(f7KeyPrefix)) continue;
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(ap.getKey());
        }
        this.getPageCache().put("f7MapFields", sb.toString());
        this.getView().updateView("fieldsetpanelap");
    }

    private void setEnable() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
        if (OPENTYPE_EDIT.equals(this.getView().getFormShowParameter().getCustomParam("pageopentype"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "applyscope"});
        }
    }

    private String sugarF7Key(String dimNumber, Collection<String> f7keys) {
        return f7keys.stream().filter(f7key -> f7key.contains(dimNumber.toLowerCase(Locale.ENGLISH))).findFirst().orElse(null);
    }
}

