/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Delete;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.enums.ApplyScopeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.BillListHyperLinkClickUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class RptAdjustQueryListPlugin
extends AbstractBaseListPlugin {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(RptAdjustQueryListPlugin.class);
    private static final String KEY_SELECTROWINFO = "key_selectRowInfo";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
        if (StringUtils.isNotEmpty((CharSequence)modelId)) {
            QFilter qcf4All = new QFilter("applyscope", "=", (Object)ApplyScopeEnum.ALL.getIndex());
            RequestContext tx = RequestContext.get();
            QFilter scopeQcf4Self = new QFilter("applyscope", "=", (Object)ApplyScopeEnum.SELF.getIndex());
            QFilter scopeQcf4Modify = new QFilter("modifier", "=", (Object)LongUtil.toLong((Object)tx.getUserId()));
            QFilter qcf4Self = scopeQcf4Self.and(scopeQcf4Modify);
            QFilter qcf4Scope = qcf4All.or(qcf4Self);
            QFilter qcf4Model = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
            e.getQFilters().add(qcf4Scope);
            e.getQFilters().add(qcf4Model);
        } else {
            QFilter none = new QFilter("1", "=", (Object)0);
            e.getQFilters().add(none);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Object modelIdObj = this.getView().getFormShowParameter().getCustomParam("model");
        String modelId = null;
        modelId = modelIdObj != null ? modelIdObj.toString() : UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model");
        if (StringUtils.isNotEmpty((CharSequence)modelId)) {
            this.getModel().setValue("model", (Object)modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId);
        }
        if (modelId == null || modelId.equals("0")) {
            this.getView().showTipNotification(MessageConstant.getMODEL_NOTEXISTS());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        if ("model".equals(e.getProperty().getName())) {
            String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
            if (modelId != null) {
                if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                this.getPageCache().put("KEY_MODEL_ID", modelId);
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
            } else {
                this.getModel().setValue("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (this.getPageCache().get("KEY_MODEL_ID") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u4f53\u7cfb\u3002", (String)"RptAdjustQueryListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String key = evt.getItemKey();
        if ("btn_addnew".equals(key)) {
            ListShowParameter param = new ListShowParameter();
            param.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            param.setBillFormId("bcm_rptadjustdata");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId("bcm_rptadjustquery_edit");
            param.setCustomParam("pageopentype", (Object)"ADDNEW");
            param.setCaption(ResManager.loadKDString((String)"\u8c03\u6574\u62b5\u9500\u5206\u5f55\u67e5\u8be2\u5217\u8868", (String)"RptAdjustQueryListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ajustPlanNew");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Delete) {
            try {
                this.getPageCache().put(KEY_SELECTROWINFO, SerializationUtils.toJsonString(this.getlogMessageMap()));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String s;
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("delete".equals(afterDoOperationEventArgs.getObjectId()) && (s = this.getPageCache().get(KEY_SELECTROWINFO)) != null) {
            Map logMessageMap = (Map)SerializationUtils.fromJsonString((String)s, Map.class);
            for (Map.Entry entry : logMessageMap.entrySet()) {
                ArrayList value = (ArrayList)entry.getValue();
                String number = (String)value.get(0);
                String name = (String)value.get(1);
                this.writeMultiLangLog(OpItemEnum.DELETE.getOpMultiLangEnumBridge(), new OPDescMultiLangEnumBridge("%1$s %2$s \u5220\u9664\u6210\u529f\u3002", "RptAdjustQueryListPlugin_10", "fi-bcm-formplugin", new String[]{number, name}));
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        BillList billList = (BillList)this.getControl("billlistap");
        switch (actionId) {
            case "ajustPlanNew": 
            case "ajustPlanEdit": {
                billList.refresh();
                break;
            }
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        Object id = BillListHyperLinkClickUtil.getObjectPkIdFromEvt(args);
        if (!QueryServiceHelper.exists((String)"bcm_rptadjustqueryplan", (Object)id)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u5e95\u7a3f\u5f0f\u5206\u5f55\u67e5\u8be2\u62a5\u8868\u65b9\u6848\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u4fee\u6539\u3002", (String)"RptAdjustQueryListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String pageId = this.getView().getPageId() + id;
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            ListShowParameter param = new ListShowParameter();
            param.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            param.setBillFormId("bcm_rptadjustdata");
            param.setCustomParam("pkId", id);
            param.setCaption(ResManager.loadKDString((String)"\u8c03\u6574\u62b5\u9500\u5206\u5f55\u67e5\u8be2", (String)"RptAdjustQueryListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            param.setStatus(OperationStatus.ADDNEW);
            param.setCustomParam("pageopentype", (Object)"EDIT");
            param.setFormId(id.toString());
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId("bcm_rptadjustquery_edit");
            param.setPageId(pageId);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ajustPlanEdit");
            param.setCloseCallBack(closeCallBack);
            if (parentView == null) {
                this.getView().showForm((FormShowParameter)param);
            } else {
                parentView.showForm((FormShowParameter)param);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
        HashMap<String, ArrayList<Object>> map = null;
        try {
            map = this.getlogMessageMap();
            for (Map.Entry<String, ArrayList<Object>> entry : map.entrySet()) {
                ArrayList<Object> value = entry.getValue();
                String number = (String)value.get(0);
                String name = (String)value.get(1);
                this.writeMultiLangLog(OpItemEnum.LOOKUP.getOpMultiLangEnumBridge(), new OPDescMultiLangEnumBridge("%1$s %2$s \u67e5\u770b\u6210\u529f\u3002", "RptAdjustQueryListPlugin_11", "fi-bcm-formplugin", new String[]{number, name}));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private HashMap<String, ArrayList<Object>> getlogMessageMap() {
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        DynamicObjectCollection planDyns = QueryServiceHelper.query((String)"bcm_rptadjustqueryplan", (String)"id,name,number", (QFilter[])new QFBuilder("id", "in", (Object)billlistap.getSelectedRows().getPrimaryKeyValues()).toArray());
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>(16);
        for (DynamicObject dyn : planDyns) {
            ArrayList<String> list = new ArrayList<String>(10);
            list.add(dyn.getString("number"));
            list.add(dyn.getString("name"));
            map.put(dyn.getString("id"), list);
        }
        return map;
    }
}

