/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.model.SpreadDimensionEntry;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.common.util.LongUtil;

public class SetSheetShowPlugin
extends AbstractFormPlugin {
    protected static final String entryentity = "entryentity";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListeners();
    }

    private void addListeners() {
        this.addClickListeners(new String[]{"lab_showall", "lab_shownumber", "lab_showname", "btn_ok_all", "btn_ok_cur"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID").toString();
        String pageNumber = (String)this.getView().getFormShowParameter().getCustomParam("pageNumber");
        AdjustModel adjustModel = (AdjustModel)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("adjustModel")));
        QFilter modelQFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter pageQFilter = new QFilter("pagenumber", "=", (Object)pageNumber);
        String selectFields = "id, dimension, dimension.name, dimension.membermodel, isshownumber, isshowname, model, pagenumber";
        DynamicObjectCollection spreadStyles = QueryServiceHelper.query((String)"bcm_spreadstyle", (String)selectFields, (QFilter[])new QFilter[]{modelQFilter, pageQFilter}, (String)"dimension.dseq");
        int i = 0;
        HashMap<String, String> styleMap = new HashMap<String, String>(16);
        for (DynamicObject spreadStyle : spreadStyles) {
            String dimensionID = String.valueOf(spreadStyle.getLong("dimension"));
            styleMap.put("dimensionID" + dimensionID, dimensionID);
            styleMap.put("isshownumber" + dimensionID, spreadStyle.getString("isshownumber"));
            styleMap.put("isshowname" + dimensionID, spreadStyle.getString("isshowname"));
            styleMap.put("pagenumber", spreadStyle.getString("pagenumber"));
        }
        for (SpreadDimensionEntry spread : adjustModel.getSpreadDimensionEntries()) {
            if ("bcm_mergenode".equals(spread.getNumber())) continue;
            Dimension dimension = spread.getDimension();
            String dimensionName = dimension.getName();
            String dimensionID = String.valueOf(dimension.getId());
            if (dimension.getName() == null) continue;
            this.getModel().insertEntryRow(entryentity, i);
            this.getModel().setValue("dimensionname", (Object)dimensionName, i);
            this.getModel().setValue("dimension", (Object)dimension.getId(), i);
            this.getModel().setValue("model", (Object)modelId, i);
            if (dimensionID.equals(styleMap.get("dimensionID" + dimensionID))) {
                this.getModel().setValue("isshownumber", styleMap.get("isshownumber" + dimensionID), i);
                this.getModel().setValue("isshowname", styleMap.get("isshowname" + dimensionID), i);
                this.getModel().setValue("pagenumber", styleMap.get("pagenumber"), i);
            } else {
                this.getModel().setValue("isshownumber", (Object)"1", i);
                this.getModel().setValue("isshowname", (Object)"1", i);
                this.getModel().setValue("pagenumber", null, i);
            }
            ++i;
        }
        this.getPageCache().put(entryentity, SerializationUtils.toJsonString((Object)this.getModel().getEntryEntity(entryentity)));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        IDataModel model = this.getModel();
        String pageNumber = (String)this.getView().getFormShowParameter().getCustomParam("pageNumber");
        String modelId = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID").toString();
        DynamicObjectCollection entityData = model.getEntryEntity(entryentity);
        switch (key) {
            case "lab_showall": {
                for (int i = 0; i < entityData.size(); ++i) {
                    this.getModel().setValue("isshownumber", (Object)1, i);
                    this.getModel().setValue("isshowname", (Object)1, i);
                }
                break;
            }
            case "lab_shownumber": {
                for (int i = 0; i < entityData.size(); ++i) {
                    this.getModel().setValue("isshownumber", (Object)1, i);
                    this.getModel().setValue("isshowname", (Object)0, i);
                }
                break;
            }
            case "lab_showname": {
                for (int i = 0; i < entityData.size(); ++i) {
                    this.getModel().setValue("isshownumber", (Object)0, i);
                    this.getModel().setValue("isshowname", (Object)1, i);
                }
                break;
            }
            case "btn_ok_all": {
                this.getView().returnDataToParent(this.saveStyle(modelId, null, entityData));
                this.getView().close();
                break;
            }
            case "btn_ok_cur": {
                this.getView().returnDataToParent(this.saveStyle(modelId, pageNumber, entityData));
                this.getView().close();
            }
        }
    }

    private Map<String, Object> saveStyle(String modelId, String pageNumber, DynamicObjectCollection entityData) {
        this.getPageCache().put(entryentity, SerializationUtils.toJsonString((Object)entityData));
        HashMap<String, Object> returnMap = new HashMap<String, Object>(10);
        ArrayList<String> dimensionIds = new ArrayList<String>(10);
        for (DynamicObject entity : entityData) {
            DynamicObject dimension = entity.getDynamicObject("dimension");
            dimensionIds.add(dimension.getString("id"));
        }
        DynamicObject[] existStyleData = this.getExistStyleData(dimensionIds);
        HashSet<DynamicObject> newStyleSet = new HashSet<DynamicObject>(10);
        HashSet<DynamicObject> updateStyleSet = new HashSet<DynamicObject>(10);
        for (DynamicObject entity : entityData) {
            DynamicObject dimension = entity.getDynamicObject("dimension");
            DynamicObject Style2 = this.checkIsExist(existStyleData, dimension.getString("id"));
            if (Style2.getString("dimension") == null) {
                Style2.set("dimension", (Object)entity.getDynamicObject("dimension"));
                Style2.set("isshownumber", (Object)entity.getString("isshownumber"));
                Style2.set("isshowname", (Object)entity.getString("isshowname"));
                Style2.set("model", (Object)modelId);
                Style2.set("pagenumber", (Object)pageNumber);
                newStyleSet.add(Style2);
            } else {
                Style2.set("isshownumber", (Object)entity.getString("isshownumber"));
                Style2.set("isshowname", (Object)entity.getString("isshowname"));
                updateStyleSet.add(Style2);
            }
            if (updateStyleSet.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])updateStyleSet.toArray(new DynamicObject[updateStyleSet.size()]));
            }
            if (newStyleSet.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])newStyleSet.toArray(new DynamicObject[newStyleSet.size()]));
            }
            String fieldmapped = dimension.getString("fieldmapped");
            returnMap.put(entity.getString("dimension.number") + "isshowname", entity.getBoolean("isshowname"));
            returnMap.put(entity.getString("dimension.number") + "isshownumber", entity.getBoolean("isshownumber"));
            if (StringUtils.isNotEmpty((String)fieldmapped)) {
                String dimIndex = fieldmapped.substring(3);
                returnMap.put(entity.getString("dimension.membermodel") + dimIndex + "isshowname", entity.getBoolean("isshowname"));
                returnMap.put(entity.getString("dimension.membermodel") + dimIndex + "isshownumber", entity.getBoolean("isshownumber"));
                continue;
            }
            returnMap.put(entity.getString("dimension.membermodel") + "isshowname", entity.getBoolean("isshowname"));
            returnMap.put(entity.getString("dimension.membermodel") + "isshownumber", entity.getBoolean("isshownumber"));
        }
        return returnMap;
    }

    private DynamicObject[] getExistStyleData(List<String> dimensionIds) {
        String selectFields = "id, dimension, dimension.membermodel, dimension.name, isshownumber, isshowname, model, pagenumber";
        return BusinessDataServiceHelper.load((String)"bcm_spreadstyle", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("dimension", "in", (Object)LongUtil.toLongList(dimensionIds))});
    }

    private DynamicObject checkIsExist(DynamicObject[] existStyleData, String dimensionId) {
        for (DynamicObject existstyle : existStyleData) {
            DynamicObject dimension = existstyle.getDynamicObject("dimension");
            if (!dimensionId.equals(dimension.getString("id"))) continue;
            return existstyle;
        }
        return BusinessDataServiceHelper.newDynamicObject((String)"bcm_spreadstyle");
    }

    private Boolean istEntryEntityDataChange() {
        String oldEntryEntity = this.getPageCache().get(entryentity);
        if (oldEntryEntity == null) {
            return true;
        }
        DynamicObjectCollection entryentitycolls = this.getModel().getEntryEntity(entryentity);
        return !oldEntryEntity.equals(SerializationUtils.toJsonString((Object)entryentitycolls));
    }
}

