/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.servicehelper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.model.SpreadDimensionEntry;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.adjust.AdjustOperationUtils;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.adjust.model.AdjustSpreadActionHandlerProxy;
import kd.fi.bcm.formplugin.adjust.model.AreaPositionManger;
import kd.fi.bcm.formplugin.cslscheme.RptAdjustEntryCopyHelper;
import kd.fi.bcm.formplugin.util.ObjectConvertUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import org.apache.commons.compress.utils.Lists;

public class AdjustModelBuildServiceHelper {
    public static AdjustModel buildAdjustModel(long adjustId) {
        AdjustModel am = new AdjustModel();
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)adjustId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust"));
        if (dy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u5f55\u5df2\u4e0d\u5b58\u5728", (String)"RptAdjustOffsetPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        am.loadDynaObj2Model(dy);
        return am;
    }

    public static SpreadManager buildManualSpreadModel(AdjustSpreadActionHandlerProxy proxy, boolean isIncludeLinkage) {
        AdjustModelBuildServiceHelper.clearSpreadManger(proxy.getSpreadManager());
        AdjustModelBuildServiceHelper.buildAdjustSpreadHead(proxy);
        AdjustModelBuildServiceHelper.buildAdjustSpreadEntry(proxy, isIncludeLinkage);
        return proxy.getSpreadManager();
    }

    public static void clearSpreadManger(SpreadManager sm) {
        sm.getBook().getSheet(0).clear();
    }

    public static void buildAdjustSpreadHead(AdjustSpreadActionHandlerProxy proxy) {
        AdjustModel adjust = proxy.getAdjust();
        int startCol = 0;
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, "groupnum", ResManager.loadKDString((String)"\u5206\u7ec4\u53f7", (String)"AdjustModelBuildServiceHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, "dseq", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"AdjustModelBuildServiceHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, "description", ResManager.loadKDString((String)"\u6458\u8981", (String)"AdjustModelBuildServiceHelper_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        for (SpreadDimensionEntry spread : adjust.getSpreadDimensionEntries()) {
            AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, spread.getNumber(), spread.getDimension().getName(), spread.getDimension());
        }
        boolean isDisplayMultiCurrency = "1".equals(adjust.getMultiplecurrency());
        String modelNum = MemberReader.findModelNumberById((Object)adjust.getModelId());
        IDNumberTreeNode srcCurNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Currency", (long)adjust.getCvtBeforeCurrencyId());
        IDNumberTreeNode mergeNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)adjust.getMergeId());
        IDNumberTreeNode defaultTarCurNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)"Currency", (String)mergeNode.getCurrency());
        if (isDisplayMultiCurrency) {
            startCol = AdjustModelBuildServiceHelper.addBeforeCvtMoneyColumn(proxy, startCol, srcCurNode.getName());
            startCol = AdjustModelBuildServiceHelper.addAfterCvtMoneyColumn(proxy, startCol, srcCurNode, defaultTarCurNode, true);
            Set<Long> curIds = RptAdjustEntryCopyHelper.getMultipleCurrency(adjust.getModelId(), adjust.getMergeId(), adjust.getBussnesstype());
            for (Long curId : curIds) {
                IDNumberTreeNode tarCurNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Currency", (long)curId);
                if (tarCurNode == IDNumberTreeNode.NotFoundTreeNode || "DC".equals(tarCurNode.getNumber()) || "EC".equals(tarCurNode.getNumber()) || "PC".equals(tarCurNode.getNumber()) || "OC".equals(tarCurNode.getNumber()) || defaultTarCurNode.getNumber().equals(tarCurNode.getNumber())) continue;
                startCol = AdjustModelBuildServiceHelper.addAfterCvtMoneyColumn(proxy, startCol, srcCurNode, tarCurNode, false);
            }
        } else if (srcCurNode != IDNumberTreeNode.NotFoundTreeNode) {
            startCol = AdjustModelBuildServiceHelper.addBeforeCvtMoneyColumn(proxy, startCol, srcCurNode.getName());
            startCol = AdjustModelBuildServiceHelper.addAfterCvtMoneyColumn(proxy, startCol, srcCurNode, defaultTarCurNode, true);
        } else {
            startCol = AdjustModelBuildServiceHelper.addBeforeCvtMoneyColumn(proxy, startCol, null);
            startCol = AdjustModelBuildServiceHelper.addAfterCvtMoneyColumn(proxy, startCol, null, null, true);
        }
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, "entryrowtype", ResManager.loadKDString((String)"\u5206\u5f55\u884c\u7c7b\u578b", (String)"AdjustModelBuildServiceHelper_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, "entrysource", ResManager.loadKDString((String)"\u5206\u5f55\u6765\u6e90", (String)"AdjustModelBuildServiceHelper_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, "linksource", ResManager.loadKDString((String)"\u5173\u8054\u4e3b\u9644\u8054\u52a8", (String)"AdjustModelBuildServiceHelper_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, "ischanged", ResManager.loadKDString((String)"\u662f\u5426\u624b\u5de5\u4fee\u6539", (String)"AdjustModelBuildServiceHelper_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, "calculatecontent", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"AdjustModelBuildServiceHelper_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
    }

    public static Map<String, String> getColumnNameMap(AdjustSpreadActionHandlerProxy proxy) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        AdjustModel adjust = proxy.getAdjust();
        result.put("groupnum", ResManager.loadKDString((String)"\u5206\u7ec4\u53f7", (String)"AdjustModelBuildServiceHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        result.put("dseq", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"AdjustModelBuildServiceHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        result.put("description", ResManager.loadKDString((String)"\u6458\u8981", (String)"AdjustModelBuildServiceHelper_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        for (SpreadDimensionEntry spread : adjust.getSpreadDimensionEntries()) {
            result.put(spread.getDimension().getNumber(), spread.getDimension().getName());
        }
        String cvtBeforeDebitName = ResManager.loadKDString((String)"\u6298\u7b97\u524d\u501f\u65b9", (String)"AdjustModelBuildServiceHelper_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String cvtBeforeCreditName = ResManager.loadKDString((String)"\u6298\u7b97\u524d\u8d37\u65b9", (String)"AdjustModelBuildServiceHelper_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String cvtBeforeSumMoney = ResManager.loadKDString((String)"\u6298\u7b97\u524d\u91d1\u989d", (String)"AdjustModelBuildServiceHelper_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        boolean isDisplayMultiCurrency = "1".equals(adjust.getMultiplecurrency());
        String modelNum = MemberReader.findModelNumberById((Object)adjust.getModelId());
        IDNumberTreeNode srcCurNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Currency", (long)adjust.getCvtBeforeCurrencyId());
        IDNumberTreeNode mergeNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)adjust.getMergeId());
        IDNumberTreeNode defaultTarCurNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)"Currency", (String)mergeNode.getCurrency());
        if (srcCurNode == IDNumberTreeNode.NotFoundTreeNode) {
            result.put("cvtbeforedebit", cvtBeforeDebitName);
            result.put("cvtbeforecredit", cvtBeforeCreditName);
            result.put("cvtbeforesummoney", cvtBeforeSumMoney);
            result.put("rate", ResManager.loadKDString((String)"\u6c47\u7387", (String)"AdjustModelBuildServiceHelper_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            result.put("debit", ResManager.loadKDString((String)"\u501f\u65b9", (String)"AdjustModelBuildServiceHelper_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            result.put("credit", ResManager.loadKDString((String)"\u8d37\u65b9", (String)"AdjustModelBuildServiceHelper_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            result.put("summoney", ResManager.loadKDString((String)"\u91d1\u989d", (String)"AdjustModelBuildServiceHelper_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            result.put("cvtbeforedebit", cvtBeforeDebitName + "(" + srcCurNode.getName() + ")");
            result.put("cvtbeforecredit", cvtBeforeCreditName + "(" + srcCurNode.getName() + ")");
            result.put("cvtbeforesummoney", cvtBeforeSumMoney + "(" + srcCurNode.getName() + ")");
            result.put("rate", String.format(ResManager.loadKDString((String)"\u6c47\u7387(%1$s->%2$s)", (String)"AdjustModelBuildServiceHelper_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), srcCurNode.getName(), defaultTarCurNode.getName()));
            result.put("debit", String.format(ResManager.loadKDString((String)"\u501f\u65b9(%1$s->%2$s)", (String)"AdjustModelBuildServiceHelper_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), srcCurNode.getName(), defaultTarCurNode.getName()));
            result.put("credit", String.format(ResManager.loadKDString((String)"\u8d37\u65b9(%1$s->%2$s)", (String)"AdjustModelBuildServiceHelper_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), srcCurNode.getName(), defaultTarCurNode.getName()));
            result.put("summoney", String.format(ResManager.loadKDString((String)"\u91d1\u989d(%1$s->%2$s)", (String)"AdjustModelBuildServiceHelper_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), srcCurNode.getName(), defaultTarCurNode.getName()));
        }
        if (isDisplayMultiCurrency) {
            Set<Long> curIds = RptAdjustEntryCopyHelper.getMultipleCurrency(adjust.getModelId(), adjust.getMergeId(), adjust.getBussnesstype());
            for (Long curId : curIds) {
                IDNumberTreeNode tarCurNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Currency", (long)curId);
                if (tarCurNode == IDNumberTreeNode.NotFoundTreeNode || "DC".equals(tarCurNode.getNumber()) || "EC".equals(tarCurNode.getNumber()) || "PC".equals(tarCurNode.getNumber()) || "OC".equals(tarCurNode.getNumber()) || defaultTarCurNode.getNumber().equals(tarCurNode.getNumber())) continue;
                result.put("rate_" + tarCurNode.getNumber(), String.format(ResManager.loadKDString((String)"\u6c47\u7387(%1$s->%2$s)", (String)"AdjustModelBuildServiceHelper_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), srcCurNode.getName(), tarCurNode.getName()));
                result.put("debit_" + tarCurNode.getNumber(), String.format(ResManager.loadKDString((String)"\u501f\u65b9(%1$s->%2$s)", (String)"AdjustModelBuildServiceHelper_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), srcCurNode.getName(), tarCurNode.getName()));
                result.put("credit_" + tarCurNode.getNumber(), String.format(ResManager.loadKDString((String)"\u8d37\u65b9(%1$s->%2$s)", (String)"AdjustModelBuildServiceHelper_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), srcCurNode.getName(), tarCurNode.getName()));
                result.put("summoney_" + tarCurNode.getNumber(), String.format(ResManager.loadKDString((String)"\u91d1\u989d(%1$s->%2$s)", (String)"AdjustModelBuildServiceHelper_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), srcCurNode.getName(), tarCurNode.getName()));
            }
        }
        result.put("entryrowtype", ResManager.loadKDString((String)"\u5206\u5f55\u884c\u7c7b\u578b", (String)"AdjustModelBuildServiceHelper_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        result.put("entrysource", ResManager.loadKDString((String)"\u5206\u5f55\u6765\u6e90", (String)"AdjustModelBuildServiceHelper_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        result.put("linksource", ResManager.loadKDString((String)"\u5173\u8054\u4e3b\u9644\u8054\u52a8", (String)"AdjustModelBuildServiceHelper_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        result.put("ischanged", ResManager.loadKDString((String)"\u662f\u5426\u624b\u5de5\u4fee\u6539", (String)"AdjustModelBuildServiceHelper_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        result.put("calculatecontent", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"AdjustModelBuildServiceHelper_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        return result;
    }

    public static void setColumnHeadCell(AdjustSpreadActionHandlerProxy proxy, int col, String entitysign, String name, Dimension dim) {
        Cell headCell = proxy.setCellValue(0, col, name);
        headCell.setUserObject("entitysign", (Object)entitysign);
        headCell.getDimensions().clear();
        if (dim != null) {
            headCell.addDimension((IDimension)ThreadCache.get((Object)dim.getNumber(), () -> ObjectConvertUtils.toIDimension(dim)));
        }
    }

    private static int addBeforeCvtMoneyColumn(AdjustSpreadActionHandlerProxy proxy, int startCol, String curName) {
        String cvtBeforeDebitName = ResManager.loadKDString((String)"\u6298\u7b97\u524d\u501f\u65b9", (String)"AdjustModelBuildServiceHelper_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, "cvtbeforedebit", curName == null ? cvtBeforeDebitName : cvtBeforeDebitName + "(" + curName + ")", null);
        String cvtBeforeCreditName = ResManager.loadKDString((String)"\u6298\u7b97\u524d\u8d37\u65b9", (String)"AdjustModelBuildServiceHelper_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, "cvtbeforecredit", curName == null ? cvtBeforeCreditName : cvtBeforeCreditName + "(" + curName + ")", null);
        String cvtBeforeSumMoney = ResManager.loadKDString((String)"\u6298\u7b97\u524d\u91d1\u989d", (String)"AdjustModelBuildServiceHelper_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, "cvtbeforesummoney", curName == null ? cvtBeforeSumMoney : cvtBeforeSumMoney + "(" + curName + ")", null);
        return startCol;
    }

    public static int addAfterCvtMoneyColumn(AdjustSpreadActionHandlerProxy proxy, int startCol, IDNumberTreeNode srcCurNode, IDNumberTreeNode tarCurNode, boolean isDefaultCur) {
        boolean isDisplayMultiCurrency = srcCurNode != null && tarCurNode != null;
        String columnKey = isDefaultCur ? "rate" : "rate_" + tarCurNode.getNumber();
        String columnName = isDisplayMultiCurrency ? String.format(ResManager.loadKDString((String)"\u6c47\u7387(%1$s->%2$s)", (String)"AdjustModelBuildServiceHelper_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), srcCurNode.getName(), tarCurNode.getName()) : ResManager.loadKDString((String)"\u6c47\u7387", (String)"AdjustModelBuildServiceHelper_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, columnKey, columnName, null);
        columnKey = isDefaultCur ? "debit" : "debit_" + tarCurNode.getNumber();
        columnName = isDisplayMultiCurrency ? String.format(ResManager.loadKDString((String)"\u501f\u65b9(%1$s->%2$s)", (String)"AdjustModelBuildServiceHelper_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), srcCurNode.getName(), tarCurNode.getName()) : ResManager.loadKDString((String)"\u501f\u65b9", (String)"AdjustModelBuildServiceHelper_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, columnKey, columnName, null);
        columnKey = isDefaultCur ? "credit" : "credit_" + tarCurNode.getNumber();
        columnName = isDisplayMultiCurrency ? String.format(ResManager.loadKDString((String)"\u8d37\u65b9(%1$s->%2$s)", (String)"AdjustModelBuildServiceHelper_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), srcCurNode.getName(), tarCurNode.getName()) : ResManager.loadKDString((String)"\u8d37\u65b9", (String)"AdjustModelBuildServiceHelper_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, columnKey, columnName, null);
        columnKey = isDefaultCur ? "summoney" : "summoney_" + tarCurNode.getNumber();
        columnName = isDisplayMultiCurrency ? String.format(ResManager.loadKDString((String)"\u91d1\u989d(%1$s->%2$s)", (String)"AdjustModelBuildServiceHelper_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), srcCurNode.getName(), tarCurNode.getName()) : ResManager.loadKDString((String)"\u91d1\u989d", (String)"AdjustModelBuildServiceHelper_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        AdjustModelBuildServiceHelper.setColumnHeadCell(proxy, startCol++, columnKey, columnName, null);
        return startCol;
    }

    public static void buildAdjustSpreadEntry(AdjustSpreadActionHandlerProxy proxy, boolean isIncludeLinkage) {
        AdjustModel adjust = proxy.getAdjust();
        QFBuilder qf = new QFBuilder();
        String idsMapStr = (String)adjust.get("idsMap");
        if (idsMapStr == null) {
            long link = proxy.getAdjust().getLinkagelinksourceId();
            if (link == 0L) {
                qf.add("adjust", "=", (Object)adjust.getId());
            } else {
                qf.add("adjust", "in", (Object)new Long[]{adjust.getId(), link});
            }
        } else {
            Map idsMap = (Map)ObjectSerialUtil.deSerializedBytes((String)idsMapStr);
            qf.add("adjust", "in", (Object)((List)idsMap.get(adjust.getNumber())).toArray());
        }
        if (!isIncludeLinkage) {
            qf.add("entrysource", "in", (Object)EntrySourceEnum.getEntrySources());
        }
        ArrayList mainEntrys = new ArrayList(16);
        LinkedHashMap<String, List<Row>> prfix2linkEntrys = new LinkedHashMap<String, List<Row>>(16);
        LinkedHashMap<String, List<Row>> otherCurEntrys = new LinkedHashMap<String, List<Row>>(16);
        try (DataSet ds = AdjustQueryServiceHelper.queryAdjustEntryDataSet(AdjustModelBuildServiceHelper.buildManualAdjustEntrySelectField(adjust), (QFBuilder)qf, (String)"showseq,groupnum,dseq", (int)-1);){
            ds.forEachRemaining(row -> {
                String sign = row.getString("sign");
                String dseq = row.getString("dseq");
                AbstractRow rowList = ((AbstractRow)row).persist();
                if (row.getBoolean("isdefaultcurrency").booleanValue()) {
                    int prfixIndex;
                    int n = prfixIndex = dseq == null ? -1 : dseq.lastIndexOf("-");
                    if (prfixIndex == -1) {
                        mainEntrys.add(rowList);
                    } else {
                        prfix2linkEntrys.computeIfAbsent(sign.substring(0, sign.lastIndexOf("-")), a -> Lists.newArrayList()).add(rowList);
                    }
                } else {
                    otherCurEntrys.computeIfAbsent(sign, a -> Lists.newArrayList()).add(rowList);
                }
            });
        }
        int startRow = 1;
        String lastGroupNum = null;
        String curGroupNum = null;
        for (Row mainEntry : mainEntrys) {
            curGroupNum = mainEntry.getString("groupnum");
            if (lastGroupNum != null && !lastGroupNum.equals(curGroupNum)) {
                AdjustModelBuildServiceHelper.writeSpiltEntryData(proxy, startRow++);
            }
            lastGroupNum = curGroupNum;
            startRow = AdjustModelBuildServiceHelper.buildEntryData(proxy, startRow, mainEntry, prfix2linkEntrys, otherCurEntrys);
        }
    }

    private static void writeSpiltEntryData(AdjustSpreadActionHandlerProxy proxy, int r) {
        proxy.getIndexMap().values().forEach(c -> proxy.setCellValue(r, (Integer)c, "---------------------------------------", true));
    }

    private static int buildEntryData(AdjustSpreadActionHandlerProxy proxy, int r, Row mainEntry, Map<String, List<Row>> prfix2linkEntrys, Map<String, List<Row>> otherCurEntrys) {
        String sign = mainEntry.getString("sign");
        AdjustModelBuildServiceHelper.writeEntryData(proxy, r++, mainEntry, otherCurEntrys.remove(sign));
        List<Row> prfix2linkEntryList = prfix2linkEntrys.remove(sign);
        if (prfix2linkEntryList != null) {
            for (Row linkEntry : prfix2linkEntryList) {
                r = AdjustModelBuildServiceHelper.buildEntryData(proxy, r, linkEntry, prfix2linkEntrys, otherCurEntrys);
            }
        }
        return r;
    }

    private static void writeEntryData(AdjustSpreadActionHandlerProxy proxy, int r, Row entry, List<Row> otherCurEntrys) {
        AreaPositionManger manger = proxy.getAreaPositionManger();
        Cell cell = proxy.setCellValue(r, manger.getColIndexBySign("groupnum"), entry.getString("groupnum"));
        cell.setUserObject("adjustDataInfo", (Object)MapInitHelper.ofMap((Object)"id", (Object)entry.getLong("id")));
        cell.setUserObject("ruleexpr", (Object)entry.getString("ruleexpr"));
        proxy.setCellValue(r, manger.getColIndexBySign("dseq"), entry.getString("dseq"));
        proxy.setCellValue(r, manger.getColIndexBySign("description"), entry.getString("description"));
        String modelNum = MemberReader.findModelNumberById((Object)proxy.getAdjust().getModelId());
        for (SpreadDimensionEntry s : proxy.getAdjust().getSpreadDimensionEntries()) {
            String dimNum = s.getDimension().getNumber();
            String fieldmapped = s.getDimension().getFieldmapped();
            if (StringUtils.isEmpty((String)fieldmapped)) {
                fieldmapped = dimNum.toLowerCase(Locale.ENGLISH);
            }
            IDNumberTreeNode memNode = BcmThreadCache.findNodeById((String)modelNum, (String)dimNum, (long)entry.getLong(fieldmapped));
            cell = proxy.setCellValue(r, manger.getColIndexBySign(dimNum), AdjustModelBuildServiceHelper.createNewName(proxy.getAdjust().getModelId(), dimNum, memNode));
            AdjustModelBuildServiceHelper.setDimensionCellValue(cell, s.getDimension(), memNode);
        }
        proxy.setCellValue(r, manger.getColIndexBySign("cvtbeforedebit"), entry.getBigDecimal("cvtbeforedebit"));
        proxy.setCellValue(r, manger.getColIndexBySign("cvtbeforecredit"), entry.getBigDecimal("cvtbeforecredit"));
        proxy.setCellValue(r, manger.getColIndexBySign("cvtbeforesummoney"), AdjustOperationUtils.handleSummoney((BigDecimal)entry.getBigDecimal("cvtbeforedebit"), (BigDecimal)entry.getBigDecimal("cvtbeforecredit")));
        proxy.setCellValue(r, manger.getColIndexBySign("rate"), entry.getBigDecimal("rate"));
        proxy.setCellValue(r, manger.getColIndexBySign("debit"), entry.getBigDecimal("debit"));
        proxy.setCellValue(r, manger.getColIndexBySign("credit"), entry.getBigDecimal("credit"));
        proxy.setCellValue(r, manger.getColIndexBySign("summoney"), AdjustOperationUtils.handleSummoney((BigDecimal)entry.getBigDecimal("debit"), (BigDecimal)entry.getBigDecimal("credit")));
        if (!CollectionUtil.isEmpty(otherCurEntrys)) {
            for (Row cvtEntry : otherCurEntrys) {
                String curNumber = cvtEntry.getString("currency.number");
                String rateColumnKey = AdjustModelBuildServiceHelper.getColumnKey("rate", curNumber);
                if (!proxy.getIndexMap().containsKey(rateColumnKey)) continue;
                proxy.setCellValue(r, manger.getColIndexBySign(rateColumnKey), cvtEntry.getBigDecimal("rate"));
                proxy.setCellValue(r, manger.getColIndexBySign(AdjustModelBuildServiceHelper.getColumnKey("debit", curNumber)), cvtEntry.getBigDecimal("debit"));
                proxy.setCellValue(r, manger.getColIndexBySign(AdjustModelBuildServiceHelper.getColumnKey("credit", curNumber)), cvtEntry.getBigDecimal("credit"));
                proxy.setCellValue(r, manger.getColIndexBySign(AdjustModelBuildServiceHelper.getColumnKey("summoney", curNumber)), AdjustOperationUtils.handleSummoney((BigDecimal)cvtEntry.getBigDecimal("debit"), (BigDecimal)cvtEntry.getBigDecimal("credit")));
            }
        }
        proxy.setCellValue(r, manger.getColIndexBySign("entryrowtype"), entry.getString("entryrowtype"));
        proxy.setCellValue(r, manger.getColIndexBySign("entrysource"), entry.getString("entrysource"));
        proxy.setCellValue(r, manger.getColIndexBySign("linksource"), entry.getString("linksource"));
        proxy.setCellValue(r, manger.getColIndexBySign("ischanged"), entry.getString("ischanged"));
        proxy.setCellValue(r, manger.getColIndexBySign("calculatecontent"), entry.getString("calculatecontent"));
    }

    private static String createNewName(long modelId, String dimNum, IDNumberTreeNode memNode) {
        if (memNode != null && memNode != IDNumberTreeNode.NotFoundTreeNode) {
            Pair<Boolean, Boolean> showStylePair = AdjustModelBuildServiceHelper.getDimShowTypeMap(modelId).getOrDefault(dimNum, (Pair<Boolean, Boolean>)Pair.onePair((Object)true, (Object)true));
            if (((Boolean)showStylePair.p1).booleanValue() && !((Boolean)showStylePair.p2).booleanValue()) {
                return memNode.getNumber();
            }
            if (!((Boolean)showStylePair.p1).booleanValue() && ((Boolean)showStylePair.p2).booleanValue()) {
                return memNode.getName();
            }
            return memNode.getName() + "|" + memNode.getNumber();
        }
        return null;
    }

    private static String getColumnKey(String key, String currencyNumber) {
        return (String)BcmThreadCache.get((Object)"getColumnKey", (Object)key, (Object)currencyNumber, () -> key + "_" + currencyNumber);
    }

    public static Map<String, Integer> createOrGetIndexMap(Sheet effectiveSheet) {
        LinkedHashMap<String, Integer> indexMap = new LinkedHashMap<String, Integer>(16);
        for (int i = 0; i < effectiveSheet.getMaxColumnCount(); ++i) {
            Cell cell = effectiveSheet.getCell(0, i);
            if (cell == null || cell.getUserObject("entitysign") == null) continue;
            String sign = (String)cell.getUserObject("entitysign");
            if (StringUtils.isNotEmpty((String)sign) && sign.startsWith("bcm_") && !"bcm_mergenode".equals(sign)) {
                indexMap.put(cell.getDimension(0).getNumber(), i);
                continue;
            }
            indexMap.put(sign, i);
        }
        return indexMap;
    }

    private static Set<String> buildManualAdjustEntrySelectField(AdjustModel adjust) {
        HashSet<String> selectFields = new HashSet<String>(35);
        selectFields.add("groupnum");
        selectFields.add("dseq");
        selectFields.add("description");
        selectFields.add("isdefaultcurrency");
        for (SpreadDimensionEntry spread : adjust.getSpreadDimensionEntries()) {
            if ("bcm_userdefinedmembertree".equals(spread.getDimension().getMemberEntityNumber())) {
                selectFields.add(spread.getDimension().getFieldmapped());
                continue;
            }
            selectFields.add(spread.getDimension().getNumber().toLowerCase(Locale.ENGLISH));
        }
        selectFields.add("currency");
        selectFields.add("currency.number");
        selectFields.add("cvtbeforedebit");
        selectFields.add("cvtbeforecredit");
        selectFields.add("cvtbeforesummoney");
        selectFields.add("rate");
        selectFields.add("debit");
        selectFields.add("credit");
        selectFields.add("summoney");
        selectFields.add("entryrowtype");
        selectFields.add("entrysource");
        selectFields.add("linksource");
        selectFields.add("ischanged");
        selectFields.add("calculatecontent");
        selectFields.add("ruleexpr");
        selectFields.add("concat(groupnum,concat('!', dseq)) as sign");
        return selectFields;
    }

    public static Cell getCell(SpreadManager spreadManager, int row, int col) {
        return spreadManager.getBook().getSheet(0).getCell(row, col);
    }

    public static Cell setDimensionCellValue(Cell dimCell, Dimension dim, IDNumberTreeNode dimMemNode) {
        if (dimCell != null) {
            dimCell.clearAllUserObject();
            dimCell.clearMembersOfUserObject();
            dimCell.getDimensions().clear();
            if (dimMemNode != null && dimMemNode != IDNumberTreeNode.NotFoundTreeNode) {
                dimCell.setUserObject("membid", (Object)dimMemNode.getId());
                dimCell.setUserObject("membname", (Object)dimMemNode.getName());
                dimCell.setUserObject("membnumber", (Object)dimMemNode.getNumber());
                dimCell.setUserObject("entitysign", (Object)DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dim.getNumber()));
                IDimension spreadDim = (IDimension)ThreadCache.get((Object)dim.getNumber(), () -> ObjectConvertUtils.toIDimension(dim));
                DimMember dimMember = (DimMember)ThreadCache.get((Object)dimMemNode, () -> new DimMember(dimMemNode.getName(), dimMemNode.getNumber(), null, spreadDim));
                dimCell.addDim2UserObject((IDimMember)dimMember);
                dimCell.addDimension(spreadDim);
            }
        }
        return dimCell;
    }

    public static Map<String, Pair<Boolean, Boolean>> getDimShowTypeMap(Long modelId) {
        return (Map)ThreadCache.get((Object)(modelId + "_adjustShowtype"), () -> {
            HashMap<String, Pair> styleMap = new HashMap<String, Pair>(16);
            DynamicObjectCollection spreadStyles = QueryServiceHelper.query((String)"bcm_spreadstyle", (String)"dimension.number,isshownumber, isshowname", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
            for (DynamicObject spreadStyle : spreadStyles) {
                styleMap.put(spreadStyle.getString("dimension.number"), Pair.onePair((Object)spreadStyle.getBoolean("isshownumber"), (Object)spreadStyle.getBoolean("isshowname")));
            }
            return styleMap;
        });
    }

    public static void repairSpreadMangerByJson(SpreadManager sm, String spreadjson) {
        if (sm != null && StringUtils.isNotEmpty((String)spreadjson)) {
            Sheet sheet = sm.getBook().getSheet(0);
            ArrayListMultimap multimap = ArrayListMultimap.create();
            sheet.iteratorCells(cell -> multimap.put((Object)cell.getRow(), (Object)cell.getCol()));
            JSONObject objArray = JSON.parseObject((String)ObjectSerialUtil.uncompress((String)spreadjson));
            for (Object sheetObject : objArray.getJSONObject("sheets").values()) {
                JSONObject dataTableJson = ((JSONObject)sheetObject).getJSONObject("data").getJSONObject("dataTable");
                dataTableJson.forEach((row, v) -> ((JSONObject)v).forEach((col, v1) -> {
                    String formula = ((JSONObject)v1).getString("formula");
                    String val = ((JSONObject)v1).getString("value");
                    Cell cell = sheet.getCell(Integer.parseInt(row), Integer.parseInt(col), !StringUtils.isEmpty((String)formula) || !StringUtils.isEmpty((String)val));
                    if (cell != null) {
                        cell.setFormula(formula);
                        cell.setValue((Object)val);
                        multimap.remove((Object)cell.getRow(), (Object)cell.getCol());
                    }
                }));
            }
            new HashMap<Integer, Collection>(multimap.asMap()).forEach((r, cList) -> new ArrayList<Integer>((Collection<Integer>)cList).forEach(c -> {
                Cell cell = sheet.getCell(r.intValue(), c.intValue(), false);
                if (cell != null) {
                    cell.setFormula(null);
                    cell.setValue(null);
                    multimap.remove((Object)cell.getRow(), (Object)cell.getCol());
                }
            }));
        }
    }
}

