/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.servicehelper;

import java.util.Collections;
import kd.bos.form.IClientViewProxy;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.adjust.model.AdjustSpreadActionHandlerProxy;
import kd.fi.bcm.formplugin.adjust.model.Colmun;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class AdjustStyleBuildServiceHelper {
    public static String buildEmptyJson(int maxrow, int maxcol) {
        return "{\"version\":\"10.0.1\",\"sheets\":{\"sheet1\":{\"name\":\"sheet1\",\"rowCount\":\"" + maxrow + "\",\"columnCount\":\"" + maxcol + "\"}}}";
    }

    public static void buildManualAdjustHeadSpreadStyle(AdjustSpreadActionHandlerProxy proxy) {
        int maxRow = Math.max(proxy.getSpreadManager().getBook().getSheet(0).getMaxRowCount(), 2000);
        proxy.setMaxRow(maxRow);
        proxy.getIndexMap().forEach((colKey, col) -> {
            Colmun colmun = proxy.getAreaPositionManger().getColmunBySign((String)colKey);
            if (colmun != null) {
                if (colmun.getDim() != null) {
                    proxy.setCellF7Style(1, (int)col, maxRow, 1, 0, 0);
                    proxy.setColumnWidth((int)col, 150);
                    proxy.setColumnFormat((int)col, 1, "@");
                } else if ("groupnum".equals(colKey)) {
                    proxy.setColumnWidth((int)col, 50);
                    proxy.setColumnFormat((int)col, 1, "@");
                    proxy.setAlign(1, maxRow, (int)col, 1, 0);
                } else if ("dseq".equals(colKey)) {
                    proxy.setColumnWidth((int)col, 30);
                    proxy.setColumnFormat((int)col, 1, "@");
                    proxy.setAlign(1, maxRow, (int)col, 1, 0);
                } else if ("description".equals(colKey)) {
                    proxy.setColumnWidth((int)col, 150);
                    proxy.setColumnFormat((int)col, 1, "@");
                    proxy.setAlign(1, maxRow, (int)col, 1, 0);
                } else if (colKey.equals("cvtbeforedebit") || colKey.equals("cvtbeforecredit") || colKey.equals("cvtbeforesummoney") || colKey.startsWith("debit") || colKey.startsWith("credit") || colKey.startsWith("summoney")) {
                    proxy.setColumnWidth((int)col, 100);
                    proxy.setColumnFormat((int)col, 1, "#,##0.00");
                    proxy.setAlign(1, maxRow, (int)col, 1, 2);
                } else if (colKey.startsWith("rate")) {
                    proxy.setColumnWidth((int)col, 100);
                    proxy.setColumnFormat((int)col, 1, "#,##0.0000");
                    proxy.setAlign(1, maxRow, (int)col, 1, 2);
                } else {
                    proxy.setColumnFormat((int)col, 1, "@");
                }
            }
        });
        int cc = proxy.getCurrentMaxCol() + 1;
        proxy.setCellColorStyle(0, 1, 0, cc, "#b2b2b2", 1);
    }

    public static void buildManualAdjustEntrySpreadStyle(AdjustSpreadActionHandlerProxy proxy, boolean isIncludeLinkage) {
        int colMax = proxy.getCurrentMaxCol() + 1;
        int rowMax = proxy.getSpreadManager().getBook().getSheet(0).getMaxRowCount();
        for (int r = 1; r < rowMax; ++r) {
            String groupNum = proxy.getCellValue(r, proxy.getAreaPositionManger().getColIndexBySign("groupnum"), String.class);
            String dseq = proxy.getCellValue(r, proxy.getAreaPositionManger().getColIndexBySign("dseq"), String.class);
            if (!StringUtils.isNotEmpty((CharSequence)groupNum) || !StringUtils.isNotEmpty((CharSequence)dseq)) continue;
            String entryrowtype = proxy.getCellValue(r, proxy.getAreaPositionManger().getColIndexBySign("entryrowtype"), String.class);
            boolean isLinkRow = dseq.contains("-");
            if ("2".equals(entryrowtype) && !isLinkRow) {
                proxy.setCellColorStyle(r, 1, 0, colMax, "#ffd4aa");
                proxy.setCellLock(r, 1, 0, colMax);
                continue;
            }
            if (!isIncludeLinkage || isLinkRow) continue;
            proxy.setCellColorStyle(r, 1, 0, colMax, "#cccccc");
        }
    }

    public static void buildManualAdjustLockSpreadStyle(AdjustSpreadActionHandlerProxy proxy, boolean isBindData, boolean hasWritePerm, boolean isIncludeLinkage) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)proxy.getView().getService(IClientViewProxy.class);
        SpreadManager sm = proxy.getSpreadManager();
        if (!isBindData) {
            SpreadClientInvoker.invokeLockSheetMethod(clientViewProxy, proxy.getSpreadkey(), Collections.singletonList(sm.getBook().getSheet(0).getSheetName()));
        }
        String status = proxy.getAdjust().getStatus();
        if (RptAdjustStatusEnum.AUDIT.status().equals(status) || RptAdjustStatusEnum.COMMIT.status().equals(status)) {
            SpreadClientInvoker.invokeLockSheetMethod(clientViewProxy, proxy.getSpreadkey(), Collections.singletonList(sm.getBook().getSheet(0).getSheetName()));
        } else if (!hasWritePerm) {
            SpreadClientInvoker.invokeLockSheetMethod(clientViewProxy, proxy.getSpreadkey(), Collections.singletonList(sm.getBook().getSheet(0).getSheetName()));
        } else {
            int colMax = proxy.getCurrentMaxCol() + 1;
            int rowMax = proxy.getSpreadManager().getBook().getSheet(0).getMaxRowCount();
            proxy.setCellLock(0, 1, 0, colMax);
            for (int r = 1; r < rowMax; ++r) {
                String entryrowtype;
                String groupNum = proxy.getCellValue(r, proxy.getAreaPositionManger().getColIndexBySign("groupnum"), String.class);
                String dseq = proxy.getCellValue(r, proxy.getAreaPositionManger().getColIndexBySign("dseq"), String.class);
                if (!StringUtils.isNotEmpty((CharSequence)groupNum) || !StringUtils.isNotEmpty((CharSequence)dseq) || !"2".equals(entryrowtype = proxy.getCellValue(r, proxy.getAreaPositionManger().getColIndexBySign("entryrowtype"), String.class))) continue;
                proxy.setCellLock(r, 1, 0, colMax);
            }
        }
        proxy.setFrozenSheet(1, 0, 0, 0, "red", 0);
    }
}

