/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.spreadvalidator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.bcm.business.adjust.model.AdjustErrorCatcher;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.model.CommDimensionEntry;
import kd.fi.bcm.business.adjust.model.SpreadDimensionEntry;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;

public abstract class AbstractSpreadValidator {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(AbstractSpreadValidator.class);
    public static final String EFFECTIVEROWS_CACHE = "effectiveRows";
    public static final String MUTI_CURRENCY_CACHE = "mutiCurrency";
    private AdjustOperationContext ctx;
    private AdjustErrorCatcher errorCatcher;
    private AdjustModel adjustModel;
    private Sheet sheet;
    private Map<String, Integer> indexMap;

    public void setCheckData(AdjustModel adjust, Sheet sheet) {
        this.adjustModel = adjust;
        this.sheet = sheet;
    }

    public void validate() {
        this.startWatch();
        this.beforeValidate();
        this.dealValidate();
        this.afterValidate();
        this.endWatch();
    }

    private void startWatch() {
        if (DebugServiceHelper.isDebugModel()) {
            LOG.startWatch();
        }
    }

    private void endWatch() {
        if (DebugServiceHelper.isDebugModel()) {
            LOG.infoEnd(String.format("\u6821\u9a8c[%s]\u6267\u884c\u8017\u65f6", this.getValidatorKey()));
        }
    }

    protected abstract void beforeValidate();

    protected abstract void dealValidate();

    protected void afterValidate() {
    }

    protected Cell getCell(int row, int col) {
        return this.getEffectiveSheet().getCell(row, col);
    }

    protected Cell getCell(int row, String colkey) {
        Integer colIndex = this.getIndexMap().get(colkey);
        if (colIndex == null) {
            LOG.error(String.format(ResManager.loadKDString((String)"%1$s\u6821\u9a8c\u4e2d\u5bf9\u5e94\u5217%2$s\u5728\u62a5\u8868\u4e2d\u4e0d\u5b58\u5728\uff0c\u5bfc\u81f4\u6821\u9a8c\u5931\u8d25\uff0c\u8be6\u7ec6\u53c2\u6570\u4e3a\uff1a%3$s ", (String)"AbstractSpreadValidator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getValidatorKey(), colkey, this.getIndexMap()));
            colIndex = 0;
        }
        return this.getCell(row, colIndex);
    }

    protected void iterator(Consumer<Integer> adjConsumer) {
        for (int row : this.getEffectRows()) {
            adjConsumer.accept(row);
        }
    }

    public List<Integer> getEffectRows() {
        return (List)this.getCtx().getUserObject(EFFECTIVEROWS_CACHE, () -> {
            ArrayList<Integer> effectRows = new ArrayList<Integer>(16);
            int maxRow = this.getEffectiveSheet().getMaxRowCount();
            for (int row = 1; row <= maxRow; ++row) {
                if (!this.isEffectiveRow(row)) continue;
                effectRows.add(row);
            }
            return effectRows;
        });
    }

    protected boolean isZero(BigDecimal value) {
        return value == null || BigDecimal.ZERO.compareTo(value) == 0;
    }

    private boolean isEffectiveRow(int rowIndex) {
        return !this.isEmpty4DimensionCol(rowIndex) || !this.isEmpty4Value(rowIndex);
    }

    private boolean isEmpty4DimensionCol(int rowIndex) {
        return this.getAdjustModel().getSpreadDimensionEntries().stream().allMatch(dim -> {
            Cell cell;
            Integer colIndex = this.getIndexMap().get(dim.getDimension().getNumber());
            if (colIndex == null) {
                LOG.error(String.format(ResManager.loadKDString((String)"%1$s\u6821\u9a8c\u4e2d\u5bf9\u5e94\u5217%2$s\u5728\u62a5\u8868\u4e2d\u4e0d\u5b58\u5728\uff0c\u5bfc\u81f4\u6821\u9a8c\u5931\u8d25\uff0c\u8be6\u7ec6\u53c2\u6570\u4e3a\uff1a%3$s ", (String)"AbstractSpreadValidator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getValidatorKey(), dim.getDimension().getNumber(), this.getIndexMap()));
                colIndex = 0;
            }
            return !(cell = this.getCell(rowIndex, colIndex)).getUserObject().containsKey((Object)"membid");
        });
    }

    protected boolean isEmpty4Value(int rowIndex) {
        boolean isCheck;
        Cell debit = this.getCell(rowIndex, "debit");
        Cell credit = this.getCell(rowIndex, "credit");
        Cell summeryCell = this.getCell(rowIndex, "summoney");
        Cell rateCell = this.getCell(rowIndex, "rate");
        Cell beforeDebitCell = this.getCell(rowIndex, "cvtbeforedebit");
        Cell beforeCreditCell = this.getCell(rowIndex, "cvtbeforecredit");
        Cell beforeSummoneyCell = this.getCell(rowIndex, "cvtbeforesummoney");
        boolean bl = isCheck = beforeDebitCell.getValue() == null && beforeCreditCell.getValue() == null && beforeSummoneyCell.getValue() == null && debit.getValue() == null && credit.getValue() == null && summeryCell.getValue() == null && rateCell.getValue() == null;
        if (isCheck && this.isMultiCurrencySave()) {
            List<String> multipleCurrency = this.getMultipleCurrency(false);
            for (String dimMember : multipleCurrency) {
                if (!isCheck) continue;
                Cell debit4MulCur = this.getCell(rowIndex, "summoney_" + dimMember);
                Cell credit4MulCur = this.getCell(rowIndex, "credit_" + dimMember);
                Cell summeryCell4MulCur = this.getCell(rowIndex, "debit_" + dimMember);
                Cell rateCell4MulCur = this.getCell(rowIndex, "rate_" + dimMember);
                if (credit4MulCur.getValue() == null && debit4MulCur.getValue() == null && summeryCell4MulCur.getValue() == null && rateCell4MulCur.getValue() == null) continue;
                isCheck = false;
            }
        }
        return isCheck;
    }

    protected boolean isMultiCurrencySave() {
        return "1".equals(this.getAdjustModel().getMultiplecurrency());
    }

    protected List<String> getMultipleCurrency(boolean isContainDefaultCurrency) {
        Set mutiCurrency = (Set)this.getCtx().getUserObject(this.getAdjustModel().getId() + MUTI_CURRENCY_CACHE, () -> {
            HashSet<String> result = new HashSet<String>(16);
            if (this.isMultiCurrencySave()) {
                IDNumberTreeNode org = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Long)this.getAdjustModel().getMergeId());
                result.add(org.getCurrency());
                this.getIndexMap().forEach((key, index) -> {
                    if (key.startsWith("rate_") || key.startsWith("credit_") || key.startsWith("debit_") || key.startsWith("summoney_")) {
                        result.add(key.split("_")[1]);
                    }
                });
            }
            return result;
        });
        ArrayList<String> currencyList = new ArrayList<String>(mutiCurrency);
        if (!isContainDefaultCurrency) {
            IDNumberTreeNode org = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Long)this.getAdjustModel().getMergeId());
            currencyList.remove(org.getCurrency());
        }
        return currencyList;
    }

    protected Map<String, Long> getCommonMemMap() {
        return (Map)this.getCtx().getUserObject("CommonMemMap", () -> {
            HashMap<String, Long> commonMemMap = new HashMap<String, Long>(16);
            for (CommDimensionEntry com : this.getAdjustModel().getCommDimensionEntries()) {
                if ("bcm_mergenode".equals(com.getNumber())) {
                    commonMemMap.put("bcm_mergenode", this.getAdjustModel().getMergeId());
                    continue;
                }
                commonMemMap.put(com.getDimension().getNumber(), com.getMember() == null ? 0L : com.getMember().getId());
            }
            if (!this.getAdjustModel().isMergeinspread() && !commonMemMap.containsKey("bcm_mergenode")) {
                commonMemMap.put("bcm_mergenode", this.getAdjustModel().getMergeId());
            }
            return commonMemMap;
        });
    }

    protected Set<Long> getSpreadMemIdSetByDimNumFromCache(String dimNum) {
        return this.getSpreadMemMapByDimNumFromCache(dimNum).keySet();
    }

    protected Map<Long, String> getSpreadMemMapByDimNumFromCache(String dimNum) {
        return new HashMap<Long, String>((Map)this.getCtx().getUserObject("SpreadMemByDimNum_" + dimNum, () -> {
            HashMap<Long, String> dim = new HashMap<Long, String>(this.getEffectiveSheet().getMaxRowCount());
            if (this.getIndexMap().containsKey(dimNum)) {
                this.iterator(row -> dim.put((Long)this.getCell((int)row, dimNum).getUserObject("membid"), (String)this.getCell((int)row, dimNum).getUserObject("membnumber")));
            } else {
                String entityNumber = "bcm_mergenode".equals(dimNum) ? "bcm_entitymembertree" : MemberReader.getEntityNumberByDim((String)this.getModelNum(), (String)dimNum);
                IDNumberTreeNode memTree = MemberReader.findMemberById((String)this.getModelNum(), (String)entityNumber, (Long)this.getCommonMemMap().get(dimNum));
                dim.put(memTree.getId(), memTree.getNumber());
            }
            dim.remove(0L);
            dim.remove(null);
            return dim;
        }));
    }

    protected Map<String, Long> getRowDimDataFromCache(int row) {
        return new HashMap<String, Long>((Map)this.getCtx().getUserObject("SpreadMemMap_" + row, () -> {
            HashMap<String, Long> dimMemMap = new HashMap<String, Long>(this.getEffectiveSheet().getMaxRowCount());
            for (SpreadDimensionEntry sprDim : this.getAdjustModel().getSpreadDimensionEntries()) {
                if ("bcm_mergenode".equals(sprDim.getNumber())) {
                    dimMemMap.put("bcm_mergenode", (Long)this.getCell(row, "bcm_mergenode").getUserObject("membid"));
                    continue;
                }
                dimMemMap.put(sprDim.getDimension().getNumber(), (Long)this.getCell(row, sprDim.getDimension().getNumber()).getUserObject("membid"));
            }
            return dimMemMap;
        }));
    }

    protected AdjustModel getAdjustModel() {
        return this.adjustModel;
    }

    protected Sheet getEffectiveSheet() {
        return this.sheet;
    }

    protected Map<String, Integer> getIndexMap() {
        if (this.indexMap == null) {
            this.indexMap = AdjustModelUtil.createOrGetIndexMap(this.sheet);
        }
        return this.indexMap;
    }

    public void setErrorCatcher(AdjustErrorCatcher errorCatcher) {
        this.errorCatcher = errorCatcher;
    }

    public AdjustErrorCatcher getErrorCatcher() {
        return this.errorCatcher;
    }

    protected void addWarningMessage(int row, String content) {
        this.addMessage(row, content, ErrorLevel.Warning);
    }

    protected void addErrorMessage(int row, String content) {
        this.addMessage(row, content, ErrorLevel.Error);
    }

    private void addMessage(int row, String content, ErrorLevel errorLevel) {
        if (ErrorLevel.Error.equals((Object)errorLevel)) {
            this.getErrorCatcher().collectErrorMsg(row, this.createErrorMsg(row, content));
        } else {
            this.getErrorCatcher().collectMsg(row, this.createErrorMsg(row, content));
        }
    }

    private String createErrorMsg(int row, String content) {
        return content;
    }

    protected boolean needCheck(int row) {
        return (Boolean)ThreadCache.get((Object)("needCheck_" + row), () -> {
            if ("btn_createlinkage".equals(this.getOperationKey()) && EntrySourceEnum.getLinkListToString().contains(this.getCell(row, "entrysource").getValue() + "")) {
                return false;
            }
            if ("btn_adddiffentry".equals(this.getOperationKey()) && "2".equals(this.getCell(row, "entryrowtype").getValue() + "")) {
                return false;
            }
            return true;
        });
    }

    protected abstract String getValidatorKey();

    protected String getEntityKey() {
        return "bcm_rptadjust";
    }

    protected long getModelId() {
        return this.getSctx().getModel();
    }

    protected String getModelNum() {
        return MemberReader.findModelNumberById((Object)this.getModelId());
    }

    public AdjustOperationContext getCtx() {
        return this.ctx;
    }

    protected SchemeContext getSctx() {
        return this.getCtx().getSctx();
    }

    public void setCtx(AdjustOperationContext ctx) {
        this.ctx = ctx;
    }

    public String getOperationKey() {
        return (String)this.ctx.getProperty("OperationKey");
    }

    protected boolean isSuccess() {
        return this.getErrorCatcher().isSuccess();
    }
}

