/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.spreadvalidator;

import java.util.Arrays;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.adjust.spreadvalidator.AbstractSpreadValidator;

public class AdjustCheckCommonSpreadValidator
extends AbstractSpreadValidator {
    private RptAdjustStatusEnum rptAdjustStatusEnum;
    private DynamicObject adjust;

    @Override
    protected void beforeValidate() {
        switch (this.getOperationKey()) {
            case "btn_tempsave": {
                this.rptAdjustStatusEnum = RptAdjustStatusEnum.TEMPSAVE;
                break;
            }
            case "btn_save": {
                this.rptAdjustStatusEnum = RptAdjustStatusEnum.SAVE;
                break;
            }
            case "btn_submit": {
                this.rptAdjustStatusEnum = RptAdjustStatusEnum.COMMIT;
                break;
            }
            case "btn_audit": {
                this.rptAdjustStatusEnum = RptAdjustStatusEnum.AUDIT;
                break;
            }
            case "btn_back": {
                this.rptAdjustStatusEnum = RptAdjustStatusEnum.BACK;
                break;
            }
            case "btn_ratify": {
                this.rptAdjustStatusEnum = RptAdjustStatusEnum.RATIFY;
                break;
            }
            case "btn_cancel_submit": {
                this.rptAdjustStatusEnum = RptAdjustStatusEnum.CANCEL_COMMIT;
                break;
            }
            case "btn_cancel_ratify": {
                this.rptAdjustStatusEnum = RptAdjustStatusEnum.CANCEL_RATIFY;
                break;
            }
        }
        this.adjust = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getAdjustModel().getId(), (String)"bcm_rptadjust");
    }

    @Override
    protected void dealValidate() {
        boolean boolan = this.checkStatus() && this.checkNameAndNumber() && this.checkCommon() && this.checkLinked();
    }

    private boolean checkCommon() {
        Set<Long> entitySet;
        if (this.getEffectiveSheet().getMaxRowCount() < 2) {
            this.addErrorMessage(-1, ResManager.loadKDString((String)"\u5206\u5f55\u4e0d\u5b58\u5728\uff0c\u7981\u6b62\u64cd\u4f5c\u3002", (String)"AdjustCheckCommonSpreadValidator_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (RptAdjustStatusEnum.TEMPSAVE == this.rptAdjustStatusEnum && !AdjustQueryServiceHelper.isUseNewRefreshType((long)this.getModelId(), (long)this.getAdjustModel().getYearId()) && (entitySet = this.getSpreadMemIdSetByDimNumFromCache("Entity")).isEmpty()) {
            this.addErrorMessage(-1, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8f93\u5165\u4e00\u5bb6\u7ec4\u7ec7\u3002", (String)"AdjustCheckCommonSpreadValidator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (RptAdjustStatusEnum.BACK != this.rptAdjustStatusEnum) {
            if (ElimHeaderSourceEnum.SHARE.getValue().equals(this.getAdjustModel().getEntrySource()) || ElimHeaderSourceEnum.SHARE_LINKAGE.getValue().equals(this.getAdjustModel().getEntrySource())) {
                this.addErrorMessage(-1, ResManager.loadKDString((String)"\u5171\u4eab\u7c7b\u578b\u7684\u5206\u5f55\u4e0d\u80fd\u5355\u72ec\u4fdd\u5b58\u6216\u8005\u63d0\u4ea4\u3002", (String)"AdjustCheckCommonSpreadValidator_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (this.isLinkPage() && this.getCtx().getProperty("sortFlag") != null) {
                this.addErrorMessage(-1, ResManager.loadKDString((String)"\u501f\u8d37\u6392\u5e8f\u540e\uff0c\u9700\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u540e\u7f16\u8f91\u3002", (String)"AdjustCheckCommonSpreadValidator_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean validateStatus(RptAdjustStatusEnum ... canOpEnum) {
        if (!Arrays.stream(canOpEnum).anyMatch(e -> e == this.rptAdjustStatusEnum)) {
            this.addErrorMessage(-1, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u5f55\u662f%1$s\u72b6\u6001,\u4e0d\u53ef\u6267\u884c%2$s\u64cd\u4f5c\u3002", (String)"AdjustCheckCommonSpreadValidator_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), RptAdjustStatusEnum.getStatusEnumBy((String)this.adjust.getString("status")).text(), this.rptAdjustStatusEnum.text()));
            return false;
        }
        return true;
    }

    private boolean checkStatus() {
        if (this.adjust == null) {
            return true;
        }
        String status = this.adjust.getString("status");
        if (RptAdjustStatusEnum.TEMPSAVE.status().equals(status)) {
            return this.validateStatus(RptAdjustStatusEnum.SAVE, RptAdjustStatusEnum.TEMPSAVE);
        }
        if (RptAdjustStatusEnum.SAVE.status().equals(status) || RptAdjustStatusEnum.BACK.status().equals(status)) {
            return this.validateStatus(RptAdjustStatusEnum.SAVE, RptAdjustStatusEnum.TEMPSAVE, RptAdjustStatusEnum.COMMIT);
        }
        if (RptAdjustStatusEnum.COMMIT.status().equals(status)) {
            return ConfigServiceHelper.isHwApp() ? this.validateStatus(RptAdjustStatusEnum.RATIFY) : this.validateStatus(RptAdjustStatusEnum.AUDIT, RptAdjustStatusEnum.BACK);
        }
        if (RptAdjustStatusEnum.RATIFY.status().equals(status)) {
            return this.validateStatus(RptAdjustStatusEnum.AUDIT, RptAdjustStatusEnum.CANCEL_RATIFY);
        }
        if (RptAdjustStatusEnum.AUDIT.status().equals(status)) {
            return this.validateStatus(RptAdjustStatusEnum.BACK);
        }
        if (RptAdjustStatusEnum.CANCEL_COMMIT.status().equals(status)) {
            return this.validateStatus(RptAdjustStatusEnum.COMMIT);
        }
        if (RptAdjustStatusEnum.CANCEL_RATIFY.status().equals(status)) {
            return this.validateStatus(RptAdjustStatusEnum.RATIFY);
        }
        return false;
    }

    private boolean checkLinked() {
        if (this.adjust != null && this.isLinkPage()) {
            boolean isAudit;
            boolean isLinkageHeader;
            boolean bl = isLinkageHeader = this.adjust.getString("entrysource").equals(ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue()) || this.adjust.getString("entrysource").equals(ElimHeaderSourceEnum.SHARE_LINKAGE.getValue());
            if (isLinkageHeader) {
                long linkAdjustId = this.adjust.getLong("linkagelinksource");
                this.adjust = QueryServiceHelper.queryOne((String)"bcm_rptadjust", (String)"number,name,status", (QFilter[])new QFBuilder("id", "=", (Object)linkAdjustId).toArray());
            }
            boolean bl2 = isAudit = this.adjust != null && this.adjust.getString("status").equals(RptAdjustStatusEnum.AUDIT.status());
            if (!isAudit) {
                this.addErrorMessage(-1, ResManager.loadKDString((String)"\u62c6\u5206\u72b6\u6001\u4e0b\u8054\u52a8\u5206\u5f55\u4fdd\u5b58\u3001\u5ba1\u6838\u6216\u8005\u63d0\u4ea4\u90fd\u9700\u8981\u6e90\u5206\u5f55\u4e3a\u5ba1\u6838\u72b6\u6001\u3002", (String)"AdjustCheckCommonSpreadValidator_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean isLinkPage() {
        return this.getCtx().getProperty("isLinkPage") == null ? Boolean.FALSE : (Boolean)this.getCtx().getProperty("isLinkPage");
    }

    private boolean checkNameAndNumber() {
        if (RptAdjustStatusEnum.TEMPSAVE != this.rptAdjustStatusEnum && RptAdjustStatusEnum.SAVE != this.rptAdjustStatusEnum) {
            return true;
        }
        if (StringUtils.isEmpty((String)this.getAdjustModel().getName())) {
            this.addErrorMessage(-1, ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustCheckCommonSpreadValidator_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        String updateNumber = this.getAdjustModel().getNumber();
        if (StringUtils.isEmpty((String)updateNumber)) {
            this.addErrorMessage(-1, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustCheckCommonSpreadValidator_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!BCMNumberRule.checkNumber((String)updateNumber)) {
            this.addErrorMessage(-1, ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AdjustCheckCommonSpreadValidator_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if ((this.adjust == null || !updateNumber.equals(this.adjust.getString("number"))) && AdjustmentServiceHelper.adjustNumberIsExist((AdjustModel)this.getAdjustModel(), (String)updateNumber)) {
            this.addErrorMessage(-1, ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"AdjustCheckCommonSpreadValidator_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    protected String getValidatorKey() {
        return null;
    }
}

