/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.spreadvalidator;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDimMemValidator;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.adjust.spreadvalidator.AbstractSpreadValidator;

public class AdjustCheckDimMemSpreadValidator
extends AbstractSpreadValidator {
    private final Map<Long, String> acctDatatypeMap = new HashMap<Long, String>(50);

    @Override
    protected void beforeValidate() {
        QFBuilder qb = new QFBuilder("id", "in", this.getSpreadMemIdSetByDimNumFromCache("Account"));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AdjustCheckDimMemSpreadValidator_account", (String)"bcm_accountmembertree", (String)"id,datatype", (QFilter[])qb.toArray(), null);){
            ds.forEachRemaining(row -> this.acctDatatypeMap.put(row.getLong("id"), row.getString("datatype")));
        }
    }

    @Override
    protected void dealValidate() {
        this.iterator(row -> {
            if (this.needCheck((int)row)) {
                HashMap<String, Long> dimMemMap = new HashMap<String, Long>(this.getCommonMemMap());
                dimMemMap.putAll(this.getRowDimDataFromCache((int)row));
                boolean bl = this.checkDimLabel((Integer)row, (Map<String, Long>)dimMemMap) && this.checkAccountType((Integer)row, (Long)dimMemMap.get("Account")) && this.checkDimMemIsLeaf((Integer)row, (Map<String, Long>)dimMemMap) && this.checkMycompanyVar((Integer)row, (Map<String, Long>)dimMemMap) && this.checkOrgMatchMerge((Integer)row, (Long)dimMemMap.get("bcm_mergenode"), (Long)dimMemMap.get("Entity")) && this.checkAccountCalc((Integer)row, (Long)dimMemMap.get("Account"));
            }
        });
    }

    protected boolean checkDimLabel(Integer row, Map<String, Long> dimMemMap) {
        for (Dimension dim : this.getSctx().getDimensions()) {
            Long membid = dimMemMap.get(dim.getNumber());
            IDNumberTreeNode dimTree = MemberReader.findMemberById((String)this.getModelNum(), (String)dim.getMembermodel(), (Long)membid);
            if (IDNumberTreeNode.NotFoundTreeNode == dimTree || StorageTypeEnum.LABEL != dimTree.getStorageType()) continue;
            this.addErrorMessage(row, String.format(AdjustCheckDimMemValidator.labelTextMessage(), dim.getName()));
            return false;
        }
        return true;
    }

    protected boolean checkMycompanyVar(Integer row, Map<String, Long> dimMemMap) {
        for (Dimension dim : this.getSctx().getDimensions()) {
            if (!DimTypesEnum.MYCOMPANY.getNumber().equals(dim.getNumber())) continue;
            Long membid = dimMemMap.get(dim.getNumber());
            IDNumberTreeNode dimTree = MemberReader.findMemberById((String)this.getModelNum(), (String)dim.getMembermodel(), (Long)membid);
            if (!SystemVarsEnum.isDimVarsByNumber((String)dimTree.getNumber())) continue;
            if (SystemVarsEnum.RELATE_ENTITY.getNumber().equals(dimTree.getNumber())) {
                Long orgId = dimMemMap.getOrDefault(DimTypesEnum.ENTITY.getNumber(), 0L);
                if (orgId != null && orgId != 0L) {
                    dimTree = MemberReader.findMemberByNumber((String)this.getModelNum(), (String)DimTypesEnum.MYCOMPANY.getNumber(), (String)MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)orgId).getNumber());
                }
            } else {
                dimTree = IDNumberTreeNode.NotFoundTreeNode;
            }
            if (IDNumberTreeNode.NotFoundTreeNode == dimTree) {
                this.addErrorMessage(row, String.format(AdjustCheckDimMemValidator.varTestMessage(), dim.getName()));
                return false;
            }
            if (StorageTypeEnum.LABEL != dimTree.getStorageType()) continue;
            this.addErrorMessage(row, String.format(AdjustCheckDimMemValidator.labelTextMessage(), dim.getName()));
            return false;
        }
        return true;
    }

    protected boolean checkAccountType(Integer row, Long accId) {
        IDNumberTreeNode accTree = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_accountmembertree", (Long)accId);
        if (!IDNumberTreeNode.NotFoundTreeNode.equals(accTree)) {
            DataTypeEnum accountType = DataTypeEnum.getDataTypeEnumByIndex((String)this.acctDatatypeMap.getOrDefault(accId, DataTypeEnum.DEFAULT.getOIndex()));
            if (DataTypeEnum.TXT == accountType || DataTypeEnum.DATETP == accountType || DataTypeEnum.ENUMTP == accountType) {
                this.addErrorMessage(row, ResManager.loadKDString((String)"\u79d1\u76ee\u662f%s\u6210\u5458\uff0c\u4e0d\u53ef\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjustCheckDimMemSpreadValidator_1", (String)"fi-bcm-formplugin", (Object[])new Object[]{accountType.getName()}));
                return false;
            }
            if (DrCRDirectEnum.NONE.getOIndex().equals(accTree.getProperty("drcrdirect"))) {
                this.addErrorMessage(row, AdjustCheckDimMemValidator.acctDirectTextmessage());
                return false;
            }
        }
        return true;
    }

    protected boolean checkDimMemIsLeaf(Integer row, Map<String, Long> dimMemMap) {
        String processNum = this.getAdjustModel().getProcess();
        for (Map.Entry<String, Long> enrty : dimMemMap.entrySet()) {
            IDNumberTreeNode dimTree;
            String dimNum = enrty.getKey();
            if ("bcm_mergenode".equals(dimNum) || IDNumberTreeNode.NotFoundTreeNode.equals(dimTree = MemberReader.findMemberById((String)this.getModelNum(), (String)DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dimNum), (Long)enrty.getValue()))) continue;
            if (dimTree.isLeaf()) {
                if (!"Entity".equals(dimNum) || !"DADJ".equals(processNum) && !"DEJE".equals(processNum)) continue;
                this.addErrorMessage(row, ResManager.loadKDString((String)"DADJ\u548cDEJE\u4e1a\u52a1\u7c7b\u578b\u4e0b\u4e0d\u80fd\u5b58\u5728\u660e\u7ec6\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCheckDimMemSpreadValidator_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if ("Entity".equals(dimNum)) continue;
            this.addErrorMessage(row, String.format(ResManager.loadKDString((String)"%1$s\u7ef4\u5ea6\u4e0d\u80fd\u5b58\u5728\u975e\u660e\u7ec6\u6210\u5458\uff1a%2$s", (String)"AdjustCheckDimMemSpreadValidator_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimNum, dimTree.getName()));
            return false;
        }
        return true;
    }

    private boolean checkOrgMatchMerge(Integer row, Long mergeId, Long orgId) {
        if (OrgRelaProcessMembPool.isRelaProcess((String)this.getAdjustModel().getProcess())) {
            IDNumberTreeNode orgTree = MemberReader.findEntityMemberById((String)this.getModelNum(), (Long)orgId);
            IDNumberTreeNode mergeTree = MemberReader.findEntityMemberById((String)this.getModelNum(), (Long)mergeId);
            if (!orgTree.getLongNumber().contains("!" + mergeTree.getNumber() + "!")) {
                this.addErrorMessage(row, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0e\u5408\u5e76\u8282\u70b9\u4e0d\u5339\u914d\uff0c\u660e\u7ec6\u5206\u5f55\u7ec4\u7ec7\uff1a%1$s\uff0c\u5408\u5e76\u8282\u70b9\u7ec4\u7ec7\uff1a%2$s\u3002", (String)"AdjustCheckDimMemSpreadValidator_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgTree.getLongNumber(), mergeTree.getLongNumber()));
            }
        }
        return true;
    }

    protected boolean checkAccountCalc(Integer row, Long accId) {
        IDNumberTreeNode accTree = MemberReader.findMemberById((String)this.getModelNum(), (String)"bcm_accountmembertree", (Long)accId);
        if (!IDNumberTreeNode.NotFoundTreeNode.equals(accTree) && ("1".equals(accTree.getProperty("iscaltype").toString()) || "true".equals(accTree.getProperty("iscaltype").toString()))) {
            this.addErrorMessage(row, AdjustCheckDimMemValidator.calAcctTextMessage());
            return false;
        }
        return true;
    }

    @Override
    protected String getValidatorKey() {
        return "AdjustCheckDimMemSpreadValidator";
    }
}

