/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.spreadvalidator;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.model.CommDimensionEntry;
import kd.fi.bcm.business.adjust.model.SpreadDimensionEntry;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.adjust.spreadvalidator.AbstractSpreadValidator;
import org.apache.commons.collections.CollectionUtils;

public class AdjustCheckDimMemberPermSpreadValidator
extends AbstractSpreadValidator {
    private boolean permSign = Boolean.TRUE;
    private ArrayListMultimap<String, Long> permCalssMap = null;
    private Set<String> specicalNoCheckDimSet = new HashSet<String>(16);

    public AdjustCheckDimMemberPermSpreadValidator(boolean permSign) {
        this.permSign = permSign;
    }

    public AdjustCheckDimMemberPermSpreadValidator(Set<String> noCheckDimSet) {
        if (noCheckDimSet != null) {
            this.specicalNoCheckDimSet.addAll(noCheckDimSet);
        }
    }

    @Override
    protected void beforeValidate() {
        boolean isModelOwner = MemberPermHelper.getLimitedModelListByUser().contains(this.getAdjustModel().getModelId());
        if (!isModelOwner && this.permCalssMap == null) {
            this.permCalssMap = PermClassEntityHelper.getPermissionMap((String)"bcm_rptadjust", (String)String.valueOf(this.getModelId()), (String)RequestContext.get().getUserId());
        }
    }

    @Override
    protected void dealValidate() {
        boolean modelManage = MemberPermHelper.getLimitedModelListByUser().contains(this.getAdjustModel().getModelId());
        if (modelManage) {
            return;
        }
        boolean comPerm = true;
        for (CommDimensionEntry com : this.getAdjustModel().getCommDimensionEntries()) {
            long memId;
            String dimNum = com.getDimension().getNumber();
            if (com.getMember() == null || this.specicalNoCheckDimSet.contains(com.getDimension().getNumber())) continue;
            long l = memId = com.getNumber().equals("bcm_mergenode") ? this.getAdjustModel().getMergeId() : com.getMember().getId();
            IDNumberTreeNode memberById = MemberReader.findMemberById((long)this.getModelId(), (String)com.getDimension().getMemberEntityNumber(), (Long)memId);
            if (memberById == IDNumberTreeNode.NotFoundTreeNode || DimTypesEnum.MYCOMPANY.getNumber().equals(dimNum) || !this.isNoPerm(memberById.getDimId(), memId)) continue;
            this.addErrorMessage(-1, String.format(ResManager.loadKDString((String)"\u901a\u7528\u7ef4%1$s\u7ef4\u5ea6\u6210\u5458%2$s%3$s\uff08%4$s\uff09,\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjustCheckDimMemberPermSpreadValidator_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), com.getDimension().getName(), memberById.getNumber(), memberById.getName(), this.getPermMsg()));
            comPerm = false;
        }
        boolean hasMerge = OrgRelaProcessMembPool.isRelaProcess((String)this.getAdjustModel().getProcess());
        if (comPerm) {
            List spreadDims = this.getAdjustModel().getSpreadDimensionEntries();
            HashSet noPermSet = new HashSet(spreadDims.size());
            this.iterator(row -> {
                if (this.needCheck((int)row)) {
                    long orgId = 0L;
                    for (SpreadDimensionEntry spr : spreadDims) {
                        Long membid;
                        String dimNum = spr.getDimension().getNumber();
                        if (this.specicalNoCheckDimSet.contains(dimNum) || (membid = LongUtil.toLong((Object)this.getCell((int)row, dimNum).getUserObject("membid"))) == 0L) continue;
                        if ("Entity".equalsIgnoreCase(dimNum)) {
                            orgId = membid;
                        }
                        if (hasMerge && "Entity".equalsIgnoreCase(dimNum) || "MyCompany".equalsIgnoreCase(dimNum) || !this.isNoPerm(spr.getDimension().getId(), membid)) continue;
                        noPermSet.add("[" + spr.getDimension().getName() + "[" + this.getCell((int)row, dimNum).getUserObject().get((Object)"membnumber") + "]]");
                    }
                    if (CollectionUtils.isNotEmpty((Collection)noPermSet)) {
                        this.addErrorMessage((int)row, String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ef4\u5ea6%1$s%2$s\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjustCheckDimMemberPermSpreadValidator_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), noPermSet, this.getPermMsg()));
                        noPermSet.clear();
                    }
                }
            });
        }
    }

    private boolean isNoPerm(long dimId, long membId) {
        if (this.permSign) {
            return !PermissionServiceImpl.getInstance((Long)this.getModelId()).hasWritePerm(Long.valueOf(dimId), Long.valueOf(membId));
        }
        return PermissionServiceImpl.getInstance((Long)this.getModelId()).hasNoPerm(Long.valueOf(dimId), Long.valueOf(membId));
    }

    @Override
    protected String getValidatorKey() {
        return "CheckDimMemberPerm|spread";
    }

    private String getPermMsg() {
        return this.permSign ? ResManager.loadKDString((String)"\u65e0\u6743\u6216\u8005\u53ea\u8bfb", (String)"AdjustCheckDimMemberPermSpreadValidator_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65e0\u6743", (String)"AdjustCheckDimMemberPermSpreadValidator_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }
}

