/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.spreadvalidator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.formplugin.adjust.spreadvalidator.AdjustCheckDimMemSpreadValidator;
import kd.fi.bcm.spread.domain.Cell;

public class AdjustPaperTemplateCheckValidator
extends AdjustCheckDimMemSpreadValidator {
    @Override
    protected void dealValidate() {
        this.checkData();
        Map<String, Long> commonMemMap = this.getCommonMemMap();
        commonMemMap.remove("Year");
        commonMemMap.remove("Scenario");
        commonMemMap.remove("Period");
        this.iterator(row -> {
            HashMap<String, Long> dimMemMap = new HashMap<String, Long>(commonMemMap);
            dimMemMap.putAll(this.getRowDimDataFromCache((int)row));
            boolean isSuccess = this.checkDimLabel((Integer)row, (Map<String, Long>)dimMemMap) && this.checkAccountType((Integer)row, (Long)dimMemMap.get("Account")) && this.checkMycompanyVar((Integer)row, (Map<String, Long>)dimMemMap) && this.checkDimMemIsLeaf((Integer)row, (Map<String, Long>)dimMemMap) && this.checkAccountCalc((Integer)row, (Long)dimMemMap.get("Account"));
        });
    }

    public boolean checkData() {
        HashSet<String> comEtyDimSet = new HashSet<String>(16);
        for (Map.Entry<String, Long> com : this.getCommonMemMap().entrySet()) {
            IDNumberTreeNode memNode;
            if (DimTypesEnum.SCENARIO.getNumber().equals(com.getKey()) || DimTypesEnum.YEAR.getNumber().equals(com.getKey()) || DimTypesEnum.PERIOD.getNumber().equals(com.getKey()) || "bcm_mergenode".equals(com.getKey()) || (memNode = MemberReader.findMemberById((String)this.getModelNum(), (String)DimensionServiceHelper.getDimMembEntityNumByDimNum((String)com.getKey()), (Long)com.getValue())) != IDNumberTreeNode.NotFoundTreeNode) continue;
            comEtyDimSet.add("bcm_mergenode".equals(com.getKey()) ? ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"AdjustCheckDataNotNullSpreadValidator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : this.getSctx().getDimensionByNumber(com.getKey()).getName());
        }
        if (comEtyDimSet.size() > 0) {
            this.addErrorMessage(-1, ResManager.loadKDString((String)"\u901a\u7528\u7ef4%s\u6210\u5458\u4e3a\u7a7a\u6216\u8005\u6210\u5458\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCheckDataNotNullSpreadValidator_0", (String)"fi-bcm-formplugin", (Object[])new Object[]{comEtyDimSet}));
            return false;
        }
        this.iterator(row -> {
            if (this.checkDimensionMemNotNull((Integer)row)) {
                this.checkBigDecimalValNotNull((Integer)row);
            }
        });
        return true;
    }

    private boolean checkDimensionMemNotNull(Integer row) {
        HashSet<String> sprEtyDimSet = new HashSet<String>(16);
        for (Map.Entry<String, Long> com : this.getRowDimDataFromCache(row).entrySet()) {
            IDNumberTreeNode memNode;
            if ("bcm_mergenode".equals(com.getKey()) || "Entity".equals(com.getKey()) || (memNode = MemberReader.findMemberById((String)this.getModelNum(), (String)DimensionServiceHelper.getDimMembEntityNumByDimNum((String)com.getKey()), (Long)com.getValue())) != IDNumberTreeNode.NotFoundTreeNode) continue;
            sprEtyDimSet.add(this.getSctx().getDimensionByNumber(com.getKey()).getName());
        }
        if (sprEtyDimSet.size() > 0) {
            this.addErrorMessage(row, ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ef4\u5ea6%s\u6210\u5458\u4e3a\u7a7a\u6216\u8005\u6210\u5458\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCheckDataNotNullSpreadValidator_2", (String)"fi-bcm-formplugin", (Object[])new Object[]{sprEtyDimSet}));
            return false;
        }
        return true;
    }

    private boolean hasFormulaOrValue(Cell cell) {
        return cell.hasFormula() || !this.isZero(InvestUtils.convertToBigDecimal((Object)cell.getValue()));
    }

    private boolean checkBigDecimalValNotNull(Integer row) {
        Cell debit = this.getCell((int)row, "debit");
        Cell credit = this.getCell((int)row, "credit");
        if (this.hasFormulaOrValue(debit) ^ this.hasFormulaOrValue(credit)) {
            return true;
        }
        this.addErrorMessage(row, ResManager.loadKDString((String)"\u501f\u65b9\u548c\u8d37\u65b9\u4e0d\u5141\u8bb8\u540c\u65f6\u4e3a\u7a7a\u6216\u8005\u540c\u65f6\u5b58\u5728\u503c\u3002", (String)"AdjustPaperTemplateCheckValidator_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        return false;
    }

    @Override
    protected boolean isEmpty4Value(int rowIndex) {
        Cell debit = this.getCell(rowIndex, "debit");
        Cell credit = this.getCell(rowIndex, "credit");
        return debit.getValue() == null && !debit.hasFormula() && credit.getValue() == null && !credit.hasFormula();
    }

    @Override
    protected String getValidatorKey() {
        return "AdjustPaperTemplateCheckValidator";
    }
}

