/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.spreadvalidator;

import java.util.LinkedHashMap;
import java.util.List;
import kd.fi.bcm.business.adjust.model.AdjustErrorCatcher;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.formplugin.adjust.spreadvalidator.AbstractSpreadValidator;
import kd.fi.bcm.spread.domain.view.Sheet;

public class AdjustSpreadValidatorExecute {
    private AdjustOperationContext ctx;
    private AdjustModel adjustModel;
    private Sheet sheet;
    private List<Integer> effectRowList;
    private final LinkedHashMap<Class<? extends AbstractSpreadValidator>, AbstractSpreadValidator> validators = new LinkedHashMap(16);
    protected AdjustErrorCatcher errorCatcher;

    AdjustSpreadValidatorExecute() {
    }

    public AdjustSpreadValidatorExecute(AdjustErrorCatcher errorCatcher, AdjustOperationContext ctx, AdjustModel adjustModel, Sheet sheet) {
        this.adjustModel = adjustModel;
        this.sheet = sheet;
        this.ctx = ctx;
        this.errorCatcher = errorCatcher;
    }

    public AdjustErrorCatcher getErrorCatcher() {
        return this.errorCatcher;
    }

    public void addValidator(AbstractSpreadValidator validator) {
        validator.setErrorCatcher(this.getErrorCatcher());
        validator.setCtx(this.getCtx());
        this.validators.put(validator.getClass(), validator);
    }

    public void excute() {
        this.validators.forEach((type, validator) -> {
            if (this.isSuccess()) {
                validator.setCheckData(this.getAdjustModel(), this.getSheet());
                validator.validate();
                if (this.effectRowList == null) {
                    this.effectRowList = validator.getEffectRows();
                }
            }
        });
    }

    public AdjustModel getAdjustModel() {
        return this.adjustModel;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public boolean isSuccess() {
        return this.getErrorCatcher().isSuccess();
    }

    public String getOperationKey() {
        return (String)this.getCtx().getProperty("OperationKey");
    }

    public void setOperationKey(String operationKey) {
        this.getCtx().getUserObject().removeAll((Object)"OperationKey");
        this.getCtx().addUserObject("OperationKey", (Object)operationKey);
    }

    public List<Integer> getEffectRows() {
        return this.effectRowList;
    }

    public AdjustOperationContext getCtx() {
        return this.ctx;
    }
}

