/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.template;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustTemplateHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.scheme.model.SysPropertyDimensionMember;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MulTiF7FilterTempleUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.IOperationLog;
import kd.fi.bcm.formplugin.TreeSearchResult;
import org.apache.commons.collections.CollectionUtils;

public class AdjustPaperTemplateAssignPlugin
extends AbstractBaseFormPlugin
implements IOperationLog {
    public static final String ctl_temcatalogtree = "temcatalogtree";
    private static final String TREE_MERGE_NODE_ID = "1";
    private static final String TREE_ISLEAF_NODE_ID = "2";
    private static final String TEMPLATE_TREE_MODEL_CACHE = "templateTreeModelCache";
    public static final String TREE_TEMPLATE_TYPE_CACHE = "treeTemplateType";
    private static final String CTL_ENTRYENTITY = "entryentity";
    private static final String CACHE_SEARCH = "cache_search";

    private static String getOperationSend() {
        return ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7", (String)"AdjustPaperTemplateAssignPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private static String getOperationTreeTypeSend() {
        return ResManager.loadKDString((String)"\u4e0d\u53ef\u8de8\u5206\u7c7b\u9009\u62e9\u6a21\u677f\u3002", (String)"AdjustPaperTemplateAssignPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addListeners();
    }

    private void addListeners() {
        this.addClickListeners("btn_selectentity", "btn_delentity", "btn_detail", "btn_selectexceptentity", "btn_delexceptentity", "btn_exceptdetail", "imageup", "imagedown");
        this.addItemClickListeners("toolbarap");
        this.addClickListeners("rangetext11");
        TreeView tree = (TreeView)this.getControl(ctl_temcatalogtree);
        tree.addTreeNodeCheckListener(evt -> {
            if ("0".equals(evt.getNodeId())) {
                tree.uncheckNode("0");
                this.repairByHistoryTreeNode();
                this.getView().showTipNotification(AdjustPaperTemplateAssignPlugin.getOperationTreeTypeSend());
                return;
            }
            if (!evt.getChecked().booleanValue()) {
                if (CollectionUtils.isEmpty((Collection)tree.getTreeState().getCheckedNodeIds())) {
                    this.getPageCache().remove(TREE_TEMPLATE_TYPE_CACHE);
                }
                this.cacheCheckTreeNode();
                this.refreshAllBillList();
            } else {
                String templdatetype;
                String type = String.valueOf("0".equals(evt.getParentNodeId()) ? evt.getNodeId() : evt.getParentNodeId());
                if (type.equals(templdatetype = this.getPageCache().get(TREE_TEMPLATE_TYPE_CACHE)) || StringUtils.isEmpty((CharSequence)templdatetype)) {
                    this.getPageCache().put(TREE_TEMPLATE_TYPE_CACHE, type);
                    this.refreshAllBillList();
                    this.cacheCheckTreeNode();
                } else {
                    tree.uncheckNode(evt.getNodeId().toString());
                    evt.setCancel(true);
                    this.getView().showTipNotification(AdjustPaperTemplateAssignPlugin.getOperationTreeTypeSend());
                }
            }
        });
        this.setBillistrapListener();
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                String text = var1.getText();
                if (text != null && !"".equals(text)) {
                    AdjustPaperTemplateAssignPlugin.this.searchTemplate(text.trim());
                } else {
                    AdjustPaperTemplateAssignPlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    private void searchTemplate(String search) {
        TreeView tree = (TreeView)this.getControl(ctl_temcatalogtree);
        String rootNodeCache = this.getPageCache().get(TEMPLATE_TREE_MODEL_CACHE);
        if (rootNodeCache != null) {
            TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootNodeCache);
            ArrayList<TreeNode> hitNode = new ArrayList<TreeNode>();
            root.getTreeNodeListByText(hitNode, search, 999);
            hitNode.removeIf(e -> "0".equals(e.getId()) || TREE_MERGE_NODE_ID.equals(e.getId()) || TREE_ISLEAF_NODE_ID.equals(e.getId()));
            TreeSearchResult result = null;
            if (hitNode.size() > 0) {
                result = new TreeSearchResult(hitNode);
                TreeNode next = result.next(1);
                tree.uncheckNodes(tree.getTreeState().getSelectedNodeId());
                tree.checkNode(next);
                this.getPageCache().put(TREE_TEMPLATE_TYPE_CACHE, String.valueOf("0".equals(next.getParentid()) ? next.getId() : next.getParentid()));
                this.cacheCheckTreeNode();
                this.refreshAllBillList();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540d\u79f0\u5e76\u91cd\u65b0\u641c\u7d22\u3002", (String)"AdjustPaperTemplateAssignPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put(CACHE_SEARCH, result == null ? null : ObjectSerialUtil.toByteSerialized((Object)result));
        }
    }

    private void setBillistrapListener() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity11");
        entryGrid.addClickListener((ClickListener)this);
    }

    private void cacheCheckTreeNode() {
        TreeView tree = (TreeView)this.getControl(ctl_temcatalogtree);
        List checkedNodes = tree.getTreeState().getCheckedNodes();
        String s = SerializationUtils.serializeToBase64((Object)checkedNodes);
        this.getPageCache().put("selectNodeIds", s);
    }

    private void repairByHistoryTreeNode() {
        String selectNodeIds = this.getPageCache().get("selectNodeIds");
        if (!StringUtils.isEmpty((CharSequence)selectNodeIds)) {
            List nodes = (List)SerializationUtils.deSerializeFromBase64((String)selectNodeIds);
            TreeView tree = (TreeView)this.getControl(ctl_temcatalogtree);
            List collect = nodes.stream().map(e -> new TreeNode(e.get("parentid").toString(), e.get("id").toString(), e.get("text").toString())).collect(Collectors.toList());
            tree.checkNodes(collect);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.contains("delete_comfirm")) {
            String suffix = callBackId.split("&")[1];
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(CTL_ENTRYENTITY + suffix);
                this.getModel().deleteEntryRows(CTL_ENTRYENTITY + suffix, entryGrid.getSelectRows());
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_selectentity": {
                this.actionSelectOrg(false);
                break;
            }
            case "btn_selectexceptentity": {
                this.actionSelectOrg(true);
                break;
            }
            case "btn_delentity": {
                this.actionDeleteOrg(false);
                break;
            }
            case "btn_delexceptentity": {
                this.actionDeleteOrg(true);
                break;
            }
            case "rangetext11": {
                int[] selectRows = ((EntryGrid)this.getView().getControl("entryentity11")).getSelectRows();
                String range = (String)this.getModel().getValue("range11", selectRows[0]);
                this.getPageCache().remove("Entity");
                if (!StringUtils.isEmpty((CharSequence)range)) {
                    DimensionScope o = (DimensionScope)ObjectSerialUtil.deSerializedBytes((String)range);
                    this.getPageCache().put("Entity", SerializationUtils.toJsonString((Object)o.getdimMembers()));
                }
                FormShowParameter para = MulTiF7FilterTempleUtils.createMulTiF7ShowParameter((IPageCache)this.getPageCache(), (long)this.getModelId(), (String)"Entity", null);
                String entityid = (String)this.getModel().getValue("entityid11", selectRows[0]);
                DynamicObject oo = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,cslscheme", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)entityid))});
                para.setCustomParam("sign", (Object)"Entity");
                para.setCustomParam("rootid", (Object)oo.getLong("id"));
                para.setCustomParam("cslscheme", (Object)oo.getLong("cslscheme"));
                para.setCustomParam("cslschemeEnable", (Object)true);
                para.setCustomParam("isNotPermFilterF7", (Object)TREE_MERGE_NODE_ID);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "dataRangeEntityList");
                para.setCloseCallBack(closeCallBack);
                this.getView().showForm(para);
                break;
            }
            case "imageup": {
                this.searchNext(-1);
                break;
            }
            case "imagedown": {
                this.searchNext(1);
                break;
            }
        }
    }

    private void searchNext(int i) {
        IPageCache pageCache = this.getPageCache();
        String searchResultCache = pageCache.get(CACHE_SEARCH);
        if (searchResultCache != null) {
            TreeSearchResult result = (TreeSearchResult)ObjectSerialUtil.deSerializedBytes((String)searchResultCache);
            TreeNode next = result.next(i);
            TreeView tree = (TreeView)this.getControl(ctl_temcatalogtree);
            if (next == null) {
                if (i > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"AdjustPaperTemplateAssignPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"AdjustPaperTemplateAssignPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            } else {
                tree.uncheckNodes(tree.getTreeState().getSelectedNodeId());
                tree.checkNode(next);
                tree.treeNodeClick(next.getParentid(), next.getId());
                pageCache.put(CACHE_SEARCH, ObjectSerialUtil.toByteSerialized((Object)result));
                this.refreshAllBillList();
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"AdjustPaperTemplateAssignPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_detail".equals(key)) {
            this.actionViewDetail();
        } else if ("btn_save".equals(key)) {
            this.actionSave();
        }
    }

    private void actionSave() {
        List<DynamicObject> leftDataCol = this.collectData(false);
        List<DynamicObject> rightDataCol = this.collectData(true);
        this.saveAssignRecord(leftDataCol, rightDataCol);
    }

    private List<DynamicObject> collectData(boolean dataRange) {
        String suffix = this.suffix(dataRange);
        EntryGrid gridControl = (EntryGrid)this.getControl(CTL_ENTRYENTITY + suffix);
        DynamicObject[] datas = gridControl.getEntryData().getDataEntitys();
        Long modelId = this.getModelId();
        Long userId = LongUtil.toLong((Object)RequestContext.get().getUserId());
        ArrayList<DynamicObject> saveDyList = new ArrayList<DynamicObject>(datas.length);
        String entityname = dataRange ? "bcm_merge_assign_data" : "bcm_templateassignrecord";
        HashSet<String> distinctKey = new HashSet<String>(16);
        for (DynamicObject data : datas) {
            DynamicObject dy = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityname));
            if (dataRange) {
                dy.set("mergeorg", data.get("entityid" + suffix));
                dy.set("belongid", data.get("templateid" + suffix));
                dy.set("type", (Object)TREE_MERGE_NODE_ID);
                String range11 = data.getString("range11");
                if (!StringUtils.isEmpty((CharSequence)range11)) {
                    DynamicObjectCollection newEntry = dy.getDynamicObjectCollection(CTL_ENTRYENTITY);
                    dy.set(CTL_ENTRYENTITY, (Object)newEntry);
                    DimensionScope ds = (DimensionScope)ObjectSerialUtil.deSerializedBytes((String)range11);
                    ds.getDimensionMembers().stream().forEach(e -> {
                        DynamicObject addNew = newEntry.addNew();
                        addNew.set("entity", (Object)e.getId());
                        addNew.set("range", (Object)e.getScope());
                        if (e instanceof SysPropertyDimensionMember) {
                            IDNumberTreeNode pnode = (IDNumberTreeNode)MemberReader.getAllNodeFromCache((String)"bcm_definedpropertyvalue", (Object)modelId).get(e.getId());
                            long pid = e.getId();
                            if (pnode != null && pnode.getParent() != null && pnode.getParent() != IDNumberTreeNode.NotFoundTreeNode) {
                                pid = pnode.getParent().getId();
                            }
                            addNew.set("property1", (Object)pid);
                            addNew.set("propertyvalue1", (Object)e.getId());
                        }
                    });
                }
            } else {
                dy.set("model", (Object)modelId);
                dy.set("entity", data.get("entityid" + suffix));
                dy.set("property", data.get("pid" + suffix));
                if (dy.getLong("property") != 0L) {
                    dy.set("propertyvalue", data.get("entityid" + suffix));
                }
                dy.set("template", data.get("templateid" + suffix));
                dy.set("range", data.get("range" + suffix));
                dy.set("creator", (Object)userId);
                dy.set("createtime", (Object)TimeServiceHelper.now());
            }
            dy.set("isexcept", (Object)data.getString("isexcept" + suffix));
            if (!dataRange && (dataRange || !distinctKey.add(this.getDistinctKey(data, suffix)))) continue;
            saveDyList.add(dy);
        }
        return saveDyList;
    }

    private String getDistinctKey(DynamicObject data, String suffix) {
        return this.getDistinctKey(data.getLong("templateid" + suffix), data.getString("entitynumber" + suffix), data.getLong("entityid" + suffix) == 0L, data.getString("range" + suffix), data.getString("isexcept" + suffix));
    }

    private String getDistinctKey(Long templateId, String entityNum, boolean isCustom, String range, String isexcept) {
        return String.format("%s_%s_%s_%s_%s", templateId, entityNum, isCustom, range, isexcept);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeSet;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("rangetext11".equals(key) && StringUtils.isEmpty((CharSequence)((String)(changeSet = e.getChangeSet()[0]).getNewValue()))) {
            this.getModel().setValue("rangetext11", (Object)"");
            this.getModel().setValue("range11", null);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("KEY_MODEL_ID", modelid);
        String foucusId = (String)this.getView().getFormShowParameter().getCustomParam("focusnodeid");
        this.getPageCache().put("focusnodeid", foucusId);
        this.setLeftTemplateTree(LongUtil.toLong((Object)modelid));
        this.refreshAllBillList();
    }

    private QFilter getTemplatePermclassQFilter(String field) {
        ArrayListMultimap map;
        List noPermIds;
        boolean modelManage = MemberPermHelper.getLimitedModelListByUser().contains(this.getModelId());
        if (!modelManage && !CollectionUtils.isEmpty((Collection)(noPermIds = (map = PermClassEntityHelper.getPermissionMap((String)"bcm_papertemplate", (String)String.valueOf(this.getModelId()), (String)RequestContext.get().getUserId())).get((Object)TREE_MERGE_NODE_ID)))) {
            QFilter qFilter = new QFilter(field, "not in", (Object)noPermIds);
            return qFilter;
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("ccb_selectmember1".equals(actionId)) {
            this.generateAssignRecord(e, false);
        } else if ("ccb_selectmember11".equals(actionId)) {
            this.generateAssignRecord(e, true);
        } else if ("dataRangeEntityList".equals(actionId)) {
            this.assignDataRange((DynamicObjectCollection)e.getReturnData());
        }
    }

    private void assignDataRange(DynamicObjectCollection orgs) {
        if (orgs == null) {
            return;
        }
        int[] selectRows = ((EntryGrid)this.getView().getControl("entryentity11")).getSelectRows();
        this.getModel().setValue("rangetext11", null, selectRows[0]);
        this.getModel().setValue("range11", null, selectRows[0]);
        if (!CollectionUtils.isEmpty((Collection)orgs)) {
            SchemeContext schemeContext = new SchemeContext(this.getModelId());
            DimensionScope ds = new DimensionScope(this.getModelId() + "", schemeContext.getDimensionByNumber("Entity"), orgs);
            this.getModel().setValue("rangetext11", (Object)ds.toString(), selectRows[0]);
            this.getModel().setValue("range11", (Object)ObjectSerialUtil.toByteSerialized((Object)ds), selectRows[0]);
        }
    }

    private void generateAssignRecord(ClosedCallBackEvent e, boolean dataRange) {
        if (e.getReturnData() != null) {
            if (dataRange) {
                this.rightAssign((DynamicObject)e.getReturnData());
            } else {
                this.leftAssign((DynamicObjectCollection)e.getReturnData());
            }
        }
    }

    private Collection<DynamicObject> querySelectedTemplates() {
        List<String> temlist = this.getTemSelectedAndResultList();
        if (!CollectionUtils.isEmpty(temlist)) {
            QFilter qf = new QFilter("id", "in", (Object)LongUtil.toLongList(temlist));
            qf.and(this.getTemplatePermclassQFilter("id"));
            return QueryServiceHelper.query((String)this.getTemplateEntityName(), (String)"id,name,number,bussnesstype", (QFilter[])qf.toArray());
        }
        return Collections.emptyList();
    }

    private void leftAssign(DynamicObjectCollection orgs) {
        String suffix = TREE_MERGE_NODE_ID;
        DynamicObjectCollection oldRecord = this.getModel().getEntryEntity(CTL_ENTRYENTITY + suffix);
        Set distinctKeys = oldRecord.stream().map(e -> this.getDistinctKey((DynamicObject)e, suffix)).collect(Collectors.toSet());
        Collection<DynamicObject> templateColl = this.querySelectedTemplates();
        if (!CollectionUtils.isEmpty(templateColl)) {
            for (DynamicObject tem : templateColl) {
                long templateId = tem.getLong("id");
                for (DynamicObject org : orgs) {
                    if (distinctKeys.contains(this.getDistinctKey(templateId, org.getString("mnum1"), org.getLong("mid1") == 0L, org.getString("filltypevalue1"), "0"))) continue;
                    int newEntryRow = this.getModel().createNewEntryRow(CTL_ENTRYENTITY + suffix);
                    this.getModel().setValue("templateid" + suffix, (Object)templateId, newEntryRow);
                    this.getModel().setValue("templatenumber" + suffix, (Object)tem.getString("number"), newEntryRow);
                    this.getModel().setValue("templatename" + suffix, (Object)tem.getString("name"), newEntryRow);
                    this.getModel().setValue("entityid" + suffix, org.get("mid1"), newEntryRow);
                    if (StringUtils.isEmpty((CharSequence)org.getString("pid1").trim()) || Objects.equals("0", org.getString("pid1").trim())) {
                        IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)org.getLong("mid1"));
                        this.getModel().setValue("entityname" + suffix, (Object)node.getName(), newEntryRow);
                        this.getModel().setValue("entitynumber" + suffix, (Object)node.getNumber(), newEntryRow);
                        this.getModel().setValue("entitylongnumber" + suffix, (Object)node.getLongNumber(), newEntryRow);
                        this.getModel().setValue("pid" + suffix, (Object)0, newEntryRow);
                    } else {
                        this.getModel().setValue("entityname" + suffix, org.get("mname1"), newEntryRow);
                        this.getModel().setValue("entitynumber" + suffix, org.get("mnum1"), newEntryRow);
                        this.getModel().setValue("pid" + suffix, org.get("pid1"), newEntryRow);
                    }
                    this.getModel().setValue("range" + suffix, org.get("filltypevalue1"), newEntryRow);
                    this.getModel().setValue("rangetext" + suffix, (Object)RangeEnum.getRangeByVal((int)org.getInt("filltypevalue1")).getName(), newEntryRow);
                }
            }
        }
    }

    private void rightAssign(DynamicObject org) {
        String suffix = "11";
        Collection<DynamicObject> templateColl = this.querySelectedTemplates();
        if (!CollectionUtils.isEmpty(templateColl)) {
            for (DynamicObject tpl : templateColl) {
                String processNumber = BusinessTypeEnum.searchByName((String)tpl.getString("bussnesstype")).getProcessNumber();
                if ("DEJE".equals(processNumber) || "DADJ".equals(processNumber)) continue;
                Long templateId = tpl.getLong("id");
                String templateNumber = tpl.getString("number");
                String templateName = tpl.getString("name");
                int newEntryRow = this.getModel().createNewEntryRow(CTL_ENTRYENTITY + suffix);
                this.getModel().setValue("templateid" + suffix, (Object)templateId, newEntryRow);
                this.getModel().setValue("templatenumber" + suffix, (Object)templateNumber, newEntryRow);
                this.getModel().setValue("templatename" + suffix, (Object)templateName, newEntryRow);
                this.getModel().setValue("entityid" + suffix, org.get("id"), newEntryRow);
                this.getModel().setValue("entityname" + suffix, org.get("name"), newEntryRow);
                this.getModel().setValue("entitynumber" + suffix, org.get("number"), newEntryRow);
                this.getModel().setValue("entitylongnumber" + suffix, (Object)MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)org.getLong("id")).getLongNumber(), newEntryRow);
                this.getModel().setValue("rangetext" + suffix, (Object)RangeEnum.VALUE_20.getName(), newEntryRow);
            }
        }
    }

    private void saveAssignRecord(List<DynamicObject> leftDataCol, List<DynamicObject> rightDataCol) {
        List tmplIds = LongUtil.toLongList(this.getTemSelectedAndResultList());
        if (CollectionUtils.isEmpty((Collection)tmplIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u6811\u6a21\u677f\u3002", (String)"AdjustPaperTemplateAssignPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"bcm_templateassignrecord", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("template", "in", (Object)tmplIds)});
                DeleteServiceHelper.delete((String)"bcm_merge_assign_data", (QFilter[])new QFilter[]{new QFilter("belongid", "in", (Object)tmplIds)});
                SaveServiceHelper.save((DynamicObject[])leftDataCol.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])rightDataCol.toArray(new DynamicObject[0]));
                String msg = ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"AdjustPaperTemplateAssignPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(msg);
                this.writeLog(AdjustPaperTemplateAssignPlugin.getOperationSend(), msg);
                this.refreshAllBillList();
                AdjustTemplateHelper.clearAssignTemplateCache((Long)this.getModelId(), (Long)this.getScenarioId());
            }
            catch (Exception e) {
                tx.markRollback();
                String s = AdjustmentServiceHelper.toString_Adj((Throwable)e);
                this.writeLog(AdjustPaperTemplateAssignPlugin.getOperationSend(), String.format(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff1a%s", (String)"AdjustPaperTemplateAssignPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), s));
                throw e;
            }
        }
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    private void refreshAllBillList() {
        this.refreshRightBillList();
        this.refreshLeftBillList();
    }

    private void refreshLeftBillList() {
        String suffix = this.suffix(Boolean.FALSE);
        this.getModel().deleteEntryData(CTL_ENTRYENTITY + suffix);
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        String selectProperties = "id,entity,template.id,template.name,template.number,range,isexcept,property,propertyvalue";
        QFilter filter1 = this.getTemQueryFilter("template");
        if (filter1 == null) {
            filter.and(new QFilter(TREE_MERGE_NODE_ID, "!=", (Object)1));
        } else {
            filter.and(filter1);
        }
        DynamicObjectCollection load = QueryServiceHelper.query((String)"bcm_templateassignrecord", (String)selectProperties, (QFilter[])filter.toArray());
        for (DynamicObject dy : load) {
            int newEntryRow = this.getModel().createNewEntryRow(CTL_ENTRYENTITY + suffix);
            this.getModel().setValue("assignid" + suffix, (Object)dy.getLong("id"), newEntryRow);
            this.getModel().setValue("templateid" + suffix, (Object)dy.getLong("template.id"), newEntryRow);
            this.getModel().setValue("templatenumber" + suffix, (Object)dy.getString("template.number"), newEntryRow);
            this.getModel().setValue("templatename" + suffix, (Object)dy.getString("template.name"), newEntryRow);
            this.getModel().setValue("entityid" + suffix, (Object)dy.getLong("entity"), newEntryRow);
            this.getModel().setValue("pid" + suffix, (Object)dy.getLong("property"), newEntryRow);
            if (dy.getLong("property") == 0L) {
                IDNumberTreeNode entity = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)dy.getLong("entity"));
                this.getModel().setValue("entitynumber" + suffix, (Object)entity.getNumber(), newEntryRow);
                this.getModel().setValue("entityname" + suffix, (Object)entity.getName(), newEntryRow);
                this.getModel().setValue("entitylongnumber" + suffix, (Object)dy.getString("entity.longnumber"), newEntryRow);
            } else {
                IDNumberTreeNode oNode = MemberReader.getAllNodeFromCache((String)"bcm_definedpropertyvalue", (Object)this.getModelId()).getOrDefault(dy.getLong("propertyvalue"), IDNumberTreeNode.NotFoundTreeNode);
                IDNumberTreeNode pNode = oNode.getParent();
                if (pNode == null || pNode == IDNumberTreeNode.NotFoundTreeNode) {
                    pNode = oNode;
                }
                this.getModel().setValue("entitynumber" + suffix, (Object)(pNode.getNumber() + ":" + oNode.getNumber()), newEntryRow);
                this.getModel().setValue("entityname" + suffix, (Object)(pNode.getName() + ":" + oNode.getName()), newEntryRow);
            }
            this.getModel().setValue("range" + suffix, (Object)dy.getInt("range"), newEntryRow);
            this.getModel().setValue("rangetext" + suffix, (Object)RangeEnum.getRangeByVal((int)dy.getInt("range")).getName(), newEntryRow);
            this.getModel().setValue("isexcept" + suffix, (Object)dy.getLong("isexcept"), newEntryRow);
        }
    }

    private void refreshRightBillList() {
        String suffix = this.suffix(Boolean.TRUE);
        this.getModel().deleteEntryData(CTL_ENTRYENTITY + suffix);
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        String selectProperties = "mergeorg.id,mergeorg.name,mergeorg.number,mergeorg.longnumber,belongid,isexcept,entryentity.entity,entryentity.range,entryentity.property1,entryentity.propertyvalue1";
        filter = new QFilter("type", "=", (Object)TREE_MERGE_NODE_ID);
        QFilter filter1 = this.getTemQueryFilter("belongid");
        if (filter1 == null) {
            filter.and(new QFilter(TREE_MERGE_NODE_ID, "!=", (Object)1));
        } else {
            filter.and(filter1);
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_merge_assign_data", (String)selectProperties, (QFilter[])filter.toArray());
        Set templateIds = Arrays.stream(load).map(e -> e.getLong("belongid")).collect(Collectors.toSet());
        Map templateMaps = BusinessDataServiceHelper.loadFromCache((String)this.getTemplateEntityName(), (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", templateIds)});
        for (DynamicObject dy : load) {
            int newEntryRow = this.getModel().createNewEntryRow(CTL_ENTRYENTITY + suffix);
            this.getModel().setValue("assignid" + suffix, (Object)dy.getLong("id"), newEntryRow);
            long templateId = dy.getLong("belongid");
            this.getModel().setValue("templateid" + suffix, (Object)templateId, newEntryRow);
            DynamicObject temp = (DynamicObject)templateMaps.get(templateId);
            if (temp != null) {
                this.getModel().setValue("templatenumber" + suffix, (Object)temp.getString("number"), newEntryRow);
                this.getModel().setValue("templatename" + suffix, (Object)temp.getString("name"), newEntryRow);
            }
            this.getModel().setValue("entityid" + suffix, (Object)dy.getLong("mergeorg.id"), newEntryRow);
            this.getModel().setValue("entitynumber" + suffix, (Object)dy.getString("mergeorg.number"), newEntryRow);
            this.getModel().setValue("entityname" + suffix, (Object)dy.getString("mergeorg.name"), newEntryRow);
            this.getModel().setValue("entitylongnumber" + suffix, (Object)dy.getString("mergeorg.longnumber"), newEntryRow);
            this.getModel().setValue("isexcept" + suffix, (Object)dy.getLong("isexcept"), newEntryRow);
            DynamicObjectCollection entryentity = dy.getDynamicObjectCollection(CTL_ENTRYENTITY);
            if (CollectionUtils.isEmpty((Collection)entryentity)) {
                this.getModel().setValue("rangetext" + suffix, (Object)RangeEnum.VALUE_20.getName(), newEntryRow);
                continue;
            }
            SchemeContext schemeContext = new SchemeContext(this.getModelId());
            Map<Long, Integer> collect = entryentity.stream().collect(Collectors.toMap(e -> e.getLong("entity_id") != 0L ? e.getLong("entity_id") : e.getLong("propertyvalue1_id"), v -> v.getInt("range"), (o1, o2) -> o1));
            DimensionScope ds = new DimensionScope(this.getModelId() + "", schemeContext.getDimensionByNumber("Entity"), collect);
            this.getModel().setValue("rangetext11", (Object)ds.toString(), newEntryRow);
            this.getModel().setValue("range11", (Object)ObjectSerialUtil.toByteSerialized((Object)ds), newEntryRow);
        }
    }

    private QFilter getTemQueryFilter(String columnname) {
        List<String> rows = this.getTemSelectedAndResultList();
        QFilter filter = null;
        if (!rows.isEmpty()) {
            filter = new QFilter(columnname, "in", (Object)LongUtil.toLongList(rows).toArray());
        }
        return filter;
    }

    private List<String> getTemSelectedAndResultList() {
        TreeView tree = (TreeView)this.getControl(ctl_temcatalogtree);
        ArrayList tids = tree.getTreeState().getSelectedNodeId();
        if (tids.isEmpty()) {
            String cache = this.getPageCache().get("templeteids");
            tids = StringUtils.isNotEmpty((CharSequence)cache) ? (List)SerializationUtils.fromJsonString((String)cache, List.class) : new ArrayList(10);
            this.getPageCache().remove("templeteids");
        }
        tids.remove(TREE_MERGE_NODE_ID);
        tids.remove(TREE_ISLEAF_NODE_ID);
        return tids;
    }

    @Override
    public long getModelId() {
        return ConvertUtil.convertStrToLong((String)this.getPageCache().get("KEY_MODEL_ID"));
    }

    private boolean checkLeftTreeNode() {
        TreeView tree = (TreeView)this.getControl(ctl_temcatalogtree);
        List tids = tree.getTreeState().getSelectedNodeId();
        tids.remove("0");
        tids.remove(TREE_MERGE_NODE_ID);
        tids.remove(TREE_ISLEAF_NODE_ID);
        if (tids.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u6811\u6a21\u677f\u3002", (String)"AdjustPaperTemplateAssignPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter qf = new QFilter("id", "in", (Object)LongUtil.toLongList((Collection)tids));
        int count = QueryServiceHelper.queryDataSet((String)this.getTemplateEntityName(), (String)this.getTemplateEntityName(), (String)"id", (QFilter[])qf.toArray(), null).count("id", false);
        if (count < tids.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u5de6\u6811\u6a21\u677f\u6570\u636e\u5b58\u5728\u5220\u9664\u7684\uff0c\u8bf7\u91cd\u8fdb\u5165\u5206\u914d\u754c\u9762\u3002", (String)"AdjustPaperTemplateAssignPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return true;
    }

    private boolean checkCanOp(boolean dataRange) {
        if (dataRange) {
            Collection<DynamicObject> templateCollect;
            boolean isMerge = TREE_MERGE_NODE_ID.equals(this.getPageCache().get(TREE_TEMPLATE_TYPE_CACHE));
            if (isMerge && (templateCollect = this.querySelectedTemplates()).stream().anyMatch(e -> {
                String processNumber = BusinessTypeEnum.searchByName((String)e.getString("bussnesstype")).getProcessNumber();
                return OrgRelaProcessMembPool.isRelaProcess((String)processNumber);
            })) {
                return true;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u7236_\u5b50\u5206\u5f55\u4e0d\u53ef\u4ee5\u5bf9\u6570\u636e\u8303\u56f4\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjustPaperTemplateAssignPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void actionSelectOrg(boolean dataRange) {
        if (this.checkLeftTreeNode() && this.checkCanOp(dataRange)) {
            boolean isMerge = TREE_MERGE_NODE_ID.equals(this.getPageCache().get(TREE_TEMPLATE_TYPE_CACHE));
            String formId = dataRange ? "bcm_singlemember_noleaf" : "bcm_mulmemberf7base_dis";
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(formId);
            formShowParameter.setCustomParam("dimension", (Object)TREE_MERGE_NODE_ID);
            if (isMerge) {
                formShowParameter.setCustomParam("setRange10_110", (Object)TREE_MERGE_NODE_ID);
                formShowParameter.setCustomParam("customFilter", (Object)new QFilter("isleaf", "!=", (Object)true).toSerializedString());
            }
            if (dataRange) {
                QFilter numberFilter = new QFilter("number", "=", (Object)DimTypesEnum.ENTITY.getNumber());
                numberFilter.and("model", "=", (Object)this.getModelId());
                DynamicObject dim = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id,number,name,dseq,membermodel", (QFilter[])new QFilter[]{numberFilter});
                formShowParameter.setCustomParam("entity", (Object)dim.getString("membermodel"));
                formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
                formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                formShowParameter.setCustomParam("dimId", (Object)dim.getLong("id"));
                formShowParameter.setCustomParam("f7Value", (Object)dim.getInt("dseq"));
            }
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"AdjustPaperTemplateAssignPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ccb_selectmember" + this.suffix(dataRange));
            formShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(formShowParameter);
        }
    }

    private String suffix(boolean dataRange) {
        return dataRange ? "11" : TREE_MERGE_NODE_ID;
    }

    private void actionDeleteOrg(boolean dataRange) {
        if (this.checkLeftTreeNode() && this.checkCanOp(dataRange)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(CTL_ENTRYENTITY + this.suffix(dataRange));
            int[] rows = entryGrid.getSelectRows();
            if (rows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u8bb0\u5f55\u7684\u6570\u636e\u884c\u3002", (String)"AdjustPaperTemplateAssignPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"AdjustPaperTemplateAssignPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm&" + this.suffix(dataRange), (IFormPlugin)this));
        }
    }

    private void actionViewDetail() {
        if (this.checkLeftTreeNode()) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(CTL_ENTRYENTITY + this.suffix(false));
            FormShowParameter param = new FormShowParameter();
            param.setFormId(this.getTemplateAssignDetailEntityName());
            param.setCaption(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u914d\u8be6\u60c5", (String)"AdjustPaperTemplateAssignPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            int[] rows = entryGrid.getSelectRows();
            DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
            ArrayList<Long> ids = new ArrayList<Long>();
            if (rows.length <= 0) {
                if (dataEntitys.length > 0) {
                    for (DynamicObject dataEntity : dataEntitys) {
                        if (dataEntity.getLong("assignid1") == 0L) continue;
                        ids.add(dataEntity.getLong("assignid1"));
                    }
                }
            } else {
                for (int row : rows) {
                    if (dataEntitys[row].getLong("assignid1") == 0L) continue;
                    ids.add(dataEntitys[row].getLong("assignid1"));
                }
            }
            List list = QueryServiceHelper.queryPrimaryKeys((String)"bcm_templateassignrecord", (QFilter[])new QFilter[]{new QFilter("id", "in", ids).and("isexcept", "=", (Object)"0")}, null, (int)-1);
            param.setCustomParam("ids", (Object)SerializationUtils.toJsonString((Object)list));
            param.setCustomParam("modelid", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            param.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(param);
        }
    }

    private void setLeftTemplateTree(Long modelid) {
        DynamicObjectCollection temlist = this.getTemplateColls(modelid);
        TreeNode rootNode = new TreeNode("", "0", TemplateCatalogEnum.PRTADJUST.getLocaleName());
        TreeNode mergeNode = new TreeNode(rootNode.getId(), TREE_MERGE_NODE_ID, ResManager.loadKDString((String)"\u62b5\u9500\u7c7b\u5206\u5f55\u6a21\u677f", (String)"AdjustPaperTemplateAssignPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        mergeNode.setIsOpened(true);
        TreeNode isleafNode = new TreeNode(rootNode.getId(), TREE_ISLEAF_NODE_ID, ResManager.loadKDString((String)"\u8c03\u6574\u7c7b\u5206\u5f55\u6a21\u677f", (String)"AdjustPaperTemplateAssignPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        isleafNode.setIsOpened(true);
        rootNode.addChildren(Arrays.asList(mergeNode, isleafNode));
        String processNumber = null;
        for (DynamicObject e : temlist) {
            if (StringUtils.isEmpty((CharSequence)e.getString("bussnesstype"))) continue;
            processNumber = BusinessTypeEnum.searchByName((String)e.getString("bussnesstype")).getProcessNumber();
            if ("DEJE".equals(processNumber) || "DADJ".equals(processNumber) || OrgRelaProcessMembPool.isRelaProcess((String)processNumber)) {
                mergeNode.addChild(new TreeNode(mergeNode.getId(), e.getString("id"), e.getString("number") + "  " + e.getString("name")));
                continue;
            }
            isleafNode.addChild(new TreeNode(isleafNode.getId(), e.getString("id"), e.getString("number") + "  " + e.getString("name")));
        }
        TreeView tree = (TreeView)this.getControl(ctl_temcatalogtree);
        BCMTreeUtils.spreadAllNode((TreeNode)rootNode);
        tree.addNode(rootNode);
        this.getPageCache().put(TEMPLATE_TREE_MODEL_CACHE, SerializationUtils.serializeToBase64((Object)rootNode));
        ArrayList<TreeNode> selNodes = new ArrayList<TreeNode>();
        if (selNodes.size() <= 0) {
            selNodes.add(rootNode);
        }
    }

    private DynamicObjectCollection getTemplateColls(Long modelId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        Object pks = this.getView().getFormShowParameter().getCustomParam("tpks");
        if (pks != null) {
            filter.and("id", "in", pks);
        }
        filter.and("templatetype", "=", (Object)TemplateCatalogEnum.PRTADJUST.getTemplatetype());
        filter.and(this.getTemplatePermclassQFilter("id"));
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id, name, number,templatecatalog,templatecatalog.longnumber,versionnumber,group,bussnesstype";
        return QueryServiceHelper.query((String)this.getTemplateEntityName(), (String)selectFields, (QFilter[])filters, (String)"number");
    }

    public String getBillForm() {
        return "bcm_templateassignrecord";
    }

    public String getTemplateEntityName() {
        return "bcm_papertemplate";
    }

    public String getTemplateAssignDetailEntityName() {
        return "bcm_adjusttmpassigndetail";
    }
}

