/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.adjust.AdjustTemplateControlEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.ControlPropValidateUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimension;

public class AdjustPaperTemplatePlugin
extends AbstractBaseFormPlugin {
    private static final String SCENARIOSET = "scenarioset";
    public static final String TMPL_SCENE_ITEMS = "tmpl_scene_items";
    public static final String TMPL_SCENE_CACHE = "tmpl_scene_cache";
    private static final String CTR_EFFECTIVETEXT = "effectivetext";
    private static final String CTR_EFFECTIVEDATA = "effectivedata";
    private static final String CTR_EFFECTIVECACHE = "effectivecache";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_ok", SCENARIOSET, CTR_EFFECTIVETEXT);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getModelId());
        BasedataEdit fcurrency = (BasedataEdit)this.getControl("foreigncurrency");
        if (fcurrency != null) {
            fcurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String chooseBaseDataEditName = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if ("foreigncurrency".equalsIgnoreCase(chooseBaseDataEditName)) {
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            filter.and("isleaf", "=", (Object)true);
            filter.and("number", "<>", (Object)"EC");
            filter.and("number", "<>", (Object)"DC");
            filter.and("number", "<>", (Object)"PC");
            filter.and("number", "<>", (Object)"OC");
            filter.and("number", "<>", (Object)"CNone");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setListFilterParameter(new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{filter}), "dseq"));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        List<ComboItem> bussnesstypeinput;
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getModel().setValue("model", (Object)modelId);
        this.getModel().setValue("scenario", this.getView().getFormShowParameter().getCustomParam("KEY_SCENARIO_ID"));
        Object tmplscenestr = this.getFormCustomParam("tmplscene");
        if (tmplscenestr != null) {
            this.getPageCache().put(TMPL_SCENE_CACHE, tmplscenestr.toString());
            Map tmplScene = (Map)this.deSerializedBytes(tmplscenestr.toString());
            if (tmplScene != null) {
                this.getModel().setValue(SCENARIOSET, tmplScene.get("name"));
                this.getPageCache().put(TMPL_SCENE_ITEMS, this.toByteSerialized(tmplScene.get("items")));
            }
        }
        if (!CollectionUtils.isEmpty(bussnesstypeinput = AdjustModelUtil.setBusinessType(this.getModel(), (ComboEdit)this.getControl(AdjustTemplateControlEnum.BUSSINESS_TYPE.getNumber()), modelId, false, true, null, false))) {
            this.getModel().setValue(AdjustTemplateControlEnum.BUSSINESS_TYPE.getNumber(), (Object)bussnesstypeinput.get(0).getValue());
        }
        this.getView().setFormTitle(ResManager.getLocaleString((String)"\u57fa\u672c\u4fe1\u606f", (String)"AdjustPaperTemplatePlugin_1", (String)"fi-bcm-formplugin"));
        this.refreshMultipleCurrency();
    }

    private boolean validateNumber() {
        QFilter fcatalog;
        QFilter fnumber;
        QFilter fmodelid = new QFilter("model", "=", (Object)this.getModelId());
        if (QueryServiceHelper.exists((String)"bcm_papertemplate", (QFilter[])new QFilter[]{fmodelid, fnumber = new QFilter("number", "=", this.getModel().getValue("number")), fcatalog = new QFilter("templatetype", "=", (Object)TemplateCatalogEnum.PRTADJUST.getTemplatetype())})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"AdjustPaperTemplatePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[]{this.getModel().getValue("number")}));
            return false;
        }
        if (!BCMNumberRule.checkNumber((String)(this.getModel().getValue("number") + ""))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AdjustPaperTemplatePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long foreigncurrency = (Long)this.getModel().getValue("foreigncurrency_id");
        if ("1".equals(this.getModel().getValue("multiplecurrency")) && (foreigncurrency == null || foreigncurrency == 0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8f93\u5165\u5e01\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptAdjustBasicInfoPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        Object templatecatalog = this.getView().getFormShowParameter().getCustomParam("templatecatalog");
        if ("btn_ok".equals(key)) {
            boolean exists = QueryServiceHelper.exists((String)"bcm_papertemplatecatalog", (QFilter[])new QFilter("id", "=", templatecatalog).toArray());
            if (!exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"AdjustPaperTemplatePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            Optional showTipMesg = ControlPropValidateUtil.validateData((IDataModel)this.getModel());
            if (showTipMesg.isPresent()) {
                this.getView().showTipNotification((String)showTipMesg.get());
                return;
            }
            if (!this.validateNumber()) {
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            Arrays.stream(AdjustTemplateControlEnum.values()).forEach(e -> {
                if (e == AdjustTemplateControlEnum.EXECUTEORDER) {
                    map.put(e.getNumber(), 99999);
                } else {
                    map.put(e.getNumber(), this.getModel().getValue(e.getNumber()));
                }
            });
            map.put("permclass", this.getModel().getValue("permclass"));
            map.put("templatecatalog", templatecatalog);
            map.put("name", this.getModel().getValue("name"));
            map.put("number", this.getModel().getValue("number"));
            map.put("KEY_MODEL_ID", this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
            map.put("scenario", this.getView().getFormShowParameter().getCustomParam("KEY_SCENARIO_ID"));
            map.put("foreigncurrency", (Long)this.getModel().getValue("foreigncurrency_id"));
            map.put(TMPL_SCENE_CACHE, this.getPageCache().get(TMPL_SCENE_CACHE));
            String s = this.getPageCache().get(CTR_EFFECTIVECACHE);
            if (StringUtils.isNotEmpty((CharSequence)s)) {
                Map effective = (Map)JSON.parseObject((String)s, (TypeReference)new TypeReference<Map<String, Set<Long>>>(){}, (Feature[])new Feature[0]);
                map.put(CTR_EFFECTIVEDATA, effective);
                map.put(CTR_EFFECTIVETEXT, this.getModel().getValue(CTR_EFFECTIVETEXT));
            }
            this.getView().returnDataToParent((Object)ObjectSerialUtil.toByteSerialized(map));
            this.getView().close();
        } else if (SCENARIOSET.equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_templatemutiscenceset");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("model", (Object)this.getModelId());
            formShowParameter.setCustomParam("selecteditems", (Object)this.getPageCache().get(TMPL_SCENE_ITEMS));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            this.getView().showForm(formShowParameter);
        } else if (CTR_EFFECTIVETEXT.equals(key)) {
            this.openExpiredDateF7(CTR_EFFECTIVETEXT);
        }
    }

    private void openExpiredDateF7(String key) {
        long modelIdl = this.getModelId();
        if (0L == modelIdl) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ConvertSettingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_expire_date_f7");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4", (String)"ConvertSettingPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelIdl);
        formShowParameter.setCustomParam("entryId", (Object)key);
        String data = this.getPageCache().get(CTR_EFFECTIVECACHE);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)data)) {
            formShowParameter.setCustomParam("effective", (Object)data);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ExpiredDate");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (SCENARIOSET.equals(actionId)) {
            String serialStr = closedCallBackEvent.getReturnData().toString();
            Map tmplScene = (Map)this.deSerializedBytes(serialStr);
            this.getModel().setValue(SCENARIOSET, tmplScene.get("name"));
            this.getPageCache().put(TMPL_SCENE_CACHE, serialStr);
            this.getPageCache().put(TMPL_SCENE_ITEMS, this.toByteSerialized(tmplScene.get("items")));
        } else if ("ExpiredDate".equals(actionId)) {
            String data = (String)this.deSerializedBytes(String.valueOf(closedCallBackEvent.getReturnData()));
            JSONObject obj = JSON.parseObject((String)data);
            this.getModel().setValue(CTR_EFFECTIVETEXT, obj.get((Object)"text"));
            if (kd.bos.util.StringUtils.isNotEmpty((String)obj.getString("effective"))) {
                Map effective = (Map)JSON.parseObject((String)obj.getString("effective"), (TypeReference)new TypeReference<Map<String, Set<Long>>>(){}, (Feature[])new Feature[0]);
                if (effective == null || effective.size() == 0) {
                    this.getPageCache().remove(CTR_EFFECTIVECACHE);
                } else {
                    this.getPageCache().put(CTR_EFFECTIVECACHE, JSON.toJSONString((Object)effective));
                }
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "bussnesstype": {
                this.refreshMultipleCurrency();
                break;
            }
            case "multiplecurrency": {
                BasedataEdit foreigncurrency = (BasedataEdit)this.getControl("foreigncurrency");
                if ("1".equals(newValue)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"foreigncurrency"});
                    foreigncurrency.setMustInput(true);
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"foreigncurrency"});
                foreigncurrency.setMustInput(false);
                this.getModel().setValue("foreigncurrency", null);
                break;
            }
            case "scenarioset": {
                if (newValue != null && !kd.bos.util.StringUtils.isBlank((String)newValue.toString())) break;
                this.getPageCache().remove(TMPL_SCENE_CACHE);
                this.getPageCache().remove(TMPL_SCENE_ITEMS);
            }
        }
    }

    private void refreshMultipleCurrency() {
        String bussnesstype = (String)this.getModel().getValue("bussnesstype");
        boolean isShowMultipleCurrency = OrgRelaProcessMembPool.isRelaProcess((String)BusinessTypeEnum.searchByName((String)bussnesstype).getProcessNumber());
        if (isShowMultipleCurrency) {
            List<DimMember> multipleCurrency = AdjustPaperTemplatePlugin.getMultipleCurrency(this.getModelId(), bussnesstype);
            isShowMultipleCurrency = !CollectionUtils.isEmpty(multipleCurrency);
        }
        this.getView().setVisible(Boolean.valueOf(isShowMultipleCurrency), new String[]{"multiplecurrency", "foreigncurrency"});
        ((BasedataEdit)this.getControl("foreigncurrency")).setMustInput(isShowMultipleCurrency);
        if (isShowMultipleCurrency) {
            this.getModel().setValue("multiplecurrency", (Object)"1");
        } else {
            this.getModel().setValue("multiplecurrency", (Object)"0");
            this.getModel().setValue("foreigncurrency", null);
        }
    }

    public static List<DimMember> getMultipleCurrency(long modelId, String businessType) {
        DynamicObject[] col;
        String businessTypeIndex = BusinessTypeEnum.searchByName((String)businessType).getIndex();
        ArrayList currencyList = Lists.newArrayList();
        HashSet currencyAllIdSet = Sets.newHashSet();
        for (DynamicObject obj : col = BusinessDataServiceHelper.load((String)"bcm_entrycvtcurrency", (String)"businesstype,entryentity,entryentity.dimensionnum,entryentity.memberid", (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{modelId}).toArray())) {
            boolean hasBusinessType = false;
            String value = obj.getString("businesstype");
            if (kd.bos.util.StringUtils.isBlank((String)value)) {
                hasBusinessType = true;
            } else {
                StringTokenizer st = new StringTokenizer(value, ",");
                while (st.hasMoreElements()) {
                    if (!st.nextToken().equals(businessTypeIndex)) continue;
                    hasBusinessType = true;
                    break;
                }
            }
            if (!hasBusinessType) continue;
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("entryentity");
            HashSet currencyIdSet = Sets.newHashSet();
            for (DynamicObject membObj : entryCol) {
                String dimNum = membObj.getString("dimensionnum");
                if (!DimEntityNumEnum.CURRENCY.getNumber().equals(dimNum) || "EC".equals(dimNum) || "DC".equals(dimNum)) continue;
                currencyIdSet.add(membObj.getLong("memberid"));
            }
            if (currencyIdSet.isEmpty()) {
                return AdjustPaperTemplatePlugin.getCurrencyResultList(modelId);
            }
            currencyAllIdSet.addAll(currencyIdSet);
        }
        if (!currencyAllIdSet.isEmpty()) {
            Map members_Currency = BusinessDataServiceHelper.loadFromCache((String)DimEntityNumEnum.CURRENCY.getEntityNum(), (String)"id, name, number", (QFilter[])new QFBuilder("id", "in", (Object)currencyAllIdSet).toArray());
            Iterator iterator = members_Currency.entrySet().iterator();
            while (iterator.hasNext()) {
                DynamicObject currency = (DynamicObject)iterator.next().getValue();
                Dimension dim = new Dimension(null, SysDimensionEnum.Currency.getNumber(), null);
                DimMember memb = new DimMember(currency.getString("name"), currency.getString("number"), null, (IDimension)dim);
                currencyList.add(memb);
            }
        }
        return currencyList;
    }

    private static List<DimMember> getCurrencyResultList(long modelId) {
        ArrayList currencyList = Lists.newArrayList();
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("isleaf", "=", (Object)true);
        filter.and(new QFilter("status", "<>", (Object)Character.valueOf('E')));
        filter.and(new QFilter("number", "<>", (Object)"EC"));
        filter.and(new QFilter("number", "<>", (Object)"DC"));
        filter.and(new QFilter("number", "<>", (Object)"PC"));
        filter.and(new QFilter("number", "<>", (Object)"CNone"));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_currencymembertree", (String)"id, name, number", (QFilter[])new QFilter[]{filter});
        for (DynamicObject obj : col) {
            Dimension dim = new Dimension(null, SysDimensionEnum.Currency.getNumber(), null);
            DimMember memb = new DimMember(obj.getString("name"), obj.getString("number"), null, (IDimension)dim);
            currencyList.add(memb);
        }
        return currencyList;
    }
}

