/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.template;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustTemplateHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.util.EntryGridUtils;

public class AdjustTemplateAssignDetailPlugin
extends AbstractFormPlugin
implements DynamicPage {
    private String assignTemplateField = "template,template.name,template.number,template.id,template.templatecatalog.name,entity,range,propertyvalue.id,propertyvalue.number,template.bussnesstype";
    private Map<Long, Object[]> templateMap;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showDetailBilllistrap();
    }

    private void showDetailBilllistrap() {
        String entityType = "bcm_templateassignrecord";
        Map<Long, Set<Long>> assignTempOrgMap = this.getAssignTempId2OrgId(entityType);
        Map<Long, Set<Long>> exceptTemplateOrg = this.getExceptTempId2OrgId(assignTempOrgMap.keySet());
        Long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelid"));
        boolean modelManage = MemberPermHelper.getLimitedModelListByUser().contains(modelId);
        Set allOrgs = assignTempOrgMap.entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream()).collect(Collectors.toSet());
        Set noPermissionIds = PermissionServiceImpl.getInstance((Long)modelId).matchNoPermMembers(MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), "bcm_entitymembertree", allOrgs);
        HashSet orgSet = new HashSet(16);
        assignTempOrgMap.forEach((templateId, orgs) -> {
            if (exceptTemplateOrg.containsKey(templateId)) {
                orgs.removeAll((Collection)exceptTemplateOrg.get(templateId));
            }
            if (!modelManage && orgs.size() > 0) {
                orgs.removeIf(noPermissionIds::contains);
            }
            orgSet.addAll(orgs);
        });
        this.setEntityVisibleByCombo();
        this.getModel().deleteEntryData("entryentity");
        assignTempOrgMap.forEach((templateId, orgs) -> {
            if (!orgs.isEmpty()) {
                Object[] templateInfo = this.templateMap.get(templateId);
                for (Long orgId : orgs) {
                    int row = this.getModel().createNewEntryRow("entryentity");
                    this.getModel().setValue("template", (Object)(templateInfo[1] + "|" + templateInfo[2]), row);
                    this.getModel().setValue("tempcatalog", templateInfo[3], row);
                    IDNumberTreeNode merge = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
                    this.getModel().setValue("entity", (Object)(merge.getNumber() + "|" + merge.getName()), row);
                    if (((Boolean)templateInfo[4]).booleanValue()) {
                        String datarange = AdjustTemplateHelper.getAssignTemplateOrgDataRange((Long)modelId, (Long)merge.getId(), (Long)((Long)templateInfo[0])).stream().map(e -> {
                            IDNumberTreeNode org = MemberReader.findEntityMemberById((Long)modelId, (Long)e);
                            return org.getNumber() + "|" + org.getName();
                        }).collect(Collectors.joining(";"));
                        this.getModel().setValue("orgscope", (Object)datarange, row);
                        continue;
                    }
                    this.getModel().setValue("orgscope", (Object)(merge.getNumber() + "|" + merge.getName()), row);
                }
            }
        });
    }

    private Map<Long, Set<Long>> getAssignTempId2OrgId(String entityType) {
        Object[] ids = (Object[])SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("ids")), Object[].class);
        String orderBys = "template";
        DynamicObjectCollection assignTempList = this.queryCollectionByParams(entityType, ids, this.assignTemplateField, orderBys);
        this.templateMap = assignTempList.stream().collect(Collectors.toMap(k -> k.getLong("template"), v -> {
            String processNumber = BusinessTypeEnum.searchByName((String)v.getString("template.bussnesstype")).getProcessNumber();
            return new Object[]{v.getLong("template.id"), v.getString("template.number"), v.getString("template.name"), v.getString("template.templatecatalog.name"), OrgRelaProcessMembPool.isRelaProcess((String)processNumber)};
        }, (k1, k2) -> k1));
        return this.resolveOrgRange(assignTempList);
    }

    private Map<Long, Set<Long>> getExceptTempId2OrgId(Set<Long> templateIds) {
        String selectFields = "template,template.name,template.number,template.templatecatalog.name,entity,range,propertyvalue.id,propertyvalue.number";
        QFilter qFilter = new QFilter("template", "in", templateIds);
        qFilter.and("isexcept", "=", (Object)"1");
        DynamicObjectCollection assignTemplateList = QueryServiceHelper.query((String)"bcm_templateassignrecord", (String)selectFields, (QFilter[])qFilter.toArray(), (String)"template");
        return this.resolveOrgRange(assignTemplateList);
    }

    private Map<Long, Set<Long>> resolveOrgRange(DynamicObjectCollection assignTemplateList) {
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam("modelid");
        HashMap<Long, Set<Long>> template2OrgIdMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject dy : assignTemplateList) {
            Set orgSet = template2OrgIdMap.computeIfAbsent(dy.getLong("template"), k -> new HashSet(16));
            if (dy.getLong("entity") == 0L || dy.getLong("propertyvalue.id") != 0L) {
                orgSet.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange((String)"bcm_entitymembertree", (Long)dy.getLong("propertyvalue.id"), (String)dy.getString("propertyvalue.number"), (int)dy.getInt("range"), (String)modelid, (DetailTypeEnum)DetailTypeEnum.TEMPLATEDIS));
                continue;
            }
            orgSet.addAll(QueryMemberDetailsHelper.queryMemberIdsByRange((String)"bcm_entitymembertree", (Long)dy.getLong("entity"), (int)dy.getInt("range"), (String)modelid, (DetailTypeEnum)DetailTypeEnum.TEMPLATEDIS));
        }
        for (Map.Entry kv : template2OrgIdMap.entrySet()) {
            template2OrgIdMap.put((Long)kv.getKey(), QueryMemberDetailsHelper.change2BaseMember((Set)((Set)kv.getValue())));
        }
        return template2OrgIdMap;
    }

    private DynamicObjectCollection queryCollectionByParams(String entitytype, Object[] ids, String selectFields, String orderBys) {
        QFilter filter = new QFilter("id", "in", (Object)ConvertUtil.convertArrayToLong((Object[])ids));
        return QueryServiceHelper.query((String)entitytype, (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)orderBys);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "temororgcombo": {
                this.showDetailBilllistrap();
                break;
            }
        }
    }

    private void setEntityVisibleByCombo() {
        String value = String.valueOf(this.getModel().getValue("temororgcombo"));
        EntryGridUtils.changeCols(this.getView(), "entryentity", beans -> {
            if ("1".equals(value)) {
                this.moveItem((List<GridConfigurationRow>)beans, "template");
            } else {
                this.moveItem((List<GridConfigurationRow>)beans, "entity");
            }
        });
    }

    private void moveItem(List<GridConfigurationRow> beans, String key) {
        Optional<GridConfigurationRow> first = beans.stream().filter(e -> e.getFieldKey().equals(key)).findFirst();
        if (first.isPresent()) {
            beans.remove(first.get());
            beans.add(0, first.get());
        }
    }
}

