/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.template;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.model.AdjustTemplateModel;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseBasicPlugIn;

public class AdjustTemplateEditPlugin
extends AbstractBaseBasicPlugIn
implements BeforeF7SelectListener {
    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(Lists.newArrayList((Object[])new String[]{"ownerorg"}), SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm"});
        BasedataEdit permissionClass = (BasedataEdit)this.getControl("permclass");
        if (permissionClass != null) {
            PermClassEntityHelper.setPermClassFilter((BasedataEdit)permissionClass, (Object)this.getModelId());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String model = (String)this.getFormCustomParam("model");
        if (StringUtils.isNotEmpty((String)model)) {
            this.setOldValue(model);
        } else {
            String bussnesstype = (String)this.getFormCustomParam("bussnesstype");
            String balancetype = (String)this.getFormCustomParam("balancetype");
            this.getModel().setValue("bussnesstype", (Object)bussnesstype);
            this.getModel().setValue("balancetype", (Object)(balancetype == null ? "1" : balancetype));
        }
        this.getModel().setValue("model", (Object)this.getModelId());
    }

    private void setOldValue(String modelString) {
        AdjustTemplateModel model = (AdjustTemplateModel)ObjectSerialUtil.deSerializedBytes((String)modelString);
        this.getPageCache().put("oldnumber", model.getNumber());
        this.getModel().setValue("number", (Object)model.getNumber());
        this.getModel().setValue("name", (Object)model.getName());
        this.getModel().setValue("journaltype", (Object)model.getJournaltype());
        this.getModel().setValue("bussnesstype", (Object)model.getBussnesstype());
        this.getModel().setValue("description", (Object)model.getDescription());
        this.getModel().setValue("balancetype", (Object)model.getBussnesstype());
        this.getModel().setValue("permclass", (Object)model.getPermClass());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_confirm".equals(key)) {
            if (this.checkNumber()) {
                return;
            }
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_adjusttemplate");
            List<String> fileds = Arrays.asList("model", "number", "name", "journaltype", "bussnesstype", "balancetype", "description", "status", "permclass");
            for (String filed : fileds) {
                obj.set(filed, this.getModel().getValue(filed));
            }
            this.getView().returnDataToParent((Object)obj);
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private boolean checkNumber() {
        String oldnumber = this.getPageCache().get("oldnumber");
        String number = this.getModel().getValue("number").toString();
        if (number.equals(oldnumber)) {
            return false;
        }
        if (!BCMNumberRule.checkNumber((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"RptAdjustBasicInfoPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        boolean exit = QueryServiceHelper.exists((String)"bcm_adjusttemplate", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("number", "=", (Object)number)});
        if (exit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AdjustTemplateEditPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return exit;
    }
}

