/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.template;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.module.OrgTreePlugin;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.util.AdjustTemplateModelUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class AdjustTemplateList
extends AbstractBaseListPlugin
implements MainPage,
TreeNodeClickListener,
HyperLinkClickListener {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(AdjustTemplateList.class);
    private static final String orgidcache = "orgidcache";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList bl = (BillList)this.getControl("billlistap");
        bl.addHyperClickListener((HyperLinkClickListener)this);
        bl.addSetFilterListener(this::setFilter);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        String modelId;
        super.afterCreateNewData(e);
        if (this.getView().getFormShowParameter().getCustomParam("model") != null && this.getView().getFormShowParameter().getCustomParam("cslscheme") != null && BcmFunPermissionHelper.isHasModelFuncPermToPage((long)((Long)this.getView().getFormShowParameter().getCustomParam("model")), (String)this.getView().getEntityId())) {
            modelId = this.getView().getFormShowParameter().getCustomParam("model").toString();
            this.getModel().setValue("cslscheme", this.getView().getFormShowParameter().getCustomParam("cslscheme"));
        } else {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model");
        }
        if (StringUtils.isNotEmpty((String)modelId) && !modelId.equals("0")) {
            this.getModel().setValue("model", (Object)modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId);
            this.initCslschemeValue(modelId, false);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("splitpanelap");
            formShowParameter.setFormId("bcm_orgtree");
            formShowParameter.setPageId(this.getPageIdAndCache(this.getPageCache(), "bcm_orgtree"));
            formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
            formShowParameter.setCustomParam("allsubordinate", (Object)"hide");
            DynamicObject obj = (DynamicObject)this.getModel().getValue("cslscheme");
            OrgTreePlugin.setOrgModuleFilterParam(formShowParameter, obj.getLong("id"), null, null);
            this.addListener(this.getPageCache(), formShowParameter.getPageId(), "treeview_org", "treeNodeClick");
            this.addListener(this.getPageCache(), formShowParameter.getPageId(), "allsubordinate", "propertyChanged");
            this.getView().showForm(formShowParameter);
            this.refreshBillList();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u4f53\u7cfb\u3002", (String)"AdjustTemplateList_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        BillList bl = (BillList)this.getControl("billlistap");
        switch (key) {
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
            case "btn_delete": {
                if (bl.getSelectedRows().isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"AdjustTemplateList_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"AdjustTemplateList_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callbackid_del_confirm", (IFormPlugin)this));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String key = messageBoxClosedEvent.getCallBackId();
        if ("callbackid_del_confirm".equals(key) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.deleteSelectRows();
        }
    }

    private void deleteSelectRows() {
        BillList bl = (BillList)this.getControl("billlistap");
        ArrayList ids = new ArrayList(10);
        bl.getSelectedRows().forEach(e -> ids.add(e.getPrimaryKeyValue()));
        try (TXHandle tx = TX.required((String)"bcm_adjusttemplate_save");){
            try {
                QFilter qf = new QFilter("id", "in", ids);
                DynamicObjectCollection templateColl = QueryServiceHelper.query((String)"bcm_adjusttemplate", (String)"number,name", (QFilter[])qf.toArray());
                DeleteServiceHelper.delete((String)"bcm_adjusttemplate", (QFilter[])qf.toArray());
                DeleteServiceHelper.delete((String)"bcm_adjusttemplatedata", (QFilter[])new QFilter("adjusttmpid", "in", ids).toArray());
                this.getView().showSuccessNotification(OpItemEnum.DELETE.getName() + ResultStatusEnum.SUCCESS.getName());
                for (DynamicObject tpl : templateColl) {
                    String number = tpl.getString("number");
                    String name = tpl.getString("name");
                    OpNameMultiLangEnumBridge opName = OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.DELETE.getMultiLangEnumBridge(), (String)OpItemEnum.DELETE.getCode());
                    OPDescMultiLangEnumBridge opdesc = new OPDescMultiLangEnumBridge("%1$s %2$s\uff0c%3$s", "AdjustTemplateList_14", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{number, name, OpItemEnum.DELETE.getName() + ResultStatusEnum.SUCCESS.getName()}));
                    this.writeMultiLangLog(opName, opdesc);
                }
            }
            catch (Throwable e2) {
                tx.markRollback();
                throw e2;
            }
        }
        this.refreshBillList();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionid = closedCallBackEvent.getActionId();
        if (!"addnew".equals(actionid) && "refresh".equals(actionid)) {
            this.refreshBillList();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        evt.getSource();
        this.getPageCache().put(orgidcache, evt.getNodeId().toString());
        this.refreshBillList();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "model": {
                String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
                if (modelId == null) {
                    this.getModel().setValue("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
                    break;
                }
                if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                this.getPageCache().put("KEY_MODEL_ID", modelId);
                this.refreshBillList();
                this.initCslschemeValue(modelId, true);
                String cslid = UserSelectUtil.getF7SelectId(this.getView(), "cslscheme");
                this.refreshTree(Long.parseLong(modelId), cslid == null ? null : Long.valueOf(Long.parseLong(cslid)));
                break;
            }
            case "cslscheme": {
                this.saveUserChangedCslscheme((DynamicObject)e.getChangeSet()[0].getNewValue());
                String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
                if (modelId == null) break;
                if (e.getChangeSet()[0].getNewValue() == null) {
                    this.refreshTree(Long.parseLong(modelId), null);
                    break;
                }
                String csl = UserSelectUtil.getF7SelectId(this.getView(), "cslscheme");
                this.refreshTree(Long.parseLong(modelId), csl == null ? null : Long.valueOf(Long.parseLong(csl)));
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        BillList bl = (BillList)hyperLinkClickEvent.getSource();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)bl.getFocusRowPkId(), (String)"bcm_adjusttemplate");
        Object number = obj.get("number");
        Object name = obj.get("name");
        try {
            this.openEditPage(obj);
            this.writeMultiLangLog(OpItemEnum.LOOKUP.getOpMultiLangEnumBridge(), new OPDescMultiLangEnumBridge("%1$s %2$s \u67e5\u770b\u6210\u529f\u3002", "AdjustTemplateList_15", "fi-bcm-formplugin", new String[]{number + "", name + ""}));
        }
        catch (Exception e) {
            this.writeMultiLangLog(OpItemEnum.LOOKUP.getOpMultiLangEnumBridge(), new OPDescMultiLangEnumBridge("%1$s %2$s \u67e5\u770b\u5931\u8d25\u3002", "AdjustTemplateList_16", "fi-bcm-formplugin", new String[]{number + "", name + ""}));
            logger.error((Throwable)e);
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(this.getFilter());
    }

    private void openEditPage(DynamicObject obj) {
        AdjustTemplateModelUtil.setDefaultCommonAndSpreadDim(obj, this.getModelId());
        FormShowParameter fs = new FormShowParameter();
        fs.setFormId("bcm_adjustoffset_common");
        fs.setCustomParam("adjusttmp_model", (Object)ObjectSerialUtil.toSerializedToDynaObj((DynamicObject)obj));
        fs.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        fs.setCustomParam("model", (Object)this.getModelId());
        fs.setCustomParam("maxgroup", (Object)0);
        fs.setCustomParam("entrysheet", (Object)obj.getString("data"));
        fs.setCustomParam("adjust_model", (Object)obj.getString("spreadjson"));
        fs.setCaption(String.format(ResManager.loadKDString((String)"\u7f16\u8f91\u5e38\u7528\u5206\u5f55%s", (String)"AdjustTemplateList_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), obj.getString("name")));
        fs.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
        fs.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(fs);
    }

    private void refreshBillList() {
        BillList bl = (BillList)this.getControl("billlistap");
        bl.getFilterParameter().setFilter(this.getFilter());
        bl.clearSelection();
        bl.refresh();
    }

    public QFilter getFilter() {
        QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
        if (!PermissionServiceImpl.getInstance((Long)this.getModelId()).isAdmin()) {
            qf.and("id", "not in", (Object)PermClassEntityHelper.getPermissionMapBatch((String)"bcm_adjusttemplate", (String)(this.getModelId() + ""), (String)(this.getUserId() + "")).get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()));
        }
        return qf;
    }

    public void refreshTree(Long modelId, Long cslid) {
        OrgTreePlugin.refreshTree(this, this.getView(), modelId, cslid, null, null);
    }
}

