/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.reportlist.cache.ReportRedisCache;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.business.tree.report.TemplateTreeNode;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.adjust.model.ITreePage;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.util.ReportListUtil;
import kd.fi.bcm.formplugin.util.SearchUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class AdjustTemplateTreeBottomPlugin
extends AbstractBaseFormPlugin
implements TreeNodeClickListener,
ITreePage,
TabSelectListener {
    private AdjustOperationContext ctx;

    @Override
    public void afterCreateNewData(EventObject e) {
        if (Boolean.TRUE.equals(this.getFormCustomParam("viewType"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"myorg_tree"});
        }
        super.afterCreateNewData(e);
        this.setDeaultValue();
        this.buildOrgLeftTree();
        this.activeTreeTab("myreport_tree");
        this.buildTemplateLeftTree();
    }

    private void setDeaultValue() {
        this.getModel().setValue("cslscheme", (Object)this.getCommonParam("cslscheme"));
        this.getModel().setValue("scenario", (Object)this.getCommonParam("scenarioId"));
        this.getModel().setValue("year", (Object)this.getCommonParam("yearId"));
        this.getModel().setValue("period", (Object)this.getCommonParam("perioId"));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((TreeView)this.getControl("treeview_entity")).addTreeNodeClickListener((TreeNodeClickListener)this);
        ((TreeView)this.getControl("treeview_template")).addTreeNodeClickListener((TreeNodeClickListener)this);
        ((Tab)this.getControl("tabap")).addItemClickListener((ItemClickListener)this);
        ((Tab)this.getControl("tabap")).addTabSelectListener((TabSelectListener)this);
        ((Search)this.getControl("entitysearchap")).addEnterListener(evt -> SearchUtil.searchMember(evt.getText(), this.getView(), this.getPageCache(), (TreeView)this.getControl("treeview_template"), "myreport_tree"));
        ((Search)this.getControl("entitysearchap1")).addEnterListener(evt -> SearchUtil.searchMember(evt.getText(), this.getView(), this.getPageCache(), (TreeView)this.getControl("treeview_entity"), "myorg_tree"));
        this.addClickListeners("searchbefore", "searchnext", "searchbefore1", "searchnext1");
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "searchbefore": 
            case "searchnext": {
                SearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), key, (TreeView)this.getControl("treeview_template"), new String[]{"searchbefore", "searchnext"}, "myreport_tree");
                break;
            }
            case "searchbefore1": 
            case "searchnext1": {
                SearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), key, (TreeView)this.getControl("treeview_entity"), new String[]{"searchbefore1", "searchnext1"}, "myorg_tree");
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        if (evt.getSource() instanceof TreeView) {
            switch (this.getActiveTreeTabKey()) {
                case "myreport_tree": {
                    this.templateTreeNodeClick(evt);
                    break;
                }
                default: {
                    this.orgTreeNodeClick(evt);
                }
            }
        }
    }

    @Override
    public void templateTreeNodeClick(TreeNodeEvent e) {
        CommandParam com = new CommandParam("bcm_adjusttree_bottom", null, "templateTreeNodeClick", e);
        com.setReFlect(true);
        this.sendMsg(this.getView(), com);
        this.setSelectTmpId((String)e.getNodeId());
    }

    @Override
    public void orgTreeNodeClick(TreeNodeEvent e) {
        CommandParam com = new CommandParam("bcm_adjusttree_bottom", null, "orgTreeNodeClick", e);
        com.setReFlect(true);
        this.sendMsg(this.getView(), com);
        this.setSelectOrgId((String)e.getNodeId());
    }

    @Override
    public void templateTreeNodeCheck(Long templateId) {
        TreeModel treeModel = this.getTreeModel(this.getView(), "cache_treetemplate");
        ITreeNode tempNode = treeModel.searchByNodeId(String.valueOf(templateId));
        ((TreeView)this.getControl("treeview_template")).focusNode(new TreeNode(tempNode.getParent().getId(), tempNode.getId(), ""));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("showorgtype".equals(key)) {
            this.refreshTree();
        } else {
            super.propertyChanged(e);
        }
    }

    private void refreshTree() {
        switch (this.getActiveTreeTabKey()) {
            case "myreport_tree": {
                this.buildTemplateLeftTree();
                break;
            }
            default: {
                this.buildOrgLeftTree();
            }
        }
    }

    private void buildOrgLeftTree() {
        IDNumberTreeNode selectOrg = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)this.getCommonParam("selectOrgId"));
        String showType = (String)this.getModel().getValue("showorgtype");
        OrgTreeNode bigRoot = this.initOrgTree(this.getModelId(), showType, false, true);
        AbstractTreeNode smallRoot = null;
        if (bigRoot != null && (smallRoot = (AbstractTreeNode)bigRoot.getTreeNode(selectOrg.getId().toString(), 100)) == null) {
            ArrayList<IDNumberTreeNode> orgList = new ArrayList<IDNumberTreeNode>(selectOrg.getBaseTreeNode().getShareNodes());
            orgList.add(selectOrg.getBaseTreeNode());
            Optional<AbstractTreeNode> op = orgList.stream().filter(orgNode -> !Objects.equals(orgNode.getId(), selectOrg.getId()) && Objects.equals(orgNode.getProperty("cslscheme.number"), selectOrg.getProperty("cslscheme.number"))).map(arg_0 -> AdjustTemplateTreeBottomPlugin.lambda$buildOrgLeftTree$3((AbstractTreeNode)bigRoot, arg_0)).filter(Objects::nonNull).findAny();
            if (op.isPresent()) {
                smallRoot = op.get();
            }
        }
        if (smallRoot == null) {
            ((TreeView)this.getControl("treeview_entity")).deleteAllNodes();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u7528\u7ec4\u7ec7\u3002", (String)"AdjustTemplateTreeBottomPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            if (this.getFormCustomParam("isRADJ", false).booleanValue()) {
                smallRoot.removeAll();
            }
            this.initTree((AbstractTreeNode<Object>)smallRoot);
        }
    }

    @Override
    public CslSchemeServiceHelper.QueryOrgParam buildQueryOrgParam(long modelId, QFBuilder builder) {
        CslSchemeServiceHelper.QueryOrgParam param = super.buildQueryOrgParam(modelId, builder);
        param.setNeedSchemeModelFilter(false);
        param.setNeedSchemeFilter(false);
        return param;
    }

    @Override
    public boolean isIgnoreOrgPermFilter() {
        return OrgRelaProcessMembPool.isRelaProcess((String)this.getBusinessTypeEnum().getProcessNumber());
    }

    private void buildTemplateLeftTree() {
        QFBuilder calBuilder = new QFBuilder("model", "=", (Object)this.getCtx().getModelId());
        calBuilder.add(new QFilter("catalogtype", "=", (Object)Character.valueOf(TemplateCatalogTypeEnum.TEMPLATECATALOG.getType())).or("number", "=", (Object)"root"));
        if (!StringUtil.equals((String)"true", (String)this.getPageCache().get("isroot"))) {
            calBuilder.and("id", "not in", (Object)PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)DataTypeEnum.NO.getIndex()));
        }
        DynamicObjectCollection doc = ReportListUtil.getCollection("bcm_templatecatalog", calBuilder.toArray(), "sequence");
        QFBuilder tmpBuilder = new QFBuilder();
        tmpBuilder.add("model", "=", (Object)this.getCtx().getModelId());
        tmpBuilder.add("usage", "=", (Object)"1");
        tmpBuilder.add("status", "=", (Object)"1");
        tmpBuilder.add("templatetype", "not in", (Object)new String[]{Integer.toString(TemplateTypeEnum.MSN.getType()), Integer.toString(TemplateTypeEnum.OTHERWP.getType()), Integer.toString(TemplateTypeEnum.DYNAMICREPORT.getType())});
        tmpBuilder.add("issavebydim", "=", (Object)"1");
        if (!MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()))) {
            tmpBuilder.add("id", "not in", (Object)PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)String.valueOf(this.getModelId()), (String)String.valueOf(this.getUserId())).get((Object)"1"));
        }
        Long scenarioId = this.getCommonParam("scenarioId");
        Long yearId = this.getCommonParam("yearId");
        Long perioId = this.getCommonParam("perioId");
        Set tmplPkids = QueryServiceHelper.queryPrimaryKeys((String)"bcm_templateentity", (QFilter[])tmpBuilder.toArray(), null, (int)-1).stream().map(LongUtil::toLong).collect(Collectors.toSet());
        if (yearId != 0L && perioId != 0L) {
            tmplPkids.retainAll(TemplateUtil.getRightTplIdByVersioned((Long)this.getModelId(), (Long)yearId, (Long)perioId, tmplPkids).values());
        }
        if (scenarioId != 0L) {
            List templateModelList = ReportRedisCache.queryTemplateModelFromCache(tmplPkids, (long)this.getModelId(), (boolean)false);
            templateModelList.forEach(p -> {
                if (!TemplateRangeService.isInnerRange((String)"bcm_scenemembertree", (TemplateModel)p, (Object)scenarioId)) {
                    tmplPkids.remove(p.getId());
                }
            });
        }
        tmpBuilder.clear();
        tmpBuilder.add("id", "in", tmplPkids);
        TemplateTreeNode root = new TemplateTreeNode("0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"AdjustTemplateTreeBottomPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        root = TreeBuilder.getTemplateTreeNew((DynamicObjectCollection)doc, (TemplateTreeNode)root, () -> ((QFBuilder)tmpBuilder).toArray(), (String)"2", null);
        root.SetIsOpened(true);
        root.setId("0");
        this.initTree((AbstractTreeNode<Object>)root);
    }

    private void initTree(AbstractTreeNode<Object> root) {
        String currentTab = this.getActiveTreeTabKey();
        if (root != null) {
            if (root.getChildren() == null) {
                return;
            }
            TreeModel treemodel = new TreeModel(root);
            TreeNode selectNode = this.findCacheNode(root);
            TreeNode rootTreeNode = null;
            if ("myorg_tree".equals(currentTab)) {
                TreeView treeView = (TreeView)this.getControl("treeview_entity");
                rootTreeNode = treemodel.buildEntryTree(treeView);
                treeView.focusNode(selectNode);
                this.expandAllSelected((TreeModel<AbstractTreeNode<Object>>)treemodel, treeView);
                treemodel.ache2page(this.getPageCache(), "cache_treeentity");
                this.orgTreeNodeClick(new TreeNodeEvent(new Object(), (Object)selectNode.getParentid(), (Object)selectNode.getId()));
                if (OrgRelaProcessMembPool.isRelaProcess((String)this.getBusinessTypeEnum().getProcessNumber())) {
                    ((TreeView)this.getControl("treeview_entity")).setRootVisible(false);
                }
            } else if ("myreport_tree".equals(currentTab)) {
                TreeView treeView = (TreeView)this.getControl("treeview_template");
                rootTreeNode = treemodel.buildEntryTree(treeView);
                treeView.focusNode(selectNode);
                this.setSelectTmpId(selectNode.getId());
                treemodel.ache2page(this.getPageCache(), "cache_treetemplate");
            }
            this.getPageCache().put(currentTab, SerializationUtils.toJsonString((Object)rootTreeNode));
        }
    }

    private TreeNode findCacheNode(AbstractTreeNode<Object> root) {
        String currentTab = this.getActiveTreeTabKey();
        String selectnode = null;
        if ("myorg_tree".equals(currentTab)) {
            List<String> selectOrgPath = this.getSelectOrgPath();
            if (selectOrgPath.isEmpty()) {
                if (OrgRelaProcessMembPool.isRelaProcess((String)this.getBusinessTypeEnum().getProcessNumber())) {
                    selectnode = CollectionUtils.isEmpty((Collection)root.getChildren()) ? null : ((ITreeNode)root.getChildren().get(0)).getId();
                } else {
                    Long adjustId = LongUtil.toLong((Object)this.getCommonParam("id"));
                    if (adjustId == 0L) {
                        selectnode = (String)this.getFormCustomParam("selectedNodeId");
                    } else {
                        try (DataSet ds = AdjustQueryServiceHelper.queryAdjustEntryDataSet(Collections.singleton("entity"), (QFBuilder)new QFBuilder("adjust", "=", (Object)adjustId), null, (int)1);){
                            if (ds.hasNext()) {
                                selectnode = ds.next().getString("entity");
                            }
                        }
                    }
                    if (root.getTreeNode(selectnode, 10) == null) {
                        selectnode = root.getId();
                    }
                }
            } else {
                selectnode = selectOrgPath.get(selectOrgPath.size() - 1);
            }
        } else if ("myreport_tree".equals(currentTab)) {
            selectnode = this.getSelectTmpId() == null ? null : this.getSelectTmpId();
        }
        ITreeNode node = root.getTreeNode(selectnode, 999);
        if (node == null) {
            return new TreeNode("0", "0", "");
        }
        return new TreeNode(node.getParent() == null ? "0" : node.getParent().getId(), node.getId(), "");
    }

    private void expandAllSelected(TreeModel<AbstractTreeNode<Object>> treemodel, TreeView treeView) {
        List<String> selects = this.getSelectOrgPath();
        OrgTreeNode root = (OrgTreeNode)treemodel.getRoot();
        for (String nodeid : selects) {
            OrgTreeNode node = (OrgTreeNode)treemodel.searchByNodeId(nodeid);
            if (node == null || node.getId() == null || node.getId().equals(root.getId())) continue;
            String parentid = node.getParent().getId();
            while (!parentid.equals(root.getId())) {
                treeView.expand(parentid);
                node = (OrgTreeNode)node.getParent();
                parentid = node.getParent().getId();
            }
        }
    }

    private QFBuilder getOrgQfBuilder() {
        QFBuilder qfBuilder = new QFBuilder("isexchangerate", "=", (Object)"0");
        if (BusinessTypeEnum.ADJUSTSELFLEVEL == this.getBusinessTypeEnum() || BusinessTypeEnum.OFFSETSELFLEVEL == this.getBusinessTypeEnum()) {
            qfBuilder.add("isleaf", "=", (Object)"0");
        }
        return qfBuilder;
    }

    private BusinessTypeEnum getBusinessTypeEnum() {
        return BusinessTypeEnum.searchByName((String)((String)this.getView().getFormShowParameter().getCustomParam("bussinessType")));
    }

    public AdjustOperationContext getCtx() {
        if (this.ctx == null) {
            this.ctx = new AdjustOperationContext(this.getModelId(), this.getCommonParam("scenarioId").longValue(), this.getCommonParam("yearId").longValue(), this.getCommonParam("perioId").longValue());
        }
        return this.ctx;
    }

    private Long getCommonParam(String param) {
        if (this.getView().getFormShowParameter().getCustomParam(param) == null || "0".equals(this.getView().getFormShowParameter().getCustomParam(param).toString())) {
            return 0L;
        }
        return Long.parseLong(this.getView().getFormShowParameter().getCustomParam(param).toString());
    }

    @Override
    public void setSelectTmpId(String selectTmpId) {
        this.getPageCache().put("templateselectedNodeId", selectTmpId);
        CommandParam com = new CommandParam("bcm_adjusttree_bottom", null, "setSelectTmpId", selectTmpId);
        com.setReFlect(true);
        this.sendMsg(this.getView(), com);
    }

    @Override
    public String getSelectTmpId() {
        return this.getPageCache().get("templateselectedNodeId");
    }

    @Override
    public String getSelectOrgId() {
        return this.getPageCache().get("selectOrgId");
    }

    @Override
    public void setSelectOrgId(String selectOrgId) {
        List<String> selectnodes = this.getSelectOrgPath();
        selectnodes.remove(selectOrgId);
        selectnodes.add(selectOrgId);
        this.getPageCache().put("selectOrgPathStr", ObjectSerialUtil.toByteSerialized(selectnodes));
        this.getPageCache().put("selectOrgId", selectOrgId);
        CommandParam com = new CommandParam("bcm_adjusttree_bottom", null, "setSelectOrgId", selectOrgId);
        com.setReFlect(true);
        this.sendMsg(this.getView(), com);
    }

    public List<String> getSelectOrgPath() {
        String selectOrgStr = this.getPageCache().get("selectOrgPathStr");
        return selectOrgStr == null ? new ArrayList(5) : (List)ObjectSerialUtil.deSerializedBytes((String)selectOrgStr);
    }

    public void tabSelected(TabSelectEvent e) {
        this.setActiveTreeTab(e.getTabKey());
    }

    @Override
    public String getActiveTreeTabKey() {
        String tabKey = this.getPageCache().get("tabSelected");
        return StringUtils.isEmpty((CharSequence)tabKey) ? "myorg_tree" : tabKey;
    }

    @Override
    public void activeTreeTab(String tabKey) {
        ((Tab)this.getControl("tabap")).activeTab("myreport_tree");
        this.setActiveTreeTab(tabKey);
    }

    private void setActiveTreeTab(String tabKey) {
        this.getPageCache().put("tabSelected", tabKey);
    }

    @Override
    public String getSender() {
        return this.getView().getFormShowParameter().getFormId();
    }

    private static /* synthetic */ AbstractTreeNode lambda$buildOrgLeftTree$3(AbstractTreeNode bigRoot, IDNumberTreeNode orgNode) {
        return (AbstractTreeNode)bigRoot.getTreeNode(orgNode.getId().toString(), 999);
    }
}

