/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.adjust.websocket;

import com.google.common.collect.Lists;
import java.util.Collection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.business.websocket.BcmWebSocketCommand;
import kd.fi.bcm.business.websocket.BcmWebSocketManger;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;

public class AdjustWebSocketCommandProcessor {
    private static final Log logger = LogFactory.getLog(AdjustWebSocketCommandProcessor.class);

    public static void sendCommandParam(String wsMsgType, String applymenu, String receiverPageId, String userSpceKey, Object ... commandParams) {
        try {
            BcmWebSocketCommand webSocketOrder = AdjustWebSocketCommandProcessor.createBcmWebSocketCommand(wsMsgType, applymenu, receiverPageId, userSpceKey, commandParams);
            AdjustWebSocketCommandProcessor.dealProducerWSOrder(webSocketOrder);
            BcmWebSocketManger.sendMsg((BcmWebSocketCommand)webSocketOrder);
        }
        catch (Throwable t) {
            logger.error(t);
            throw t;
        }
    }

    public static BcmWebSocketCommand createBcmWebSocketCommand(String wsMsgType, String applymenu, String receiverPageId, String userSpceKey, Object ... commandParams) {
        BcmWebSocketCommand webSocketOrder = new BcmWebSocketCommand(wsMsgType);
        webSocketOrder.getConsumer().setApplymenu(applymenu);
        webSocketOrder.getConsumer().setPageId(receiverPageId);
        webSocketOrder.getConsumer().setServiceName("AdjustWSMsgProcessService");
        webSocketOrder.getConsumer().setMethod("dealMsg");
        webSocketOrder.getConsumer().setUserSpceKey(userSpceKey);
        for (Object command : commandParams) {
            webSocketOrder.addCommandTag(command);
        }
        return webSocketOrder;
    }

    public static void dealProducerWSOrder(BcmWebSocketCommand bcmWebSocketOrder) {
        String identifytype = BcmWebSocketManger.buildWSIdentifytype((String)bcmWebSocketOrder.getWsMsgType(), (String)bcmWebSocketOrder.getConsumer().getAccountId(), (String)bcmWebSocketOrder.getConsumer().getTenantId(), (String)bcmWebSocketOrder.getConsumer().getReceiver(), (String)bcmWebSocketOrder.getConsumer().getUserSpceKey());
        bcmWebSocketOrder.setIdentifyType(identifytype);
        for (Object command : bcmWebSocketOrder.getCommandList()) {
            if (!(command instanceof CommandParam)) continue;
            AdjustWebSocketCommandProcessor.dealProducerWSCommandParam(bcmWebSocketOrder, (CommandParam)command);
        }
    }

    private static void dealProducerWSCommandParam(BcmWebSocketCommand webSocketOrder, CommandParam command) {
        if ("bcm_adjustoffset_entry".equals(webSocketOrder.getConsumer().getApplymenu())) {
            switch (command.getOperation()) {
                case "returnEntry": {
                    BcmWebSocketManger.setParam((String)webSocketOrder.getPkId(), (String)"returnEntry", (String)ObjectSerialUtil.toByteSerialized(command.getParam()), (int)60);
                    command.setParam(Lists.newArrayList());
                    break;
                }
            }
        }
    }

    public static void dealConsumerWSOrder(BcmWebSocketCommand webSocketOrder) {
        for (Object command : webSocketOrder.getCommandList()) {
            if (!(command instanceof CommandParam)) continue;
            AdjustWebSocketCommandProcessor.dealConsumerWSCommandParam(webSocketOrder, (CommandParam)command);
        }
    }

    private static void dealConsumerWSCommandParam(BcmWebSocketCommand webSocketOrder, CommandParam command) {
        if ("bcm_adjustoffset_entry".equals(webSocketOrder.getConsumer().getApplymenu())) {
            switch (command.getOperation()) {
                case "returnEntry": {
                    String entryCache = BcmWebSocketManger.getParam((String)webSocketOrder.getPkId(), (String)"returnEntry");
                    if (!StringUtils.isNotEmpty((CharSequence)entryCache)) break;
                    command.getParam().addAll((Collection)ObjectSerialUtil.deSerializedBytes((String)entryCache));
                    break;
                }
            }
        }
    }
}

