/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.PageBasicInfo;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.util.DragUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.json.JSONObject;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;

public class AnalysisDetailMemberMovePlugin
extends AbstractBaseListPlugin
implements DynamicPage {
    private static String PANEL = "datapanel";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok", "btncancel");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        List memberList = (List)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("entry")), List.class);
        this.getModel().setValue("name", (Object)ResManager.loadKDString((String)"\u5e8f\u53f7 | \u6210\u5458\u7f16\u7801 | \u6210\u5458\u540d\u79f0", (String)"AnalysisDetailMemberMovePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        List<Pair<String, String>> memberPair = memberList.stream().map(v -> (Pair)JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)v), Pair.class)).collect(Collectors.toList());
        this.bindEntry(memberPair);
    }

    private void bindEntry(List<Pair<String, String>> adjustStatus) {
        this.getModel().beginInit();
        if (adjustStatus.size() > 0) {
            int curIndex;
            Page page = new Page();
            Area area = new Area(PANEL);
            String sign = "";
            LocaleString width = new LocaleString("90%");
            Long seq = 0L;
            for (curIndex = 0; curIndex < adjustStatus.size(); ++curIndex) {
                sign = "sign_" + (String)adjustStatus.get((int)curIndex).p1;
                TextEditElement textEditElement = this.createTextEditElement((String)adjustStatus.get((int)curIndex).p2, sign.toLowerCase(), width, 1, seq);
                textEditElement.addUserObject("seq", (Object)(curIndex + 1));
                textEditElement.addUserObject("member_id", adjustStatus.get((int)curIndex).p1);
                textEditElement.addUserObject("member_name", adjustStatus.get((int)curIndex).p2);
                area.addElement((Element)textEditElement);
            }
            page.addArea(area);
            this.setPage(this.getView(), page);
            page.updatePage(this.getView());
            page.setChangeable(true);
            this.setDraggable(page);
            for (curIndex = 0; curIndex < adjustStatus.size(); ++curIndex) {
                String controlSeq = String.valueOf(((Element)area.getElementListList().get(curIndex)).getUserObject("seq"));
                sign = "sign_" + (String)adjustStatus.get((int)curIndex).p1;
                this.setValue(sign, controlSeq + " | " + (String)adjustStatus.get((int)curIndex).p2);
            }
        }
        this.getModel().endInit();
        this.getView().updateView();
    }

    private TextEditElement createTextEditElement(String name, String sign, LocaleString width, int editStyle, long seq) {
        TextEditElement textEditElement = new TextEditElement(name, sign, "");
        textEditElement.setEditStyle(editStyle);
        textEditElement.setWidth(width);
        textEditElement.setFieldStyle(1);
        textEditElement.setShowLabel(false);
        textEditElement.setHeight(new LocaleString("30px"));
        textEditElement.setLabelWidth(new LocaleString("0%"));
        textEditElement.setFieldTextAlign("left");
        textEditElement.setLock("new");
        return textEditElement;
    }

    private void setDraggable(Page page) {
        page.getAreaList().forEach(a -> a.getElementListList().forEach(e -> {
            this.getView().getControl(e.getSign()).setDroppable(true);
            this.getView().getControl(e.getSign()).setDraggable(true);
        }));
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String eventArgs = e.getEventArgs();
            Page page = this.getPage(this.getView());
            boolean rebuildPageState = this.rebuildPage(page, eventArgs);
            if (rebuildPageState) {
                page.updatePage(this.getView());
                this.setPage(this.getView(), page);
                this.setDraggable(page);
            }
        }
    }

    private boolean rebuildPage(Page page, String command) {
        String[] msg = DragUtil.translateMessage((String)command);
        PageBasicInfo target = page.seaechSign(msg[0]);
        Element source = (Element)page.seaechSign(msg[1]);
        String dropSign = source.getSign();
        Area sourceArea = source.getArea();
        Area targetArea = ((Element)target).getArea();
        Element dropElement = source;
        int i = targetArea.getElementListList().indexOf(target);
        targetArea.removeElememt(dropSign);
        sourceArea.removeElememt(dropSign);
        dropElement.setArea(targetArea);
        targetArea.getElementListList().add(i, dropElement);
        int curIndex = 1;
        for (Element element : targetArea.getElementListList()) {
            element.addUserObject("seq", (Object)curIndex);
            String sign = element.getSign();
            String oldValue = String.valueOf(element.getValue(this.getPlugin().getPageCache()));
            String[] oldValueSplit = oldValue.split("\\|", 3);
            String memberName = oldValueSplit[1] + "|" + oldValueSplit[2];
            String newValue = curIndex + " | " + memberName;
            this.setValue(sign, newValue);
            ++curIndex;
        }
        return true;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if (!this.validator()) {
            return;
        }
        Page page = this.getPage(this.getView());
        if (page == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u6570\u636e\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58\u3002", (String)"TemplateListOrderPopupPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            if ("btncancel".equals(key)) {
                this.getView().close();
            }
            return;
        }
        Area area = (Area)page.seaechSign(PANEL);
        if (area == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u6570\u636e\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58\u3002", (String)"TemplateListOrderPopupPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            if ("btncancel".equals(key)) {
                this.getView().close();
            }
            return;
        }
        List elementList = area.getElementListList();
        switch (key) {
            case "btnok": {
                if (elementList.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u6570\u636e\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58\u3002", (String)"TemplateListOrderPopupPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.exitAndReturn(elementList);
                this.getView().close();
                break;
            }
            case "btncancel": {
                if (!this.templateChangedSeq(elementList)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6a21\u677f\u987a\u5e8f\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u662f\u5426\u8fdb\u884c\u4fdd\u5b58\uff1f", (String)"AnalysisDetailMemberMovePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("exit_save", (IFormPlugin)this));
                    break;
                }
                this.getView().close();
                break;
            }
        }
    }

    private void exitAndReturn(List<Element> elementList) {
        ArrayList<Pair> returnData = new ArrayList<Pair>(elementList.size());
        for (int i = 0; i < elementList.size(); ++i) {
            Element obj = elementList.get(i);
            String memberId = obj.getUserObject("member_id").toString();
            String memberName = obj.getUserObject("member_name").toString();
            returnData.add(Pair.onePair((Object)memberId, (Object)memberName));
        }
        this.getView().returnDataToParent(returnData);
    }

    private boolean templateChangedSeq(List<Element> elementList) {
        for (int i = 0; i < elementList.size(); ++i) {
            if (Long.parseLong(elementList.get(i).getUserObject("seq").toString()) == (long)(i + 1)) continue;
            return false;
        }
        return true;
    }
}

