/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.analysishelper.AnalysisPageServiceHelper;
import kd.fi.bcm.spread.common.util.StringUtil;

public class AnalysisHelperAlertSettingPlugin
extends AbstractBaseFormPlugin {
    private static final String ENTRYENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        Button btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
        this.addItemClickListeners("advcontoolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initValueTypeCombolEdit();
        this.initPageData();
    }

    @Override
    public void click(EventObject evt) {
        String opkey;
        switch (opkey = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                if (!this.checkNullEntryRow()) break;
                this.exitAndReturnData();
                break;
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "add": {
                this.addNewEntryData();
                break;
            }
            case "delete": {
                this.deleteEntryRow();
            }
        }
    }

    private void initValueTypeCombolEdit() {
        String analysisType = (String)this.getView().getFormShowParameter().getCustomParam("analysistype");
        ArrayList<ComboItem> fieldData = new ArrayList<ComboItem>(16);
        if (StringUtil.equals((String)"1", (String)analysisType)) {
            ComboItem money = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c", (String)"AnalysisHelperAlertSettingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "money");
            fieldData.add(money);
            ComboItem balance = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5dee\u989d\u9879", (String)"AnalysisHelperAlertSettingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "balance");
            fieldData.add(balance);
            ComboItem varaibleproportion = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5dee\u989d\u6bd4\u4f8b", (String)"AnalysisHelperAlertSettingPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "varaibleproportion");
            fieldData.add(varaibleproportion);
        } else {
            ComboItem proportion = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5360\u6bd4", (String)"AnalysisHelperAlertSettingPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "proportion");
            fieldData.add(proportion);
        }
        ComboEdit valueTypeComboEdit = (ComboEdit)this.getControl("valuetype");
        valueTypeComboEdit.setComboItems(fieldData);
    }

    private void initPageData() {
        String alertValue = (String)this.getView().getFormShowParameter().getCustomParam("alertnum");
        if (!StringUtil.isEmptyString((String)alertValue)) {
            String[] alertValueArr = alertValue.split(";");
            int index = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, alertValueArr.length)[0];
            for (String alertNum : alertValueArr) {
                String alertCondition = "";
                if (alertNum.contains(">")) {
                    alertCondition = ">";
                } else if (alertNum.contains("<")) {
                    alertCondition = "<";
                } else if (alertNum.contains(":")) {
                    alertCondition = ":";
                } else if (alertNum.contains("!")) {
                    alertCondition = "!";
                } else if (alertNum.contains("=")) {
                    alertCondition = "=";
                }
                String[] alertSplit = alertNum.split(alertCondition);
                this.getModel().setValue("valuetype", (Object)alertSplit[0], index);
                this.getModel().setValue("condition", (Object)alertCondition, index);
                this.getModel().setValue("alertvalue", (Object)alertSplit[1], index);
                ++index;
            }
        }
    }

    private void exitAndReturnData() {
        DynamicObjectCollection entryInfo = this.getModel().getEntryEntity(ENTRYENTITY);
        StringBuilder saveResult = new StringBuilder();
        StringBuilder displayResult = new StringBuilder();
        for (DynamicObject entryValue : entryInfo) {
            saveResult.append(entryValue.getString("valuetype"));
            saveResult.append(entryValue.getString("condition"));
            saveResult.append(entryValue.getBigDecimal("alertvalue").stripTrailingZeros().toPlainString());
            saveResult.append(";");
            displayResult.append(AnalysisPageServiceHelper.mapAlertValue(entryValue.getString("valuetype")));
            displayResult.append(AnalysisPageServiceHelper.mapAlertValue(entryValue.getString("condition")));
            displayResult.append(entryValue.getBigDecimal("alertvalue").stripTrailingZeros().toPlainString());
            displayResult.append(' ');
            displayResult.append("; ");
        }
        HashMap returnData = Maps.newHashMapWithExpectedSize((int)2);
        returnData.put("saveResult", saveResult.toString());
        returnData.put("displayResult", displayResult.toString());
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    private void addNewEntryData() {
        this.getModel().createNewEntryRow(ENTRYENTITY);
    }

    private void deleteEntryRow() {
        EntryGrid reportNameEntry = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        if (reportNameEntry.getSelectRows().length != 0) {
            int row = reportNameEntry.getSelectRows()[0];
            this.getModel().deleteEntryRow(ENTRYENTITY, row);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"DiscTemplateEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkNullEntryRow() {
        DynamicObjectCollection entryInfo = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject entryRow : entryInfo) {
            int dseq = entryRow.getInt("seq");
            if (!StringUtil.isEmptyString((String)entryRow.getString("valuetype")) && !StringUtil.isEmptyString((String)entryRow.getString("condition")) && !StringUtil.isEmptyString((String)entryRow.getString("alertvalue"))) continue;
            String msg = ResManager.loadKDString((String)"\u7b2c%d\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\u3002", (String)"DiscTemplateSaveValidator_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(msg, dseq));
            return false;
        }
        return true;
    }
}

