/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ClientActions;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Chart;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.analysishelper.AnalysisPageServiceHelper;
import kd.fi.bcm.formplugin.analysishelper.ai.AHGptServiceHelper;
import kd.fi.bcm.formplugin.analysishelper.ai.GptLicenseUtils;
import kd.fi.bcm.formplugin.analysishelper.chartconfig.AnalysisChartsFactory;
import kd.fi.bcm.formplugin.analysishelper.chartenums.ChartType;
import kd.fi.bcm.formplugin.analysishelper.charts.abstractchart.AnalysisChart;
import kd.fi.bcm.formplugin.analysishelper.datatable.ComparedDataTable;
import kd.fi.bcm.formplugin.analysishelper.datatable.ProportionDataTable;
import kd.fi.bcm.formplugin.analysishelper.enums.ReceiveMessageType;
import kd.fi.bcm.formplugin.analysishelper.utils.CalServiceHelper;
import kd.fi.bcm.formplugin.analysishelper.utils.ChartDataServiceHelper;
import kd.fi.bcm.formplugin.analysishelper.utils.DataTableUtils;
import kd.fi.bcm.formplugin.analysishelper.utils.NumberDecimalUtils;
import kd.fi.bcm.formplugin.analysishelper.utils.SchemeServiceHelper;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class AnalysisHelperPlugin
extends AbstractBaseFormPlugin
implements SubPage {
    private static String MODEL = "model";
    private static String CTL_ANALYSIS_SCHEME = "analysis_scheme";
    private static String CTL_ECHARTS_BOX = "echartsbox";
    private static String CTL_CUSTOMCHARTAP = "customchartap";
    private static final String BTN_COMPARED_GROUP = "btn_compared_group";
    private static final String BTN_SWITCHAXIS = "btn_switchaxis";
    private static final String BTN_MAXSIZE = "btn_maxsize";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String SENDBTN = "sendbtn";
    private static final String ANALYSISBTN = "analysisbtn";
    private static final String SWITCHAXIS = "SwitchAxis";
    private static final String DIMNUMBERANDNAMEMAP = "DimNumberAndNameMap";
    private static String CTL_TABAP = "tabap";
    private static String COMPARED_TAB = "compared_tab";
    private static String PROPORTION_TAB = "proportion_tab";
    private static String CHARTDATA = "CHARTDATA";
    private static String TABLEDATA = "TABLEDATA";
    private static String CurrChartType = "CurrChartType";
    private static String CurrAnalysisSchemeType = "CurrAnalysisSchemeType";
    private static String CurrAnalysisDataType = "CurrAnalysisDataType";
    private static String DataAlterValue = "DataAlterValue";
    private static String CTL_COMPARED_DATATABLE = "compared_datatable";
    private static String CTL_PROPORTION_DATATABLE = "proportion_datatable";
    private static String MONEY = "money";
    private static String BALANCE = "balance";
    private static String VARIABLEPROPORTION = "varaibleproportion";
    private static String CALCULATEDATA = "CalculateData";
    private static String ISWRONGSCHEME = "iswrongscheme";
    private static int MAXSERIES = 12;
    private static final String CLEARPARAM = "clearparam";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_SWITCHAXIS, BTN_MAXSIZE, BTN_REFRESH, SENDBTN, ANALYSISBTN);
        BasedataEdit analysisSettig = (BasedataEdit)this.getView().getControl(CTL_ANALYSIS_SCHEME);
        analysisSettig.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String operationKey = e.getProperty().getName();
        if (CTL_ECHARTS_BOX.equals(operationKey) && StringUtil.isEmptyString((String)this.isWrongScheme())) {
            this.changeEcharts(e);
        } else if (CTL_ANALYSIS_SCHEME.equals(operationKey)) {
            this.checkMsgChange();
            this.refreshCunit();
            this.changeAnalysisScheme(e);
        } else if (BTN_COMPARED_GROUP.equals(operationKey) && this.checkChangedDataType(e) && StringUtil.isEmptyString((String)this.isWrongScheme())) {
            this.refreshCharts();
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initModel();
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        AnalysisPageServiceHelper.initStaticAnalysisTemp(modelId);
        this.clearDataTable();
        this.refreshChartsBox();
        this.initDefaultPlan();
        this.resetBtnCurrAnalysisDataType();
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "sendbtn": {
                this.sendContentToGPT(null);
                break;
            }
            case "analysisbtn": {
                this.analysisCurrData();
                break;
            }
            case "btn_switchaxis": {
                this.switchChartAxis();
                break;
            }
            case "btn_maxsize": {
                this.openMaxView();
                break;
            }
            case "btn_refresh": {
                this.checkMsgChange();
                this.refreshCunit();
                this.refreshPage();
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String dimKey = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (StringUtil.equals((String)CTL_ANALYSIS_SCHEME, (String)dimKey)) {
            Long modelId = LongUtil.toLong((Object)this.getPageCache().get(MODEL));
            ids.add(modelId);
            ids.add(0L);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter(MODEL, "in", ids).and(new QFilter("status", "=", (Object)"1"));
            this.getPermFIlter(filter);
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.getListFilterParameter().setOrderBy("createtime");
        }
    }

    private void getPermFIlter(QFilter filter) {
        String modelId = this.getPageCache().get(MODEL);
        if (StringUtil.isEmptyString((String)modelId)) {
            return;
        }
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)modelId);
        if (adminUserBol) {
            return;
        }
        ArrayList<Long> noPermIds = new ArrayList<Long>(16);
        noPermIds.addAll(AnalysisPageServiceHelper.getPermCataLogIds("bcm_analysishelper", LongUtil.toLong((Object)modelId), String.valueOf(this.getUserId()), "1"));
        if (noPermIds.size() != 0) {
            filter.and(new QFilter("id", "not in", noPermIds));
        }
        ArrayList<Long> noPermsCatalogIds = new ArrayList<Long>(16);
        noPermsCatalogIds.addAll(AnalysisPageServiceHelper.getPermCataLogIds("bcm_anaysiscatalog", LongUtil.toLong((Object)modelId), String.valueOf(this.getUserId()), "1"));
        DynamicObject[] hasPermIds = BusinessDataServiceHelper.load((String)"bcm_analysishelper", (String)"id,templatecatalog", (QFilter[])new QFilter[]{filter});
        Map<Long, DynamicObject> parentMap = this.buildCataLogParentMap(LongUtil.toLong((Object)modelId));
        for (DynamicObject hasPermDy : hasPermIds) {
            DynamicObject templatecataLog = hasPermDy.getDynamicObject("templatecatalog");
            if (templatecataLog == null || !this.isCataLogNoPerm(templatecataLog, noPermsCatalogIds, parentMap)) continue;
            noPermIds.add(hasPermDy.getLong("id"));
        }
    }

    private Map<Long, DynamicObject> buildCataLogParentMap(Long modelId) {
        DynamicObject[] allCatalOG = BusinessDataServiceHelper.load((String)"bcm_anaysiscatalog", (String)"id,parent", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        HashMap<Long, DynamicObject> parentMap = new HashMap<Long, DynamicObject>(allCatalOG.length);
        for (DynamicObject catalog : allCatalOG) {
            if (catalog.get("parent") == null) continue;
            parentMap.put(catalog.getLong("id"), catalog.getDynamicObject("parent"));
        }
        return parentMap;
    }

    private boolean isCataLogNoPerm(DynamicObject cataLog, List<Long> noPermsCatalogIds, Map<Long, DynamicObject> parentMap) {
        if (noPermsCatalogIds.contains(cataLog.getLong("id"))) {
            return true;
        }
        DynamicObject parent = parentMap.get(cataLog.getLong("id"));
        if (parent == null) {
            return false;
        }
        return this.isCataLogNoPerm(parent, noPermsCatalogIds, parentMap);
    }

    private void initDefaultPlan() {
        DynamicObject defaultScheme = SchemeServiceHelper.initDefaultScheme();
        this.getView().getPageCache().put(CurrAnalysisSchemeType, defaultScheme.getString("analysistype"));
        this.getView().getPageCache().put(CurrAnalysisSchemeType, "1");
        if (this.initDefaultSchemeData()) {
            this.setBtnVisible(true);
            this.getModel().setValue(CTL_ANALYSIS_SCHEME, (Object)defaultScheme);
            this.initRenderEcharts();
            this.initComparedDataTable();
        } else {
            this.setBtnVisible(false);
        }
    }

    private void initDataTable() {
        if (this.getModel().getValue(CTL_ANALYSIS_SCHEME) == null) {
            return;
        }
        this.clearDataTable();
        if (this.isCompared()) {
            this.initComparedDataTable();
        } else {
            this.initProportionDataTable();
        }
    }

    private void initComparedDataTable() {
        List<ComparedDataTable> comparedDataTableSource = this.getComparedDataTable();
        int size = comparedDataTableSource.size();
        if (size <= 0) {
            return;
        }
        Map alertNumPair = this.getCurrAlertNumPair();
        HashSet<Integer> alterSet = new HashSet<Integer>();
        DataTableUtils.buildComparedDataTable(this.getView(), comparedDataTableSource, alterSet, alertNumPair);
        if (this.getView().getPageCache().get(DataAlterValue) != null) {
            this.setDataAlter(alterSet, CTL_COMPARED_DATATABLE);
        }
    }

    private void initProportionDataTable() {
        List<ProportionDataTable> proportionDataTableSource = this.getProportionDataTable();
        int size = proportionDataTableSource.size();
        if (size <= 0) {
            return;
        }
        Map alertNumPair = this.getCurrAlertNumPair();
        HashSet<Integer> alterSet = new HashSet<Integer>();
        DataTableUtils.buildProportionDataTable(this.getView(), proportionDataTableSource, alterSet, alertNumPair);
        if (this.getView().getPageCache().get(DataAlterValue) != null) {
            this.setDataAlter(alterSet, CTL_PROPORTION_DATATABLE);
        }
    }

    private void activeTab() {
        Tab tab = (Tab)this.getControl(CTL_TABAP);
        if (this.isCompared()) {
            tab.activeTab(COMPARED_TAB);
        } else {
            tab.activeTab(PROPORTION_TAB);
        }
    }

    private void clearDataTable() {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(CTL_COMPARED_DATATABLE);
        dataModel.deleteEntryData(CTL_PROPORTION_DATATABLE);
        dataModel.updateCache();
        this.getView().updateView(CTL_COMPARED_DATATABLE);
        this.getView().updateView(CTL_PROPORTION_DATATABLE);
    }

    private void changeAnalysisScheme(PropertyChangedArgs e) {
        if (this.checkAnalysisSchemeProperty(e)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{CTL_ECHARTS_BOX});
            if (this.isDefaultScheme()) {
                if (!this.initDefaultSchemeData()) {
                    this.refreshChartsBox();
                    this.clearDataTable();
                    this.clearChartView();
                    this.setBtnVisible(false);
                    return;
                }
                this.getPageCache().remove(ISWRONGSCHEME);
            } else if (this.changeOtherScheme()) {
                return;
            }
            this.activeTab();
            this.initDataTable();
            this.resetBtnCurrAnalysisDataType();
            this.refreshChartsBox();
            this.refreshCharts();
            this.setBtnVisible(this.isCompared());
            this.clearCache();
        }
    }

    private boolean changeOtherScheme() {
        String msg = this.getAndCacheMoneyData();
        Boolean isErrorMsg = false;
        if (this.getPageCache().get("errorMsg") != null) {
            msg = this.getPageCache().get("errorMsg");
            isErrorMsg = true;
        }
        if (!StringUtil.isEmptyString((String)msg)) {
            this.getPageCache().put(ISWRONGSCHEME, msg);
            if (isErrorMsg.booleanValue()) {
                this.getView().showErrorNotification(msg);
            } else {
                this.getView().showTipNotification(msg);
            }
            this.refreshChartsBox();
            this.clearDataTable();
            this.clearChartView();
            this.setBtnVisible(false);
            this.refreshChartsBox();
            return true;
        }
        this.getPageCache().remove(ISWRONGSCHEME);
        return false;
    }

    private boolean checkAnalysisSchemeProperty(PropertyChangedArgs e) {
        DynamicObject as = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (as == null) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            this.getModel().setValue(CTL_ANALYSIS_SCHEME, oldValue);
            return false;
        }
        Long id = as.getLong("id");
        this.setCurrAnalysisSchemeType(id);
        return true;
    }

    private void setCurrAnalysisSchemeType(Long id) {
        this.getView().getPageCache().remove(DataAlterValue);
        this.getView().getPageCache().remove(CurrAnalysisSchemeType);
        DynamicObject analysisDy = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bcm_analysishelper");
        this.getView().getPageCache().put(CurrAnalysisSchemeType, analysisDy.getString("analysistype"));
        Map<String, Pair<List<Pair<String, String>>, List<String>>> alertNum = AnalysisPageServiceHelper.getAlertNum(id);
        this.getView().getPageCache().put(DataAlterValue, SerializationUtils.toJsonString(alertNum));
    }

    private List<String> getAlertNumsList() {
        ArrayList<String> al = new ArrayList<String>();
        Map p = this.getCurrAlertNumPair();
        if (p != null) {
            List p1 = (List)p.get("p1");
            for (Map pair : p1) {
                String p11 = ((String)pair.get("p1")).replace("#", "");
                String p12 = ((String)pair.get("p2")).replace("#", "");
                if (!al.contains(p11)) {
                    al.add(p11);
                }
                if (al.contains(p12)) continue;
                al.add(p12);
            }
            List p2 = (List)p.get("p2");
            for (String pb : p2) {
                if (al.contains(pb)) continue;
                al.add(pb);
            }
        }
        return al;
    }

    private Map getCurrAlertNumPair() {
        String dataValue = this.getView().getPageCache().get(DataAlterValue);
        if (dataValue == null) {
            return null;
        }
        Map alert = (Map)SerializationUtils.fromJsonString((String)dataValue, Map.class);
        String dataType = this.getView().getPageCache().get(CurrAnalysisDataType);
        if (this.isCompared()) {
            if (StringUtils.equals((CharSequence)dataType, (CharSequence)"2")) {
                return (Map)alert.get(BALANCE);
            }
            if (StringUtils.equals((CharSequence)dataType, (CharSequence)"3")) {
                return (Map)alert.get(VARIABLEPROPORTION);
            }
            return (Map)alert.get(MONEY);
        }
        return (Map)alert.get("proportion");
    }

    private boolean checkChangedDataType(PropertyChangedArgs e) {
        String newValue = e.getChangeSet()[0].getNewValue().toString();
        String oldValue = e.getChangeSet()[0].getOldValue().toString();
        if (!StringUtils.equals((CharSequence)oldValue, (CharSequence)newValue)) {
            this.getView().getPageCache().put(CurrAnalysisDataType, newValue);
            return true;
        }
        return false;
    }

    private void clearCache() {
        this.getView().getPageCache().remove(CurrAnalysisDataType);
    }

    private void clearChartView() {
        String type = this.getPageCache().get(CurrChartType);
        AnalysisChart chart = AnalysisChartsFactory.getChartInstace(this.getControlChart(), ChartType.getChartType(type), false);
        chart.clearData();
        chart.refresh();
    }

    private void changeEcharts(PropertyChangedArgs e) {
        if (StringUtils.isNotEmpty((CharSequence)this.isOperationContinue())) {
            this.getView().showTipNotification(this.isOperationContinue());
            return;
        }
        String type = e.getChangeSet()[0].getNewValue().toString();
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        this.getPageCache().put(CurrChartType, type);
        this.initRenderEcharts();
    }

    private void initRenderEcharts() {
        String chartType = this.getView().getPageCache().get(CurrChartType);
        if (StringUtils.isEmpty((CharSequence)chartType)) {
            return;
        }
        Map<String, LinkedHashMap<String, Number>> data = this.getComparedChartData();
        if (!this.isCompared()) {
            data = this.getProportionChartData();
        }
        this.bindChartData(chartType, data);
        this.getPageCache().put(CHARTDATA, SerializationUtils.toJsonString(data));
    }

    private void bindChartData(String chartType, Map<String, LinkedHashMap<String, Number>> data) {
        AnalysisChart chart = AnalysisChartsFactory.getChartInstace(this.getControlChart(), ChartType.getChartType(chartType), false);
        if (!this.isCompared() || this.isCurrDataTypePercentage()) {
            chart.setPercentage(true);
        }
        chart.setSubText(this.getUnitInfo());
        chart.setBlingMembers(this.getBlingMembers());
        chart.setAlterNum(this.getAlertNumsList());
        chart.setChartData(data);
        chart.refresh();
    }

    private void switchChartAxis() {
        String chartType = this.getView().getPageCache().get(CurrChartType);
        String chartData = this.getPageCache().get(CHARTDATA);
        if (StringUtils.isNotEmpty((CharSequence)chartType) && StringUtils.isNotEmpty((CharSequence)chartData)) {
            try {
                Map<String, LinkedHashMap<String, Number>> transformAxisData = ChartDataServiceHelper.transformAxisData((Map)SerializationUtils.fromJsonString((String)chartData, Map.class));
                this.bindChartData(chartType, ChartDataServiceHelper.buildLimitedSeriesData(transformAxisData));
                this.getPageCache().put(CHARTDATA, SerializationUtils.toJsonString(transformAxisData));
            }
            catch (Exception ex) {
                log.error("Echarts switch axis failed");
            }
        }
    }

    private List<String> getBlingMembers() {
        ArrayList<String> blingMembers = new ArrayList<String>(12);
        DynamicObject dy = (DynamicObject)this.getModel().getValue(CTL_ANALYSIS_SCHEME);
        if (!this.isCompared() || StringUtils.equals((CharSequence)dy.getString("number"), (CharSequence)"default") || !this.isBling()) {
            return blingMembers;
        }
        Long analysisId = dy.getLong("id");
        DynamicObject analysisDim = AnalysisPageServiceHelper.getAnalysisDim(analysisId);
        String analysisDimNumber = analysisDim.getString("number");
        this.checkMsgChange();
        String selectedCellsInfoMapStr = (String)this.getView().getFormShowParameter().getCustomParam("selectedCellsInfoMap");
        Map selectedCellsInfoMap = (Map)ObjectSerialUtil.deSerializedBytes((String)selectedCellsInfoMapStr);
        boolean isDisplayName = this.isDisplayName();
        for (Map.Entry outerMap : selectedCellsInfoMap.entrySet()) {
            String memberNumber = (String)((Map)outerMap.getValue()).get(analysisDimNumber);
            IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)analysisDimNumber, (String)memberNumber);
            String member = isDisplayName ? memberByNumber.getName() : memberNumber;
            if (blingMembers.contains(member)) continue;
            blingMembers.add(member);
        }
        return blingMembers;
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if (!this.checkLicense(eventArgs)) {
            return;
        }
        if (ReceiveMessageType.USERINPUT.getTypeName().equals(eventName)) {
            this.handleUserInput(eventArgs);
        } else if (ReceiveMessageType.FASTANALYSIS.getTypeName().equals(eventName)) {
            this.handleAnalysisCharData(eventArgs);
        }
    }

    private void handleUserInput(String eventArgs) {
        JSONObject argsJson = JSON.parseObject((String)eventArgs);
        String returnAnswer = "";
        try {
            returnAnswer = AHGptServiceHelper.chat(argsJson.getString("gptPromptNumber"), argsJson.getString("input"));
        }
        catch (Exception e) {
            returnAnswer = e.getMessage();
        }
        this.SendToVue(this.buildRespondParams(returnAnswer, argsJson.getString("chartId")));
    }

    private void handleAnalysisCharData(String eventArgs) {
        JSONObject argsJson = JSON.parseObject((String)eventArgs);
        String chartData = this.getPageCache().get(CHARTDATA);
        if (StringUtils.isEmpty((CharSequence)chartData) || JSONObject.parseObject((String)chartData).isEmpty()) {
            this.SendToVue(this.buildRespondParams(ResManager.loadKDString((String)"\u6682\u65e0\u56fe\u8868\u6570\u636e\u53ef\u4ee5\u5206\u6790\u3002", (String)"AnalysisHelperPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), argsJson.getString("chartId")));
            return;
        }
        String returnAnswer = "";
        try {
            returnAnswer = AHGptServiceHelper.analysisChart(argsJson.getString("gptPromptNumber"), this.getPageCache().get(CHARTDATA));
        }
        catch (Exception e) {
            returnAnswer = e.getMessage();
        }
        this.SendToVue(this.buildRespondParams(returnAnswer, argsJson.getString("chartId")));
    }

    public boolean checkLicense(String eventArgs) {
        JSONObject argsJson = JSON.parseObject((String)eventArgs);
        String nima = "";
        if (!GptLicenseUtils.checkGptLicense()) {
            this.SendToVue(this.buildRespondParams(ResManager.loadKDString((String)"\u8bf7\u5148\u8d2d\u4e70GPT\u8d22\u52a1\u52a9\u624b\u8bb8\u53ef\u540e\u91cd\u8bd5\u3002", (String)"AnalysisHelperPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), argsJson.getString("chartId")));
            return false;
        }
        return true;
    }

    private JSONObject buildRespondParams(String content, String chartId) {
        JSONObject noticeRespond = new JSONObject(2);
        noticeRespond.put("content", (Object)content);
        noticeRespond.put("chartId", (Object)chartId);
        noticeRespond.put("t", (Object)TimeServiceHelper.now());
        return noticeRespond;
    }

    private void analysisCurrData() {
    }

    private void sendContentToGPT(String content) {
    }

    private void SendToVue(Object data) {
        CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
        custom.setData(data);
    }

    public void refreshPage() {
        if (StringUtils.isNotEmpty((CharSequence)this.isOperationContinue())) {
            this.getView().showTipNotification(this.isOperationContinue());
            return;
        }
        if (this.isDefaultScheme()) {
            if (!this.initDefaultSchemeData()) {
                this.refreshChartsBox();
                this.clearDataTable();
                this.clearChartView();
                this.setBtnVisible(false);
                return;
            }
            this.setBtnVisible(true);
            this.getPageCache().remove(ISWRONGSCHEME);
        } else if (this.refreshPageByOther()) {
            return;
        }
        this.activeTab();
        this.initDataTable();
        this.refreshCharts();
    }

    private boolean refreshPageByOther() {
        DynamicObject sch = (DynamicObject)this.getModel().getValue(CTL_ANALYSIS_SCHEME);
        this.setCurrAnalysisSchemeType(sch.getLong("id"));
        String msg = this.getAndCacheMoneyData();
        Boolean isErrorMsg = false;
        if (this.getPageCache().get("errorMsg") != null) {
            msg = this.getPageCache().get("errorMsg");
            isErrorMsg = true;
        }
        if (!StringUtil.isEmptyString((String)msg)) {
            this.getPageCache().put(ISWRONGSCHEME, msg);
            if (isErrorMsg.booleanValue()) {
                this.getView().showErrorNotification(msg);
            } else {
                this.getView().showTipNotification(msg);
            }
            this.clearDataTable();
            this.clearChartView();
            this.setBtnVisible(false);
            this.refreshChartsBox();
            return true;
        }
        this.getPageCache().remove(ISWRONGSCHEME);
        this.setBtnVisible(this.isCompared());
        this.refreshChartsBox();
        return false;
    }

    private void refreshCharts() {
        if (StringUtils.isEmpty((CharSequence)this.isOperationContinue())) {
            this.initRenderEcharts();
            this.initDataTable();
        }
    }

    private boolean isCurrDataTypePercentage() {
        return StringUtils.equals((CharSequence)this.getView().getPageCache().get(CurrAnalysisDataType), (CharSequence)"3");
    }

    private boolean isCompared() {
        String type = this.getView().getPageCache().get(CurrAnalysisSchemeType);
        return !StringUtils.equals((CharSequence)"2", (CharSequence)type);
    }

    private boolean isDisplayName() {
        return this.getSchemeFieldDataFromDB("displaytype");
    }

    private boolean isBling() {
        return this.getSchemeFieldDataFromDB("isbling");
    }

    private boolean getSchemeFieldDataFromDB(String field) {
        DynamicObject analysisScheme;
        DynamicObject dy = (DynamicObject)this.getModel().getValue(CTL_ANALYSIS_SCHEME);
        if (Objects.nonNull(dy) && Objects.nonNull(analysisScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)dy.getLong("id"), (String)"bcm_analysishelper", (String)field))) {
            return analysisScheme.getBoolean(field);
        }
        return true;
    }

    private void refreshChartsBox() {
        ComboEdit comboEdit = (ComboEdit)this.getControl(CTL_ECHARTS_BOX);
        ComboProp cp = (ComboProp)comboEdit.getProperty();
        List comboItemList = cp.getComboItems().stream().map(item -> new ComboItem(item.getName(), item.getValue(), item.getImageKey())).collect(Collectors.toList());
        if (this.getModel().getValue(CTL_ANALYSIS_SCHEME) == null || !StringUtil.isEmptyString((String)this.isWrongScheme())) {
            comboItemList.stream().forEach(v -> {
                if (!ChartType.PIE.getType().equals(v.getValue()) && !ChartType.CIRCULAR_PIE.getType().equals(v.getValue())) {
                    v.setItemVisible(true);
                } else {
                    v.setItemVisible(false);
                }
            });
            this.getModel().setValue(CTL_ECHARTS_BOX, (Object)ChartType.COLUMN_BAR.getType());
            this.getPageCache().put(CurrChartType, ChartType.COLUMN_BAR.getType());
        } else if (this.isCompared()) {
            comboItemList.stream().forEach(v -> {
                if (!ChartType.PIE.getType().equals(v.getValue()) && !ChartType.CIRCULAR_PIE.getType().equals(v.getValue())) {
                    v.setItemVisible(true);
                } else {
                    v.setItemVisible(false);
                }
            });
            this.getModel().setValue(CTL_ECHARTS_BOX, (Object)ChartType.COLUMN_BAR.getType());
            this.getPageCache().put(CurrChartType, ChartType.COLUMN_BAR.getType());
        } else {
            comboItemList.stream().forEach(v -> v.setItemVisible(true));
            this.getModel().setValue(CTL_ECHARTS_BOX, (Object)ChartType.PIE.getType());
            this.getPageCache().put(CurrChartType, ChartType.PIE.getType());
        }
        comboEdit.setComboItems(comboItemList);
    }

    private void setDataAlter(Set<Integer> rows, String ctl_Table) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        ClientActions.createRowStyleBuilder().setRows(rows.stream().mapToInt(Integer::intValue).toArray()).setForeColor("red").buildStyle().build().invokeControlMethod(proxy, ctl_Table);
    }

    private void openMaxView() {
        if (StringUtils.isNotEmpty((CharSequence)this.isOperationContinue())) {
            this.getView().showTipNotification(this.isOperationContinue());
            return;
        }
        if (!StringUtil.isEmptyString((String)this.isWrongScheme())) {
            this.getView().showTipNotification(this.isWrongScheme());
            return;
        }
        String chartData = this.getPageCache().get(CHARTDATA);
        String chartType = this.getPageCache().get(CurrChartType);
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bcm_analysis_max");
        param.setCustomParam("chartData", (Object)chartData);
        param.setCustomParam("chartType", (Object)chartType);
        param.setCustomParam("schemeType", (Object)this.isCompared());
        param.setCustomParam("unit", (Object)this.getUnitInfo());
        if (this.isCompared()) {
            param.setCustomParam("isPercentage", (Object)this.isCurrDataTypePercentage());
            List<String> blingMembers = this.getBlingMembers();
            param.setCustomParam("blingMembers", (Object)SerializationUtils.toJsonString(blingMembers));
        } else {
            param.setCustomParam("isPercentage", (Object)true);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getView().getPageCache().get(DataAlterValue))) {
            List<String> alertNumsList = this.getAlertNumsList();
            param.setCustomParam(DataAlterValue, (Object)SerializationUtils.toJsonString(alertNumsList));
        }
        this.getView().showForm(param);
    }

    private void setBtnVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"btn_compared_money", "btn_compared_balance", "btn_compared_percentage", BTN_SWITCHAXIS});
    }

    private void resetBtnCurrAnalysisDataType() {
        this.getModel().setValue(BTN_COMPARED_GROUP, (Object)"1");
        this.getView().getPageCache().put(CurrAnalysisDataType, "1");
    }

    private Chart getControlChart() {
        return (Chart)this.getControl(CTL_CUSTOMCHARTAP);
    }

    private void initModel() {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getPageCache().put(MODEL, String.valueOf(modelId));
    }

    private Map<String, LinkedHashMap<String, Number>> getComparedChartData() {
        Map<String, Object> dataSource = this.getDataSourceCache();
        String dataType = this.getView().getPageCache().get(CurrAnalysisDataType);
        if (StringUtils.equals((CharSequence)dataType, (CharSequence)"2")) {
            return (Map)((Map)dataSource.get(CHARTDATA)).get(BALANCE);
        }
        if (StringUtils.equals((CharSequence)dataType, (CharSequence)"3")) {
            return (Map)((Map)dataSource.get(CHARTDATA)).get(VARIABLEPROPORTION);
        }
        return (Map)((Map)dataSource.get(CHARTDATA)).get(MONEY);
    }

    private List<ComparedDataTable> getComparedDataTable() {
        List list = (List)this.getDataSourceCache().get(TABLEDATA);
        List<ComparedDataTable> collect = list.stream().map(v -> JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)v), ComparedDataTable.class)).collect(Collectors.toList());
        return collect;
    }

    private Map<String, LinkedHashMap<String, Number>> getProportionChartData() {
        return (Map)this.getDataSourceCache().get(CHARTDATA);
    }

    private List<ProportionDataTable> getProportionDataTable() {
        List list = (List)this.getDataSourceCache().get(TABLEDATA);
        List<ProportionDataTable> collect = list.stream().map(v -> JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)v), ProportionDataTable.class)).collect(Collectors.toList());
        return collect;
    }

    private Map<String, Object> getDataSourceCache() {
        String dataStr = this.getPageCache().get(CALCULATEDATA);
        Map dataSource = (Map)SerializationUtils.fromJsonString((String)dataStr, Map.class);
        return dataSource;
    }

    private String getAndCacheMoneyData() {
        Long analysisId = ((DynamicObject)this.getModel().getValue(CTL_ANALYSIS_SCHEME)).getLong("id");
        String selectedCellsInfoMapStr = (String)this.getView().getFormShowParameter().getCustomParam("selectedCellsInfoMap");
        Long modelId = LongUtil.toLong((Object)this.getPageCache().get(MODEL));
        List changeDimNumber = (List)this.getView().getFormShowParameter().getCustomParam("changeDim");
        Boolean isMutilChangeDim = (Boolean)this.getView().getFormShowParameter().getCustomParam("isMutilchangeDim");
        String unit = (String)this.getView().getFormShowParameter().getCustomParam("unit");
        if (isMutilChangeDim.booleanValue()) {
            if (!this.isCompared()) {
                return ResManager.loadKDString((String)"\u5360\u6bd4\u5206\u6790\u4e2d\u53ea\u80fd\u6709\u4e00\u4e2a\u53d8\u52a8\u7ef4\uff0c\u65e0\u6cd5\u9009\u62e9\u6b64\u65b9\u6848\u3002", (String)"AnalysisPageServiceHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u5bf9\u6bd4\u5206\u6790\u4e2d\u4e0e\u5206\u6790\u7ef4\u76f8\u540c\u7ef4\u5ea6\u4e4b\u5916\u7684\u53d8\u52a8\u7ef4\u53ea\u80fd\u6709\u4e00\u4e2a\uff0c\u65e0\u6cd5\u9009\u62e9\u6b64\u65b9\u6848\u3002", (String)"AnalysisPageServiceHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        String rowCallDimStr = (String)this.getView().getFormShowParameter().getCustomParam("rowColDims");
        List rowCallDim = (List)ObjectSerialUtil.deSerializedBytes((String)rowCallDimStr);
        Object data = AnalysisPageServiceHelper.getMoneyData(analysisId, selectedCellsInfoMapStr, modelId, changeDimNumber, rowCallDim, unit);
        if (data instanceof String) {
            return String.valueOf(data);
        }
        Map<String, Object> resData = null;
        if (this.isCompared()) {
            resData = CalServiceHelper.calComparedData(data, this.isDisplayName());
        } else {
            resData = CalServiceHelper.calProportionData(data, this.isDisplayName());
            if (resData == null) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u5206\u6790\u7ef4\u6210\u5458\u6570\u636e\u603b\u548c\u4e3a0,\u65e0\u6cd5\u8fdb\u884c\u5360\u6bd4\u5206\u6790\u3002", (String)"AnalysisHelperPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        }
        this.getPageCache().put(CALCULATEDATA, SerializationUtils.toJsonString(resData));
        return "";
    }

    private boolean initDefaultSchemeData() {
        if (this.getPageCache().get("errorMsg") != null) {
            String msg = this.getPageCache().get("errorMsg");
            this.getView().showErrorNotification(msg);
            this.getPageCache().put(ISWRONGSCHEME, msg);
            return false;
        }
        Long modelId = LongUtil.toLong((Object)this.getPageCache().get(MODEL));
        DynamicObject modelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"bcm_model");
        String modelNumber = modelDy.getString("number");
        String selectedCellsInfoMapStr = (String)this.getView().getFormShowParameter().getCustomParam("selectedCellsInfoMap");
        ArrayList<String> changeDimNumberList = (ArrayList<String>)this.getView().getFormShowParameter().getCustomParam("changeDim");
        Boolean isMutilChangeDim = (Boolean)this.getView().getFormShowParameter().getCustomParam("isMutilchangeDim");
        String unit = (String)this.getView().getFormShowParameter().getCustomParam("unit");
        Map selectedCellsInfoMap = (Map)ObjectSerialUtil.deSerializedBytes((String)selectedCellsInfoMapStr);
        if (isMutilChangeDim.booleanValue() || changeDimNumberList != null && changeDimNumberList.size() > 2) {
            String tips = ResManager.loadKDString((String)"\u5f53\u524d\u5b58\u5728\u591a\u4e2a\u53d8\u52a8\u7ef4\u5ea6\uff0c\u65e0\u6cd5\u9009\u62e9\u9ed8\u8ba4\u65b9\u6848\u3002", (String)"AnalysisHelperPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            this.getPageCache().put(ISWRONGSCHEME, tips);
            return false;
        }
        if (Objects.isNull(changeDimNumberList)) {
            changeDimNumberList = new ArrayList<String>(2);
        }
        this.buildSingleCellOrSingleRowColParams(changeDimNumberList, selectedCellsInfoMap, modelId);
        if (Objects.isNull(changeDimNumberList) || changeDimNumberList.size() < 2) {
            return false;
        }
        List<String> orderDims = this.verifyDimensionOrder(changeDimNumberList, modelId);
        changeDimNumberList = orderDims.isEmpty() ? changeDimNumberList : orderDims;
        Map<String, Object> resultMap = this.getDimNumberAndNameMap(changeDimNumberList, selectedCellsInfoMap, modelId);
        Boolean switchAxis = (Boolean)resultMap.get(SWITCHAXIS);
        Map dimNumberAndNameMap = (Map)resultMap.get(DIMNUMBERANDNAMEMAP);
        ArrayList<String> analysisMembers = new ArrayList<String>(16);
        LinkedHashMap defaultSelectedCellMap = Maps.newLinkedHashMapWithExpectedSize((int)12);
        String analysisNumber = switchAxis != false ? (String)changeDimNumberList.get(1) : (String)changeDimNumberList.get(0);
        String changeNumber = switchAxis != false ? (String)changeDimNumberList.get(0) : (String)changeDimNumberList.get(1);
        for (Map cellInfo : selectedCellsInfoMap.values()) {
            String analysisDimMemberNumber = (String)cellInfo.get(analysisNumber);
            if (analysisMembers.size() < MAXSERIES && !analysisMembers.contains(analysisDimMemberNumber)) {
                analysisMembers.add(analysisDimMemberNumber);
            }
            String changeDimMemberNumber = (String)cellInfo.get(changeNumber);
            if (defaultSelectedCellMap.size() != 0 && defaultSelectedCellMap.containsKey(changeDimMemberNumber)) continue;
            cellInfo.put(analysisNumber, changeDimMemberNumber);
            defaultSelectedCellMap.put(changeDimMemberNumber, cellInfo);
        }
        Pair dimPair = Pair.onePair((Object)analysisNumber, analysisMembers);
        LinkedHashMap data = Maps.newLinkedHashMapWithExpectedSize((int)12);
        data.putAll(AnalysisPageServiceHelper.queryOlapDataCONSTRACT((Pair<String, List<String>>)dimPair, defaultSelectedCellMap, analysisNumber, modelNumber));
        NumberDecimalUtils.valDecimalFormatter(data, unit);
        AnalysisPageServiceHelper.validaData(data, analysisMembers, dimNumberAndNameMap, changeNumber, analysisNumber, true);
        Map<String, Object> comparedData = CalServiceHelper.calComparedData(data, true);
        this.getPageCache().put(CALCULATEDATA, SerializationUtils.toJsonString(comparedData));
        return true;
    }

    private List<String> verifyDimensionOrder(List<String> changeDimNumberList, Long modelId) {
        List tempDimList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(changeDimNumberList), List.class);
        ArrayList orderDimensionList = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray(), (String)"dseq").values().stream().map(v -> v.getString("number")).filter(v -> tempDimList.contains(v)).collect(Collectors.toList());
        return Objects.isNull(orderDimensionList) ? new ArrayList(0) : orderDimensionList;
    }

    private void buildSingleCellOrSingleRowColParams(List<String> changeDimNumberList, Map<String, Map<String, String>> selectedCellsInfoMap, Long modelId) {
        if (selectedCellsInfoMap.size() == 1 || changeDimNumberList.size() == 1) {
            String rowCallDimStr = (String)this.getView().getFormShowParameter().getCustomParam("rowColDims");
            List rowCallDim = (List)ObjectSerialUtil.deSerializedBytes((String)rowCallDimStr);
            Map dimMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray(), (String)"dseq");
            List dimNums = dimMap.values().stream().map(o -> o.getString("number")).collect(Collectors.toList());
            for (String dimNum : dimNums) {
                int oldIndex;
                if (!rowCallDim.contains(dimNum) || changeDimNumberList.contains(dimNum)) continue;
                if (changeDimNumberList.size() == 2) break;
                String firstDim = changeDimNumberList.size() != 0 ? changeDimNumberList.get(0) : dimNum;
                int newIndex = dimNums.indexOf(dimNum);
                if (newIndex < (oldIndex = dimNums.indexOf(firstDim))) {
                    changeDimNumberList.add(0, dimNum);
                    continue;
                }
                changeDimNumberList.add(dimNum);
            }
        }
    }

    private Map<String, Object> getDimNumberAndNameMap(List<String> changeDimNumber, Map<String, Map<String, String>> selectedCellsInfoMap, Long modelId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        HashMap<String, Map<String, String>> dimNumberAndNameMap = new HashMap<String, Map<String, String>>(12);
        Map<String, String> analysisDimNumberMap = AnalysisPageServiceHelper.getChangeDimNumberMap(selectedCellsInfoMap, changeDimNumber.get(0), modelId);
        Map<String, String> changeDimNumberMap = AnalysisPageServiceHelper.getChangeDimNumberMap(selectedCellsInfoMap, changeDimNumber.get(1), modelId);
        resultMap.put(SWITCHAXIS, false);
        if (analysisDimNumberMap.size() < changeDimNumberMap.size()) {
            resultMap.put(SWITCHAXIS, true);
        }
        dimNumberAndNameMap.put(changeDimNumber.get(0), analysisDimNumberMap);
        dimNumberAndNameMap.put(changeDimNumber.get(1), changeDimNumberMap);
        resultMap.put(DIMNUMBERANDNAMEMAP, dimNumberAndNameMap);
        return resultMap;
    }

    private String isOperationContinue() {
        if (this.getModel().getValue(CTL_ANALYSIS_SCHEME) == null) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65b9\u6848", (String)"AnalysisHelperPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String isWrongScheme() {
        if (StringUtil.isEmptyString((String)this.getPageCache().get(ISWRONGSCHEME))) {
            return "";
        }
        return this.getPageCache().get(ISWRONGSCHEME);
    }

    private boolean isDefaultScheme() {
        DynamicObject sch = (DynamicObject)this.getModel().getValue(CTL_ANALYSIS_SCHEME);
        return StringUtils.equals((CharSequence)sch.getString("number"), (CharSequence)"default");
    }

    @Override
    public void dealMsg(CommandParam com) {
        if ("refresh".equals(com.getOperation())) {
            List changeDim = (List)this.getView().getFormShowParameter().getCustomParam("changeDim");
            if (changeDim != null) {
                this.getPageCache().put("changeDim", SerializationUtils.toJsonString((Object)changeDim));
            } else {
                this.getPageCache().put("changeDim", CLEARPARAM);
            }
            this.getPageCache().put("selectedCellsInfoMap", (String)this.getView().getFormShowParameter().getCustomParam("selectedCellsInfoMap"));
            Boolean isMutilChangeDim = (Boolean)this.getView().getFormShowParameter().getCustomParam("isMutilchangeDim");
            this.getPageCache().put("isMutilchangeDim", String.valueOf(isMutilChangeDim));
            String errorMsg = (String)this.getView().getFormShowParameter().getCustomParam("errorMsg");
            if (!StringUtil.isEmptyString((String)errorMsg)) {
                this.getPageCache().put("errorMsg", errorMsg);
            } else {
                this.getPageCache().remove("errorMsg");
            }
            String unit = (String)this.getView().getFormShowParameter().getCustomParam("unit");
            if (!StringUtil.isEmptyString((String)unit)) {
                this.getPageCache().put("unit", unit);
            } else {
                this.getPageCache().remove("unit");
            }
            if (CollectionUtils.isNotEmpty(com.getParam()) && !((Boolean)com.getParam().get(0)).booleanValue()) {
                this.checkMsgChange();
                this.refreshCunit();
                this.refreshPage();
            }
        }
    }

    private void checkMsgChange() {
        if (this.getPageCache().get("changeDim") != null) {
            String changeDimStr = this.getPageCache().get("changeDim");
            if (!CLEARPARAM.equals(changeDimStr)) {
                List changeDim = (List)SerializationUtils.fromJsonString((String)changeDimStr, List.class);
                this.getView().getFormShowParameter().setCustomParam("changeDim", (Object)changeDim);
            } else {
                this.getView().getFormShowParameter().setCustomParam("changeDim", null);
            }
        }
        if (this.getPageCache().get("selectedCellsInfoMap") != null) {
            this.getView().getFormShowParameter().setCustomParam("selectedCellsInfoMap", (Object)this.getPageCache().get("selectedCellsInfoMap"));
        }
        if (this.getPageCache().get("isMutilchangeDim") != null) {
            String isMutilchangeDim = this.getPageCache().get("isMutilchangeDim");
            boolean aBoolean = Boolean.parseBoolean(isMutilchangeDim);
            this.getView().getFormShowParameter().setCustomParam("isMutilchangeDim", (Object)aBoolean);
        }
        if (this.getPageCache().get("unit") != null) {
            String unit = this.getPageCache().get("unit");
            this.getView().getFormShowParameter().setCustomParam("unit", (Object)unit);
        }
    }

    public void refreshCunit() {
        if (Objects.nonNull(this.getPageCache().get("unit"))) {
            String unit = this.getPageCache().get("unit");
            this.getPageCache().put("cunit", unit);
        } else {
            this.getPageCache().put("cunit", "");
        }
    }

    private String getUnitInfo() {
        String unit = Objects.isNull(this.getPageCache().get("cunit")) ? (String)this.getView().getFormShowParameter().getCustomParam("unit") : this.getPageCache().get("cunit");
        return NumberDecimalUtils.getDisplayUnit(unit);
    }
}

