/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.analysishelper.utils.NumberDecimalUtils;
import kd.fi.bcm.spread.common.util.StringUtil;

public class AnalysisPageServiceHelper {
    private static final String PROPERRATION = "2";
    public static final String DEFAULT = "default";
    public static final String CHANGE_DIM = "changedim";
    public static final String ANALYSIS_DIM = "analysisdim";
    public static final String CMP_BY_PERIOD = "CMP-by-Period";
    public static final String CMP_BY_YEAR = "CMP-by-Year";
    public static final String PERIOD_M_YEARTOTAL = "Period/M_YearTotal";
    public static final String YEAR_ALLYEAR = "Year/AllYear";

    public static Map<String, List<Pair<String, BigDecimal>>> queryOlapDataCONSTRACT(Pair<String, List<String>> dimPair, Map<String, Map<String, String>> selectedCellsInfoMap, String changeDimNumber, String modelNumber) {
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)3);
        String selectDimNumber = (String)dimPair.p1;
        List selectDimMemberNumbers = (List)dimPair.p2;
        for (Map.Entry<String, Map<String, String>> cellInfo : selectedCellsInfoMap.entrySet()) {
            Map<String, String> dimMemberMap = cellInfo.getValue();
            SQLBuilder sql = new SQLBuilder(modelNumber);
            sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            sql.addFilter(selectDimNumber, selectDimMemberNumbers.toArray(new String[0]));
            for (Map.Entry<String, String> dimMember : dimMemberMap.entrySet()) {
                String dimNum = dimMember.getKey();
                String dimMemberNum = dimMember.getValue();
                if (!selectDimNumber.equals(dimNum)) {
                    sql.addFilter(dimNum, new String[]{dimMemberNum});
                }
                sql.addSelectField(new String[]{dimNum});
            }
            MDResultSet set = OlapServiceHelper.queryData((SQLBuilder)sql);
            ArrayList pairList = Lists.newArrayListWithExpectedSize((int)16);
            AnalysisPageServiceHelper.generateDataResult(pairList, selectDimNumber, set);
            String defualtNumber = String.format(ResManager.loadKDString((String)"%s\u9ed8\u8ba4", (String)"AnalysisPageServiceHelper_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "default/");
            result.put(StringUtils.isEmpty((CharSequence)changeDimNumber) ? defualtNumber : dimMemberMap.get(changeDimNumber), pairList);
        }
        return result;
    }

    private static void generateDataResult(List<Pair<String, BigDecimal>> pairList, String selectDimNumber, MDResultSet set) {
        if (set.getRows().length > 0) {
            for (Row row : set.getRows()) {
                pairList.add((Pair<String, BigDecimal>)Pair.onePair((Object)row.getString(selectDimNumber), (Object)row.getBigDecimal(FacTabFieldDefEnum.FIELD_MONEY.getField())));
            }
        }
    }

    public static Map<String, List<Pair<String, BigDecimal>>> queryOlapDataPROPERRATION(List<String> analysisDimMemberNumbers, Map<String, Map<String, String>> selectedCellsInfoMap, String changeDimNumber, String modelNumber) {
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)3);
        List<String> changeDimMemberNumbers = selectedCellsInfoMap.values().stream().map(m -> (String)m.get(changeDimNumber)).collect(Collectors.toList());
        HashMap<String, String> dimMemberMap = new HashMap<String, String>(16);
        dimMemberMap.putAll(selectedCellsInfoMap.values().iterator().next());
        SQLBuilder sql = new SQLBuilder(modelNumber);
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        sql.addFilter(changeDimNumber, changeDimMemberNumbers.toArray(new String[0]));
        for (Map.Entry dimMember : dimMemberMap.entrySet()) {
            String dimNum = (String)dimMember.getKey();
            String dimMemberNum = (String)dimMember.getValue();
            if (!changeDimNumber.equals(dimNum)) {
                sql.addFilter(dimNum, new String[]{dimMemberNum});
            }
            sql.addSelectField(new String[]{dimNum});
        }
        MDResultSet set = OlapServiceHelper.queryData((SQLBuilder)sql);
        ArrayList pairList = Lists.newArrayListWithExpectedSize((int)16);
        AnalysisPageServiceHelper.generateDataResult(pairList, changeDimNumber, set);
        result.put(CHANGE_DIM, pairList);
        SQLBuilder sql2 = new SQLBuilder(modelNumber);
        sql2.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        sql2.addFilter(changeDimNumber, analysisDimMemberNumbers.toArray(new String[0]));
        for (Map.Entry entry : dimMemberMap.entrySet()) {
            String dimNum = (String)entry.getKey();
            String dimMemberNum = (String)entry.getValue();
            if (dimNum != null && !changeDimNumber.equals(dimNum)) {
                sql2.addFilter(dimNum, new String[]{dimMemberNum});
            }
            sql2.addSelectField(new String[]{dimNum});
        }
        MDResultSet set2 = OlapServiceHelper.queryData((SQLBuilder)sql2);
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)16);
        AnalysisPageServiceHelper.generateDataResult(arrayList, changeDimNumber, set2);
        result.put(ANALYSIS_DIM, arrayList);
        return result;
    }

    public static Object getMoneyData(Long analysisId, String selectedCellsInfoMapStr, Long modelId, List<String> changeDimNumberList, List<String> rowColDim, String unit) {
        DynamicObject modelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"bcm_model");
        String modelNumber = modelDy.getString("number");
        DynamicObject analysisDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisId, (String)"bcm_analysishelper");
        String dimId = analysisDy.getString("anaysisdim").split("/")[0];
        DynamicObject dimDy = BusinessDataServiceHelper.loadSingleFromCache((Object)LongUtil.toLong((Object)dimId), (String)"bcm_dimension");
        Map selectedCellsInfoMap = (Map)ObjectSerialUtil.deSerializedBytes((String)selectedCellsInfoMapStr);
        if (selectedCellsInfoMap.size() == 0) {
            return "errorMsg";
        }
        String AnalysisDim = dimDy.getString("number");
        String AnalysiaType = analysisDy.getString("analysistype");
        int seriesLimit = StringUtil.equals((String)PROPERRATION, (String)AnalysiaType) ? 3 : analysisDy.getInt("serieslimit");
        int maxMemberSize = StringUtil.equals((String)PROPERRATION, (String)AnalysiaType) ? 12 : analysisDy.getInt("showpredimmember");
        List<Long> members = AnalysisPageServiceHelper.getDetailMemberIds(analysisId, modelId);
        if (members.size() == 0) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u65e0\u6709\u6548\u5206\u6790\u7ef4\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u914d\u7f6e\u3002", (String)"AnalysisPageServiceHelper_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        Map dims = BusinessDataServiceHelper.loadFromCache((Object[])members.toArray(), (String)DimEntityNumEnum.getEntieyNumByNumber((String)AnalysisDim));
        List<String> selectDimMemberNumbers = dims.values().stream().map(o -> o.getString("number")).collect(Collectors.toList());
        HashMap<String, Map<String, String>> dimNumberAndNameMap = new HashMap<String, Map<String, String>>(12);
        HashMap<String, String> changeDimNumberAndNameMap = new HashMap<String, String>(12);
        HashMap<String, String> analysisDimNumberAndNameMap = new HashMap<String, String>(12);
        for (DynamicObject dim : dims.values()) {
            analysisDimNumberAndNameMap.put(dim.getString("number"), dim.getString("name"));
        }
        dimNumberAndNameMap.put(AnalysisDim, analysisDimNumberAndNameMap);
        Boolean iscomwithdimlist = StringUtil.equals((String)PROPERRATION, (String)AnalysiaType) ? true : analysisDy.getBoolean("iscomwithdimlist");
        Boolean isshowdimlist = StringUtil.equals((String)PROPERRATION, (String)AnalysiaType) ? false : analysisDy.getBoolean("isshowdimlist");
        AnalysisPageServiceHelper.checkIsShowDimList(selectedCellsInfoMap, maxMemberSize, selectDimMemberNumbers, iscomwithdimlist, isshowdimlist, AnalysisDim, modelId, analysisDimNumberAndNameMap);
        LinkedHashMap<String, List<Pair<String, BigDecimal>>> result = new LinkedHashMap<String, List<Pair<String, BigDecimal>>>();
        String changeDimNumber = null;
        if (changeDimNumberList != null) {
            if (changeDimNumberList.size() > 1 && !changeDimNumberList.contains(AnalysisDim)) {
                return ResManager.loadKDString((String)"\u5206\u6790\u4e2d\u4e0e\u5206\u6790\u7ef4\u76f8\u540c\u7ef4\u5ea6\u4e4b\u5916\u7684\u53d8\u52a8\u7ef4\u53ea\u80fd\u6709\u4e00\u4e2a\uff0c\u65e0\u6cd5\u9009\u62e9\u6b64\u65b9\u6848\u3002", (String)"AnalysisPageServiceHelper_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            if (changeDimNumberList.size() != 1) {
                changeDimNumberList.remove(AnalysisDim);
            }
            changeDimNumber = changeDimNumberList.get(0);
            changeDimNumberAndNameMap.putAll(AnalysisPageServiceHelper.getChangeDimNumberMap(selectedCellsInfoMap, changeDimNumber, modelId));
            dimNumberAndNameMap.put(changeDimNumber, changeDimNumberAndNameMap);
        }
        if (selectedCellsInfoMap.size() > 1 && StringUtil.equals((String)AnalysisDim, changeDimNumber)) {
            return ResManager.loadKDString((String)"\u5206\u6790\u4e2d\u5206\u6790\u7ef4\u4e0e\u6240\u753b\u5355\u5143\u683c\u53d8\u52a8\u7ef4\u5ea6\u4e0d\u80fd\u76f8\u540c\uff0c\u65e0\u6cd5\u9009\u62e9\u6b64\u65b9\u6848\u3002", (String)"AnalysisPageServiceHelper_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        LinkedHashMap<String, Map<String, String>> topSeriesSelectedCellMap = new LinkedHashMap<String, Map<String, String>>(seriesLimit);
        HashSet changeDimMemberList = new HashSet(16);
        for (Map.Entry cellMap : selectedCellsInfoMap.entrySet()) {
            if (topSeriesSelectedCellMap.size() >= seriesLimit) break;
            if (!StringUtil.isEmptyString((String)changeDimNumber) && !changeDimMemberList.contains(((Map)cellMap.getValue()).get(changeDimNumber))) {
                topSeriesSelectedCellMap.put((String)cellMap.getKey(), (Map<String, String>)cellMap.getValue());
                changeDimMemberList.add(((Map)cellMap.getValue()).get(changeDimNumber));
                continue;
            }
            if (!StringUtil.isEmptyString((String)changeDimNumber)) continue;
            topSeriesSelectedCellMap.put((String)cellMap.getKey(), (Map<String, String>)cellMap.getValue());
        }
        Pair dimPair = Pair.onePair((Object)AnalysisDim, selectDimMemberNumbers);
        changeDimNumber = AnalysisPageServiceHelper.buildSingleCellOrRowCols(modelId, rowColDim, selectedCellsInfoMap, AnalysisDim, changeDimNumberAndNameMap, changeDimNumber);
        dimNumberAndNameMap.put(changeDimNumber, changeDimNumberAndNameMap);
        result.putAll(AnalysisPageServiceHelper.queryOlapDataCONSTRACT((Pair<String, List<String>>)dimPair, topSeriesSelectedCellMap, changeDimNumber, modelNumber));
        NumberDecimalUtils.valDecimalFormatter(result, unit);
        AnalysisPageServiceHelper.validaData(result, selectDimMemberNumbers, dimNumberAndNameMap, changeDimNumber, AnalysisDim, true);
        return result;
    }

    private static String buildSingleCellOrRowCols(Long modelId, List<String> rowColDim, Map<String, Map<String, String>> selectedCellsInfoMap, String AnalysisDim, Map<String, String> dimNumberAndNameMap, String changeDimNumber) {
        if (selectedCellsInfoMap.size() == 1 && Objects.isNull(changeDimNumber)) {
            List<String> dimOrderList;
            rowColDim.remove(AnalysisDim);
            if (rowColDim.size() == 1) {
                changeDimNumber = rowColDim.get(0);
                dimNumberAndNameMap.putAll(AnalysisPageServiceHelper.getChangeDimNumberMap(selectedCellsInfoMap, changeDimNumber, modelId));
            } else if (rowColDim.size() > 1 && (dimOrderList = AnalysisPageServiceHelper.verifyDimOrder(rowColDim, modelId)).size() > 0) {
                changeDimNumber = dimOrderList.get(0);
                dimNumberAndNameMap.putAll(AnalysisPageServiceHelper.getChangeDimNumberMap(selectedCellsInfoMap, changeDimNumber, modelId));
            }
        }
        return changeDimNumber;
    }

    private static List<String> verifyDimOrder(List<String> changeDimNumberList, Long modelId) {
        List tempDimList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(changeDimNumberList), List.class);
        ArrayList orderDimensionList = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray(), (String)"dseq").values().stream().map(v -> v.getString("number")).filter(v -> tempDimList.contains(v)).collect(Collectors.toList());
        return Objects.isNull(orderDimensionList) ? new ArrayList(0) : orderDimensionList;
    }

    public static void validaData(Map<String, List<Pair<String, BigDecimal>>> data, List<String> analysisDimMemberNumbers, Map<String, Map<String, String>> dimNumberAndNameMap, String changeNumber, String analysisNumber, boolean isCompare) {
        Map<String, String> changeDimNumberAndNameMap = dimNumberAndNameMap.get(changeNumber);
        Map<String, String> analysisDimNumberAndNameMap = dimNumberAndNameMap.get(analysisNumber);
        if (isCompare) {
            ArrayList<String> removeChangeDim = new ArrayList<String>(3);
            LinkedHashMap newData = new LinkedHashMap(data.size());
            for (Map.Entry<String, List<Pair<String, BigDecimal>>> entry : data.entrySet()) {
                removeChangeDim.add(entry.getKey());
                if (entry.getValue().size() == 0) continue;
                String changeMemberName = changeDimNumberAndNameMap.get(entry.getKey());
                ArrayList<Pair> newAnalysisData = new ArrayList<Pair>(12);
                for (String analsisNumber : analysisDimMemberNumbers) {
                    BigDecimal money = null;
                    for (Pair<String, BigDecimal> curAnalysisData : entry.getValue()) {
                        if (!StringUtil.equals((String)((String)curAnalysisData.p1), (String)analsisNumber)) continue;
                        money = (BigDecimal)curAnalysisData.p2;
                        break;
                    }
                    if (money == null) {
                        money = new BigDecimal("0");
                    }
                    newAnalysisData.add(Pair.onePair((Object)(analsisNumber + "/" + analysisDimNumberAndNameMap.get(analsisNumber)), (Object)money));
                }
                if (changeMemberName != null) {
                    newData.put(entry.getKey() + "/" + changeMemberName, newAnalysisData);
                    continue;
                }
                newData.put(entry.getKey(), newAnalysisData);
                removeChangeDim.remove(entry.getKey());
            }
            data.putAll(newData);
            for (String string : removeChangeDim) {
                data.remove(string);
            }
        } else {
            List<Pair<String, BigDecimal>> analysisData = data.get(ANALYSIS_DIM);
            HashMap<Object, Pair<String, BigDecimal>> analysisDataMap = new HashMap<Object, Pair<String, BigDecimal>>(16);
            for (Pair<String, BigDecimal> pair : analysisData) {
                analysisDataMap.put(pair.p1, pair);
            }
            ArrayList analysisDataSort = new ArrayList(analysisData.size());
            for (String number : analysisDimMemberNumbers) {
                if (!analysisDataMap.containsKey(number)) continue;
                analysisDataSort.add(analysisDataMap.get(number));
            }
            data.put(ANALYSIS_DIM, analysisDataSort);
            ArrayList<Pair> arrayList = new ArrayList<Pair>(16);
            for (Pair<String, BigDecimal> cd : data.get(CHANGE_DIM)) {
                String changedimName = (String)cd.p1 + "/" + changeDimNumberAndNameMap.get(cd.p1);
                arrayList.add(Pair.onePair((Object)changedimName, (Object)cd.p2));
            }
            data.put(CHANGE_DIM, arrayList);
        }
    }

    public static Pair<Boolean, List<String>> isHaveOnlyOneChangeDim(Map<String, Map<String, String>> selectedCellsInfoMap, long modelId) {
        if (selectedCellsInfoMap.size() > 1) {
            Map dimMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
            Set dimNums = dimMap.values().stream().map(o -> o.getString("number")).collect(Collectors.toSet());
            ArrayList<String> changeDimList = new ArrayList<String>(2);
            for (String dimNum : dimNums) {
                Set collect = selectedCellsInfoMap.values().stream().map(o -> (String)o.get(dimNum)).collect(Collectors.toSet());
                if (collect.size() <= 1) continue;
                if (changeDimList.size() > 1) {
                    return Pair.onePair((Object)Boolean.FALSE, null);
                }
                changeDimList.add(dimNum);
            }
            return Pair.onePair((Object)Boolean.TRUE, changeDimList);
        }
        return Pair.onePair((Object)Boolean.TRUE, null);
    }

    private static void checkIsShowDimList(Map<String, Map<String, String>> selectedCellsInfoMap, int maxMemberSize, List<String> selectDimMemberNumbers, Boolean iscomwithdimlist, Boolean isshowdimlist, String AnalysisDim, Long modelId, Map<String, String> dimNumberAndNameMap) {
        if (!iscomwithdimlist.booleanValue()) {
            ArrayList<String> selectDimNew = new ArrayList<String>(selectDimMemberNumbers.size() + selectedCellsInfoMap.size());
            for (Map<String, String> cellInfo : selectedCellsInfoMap.values()) {
                selectDimNew.add(cellInfo.get(AnalysisDim));
            }
            QFilter dimFilter = new QFilter("model", "=", (Object)modelId).and(new QFilter("number", "in", selectDimNew));
            DynamicObjectCollection cellMemberDys = QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber((String)AnalysisDim), (String)"number,name,level,dseq", (QFilter[])dimFilter.toArray(), (String)"level,dseq");
            List cellMemberNumbers = cellMemberDys.stream().map(p -> p.getString("number")).collect(Collectors.toList());
            HashMap<String, String> cellMemberMap = new HashMap<String, String>(16);
            for (DynamicObject cellDys : cellMemberDys) {
                cellMemberMap.put(cellDys.getString("number"), cellDys.getString("name"));
            }
            ArrayList<String> allMemberNumber = new ArrayList<String>(cellMemberNumbers.size() + selectDimMemberNumbers.size());
            for (String cellNumber : cellMemberNumbers) {
                if (selectDimMemberNumbers.contains(cellNumber) || allMemberNumber.contains(cellNumber)) continue;
                allMemberNumber.add(cellNumber);
                dimNumberAndNameMap.put(cellNumber, (String)cellMemberMap.get(cellNumber));
            }
            allMemberNumber.addAll(selectDimMemberNumbers);
            selectDimMemberNumbers.clear();
            selectDimMemberNumbers.addAll(allMemberNumber);
        } else if (isshowdimlist.booleanValue()) {
            int index = -1;
            for (Map<String, String> cellInfo : selectedCellsInfoMap.values()) {
                String memberNumber = cellInfo.get(AnalysisDim);
                int memberIndex = selectDimMemberNumbers.contains(memberNumber) ? selectDimMemberNumbers.indexOf(memberNumber) : -1;
                if (memberIndex <= index) continue;
                index = memberIndex;
            }
            if (index == -1) {
                index = maxMemberSize - 1;
            }
            while (selectDimMemberNumbers.size() > index + 1) {
                selectDimMemberNumbers.remove(selectDimMemberNumbers.size() - 1);
            }
        }
    }

    public static Map<String, String> getChangeDimNumberMap(Map<String, Map<String, String>> selectedCellsInfoMap, String changeDimNumber, Long modelId) {
        HashMap<String, String> changeDimMap = new HashMap<String, String>(selectedCellsInfoMap.size());
        for (Map<String, String> cellInfo : selectedCellsInfoMap.values()) {
            String memberNumber = cellInfo.get(changeDimNumber);
            if (!StringUtils.isNotEmpty((CharSequence)memberNumber) || !StringUtils.isNotEmpty((CharSequence)changeDimNumber)) continue;
            IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)changeDimNumber, (String)memberNumber);
            changeDimMap.put(memberNumber, memberByNumber.getName());
        }
        return changeDimMap;
    }

    public static String mapAlertValue(String condition) {
        String result = "";
        switch (condition) {
            case ">": {
                result = ResManager.loadKDString((String)"\u5927\u4e8e", (String)"AnalysisHelperAlertSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "<": {
                result = ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"AnalysisHelperAlertSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "=": {
                result = ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"AnalysisHelperAlertSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "?": {
                result = ResManager.loadKDString((String)"\u5927\u4e8e\u7b49\u4e8e", (String)"AnalysisHelperAlertSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "!": {
                result = ResManager.loadKDString((String)"\u5c0f\u4e8e\u7b49\u4e8e", (String)"AnalysisHelperAlertSettingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "money": {
                result = ResManager.loadKDString((String)"\u5ea6\u91cf\u503c", (String)"AnalysisHelperAlertSettingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "balance": {
                result = ResManager.loadKDString((String)"\u5dee\u989d\u9879", (String)"AnalysisHelperAlertSettingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "varaibleproportion": {
                result = ResManager.loadKDString((String)"\u5dee\u989d\u6bd4\u4f8b", (String)"AnalysisHelperAlertSettingPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "proportion": {
                result = ResManager.loadKDString((String)"\u5360\u6bd4\u6bd4\u4f8b", (String)"AnalysisHelperAlertSettingPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "&": {
                result = ResManager.loadKDString((String)"\u4e14", (String)"AnalysisHelperAlertSettingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case ";": {
                result = ";";
                break;
            }
        }
        return result + " ";
    }

    public static Map<String, Pair<List<Pair<String, String>>, List<String>>> getAlertNum(Long analysisHelperId) {
        DynamicObject analysisHelper = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisHelperId, (String)"bcm_analysishelper");
        String alertStr = analysisHelper.getString("alertnum");
        HashMap<String, Pair<List<Pair<String, String>>, List<String>>> alertNumResultMap = new HashMap<String, Pair<List<Pair<String, String>>, List<String>>>();
        HashMap<String, Tuple<List<BigDecimal>, List<BigDecimal>, List<BigDecimal>>> alertNumAnalysisMap = new HashMap<String, Tuple<List<BigDecimal>, List<BigDecimal>, List<BigDecimal>>>(3);
        ArrayList<String> EqualFlagList = new ArrayList<String>();
        AnalysisPageServiceHelper.initAnalysisQueue(alertStr, alertNumAnalysisMap, EqualFlagList);
        for (Tuple tuple : alertNumAnalysisMap.values()) {
            ((List)tuple.p1).sort(BigDecimal::compareTo);
            ((List)tuple.p2).sort(BigDecimal::compareTo);
            ((List)tuple.p3).sort(BigDecimal::compareTo);
        }
        for (Map.Entry entry : alertNumAnalysisMap.entrySet()) {
            ArrayList<Pair> rangeList;
            Tuple alertQueue = (Tuple)entry.getValue();
            Pair curPair = (Pair)alertNumResultMap.get(entry.getKey());
            if (((List)alertQueue.p1).size() != 0 && ((List)alertQueue.p2).size() == 0) {
                rangeList = new ArrayList<Pair>(16);
                String lowerValue = String.valueOf(((List)alertQueue.p1).get(0));
                if (EqualFlagList.contains(lowerValue)) {
                    lowerValue = "#" + lowerValue;
                }
                rangeList.add(Pair.onePair((Object)lowerValue, (Object)""));
                curPair = Pair.onePair(rangeList, new ArrayList(16));
                alertNumResultMap.put((String)entry.getKey(), (Pair<List<Pair<String, String>>, List<String>>)curPair);
            } else if (((List)alertQueue.p1).size() == 0 && ((List)alertQueue.p2).size() != 0) {
                rangeList = new ArrayList(16);
                String upperValue = String.valueOf(((List)alertQueue.p2).get(((List)alertQueue.p2).size() - 1));
                if (EqualFlagList.contains(upperValue)) {
                    upperValue = "#" + upperValue;
                }
                rangeList.add(Pair.onePair((Object)"", (Object)upperValue));
                curPair = Pair.onePair(rangeList, new ArrayList(16));
                alertNumResultMap.put((String)entry.getKey(), (Pair<List<Pair<String, String>>, List<String>>)curPair);
            } else if (((List)alertQueue.p1).size() != 0 && ((List)alertQueue.p2).size() != 0) {
                for (int p1Index = ((List)alertQueue.p1).size() - 1; p1Index >= 0; --p1Index) {
                    boolean isRetain = false;
                    int p2RemoveIndex = ((List)alertQueue.p2).size() - 1;
                    for (int p2Index = ((List)alertQueue.p2).size() - 1; p2Index >= 0; --p2Index) {
                        ArrayList<Pair> rangeQueue;
                        String upValue;
                        if (((BigDecimal)((List)alertQueue.p2).get(p2Index)).compareTo((BigDecimal)((List)alertQueue.p1).get(p1Index)) >= 0 && p1Index != 0) continue;
                        isRetain = true;
                        p2RemoveIndex = p2Index;
                        String lowValue = String.valueOf(((List)alertQueue.p1).get(p1Index));
                        if (EqualFlagList.contains(lowValue)) {
                            lowValue = "#" + lowValue;
                            EqualFlagList.remove(lowValue);
                        }
                        if (EqualFlagList.contains(upValue = String.valueOf(((List)alertQueue.p2).get(((List)alertQueue.p2).size() - 1)))) {
                            upValue = "#" + upValue;
                            EqualFlagList.remove(upValue);
                        }
                        Pair effectiveRange = Pair.onePair((Object)lowValue, (Object)upValue);
                        if (curPair == null) {
                            rangeQueue = new ArrayList<Pair>(16);
                            rangeQueue.add(effectiveRange);
                            curPair = Pair.onePair(rangeQueue, new ArrayList(16));
                            alertNumResultMap.put((String)entry.getKey(), (Pair<List<Pair<String, String>>, List<String>>)curPair);
                            break;
                        }
                        rangeQueue = (ArrayList<Pair>)curPair.p1;
                        rangeQueue.add(effectiveRange);
                        break;
                    }
                    if (!isRetain) continue;
                    for (int index = ((List)alertQueue.p2).size() - 1; index > p2RemoveIndex; --index) {
                        ((List)alertQueue.p2).remove(index);
                    }
                }
            } else {
                curPair = Pair.onePair(new ArrayList(16), new ArrayList(16));
                alertNumResultMap.put((String)entry.getKey(), (Pair<List<Pair<String, String>>, List<String>>)curPair);
            }
            for (BigDecimal equalValue : (List)alertQueue.p3) {
                boolean effectiveValue = true;
                for (Pair curRange : (List)curPair.p1) {
                    if (!AnalysisPageServiceHelper.isInRange((String)curRange.p1, (String)curRange.p2, equalValue)) continue;
                    effectiveValue = false;
                    break;
                }
                if (!effectiveValue) continue;
                ((List)curPair.p2).add(String.valueOf(equalValue));
            }
        }
        return alertNumResultMap;
    }

    public static boolean isInRange(String lowerValue, String uperValue, BigDecimal value) {
        int bigerOrSmaller;
        boolean biggerThanLowerValue = false;
        boolean smallerThanUperValue = false;
        if (lowerValue.startsWith("#")) {
            bigerOrSmaller = value.compareTo(new BigDecimal(lowerValue.substring(1)));
            if (bigerOrSmaller >= 0) {
                biggerThanLowerValue = true;
            }
        } else if (StringUtil.isEmptyString((String)lowerValue) || value.compareTo(new BigDecimal(lowerValue)) > 0) {
            biggerThanLowerValue = true;
        }
        if (uperValue.startsWith("#")) {
            bigerOrSmaller = value.compareTo(new BigDecimal(uperValue.substring(1)));
            if (bigerOrSmaller <= 0) {
                smallerThanUperValue = true;
            }
        } else if (StringUtil.isEmptyString((String)uperValue) || value.compareTo(new BigDecimal(uperValue)) < 0) {
            smallerThanUperValue = true;
        }
        return biggerThanLowerValue && smallerThanUperValue;
    }

    private static void initAnalysisQueue(String alertStr, Map<String, Tuple<List<BigDecimal>, List<BigDecimal>, List<BigDecimal>>> alertNumAnalysisMap, List<String> EqualFlagList) {
        String[] alertValueArr;
        ArrayList moneySmallQueue = new ArrayList(16);
        ArrayList moneyBigQueue = new ArrayList(16);
        ArrayList moneyEqualQueue = new ArrayList(16);
        alertNumAnalysisMap.put("money", (Tuple<List<BigDecimal>, List<BigDecimal>, List<BigDecimal>>)new Tuple(moneyBigQueue, moneySmallQueue, moneyEqualQueue));
        ArrayList balanceSmallQueue = new ArrayList(16);
        ArrayList balanceBigQueue = new ArrayList(16);
        ArrayList balanceEqualQueue = new ArrayList(16);
        alertNumAnalysisMap.put("balance", (Tuple<List<BigDecimal>, List<BigDecimal>, List<BigDecimal>>)new Tuple(balanceBigQueue, balanceSmallQueue, balanceEqualQueue));
        ArrayList varaibleproportionSmallQueue = new ArrayList(16);
        ArrayList varaibleproportionBigQueue = new ArrayList(16);
        ArrayList varaibleproportionEqualQueue = new ArrayList(16);
        alertNumAnalysisMap.put("varaibleproportion", (Tuple<List<BigDecimal>, List<BigDecimal>, List<BigDecimal>>)new Tuple(varaibleproportionBigQueue, varaibleproportionSmallQueue, varaibleproportionEqualQueue));
        ArrayList proportionSmallQueue = new ArrayList(16);
        ArrayList proportionBigQueue = new ArrayList(16);
        ArrayList proportionEqualQueue = new ArrayList(16);
        alertNumAnalysisMap.put("proportion", (Tuple<List<BigDecimal>, List<BigDecimal>, List<BigDecimal>>)new Tuple(proportionBigQueue, proportionSmallQueue, proportionEqualQueue));
        for (String alertNums : alertValueArr = alertStr.split(";")) {
            String[] alertSplit;
            if (alertNums.contains(">")) {
                alertSplit = alertNums.split(">");
                ((List)alertNumAnalysisMap.get((Object)alertSplit[0]).p1).add(new BigDecimal(alertSplit[1]));
                continue;
            }
            if (alertNums.contains("<")) {
                alertSplit = alertNums.split("<");
                ((List)alertNumAnalysisMap.get((Object)alertSplit[0]).p2).add(new BigDecimal(alertSplit[1]));
                continue;
            }
            if (alertNums.contains(":")) {
                alertSplit = alertNums.split(":");
                ((List)alertNumAnalysisMap.get((Object)alertSplit[0]).p1).add(new BigDecimal(alertSplit[1]));
                EqualFlagList.add(alertSplit[1]);
                continue;
            }
            if (alertNums.contains("!")) {
                alertSplit = alertNums.split("!");
                ((List)alertNumAnalysisMap.get((Object)alertSplit[0]).p2).add(new BigDecimal(alertSplit[1]));
                EqualFlagList.add(alertSplit[1]);
                continue;
            }
            if (!alertNums.contains("=")) continue;
            alertSplit = alertNums.split("=");
            ((List)alertNumAnalysisMap.get((Object)alertSplit[0]).p3).add(new BigDecimal(alertSplit[1]));
        }
    }

    public static List<Long> getDetailMemberIds(Long analysisId, Long modelId) {
        ArrayList<Long> detailMemberList = new ArrayList<Long>(16);
        DynamicObject analysisDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisId, (String)"bcm_analysishelper");
        if (analysisDy == null) {
            return detailMemberList;
        }
        if (analysisDy.get("showpredimmember") == null) {
            return detailMemberList;
        }
        int maxMember = analysisDy.getInt("showpredimmember");
        String dimInfo = analysisDy.getString("anaysisdim");
        String entityName = dimInfo.split("/")[1];
        DynamicObjectCollection memberDys = analysisDy.getDynamicObjectCollection("anaysisdimrange");
        HashSet<Long> memberIds = new HashSet<Long>(memberDys.size());
        int index = 0;
        HashMap indexSortMap = new HashMap(16);
        HashSet repeatMemberids = new HashSet(16);
        for (DynamicObject memberDy : memberDys) {
            int range = Integer.parseInt(memberDy.getString("dimrange"));
            Long memberId = LongUtil.toLong((Object)memberDy.getString("dimrangevalue"));
            HashSet<Long> curMemeberIds = new HashSet<Long>(16);
            if (range == 10) {
                curMemeberIds.add(memberId);
            } else {
                curMemeberIds.addAll(QueryMemberDetailsHelper.queryMemberIdsByRange((String)entityName, (Long)memberId, (int)range, (String)String.valueOf(modelId), (DetailTypeEnum)DetailTypeEnum.OTHERS));
            }
            curMemeberIds.removeAll(repeatMemberids);
            repeatMemberids.addAll(curMemeberIds);
            memberIds.addAll(curMemeberIds);
            if (indexSortMap.get(index) != null) {
                ((Set)indexSortMap.get(index)).addAll(curMemeberIds);
            } else {
                indexSortMap.put(index, curMemeberIds);
            }
            if (memberIds.size() > maxMember) break;
            ++index;
        }
        DynamicObjectCollection memDyListSort = QueryServiceHelper.query((String)entityName, (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", memberIds)});
        List<Long> sortDyId = AnalysisPageServiceHelper.sortDimMembers(modelId, entityName, memberIds);
        HashMap<Long, String> memIdNumberMap = new HashMap<Long, String>(16);
        for (DynamicObject memDy : memDyListSort) {
            memIdNumberMap.put(memDy.getLong("id"), memDy.getString("number"));
        }
        block2: for (int desq = 0; desq < indexSortMap.size(); ++desq) {
            Set curDesqMemberIds = (Set)indexSortMap.get(desq);
            if (curDesqMemberIds.size() == 1) {
                if (detailMemberList.size() >= maxMember) break;
                detailMemberList.addAll(curDesqMemberIds);
                continue;
            }
            for (Long memberId : sortDyId) {
                if (!curDesqMemberIds.contains(memberId)) continue;
                if (detailMemberList.size() >= maxMember) continue block2;
                detailMemberList.add(memberId);
            }
        }
        ArrayList<Long> finaldetailMemberList = new ArrayList<Long>(16);
        ArrayList repeatNumberList = new ArrayList(16);
        for (Long finalId : detailMemberList) {
            if (!memIdNumberMap.containsKey(finalId) || repeatNumberList.contains(memIdNumberMap.get(finalId))) continue;
            repeatNumberList.add(memIdNumberMap.get(finalId));
            finaldetailMemberList.add(finalId);
        }
        return finaldetailMemberList;
    }

    public static void initStaticAnalysisTemp(Long modelId) {
        try (TXHandle tx = TX.required();){
            QFBuilder templateCataLog = new QFBuilder();
            QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
            templateCataLog.add(modelFilter);
            templateCataLog.add(new QFilter("number", "=", (Object)"root"));
            if (QueryServiceHelper.exists((String)"bcm_anaysiscatalog", (QFilter[])templateCataLog.toArray())) {
                return;
            }
            try {
                Long catalogRootId = AnalysisPageServiceHelper.addCatalogRoot(modelId);
                if (Objects.isNull(catalogRootId)) {
                    DynamicObject rootCatalog = QueryServiceHelper.queryOne((String)"bcm_anaysiscatalog", (String)"id", (QFilter[])templateCataLog.toArray());
                    catalogRootId = rootCatalog.getLong("id");
                }
                AnalysisPageServiceHelper.saveDefaultAnalysis(catalogRootId, modelId, modelFilter);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(ThrowableHelper.toString((Exception)e));
            }
        }
    }

    private static void saveDefaultAnalysis(Long catalogRootId, Long modelId, QFilter modelFilter) {
        Tuple analysisPeriod = new Tuple((Object)CMP_BY_PERIOD, (Object)PERIOD_M_YEARTOTAL, (Object)ResManager.getLocaleString((String)"\u73af\u6bd4\u5206\u6790", (String)"AnalysisPageServiceHelper_5", (String)"fi-bcm-formplugin"));
        Tuple analysisYear = new Tuple((Object)CMP_BY_YEAR, (Object)YEAR_ALLYEAR, (Object)ResManager.getLocaleString((String)"\u540c\u671f\u5bf9\u6bd4\u5206\u6790", (String)"AnalysisPageServiceHelper_6", (String)"fi-bcm-formplugin"));
        ArrayList previewAnalysis = Lists.newArrayListWithCapacity((int)2);
        previewAnalysis.add(analysisPeriod);
        previewAnalysis.add(analysisYear);
        for (Tuple preAnalysis : previewAnalysis) {
            QFBuilder anlysisCheckBuilder = new QFBuilder();
            anlysisCheckBuilder.add(modelFilter);
            anlysisCheckBuilder.add(new QFilter("number", "=", preAnalysis.p1));
            if (QueryServiceHelper.exists((String)"bcm_analysishelper", (QFilter[])anlysisCheckBuilder.toArray())) continue;
            QFBuilder periodFilter = new QFBuilder();
            periodFilter.add(modelFilter);
            periodFilter.add(new QFilter("number", "=", (Object)((String)preAnalysis.p2).split("/")[0]));
            DynamicObject period = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,memberform", (QFilter[])periodFilter.toArray());
            QFBuilder periodMemberFilter = new QFBuilder();
            periodMemberFilter.add(new QFilter("number", "=", (Object)((String)preAnalysis.p2).split("/")[1]));
            periodMemberFilter.add(modelFilter);
            DynamicObject periodMember = BusinessDataServiceHelper.loadSingle((String)period.getString("memberform"), (String)"id,name", (QFilter[])periodMemberFilter.toArray());
            DynamicObject newCMPPeriod = AnalysisPageServiceHelper.newCMPPeriod((Tuple<String, String, ILocaleString>)preAnalysis, modelId, catalogRootId, period);
            DynamicObjectCollection dimRange = newCMPPeriod.getDynamicObjectCollection("anaysisdimrange");
            DynamicObject dimRangeRow = new DynamicObject(dimRange.getDynamicObjectType());
            dimRangeRow.set("dimrangevalue", (Object)periodMember.getString("id"));
            dimRangeRow.set("dimrange", (Object)"90");
            dimRangeRow.set("dimentity", (Object)period.getString("memberform"));
            dimRange.add((Object)dimRangeRow);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newCMPPeriod});
        }
    }

    private static DynamicObject newCMPPeriod(Tuple<String, String, ILocaleString> preAnalysis, Long modelId, Long catalogRootId, DynamicObject period) {
        DynamicObject newCMPPeriod = BusinessDataServiceHelper.newDynamicObject((String)"bcm_analysishelper");
        newCMPPeriod.set("number", preAnalysis.p1);
        newCMPPeriod.set("name", preAnalysis.p3);
        newCMPPeriod.set("ispreset", (Object)1);
        newCMPPeriod.set("analysistype", (Object)"1");
        newCMPPeriod.set("model", (Object)modelId);
        newCMPPeriod.set("templatecatalog", (Object)catalogRootId);
        newCMPPeriod.set("status", (Object)"1");
        newCMPPeriod.set("memberinfo", (Object)"");
        newCMPPeriod.set("iscomwithdimlist", (Object)1);
        newCMPPeriod.set("isshowdimlist", (Object)0);
        newCMPPeriod.set("alertnum", (Object)"");
        newCMPPeriod.set("showpredimmember", (Object)12);
        newCMPPeriod.set("serieslimit", (Object)3);
        newCMPPeriod.set("descriprion", (Object)ResManager.getLocaleString((String)"\u9884\u7f6e\u65b9\u6848\u4e0d\u53ef\u4ee5\u4fee\u6539\u3002", (String)"AnalysisPageServiceHelper_7", (String)"fi-bcm-formplugin"));
        Long currentUserId = RequestContext.get().getCurrUserId();
        newCMPPeriod.set("creator", (Object)currentUserId);
        newCMPPeriod.set("modifier", (Object)currentUserId);
        StringBuilder anaysisDim = new StringBuilder();
        anaysisDim.append(period.getString("id"));
        anaysisDim.append('/');
        anaysisDim.append(period.getString("memberform"));
        newCMPPeriod.set("anaysisdim", (Object)anaysisDim.toString());
        return newCMPPeriod;
    }

    public static Long addCatalogRoot(Long modelId) {
        DynamicObject catalog = BusinessDataServiceHelper.newDynamicObject((String)"bcm_anaysiscatalog");
        catalog.set("model", (Object)modelId);
        catalog.set("number", (Object)"root");
        catalog.set("name", (Object)ResManager.getLocaleString((String)"\u65b9\u6848\u5206\u7c7b", (String)"AnaysisHelperSettingPlugin_0", (String)"fi-bcm-formplugin"));
        catalog.set("isleaf", (Object)Boolean.TRUE);
        catalog.set("longnumber", (Object)"root");
        Object[] catalogArray = SaveServiceHelper.save((IDataEntityType)catalog.getDynamicObjectType(), (Object[])new Object[]{catalog});
        if (Objects.nonNull(catalogArray) && catalogArray.length > 0) {
            DynamicObject finalDynamicObject = (DynamicObject)catalogArray[0];
            Long id = finalDynamicObject.getLong("id");
            return id;
        }
        return null;
    }

    public static boolean isNodeReadOnly(Set<String> nodeIds, List<Map<String, String>> treeList, Long modelId, Long userId) {
        ArrayList<Long> readOnlyIds = new ArrayList<Long>(16);
        readOnlyIds.addAll(AnalysisPageServiceHelper.getPermCataLogIds("bcm_anaysiscatalog", modelId, String.valueOf(userId), PROPERRATION));
        for (Map<String, String> next : treeList) {
            if (!nodeIds.contains(next.get("id"))) continue;
            if (readOnlyIds.contains(LongUtil.toLong((Object)next.get("id")))) {
                return true;
            }
            if (!AnalysisPageServiceHelper.hasOnlyReadParentNode(treeList, next, readOnlyIds)) continue;
            return true;
        }
        return false;
    }

    public static List<Long> getPermCataLogIds(String entityName, Long modelId, String userId, String perm) {
        ArrayList<Long> readOnlyPerms = new ArrayList<Long>();
        readOnlyPerms.addAll(PermClassEntityHelper.getPermissionMap((String)entityName, (String)String.valueOf(modelId), (String)userId).get((Object)perm));
        return readOnlyPerms;
    }

    public static boolean hasOnlyReadParentNode(List<Map<String, String>> treeList, Map<String, String> node, List<Long> readOnlyIds) {
        for (Map<String, String> next : treeList) {
            if (!node.get("parentid").equals(next.get("id"))) continue;
            if (readOnlyIds.contains(LongUtil.toLong((Object)next.get("id")))) {
                return true;
            }
            return AnalysisPageServiceHelper.hasOnlyReadParentNode(treeList, next, readOnlyIds);
        }
        return false;
    }

    public static void checkAnalysisHelperMember(Set<String> memberIdList) {
        QFBuilder memberFilter = new QFBuilder();
        memberFilter.add(new QFilter("anaysisdimrange.dimrangevalue", "in", memberIdList));
        if (QueryServiceHelper.exists((String)"bcm_analysishelper", (QFilter[])memberFilter.toArray())) {
            DynamicObject[] relateAnaysisHelper;
            HashSet<Long> entryIdList = new HashSet<Long>(16);
            for (DynamicObject anaysisHelper : relateAnaysisHelper = BusinessDataServiceHelper.load((String)"bcm_analysishelper", (String)"anaysisdimrange.dimrangevalue", (QFilter[])memberFilter.toArray())) {
                DynamicObjectCollection dimRange = anaysisHelper.getDynamicObjectCollection("anaysisdimrange");
                for (DynamicObject range : dimRange) {
                    if (!memberIdList.contains(range.getString("dimrangevalue"))) continue;
                    entryIdList.add(range.getLong("id"));
                }
            }
            DeleteServiceHelper.delete((IDataEntityType)((DynamicObject)relateAnaysisHelper[0].getDynamicObjectCollection("anaysisdimrange").get(0)).getDataEntityType(), (Object[])entryIdList.toArray());
        }
    }

    public static List<Long> sortDimMembers(Long modelId, String entityName, Set<Long> memberIds) {
        QFBuilder detailMemberBuilder = new QFBuilder();
        detailMemberBuilder.add(new QFilter("model", "=", (Object)modelId));
        detailMemberBuilder.add(new QFilter("id", "in", memberIds));
        DynamicObjectCollection detailMembers = QueryServiceHelper.query((String)entityName, (String)"id,longnumber,level,dseq", (QFilter[])detailMemberBuilder.toArray());
        HashSet<String> parentMemberNumber = new HashSet<String>(16);
        for (DynamicObject member : detailMembers) {
            String longNumber = member.getString("longnumber");
            String[] parentNumberArr = longNumber.split("!");
            for (String number : parentNumberArr) {
                parentMemberNumber.add(number);
            }
        }
        QFBuilder parentNumberFilter = new QFBuilder();
        parentNumberFilter.add(new QFilter("model", "=", (Object)modelId));
        parentNumberFilter.add(new QFilter("number", "in", parentMemberNumber));
        DynamicObjectCollection parentNumberMember = QueryServiceHelper.query((String)entityName, (String)"id,parent,dseq,number", (QFilter[])parentNumberFilter.toArray());
        HashMap relationMap = new HashMap(16);
        HashMap<Long, Integer> seqMap = new HashMap<Long, Integer>(16);
        for (DynamicObject member : parentNumberMember) {
            seqMap.put(member.getLong("id"), member.getInt("dseq"));
            Long parentId = member.getLong("parent");
            if (relationMap.get(parentId) != null) {
                ((List)relationMap.get(parentId)).add(member.getLong("id"));
                continue;
            }
            ArrayList<Long> memberList = new ArrayList<Long>(16);
            memberList.add(member.getLong("id"));
            relationMap.put(parentId, memberList);
        }
        HashMap sortRelationMap = new HashMap(16);
        for (Map.Entry entryNode : relationMap.entrySet()) {
            ArrayList seqSortList = new ArrayList(16);
            HashMap seqAlterMap = new HashMap(16);
            for (Long childMemberId : (List)entryNode.getValue()) {
                if (seqMap.get(childMemberId) == null) continue;
                seqSortList.add(seqMap.get(childMemberId));
                seqAlterMap.put(seqMap.get(childMemberId), childMemberId);
            }
            seqSortList.sort(Integer::compareTo);
            ArrayList sortChildList = new ArrayList(16);
            for (Integer seq : seqSortList) {
                sortChildList.add(seqAlterMap.get(seq));
            }
            sortRelationMap.put(entryNode.getKey(), sortChildList);
        }
        Long rootId = 0L;
        ArrayList<Long> sortMemberIds = new ArrayList<Long>(memberIds.size());
        ArrayList<Long> curList = new ArrayList<Long>(16);
        curList.add(rootId);
        while (curList.size() != 0) {
            boolean keyFlag = true;
            if (sortRelationMap.get(rootId) != null) {
                List sortStraightIds = (List)sortRelationMap.get(rootId);
                for (Long straightId : sortStraightIds) {
                    if (!memberIds.contains(straightId)) continue;
                    sortMemberIds.add(straightId);
                }
            } else {
                keyFlag = false;
            }
            if (curList.indexOf(rootId) != curList.size() - 1) {
                Long lastRootId = rootId;
                rootId = (Long)curList.get(curList.indexOf(lastRootId) + 1);
                if (keyFlag) continue;
                curList.remove(lastRootId);
                continue;
            }
            ArrayList newCurList = new ArrayList(16);
            for (Long curLevelNode : curList) {
                if (sortRelationMap.get(curLevelNode) == null) continue;
                newCurList.addAll((Collection)sortRelationMap.get(curLevelNode));
            }
            if (newCurList.size() != 0) {
                rootId = (Long)newCurList.get(0);
            }
            curList.clear();
            curList.addAll(newCurList);
        }
        return sortMemberIds;
    }

    public static DynamicObject getAnalysisDim(Long analysisId) {
        DynamicObject analysisDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisId, (String)"bcm_analysishelper");
        String dimId = analysisDy.getString("anaysisdim").split("/")[0];
        DynamicObject dimDy = BusinessDataServiceHelper.loadSingleFromCache((Object)LongUtil.toLong((Object)dimId), (String)"bcm_dimension");
        return dimDy;
    }
}

