/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.util.LongUtil;

public class AnaysisCatalogEditPlugin
extends AbstractBasePlugIn {
    private static final String MODEL = "model";
    private static final String PARENT = "parent";
    private static final String SEQUENCE = "sequence";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)modelId);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object objModel = map.get(MODEL);
        Object objParent = map.get(PARENT);
        this.getModel().setValue(MODEL, objModel);
        this.getModel().setValue(PARENT, objParent);
        this.getView().setEnable(Boolean.FALSE, new String[]{PARENT});
        int seq = this.getCurNodeSequence(map.get(MODEL).toString(), map.get(PARENT).toString());
        this.getModel().setValue(SEQUENCE, (Object)seq);
    }

    private int getCurNodeSequence(String modelId, String parentId) {
        QFilter model = new QFilter(MODEL, "=", (Object)Long.valueOf(modelId));
        QFilter parent = new QFilter(PARENT, "=", (Object)Long.valueOf(parentId));
        QFilter[] filters = new QFilter[]{model, parent};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)this.getTemplateCataLogEntryEntity(), (String)SEQUENCE, (QFilter[])filters, (String)"sequence desc");
        if (dcs != null && dcs.size() > 0) {
            DynamicObject dyMaxSeq = (DynamicObject)dcs.iterator().next();
            String strSeq = dyMaxSeq.getString(SEQUENCE);
            return (strSeq.isEmpty() ? 0 : Integer.parseInt(strSeq)) + 1;
        }
        return 1;
    }

    public void afterLoadData(EventObject e) {
        Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
        PermClassEntityHelper.loadPermClass((IDataModel)this.getModel(), (Object)modelId, (boolean)false);
        this.getModel().setDataChanged(false);
        Object parentNode = this.getModel().getValue(PARENT);
        if (Objects.isNull(parentNode)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name"});
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{PARENT});
    }

    protected String getTemplateCataLogEntryEntity() {
        return "bcm_anaysiscatalog";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Matcher matcherNumber;
        super.beforeDoOperation(args);
        Object number = this.getModel().getValue("number");
        if (Objects.nonNull(number) && (!(matcherNumber = Pattern.compile("^(?!_)[-a-zA-Z0-9.]+$").matcher(number.toString())).matches() || number.toString().contains("..") || number.toString().startsWith(".") || number.toString().startsWith("-"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"DiscTemplateEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            this.writeLog(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        List ids = e.getOperationResult().getSuccessPkIds();
        HashMap returnData = Maps.newHashMapWithExpectedSize((int)2);
        if (e.getSource() instanceof Save && issuccess) {
            PermClassEntityHelper.savePermClass((IDataModel)this.getModel(), (String)"bcm_anaysiscatalog", (Long)LongUtil.toLong(ids.get(0)), (Object)modelId, (OperationStatus)status);
            returnData.put("ids", ids);
            if ("add".equals(type)) {
                returnData.put("status", OperationStatus.ADDNEW);
            } else if ("edit".equals(type)) {
                returnData.put("status", OperationStatus.EDIT);
            }
            this.writeLog(true);
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        } else {
            this.writeLog(false);
        }
    }

    private void writeLog(boolean isSuccess) {
        String number = "";
        String name = "";
        String openType = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String optionName = "";
        String optionSuccess = "";
        Long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam(MODEL));
        if (this.getModel().getValue("number") != null) {
            number = String.valueOf(this.getModel().getValue("number"));
        }
        if (this.getModel().getValue("name") != null) {
            name = String.valueOf(this.getModel().getValue("name"));
        }
        optionName = "edit".equals(openType) ? ResManager.loadKDString((String)"\u4fee\u6539\u52a9\u624b\u65b9\u6848\u5206\u7c7b", (String)"AnalysisCatalogEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65b0\u589e\u52a9\u624b\u65b9\u6848\u5206\u7c7b", (String)"AnalysisCatalogEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        optionSuccess = isSuccess ? ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"AdjustShareGlobalSettingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"InvrelationSearchSetPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String optionDescrioprion = number + ";" + name + " " + optionSuccess;
        OperationLogUtil.writeOperationLog((String)optionName, (String)optionDescrioprion, (Long)modelId, (String)"bcm_anaysiscatalog");
    }
}

