/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.analysishelper.AnalysisPageServiceHelper;
import kd.fi.bcm.spread.common.util.StringUtil;

public class AnaysisHelperEditPlugin
extends AbstractBaseFormPlugin
implements IBillPlugin,
RowClickEventListener {
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ANALYSISTYPE = "analysistype";
    private static final String ANALYSISDIM = "anaysisdim";
    private static final String DIMMAPINFO = "dimmapinfo";
    private static final String RANGEMEMBERENTRY = "anaysisdimrange";
    private static final String SHOWPREDIMMEMBER = "showpredimmember";
    private static final String SERIESLIMIT = "serieslimit";
    private static final String ALERTNUM = "alertnum";
    private static final int DETIALENTRYMAXSHOW = 200;
    private static final int DETIALENTRYMAX = 200;
    private static final String PERMCLASS = "permclass";
    private static final String DESCRIPTION = "descriprion";
    private static final String ISSHOWDIMLIST = "isshowdimlist";
    private static final String ISCOMWITHDIMLIST = "iscomwithdimlist";
    private static final String ISADDRANGEENYRY = "isaddrangeentry";
    private static final String DATAPAGECACHE = "dataPageCache";
    private static final String PROPORTION_ANALYSISMEMBER_NUM = "12";
    private static final String PROPORTION_SERIES_NUM = "3";

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners("tbmain", "advcontoolbarap", "advcontoolbarap1");
        EntryGrid dimRangeGrid = (EntryGrid)this.getControl(RANGEMEMBERENTRY);
        dimRangeGrid.addRowClickListener((RowClickEventListener)this);
        TextEdit alert = (TextEdit)this.getView().getControl("alertname");
        alert.addClickListener((ClickListener)this);
        Long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getView().getControl(PERMCLASS)), (Object)modelId);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDimCombolEdit();
        this.setShowDimListEnable(Boolean.FALSE);
        this.initButton(Boolean.FALSE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"ispreset"});
    }

    public void afterLoadData(EventObject e) {
        this.initDimCombolEdit();
        this.initRangeMember();
        this.initButton(Boolean.TRUE);
        this.initAlertNum();
        this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"ispreset"});
        this.getModel().setDataChanged(false);
        this.checkIsPreset();
        this.cacheModelData();
        if (this.getModel().getValue(ANALYSISTYPE) != null) {
            this.getView().setEnable(Boolean.valueOf(this.isCompared()), new String[]{"isbling"});
            this.setSeriesLimitAndDitail(this.isCompared());
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        if ("edit".equals(this.getView().getFormShowParameter().getCustomParam("type"))) {
            super.itemClick(evt);
        }
        switch (itemKey = evt.getItemKey()) {
            case "add": {
                String dimType = String.valueOf(this.getModel().getValue(ANALYSISDIM));
                if (StringUtil.isEmptyString((String)dimType) || StringUtil.equals((String)"null", (String)dimType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnaysisHelperEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showMulTiF7();
                break;
            }
            case "bar_save": {
                String perm = this.checkPerm();
                if (!StringUtil.isEmptyString((String)perm)) {
                    this.getView().showTipNotification(perm);
                    return;
                }
                String msg = this.checkMustInput();
                if (!StringUtil.isEmptyString((String)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                if (this.isPlanValid()) {
                    this.saveAnalysisHelper();
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"AnalysisHelperAlertSettingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "delete": {
                this.deleteEntryRow();
                break;
            }
            case "moveup": {
                this.entryRowMoveUp();
                break;
            }
            case "movedown": {
                this.entryRowMovedown();
                break;
            }
            case "movepage": {
                this.openMovePage();
                break;
            }
            case "preview": {
                if (this.getModel().getValue(SHOWPREDIMMEMBER) == null && this.isCompared()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\"\u4ec5\u663e\u793a\u5f53\u524d\u6210\u5458\u524d\"\u3002", (String)"AnaysisHelperEditPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String dimInfo = String.valueOf(this.getModel().getValue(ANALYSISDIM));
                if (this.getModel().getValue(ANALYSISDIM) == null || StringUtil.isEmptyString((String)dimInfo)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\"\u5206\u6790\u7ef4\u5ea6\"\u3002", (String)"AnaysisHelperEditPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.initDetailMember();
                this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
                break;
            }
            case "close": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
                break;
            }
            case "bar_close": {
                if (!this.isDataChange()) {
                    this.getModel().setDataChanged(false);
                }
                this.getView().close();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnData;
        super.closedCallBack(evt);
        if (StringUtil.equals((String)"multiF7", (String)evt.getActionId())) {
            DynamicObjectCollection dimRange;
            Map returnData2 = (Map)evt.getReturnData();
            if (returnData2 != null && "true".equals(returnData2.get("okbtn")) && (dimRange = (DynamicObjectCollection)returnData2.get("doc")) != null && dimRange.size() != 0) {
                this.addAllDimEntryEntity(dimRange);
            }
        } else if (StringUtil.equals((String)"moveDetailPage", (String)evt.getActionId())) {
            List returnData3 = (List)evt.getReturnData();
            if (returnData3 != null) {
                this.rebuildPage(returnData3);
            }
        } else if (StringUtil.equals((String)"alertPage", (String)evt.getActionId()) && (returnData = (Map)evt.getReturnData()) != null && returnData.size() != 0) {
            String saveResult = (String)returnData.get("saveResult");
            String displayResult = (String)returnData.get("displayResult");
            this.getModel().setValue("alertname", (Object)displayResult);
            this.getModel().setValue(ALERTNUM, (Object)saveResult);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "anaysisdim": {
                this.clearEntryEntity();
                break;
            }
            case "iscomwithdimlist": {
                String iscomwithdimlist = String.valueOf(this.getModel().getValue(ISCOMWITHDIMLIST));
                if (StringUtil.equals((String)"true", (String)iscomwithdimlist)) {
                    this.setShowDimListEnable(Boolean.TRUE);
                    break;
                }
                this.getModel().setValue(ISSHOWDIMLIST, (Object)false);
                this.setShowDimListEnable(Boolean.FALSE);
                break;
            }
            case "analysistype": {
                String analysistype = String.valueOf(this.getModel().getValue(ANALYSISTYPE));
                if (StringUtil.equals((String)"2", (String)analysistype)) {
                    this.getModel().setValue(ISCOMWITHDIMLIST, (Object)true);
                    this.getView().setEnable(Boolean.FALSE, new String[]{ISCOMWITHDIMLIST});
                    this.setBlingMember(false);
                    this.setSeriesLimitAndDitail(false);
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{ISCOMWITHDIMLIST});
                    this.setBlingMember(true);
                    this.setSeriesLimitAndDitail(true);
                }
                this.getModel().setValue("alertname", (Object)"");
                this.getModel().setValue(ALERTNUM, (Object)"");
                break;
            }
            case "alertname": {
                String alertname = String.valueOf(this.getModel().getValue("alertname"));
                if (!StringUtil.isEmptyString((String)alertname)) break;
                this.getModel().setValue(ALERTNUM, null);
                break;
            }
        }
    }

    private String checkMustInput() {
        String msg = "";
        String number = String.valueOf(this.getModel().getValue(NUMBER));
        if (StringUtil.isEmptyString((String)number)) {
            msg = ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnaysisHelperEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return msg;
        }
        String name = String.valueOf(this.getModel().getValue(NAME));
        if (StringUtil.isEmptyString((String)name)) {
            msg = ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnaysisHelperEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return msg;
        }
        if (this.getModel().getValue(ANALYSISTYPE) == null) {
            msg = ResManager.loadKDString((String)"\u5206\u6790\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnaysisHelperEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return msg;
        }
        String dimType = String.valueOf(this.getModel().getValue(ANALYSISDIM));
        if (StringUtil.isEmptyString((String)dimType)) {
            msg = ResManager.loadKDString((String)"\u5206\u6790\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnaysisHelperEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return msg;
        }
        String isShowDimPre = String.valueOf(this.getModel().getValue(SHOWPREDIMMEMBER));
        if (StringUtil.isEmptyString((String)isShowDimPre) && this.isCompared()) {
            msg = ResManager.loadKDString((String)"\"\u4ec5\u663e\u793a\u5f53\u524d\u6210\u5458\u524d\"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnaysisHelperEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return msg;
        }
        String seriesLimit = String.valueOf(this.getModel().getValue(SERIESLIMIT));
        if (StringUtil.isEmptyString((String)seriesLimit) && this.isCompared()) {
            msg = ResManager.loadKDString((String)"\"\u7cfb\u5217\u6570\u91cf\u9650\u5236\"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnaysisHelperEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return msg;
        }
        DynamicObjectCollection analysisMemberData = this.getModel().getEntryEntity(RANGEMEMBERENTRY);
        if (analysisMemberData == null || analysisMemberData.size() == 0) {
            msg = ResManager.loadKDString((String)"\u5206\u6790\u7ef4\u6210\u5458\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnaysisHelperEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return msg;
        }
        Matcher matcherNumber = Pattern.compile("^(?!_)[-a-zA-Z0-9.]+$").matcher(number);
        if (!matcherNumber.matches() || number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
            msg = ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"DiscTemplateEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    @Override
    public void click(EventObject evt) {
        String opkey;
        switch (opkey = ((Control)evt.getSource()).getKey()) {
            case "alertname": {
                if (this.getModel().getValue(ANALYSISTYPE) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u7c7b\u578b\u3002", (String)"AnalysisHelperAlertSettingPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openAlertChoosePage();
                break;
            }
        }
    }

    private void openAlertChoosePage() {
        String alertValue = String.valueOf(this.getModel().getValue(ALERTNUM));
        String analysisType = String.valueOf(this.getModel().getValue(ANALYSISTYPE));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("bcm_alertfilter_entry");
        formShowParameter.setCustomParam(ALERTNUM, (Object)alertValue);
        formShowParameter.setCustomParam(ANALYSISTYPE, (Object)analysisType);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "alertPage"));
        this.getView().showForm(formShowParameter);
    }

    private boolean isPlanValid() {
        DynamicObject analysisDy = this.getModel().getDataEntity();
        Long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        QFilter qFilter = new QFilter("model", "=", (Object)modelId).and(new QFilter(NUMBER, "=", (Object)analysisDy.getString(NUMBER)).or(new QFilter(NAME, "=", (Object)analysisDy.getString(NAME))));
        if (this.isAdd()) {
            boolean exists = QueryServiceHelper.exists((String)"bcm_analysishelper", (QFilter[])new QFilter[]{qFilter});
            if (exists) {
                return false;
            }
        } else {
            List ids = QueryServiceHelper.query((String)"bcm_analysishelper", (String)"id", (QFilter[])new QFilter[]{qFilter}).stream().map(v -> v.getLong("id")).distinct().collect(Collectors.toList());
            if (ids.size() >= 2) {
                return false;
            }
            if (ids.size() == 1) {
                return ((Long)ids.get(0)).longValue() == analysisDy.getLong("id");
            }
        }
        return true;
    }

    private boolean isAdd() {
        DynamicObject analysisDy = this.getModel().getDataEntity();
        return StringUtil.isEmptyString((String)analysisDy.getString("id")) || analysisDy.getLong("id") == 0L;
    }

    private void saveAnalysisHelper() {
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject analysisDy = this.getModel().getDataEntity();
                Long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
                analysisDy.set("model", (Object)modelId);
                if (StringUtil.isEmptyString((String)analysisDy.getString("id")) || analysisDy.getLong("id") == 0L) {
                    analysisDy.set("status", (Object)"0");
                    analysisDy.set("templatecatalog", this.getView().getFormShowParameter().getCustomParam("template"));
                }
                if (!this.isCompared()) {
                    analysisDy.set(SHOWPREDIMMEMBER, (Object)Integer.parseInt(PROPORTION_ANALYSISMEMBER_NUM));
                    analysisDy.set(SERIESLIMIT, (Object)Integer.parseInt(PROPORTION_SERIES_NUM));
                }
                analysisDy.set(RANGEMEMBERENTRY, (Object)this.getModel().getEntryEntity(RANGEMEMBERENTRY));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{analysisDy});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AnaysisHelperEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                PermClassEntityHelper.savePermClass((DynamicObject)analysisDy);
                this.getView().getPageCache().remove(ISADDRANGEENYRY);
                this.cacheModelData();
                this.writeLog(true);
            }
            catch (Throwable e) {
                this.writeLog(false);
                tx.markRollback();
                throw new KDBizException(ThrowableHelper.toString((Throwable)e));
            }
        }
    }

    private void showMulTiF7() {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bcm_multiplememberf7b_per");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("KEY_MODEL_ID", this.getView().getFormShowParameter().getCustomParam("model"));
        para.setCustomParam("dimensionid", (Object)String.valueOf(this.getModel().getValue(ANALYSISDIM)).split("/")[0]);
        Long dimensionid = LongUtil.toLong((Object)String.valueOf(this.getModel().getValue(ANALYSISDIM)).split("/")[0]);
        DynamicObject dimension = BusinessDataServiceHelper.loadSingle((Object)dimensionid, (String)"bcm_dimension");
        String pageName = String.format(ResManager.loadKDString((String)"%s-\u6210\u5458\u9009\u62e9", (String)"AnaysisHelperEditPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimension.getLocaleString(NAME).getLocaleValue());
        para.setCaption(pageName);
        Map diminfo = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(DIMMAPINFO), Map.class);
        String desq = (String)diminfo.get(String.valueOf(this.getModel().getValue(ANALYSISDIM)).split("/")[0]);
        para.setCustomParam("dimension", (Object)desq);
        para.setCustomParam("cvtCurrencySet", (Object)"true");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "multiF7");
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private void initDimCombolEdit() {
        Long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        String dimSelectField = "id,name,dseq,memberform";
        QFilter dimFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject[] dimCollection = BusinessDataServiceHelper.load((String)"bcm_dimension", (String)dimSelectField, (QFilter[])new QFilter[]{dimFilter}, (String)"dseq");
        ComboEdit dimComboEdit = (ComboEdit)this.getControl(ANALYSISDIM);
        ArrayList<ComboItem> fieldData = new ArrayList<ComboItem>(16);
        HashMap<String, String> dimMap = new HashMap<String, String>(dimCollection.length);
        for (DynamicObject dim : dimCollection) {
            StringBuilder dimInfo = new StringBuilder(dim.getString("id"));
            dimInfo.append("/");
            dimInfo.append(dim.getString("memberform"));
            ComboItem comboItem = new ComboItem(new LocaleString(dim.getString(NAME)), dimInfo.toString());
            fieldData.add(comboItem);
            dimMap.put(dim.getString("id"), dim.getString("dseq"));
        }
        dimComboEdit.setComboItems(fieldData);
        this.getPageCache().put(DIMMAPINFO, SerializationUtils.toJsonString(dimMap));
    }

    private void addAllDimEntryEntity(DynamicObjectCollection dimRange) {
        DynamicObjectCollection curDy = this.getModel().getEntryEntity(RANGEMEMBERENTRY);
        int curSize = curDy.size();
        HashSet<String> curRangeList = new HashSet<String>(curDy.size());
        for (DynamicObject cd : curDy) {
            StringBuilder dimRangeValue = new StringBuilder(cd.getString("dimrangevalue"));
            dimRangeValue.append("_");
            dimRangeValue.append(cd.getString("dimrange"));
            curRangeList.add(dimRangeValue.toString());
        }
        String dimInfo = String.valueOf(this.getModel().getValue(ANALYSISDIM));
        String dimEntity = "";
        if (StringUtils.isNotEmpty((CharSequence)dimInfo)) {
            dimEntity = dimInfo.split("/").length == 2 ? dimInfo.split("/")[1] : "";
        }
        for (DynamicObject dim : dimRange) {
            if (curSize >= 200) break;
            StringBuilder dimRangeValue = new StringBuilder(dim.getString("mid1"));
            dimRangeValue.append("_");
            dimRangeValue.append(dim.getString("filltypevalue1"));
            if (curRangeList.contains(dimRangeValue.toString())) continue;
            int index = this.getModel().createNewEntryRow(RANGEMEMBERENTRY);
            this.getModel().setValue("dimrange", (Object)dim.getString("filltypevalue1"), index);
            this.getModel().setValue("dimrangevalue", (Object)dim.getString("mid1"), index);
            this.getModel().setValue("dimname", (Object)new LocaleString(dim.getString("mname1")), index);
            this.getModel().setValue("dimnumber", (Object)dim.getString("mnum1"), index);
            this.getModel().setValue("dimentity", (Object)dimEntity, index);
            ++curSize;
        }
        this.getView().getPageCache().put(ISADDRANGEENYRY, "true");
    }

    private void deleteEntryRow() {
        EntryGrid reportNameEntry = (EntryGrid)this.getView().getControl(RANGEMEMBERENTRY);
        if (reportNameEntry.getSelectRows().length != 0) {
            int row = reportNameEntry.getSelectRows()[0];
            this.getModel().deleteEntryRow(RANGEMEMBERENTRY, row);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"DiscTemplateEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.getModel().deleteEntryData("anaysismember");
    }

    private void clearEntryEntity() {
        this.getModel().deleteEntryData(RANGEMEMBERENTRY);
        this.getModel().deleteEntryData("anaysismember");
    }

    private void initRangeMember() {
        DynamicObjectCollection rangeDyn = this.getModel().getEntryEntity(RANGEMEMBERENTRY);
        HashSet<Long> memberIdSet = new HashSet<Long>(rangeDyn.size());
        for (DynamicObject dimRange : rangeDyn) {
            String dimRangeValue = dimRange.getString("dimrangevalue");
            memberIdSet.add(LongUtil.toLong((Object)dimRangeValue));
        }
        String dimInfo = String.valueOf(this.getModel().getValue(ANALYSISDIM));
        Map memberMapSet = BusinessDataServiceHelper.loadFromCache((String)dimInfo.split("/")[1], (String)NUMBER, (QFilter[])new QFilter[]{new QFilter("id", "in", memberIdSet)});
        int index = 0;
        for (DynamicObject dimRange : rangeDyn) {
            String dimRangeValue = dimRange.getString("dimrangevalue");
            if (!memberMapSet.containsKey(LongUtil.toLong((Object)dimRangeValue.split("_")[0]))) continue;
            DynamicObject memberRangeDy = (DynamicObject)memberMapSet.get(LongUtil.toLong((Object)dimRangeValue.split("_")[0]));
            String name = memberRangeDy.getString(NAME);
            String number = memberRangeDy.getString(NUMBER);
            this.getModel().setValue("dimnumber", (Object)number, index);
            this.getModel().setValue("dimname", (Object)name, index);
            ++index;
        }
    }

    private void initDetailMember() {
        this.getModel().deleteEntryData("anaysismember");
        int maxMember = this.getModel().getValue(SHOWPREDIMMEMBER) == null ? 12 : (Integer)this.getModel().getValue(SHOWPREDIMMEMBER);
        String dimInfo = String.valueOf(this.getModel().getValue(ANALYSISDIM));
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("model");
        String entityName = dimInfo.split("/")[1];
        DynamicObjectCollection memberDys = this.getModel().getEntryEntity(RANGEMEMBERENTRY);
        HashSet<Long> memberIds = new HashSet<Long>(memberDys.size());
        int index = 0;
        HashMap<Integer, Object> indexSortMap = new HashMap<Integer, Object>(16);
        HashSet repeatMemberids = new HashSet(16);
        for (DynamicObject memberDy : memberDys) {
            int range = Integer.parseInt(memberDy.getString("dimrange"));
            Long memberId = LongUtil.toLong((Object)memberDy.getString("dimrangevalue"));
            HashSet<Long> curMemeberIds = new HashSet<Long>(16);
            if (range == 10) {
                curMemeberIds.add(memberId);
            } else {
                curMemeberIds.addAll(QueryMemberDetailsHelper.queryMemberIdsByRange((String)entityName, (Long)memberId, (int)range, (String)modelId, (DetailTypeEnum)DetailTypeEnum.OTHERS));
            }
            curMemeberIds.removeAll(repeatMemberids);
            repeatMemberids.addAll(curMemeberIds);
            if (memberIds.size() < maxMember) {
                if (indexSortMap.get(index) != null) {
                    ((Set)indexSortMap.get(index)).addAll(curMemeberIds);
                } else {
                    indexSortMap.put(index, curMemeberIds);
                }
            }
            memberIds.addAll((Collection<Long>)curMemeberIds);
            ++index;
        }
        ArrayList<Long> finalDyList = new ArrayList<Long>(maxMember);
        List<Long> sortMemberIds = AnalysisPageServiceHelper.sortDimMembers(LongUtil.toLong((Object)modelId), entityName, memberIds);
        block1: for (int desq = 0; desq < indexSortMap.size(); ++desq) {
            Set curDesqMemberIds = (Set)indexSortMap.get(desq);
            if (curDesqMemberIds.size() == 1) {
                if (finalDyList.size() >= maxMember) break;
                finalDyList.addAll(curDesqMemberIds);
                continue;
            }
            for (Long l : sortMemberIds) {
                if (!curDesqMemberIds.contains(l)) continue;
                if (finalDyList.size() >= maxMember) continue block1;
                finalDyList.add(l);
            }
        }
        QFBuilder memberFilter = new QFBuilder();
        memberFilter.add(new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId)));
        memberFilter.add(new QFilter("id", "in", finalDyList));
        Map curMemberDynMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])memberFilter.toArray());
        DynamicObjectCollection curMemberDyn = new DynamicObjectCollection();
        for (Long curId : finalDyList) {
            curMemberDyn.add(curMemberDynMap.get(curId));
        }
        memberIds.removeAll(finalDyList);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entityName, (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", memberIds)});
        curMemberDyn.addAll((Collection)dynamicObjectCollection);
        if (curMemberDyn.size() != 0) {
            int entryRow = curMemberDyn.size();
            if (curMemberDyn.size() > 200) {
                entryRow = 200;
            }
            this.getModel().batchCreateNewEntryRow("anaysismember", entryRow);
            int rowindex = 0;
            for (DynamicObject dy : curMemberDyn) {
                if (rowindex >= 200) break;
                this.getModel().setValue("detailmember", (Object)dy.getString(NAME), rowindex);
                this.getModel().setValue("detailmembernumber", (Object)dy.getString(NUMBER), rowindex);
                ++rowindex;
            }
        }
    }

    private void entryRowMoveUp() {
        EntryGrid reportNameEntry = (EntryGrid)this.getView().getControl(RANGEMEMBERENTRY);
        if (reportNameEntry.getSelectRows().length != 0) {
            int row = reportNameEntry.getSelectRows()[0];
            if (row != 0) {
                this.getModel().moveEntryRowUp(RANGEMEMBERENTRY, row);
                this.getView().updateView(RANGEMEMBERENTRY);
                reportNameEntry.selectRows(row - 1);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u5df2\u7ecf\u662f\u7b2c\u4e00\u884c\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"DiscTemplateEditPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"DiscTemplateEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void entryRowMovedown() {
        EntryGrid reportNameEntry = (EntryGrid)this.getView().getControl(RANGEMEMBERENTRY);
        if (reportNameEntry.getSelectRows().length != 0) {
            int row = reportNameEntry.getSelectRows()[0];
            int rowCount = this.getModel().getEntryRowCount(RANGEMEMBERENTRY);
            if (rowCount - 1 > row) {
                this.getModel().moveEntryRowDown(RANGEMEMBERENTRY, row);
                this.getView().updateView(RANGEMEMBERENTRY);
                reportNameEntry.selectRows(row + 1);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u884c\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"DiscTemplateEditPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"DiscTemplateEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void openMovePage() {
        Long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        DynamicObjectCollection detailMember = this.getModel().getEntryEntity(RANGEMEMBERENTRY);
        List detailMemberList = detailMember.stream().map(mem -> Pair.onePair((Object)(mem.getString("dimrangevalue") + "_" + mem.getString("dimrange")), (Object)(mem.getString("dimnumber") + " | " + mem.getString("dimname")))).collect(Collectors.toList());
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("bcm_analysis_membermove");
        formShowParameter.setCustomParam("entry", (Object)SerializationUtils.toJsonString(detailMemberList));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "moveDetailPage"));
        this.getView().showForm(formShowParameter);
    }

    private void rebuildPage(List<Pair<Long, String>> returnData) {
        this.getModel().deleteEntryData(RANGEMEMBERENTRY);
        this.getModel().batchCreateNewEntryRow(RANGEMEMBERENTRY, returnData.size());
        int rowindex = 0;
        for (Pair<Long, String> data : returnData) {
            String nameInfo = String.valueOf(data.p1);
            this.getModel().setValue("dimrange", (Object)nameInfo.split("_")[1], rowindex);
            this.getModel().setValue("dimname", (Object)((String)data.p2).split(" \\| ")[1], rowindex);
            this.getModel().setValue("dimnumber", (Object)((String)data.p2).split(" \\| ")[0], rowindex);
            this.getModel().setValue("dimrangevalue", (Object)nameInfo.split("_")[0], rowindex);
            ++rowindex;
        }
    }

    private void setShowDimListEnable(Boolean enable) {
        this.getView().setEnable(enable, new String[]{ISSHOWDIMLIST});
    }

    private void initButton(Boolean isEdit) {
        if (isEdit.booleanValue() && !Boolean.parseBoolean(String.valueOf(this.getModel().getValue(ISCOMWITHDIMLIST)))) {
            this.setShowDimListEnable(Boolean.FALSE);
        }
        if (isEdit.booleanValue() && StringUtil.equals((String)"2", (String)String.valueOf(this.getModel().getValue(ANALYSISTYPE)))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ISCOMWITHDIMLIST});
        }
        if (!isEdit.booleanValue()) {
            this.setShowDimListEnable(Boolean.FALSE);
        }
        if (isEdit.booleanValue() && Boolean.parseBoolean(String.valueOf(this.getModel().getValue("ispreset")))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_save"});
        }
    }

    private void initAlertNum() {
        String alertNum = String.valueOf(this.getModel().getValue(ALERTNUM));
        if (!StringUtil.isEmptyString((String)alertNum)) {
            String[] alertNumStr = alertNum.split(";");
            StringBuilder disPlayAlert = new StringBuilder();
            for (String alertNums : alertNumStr) {
                String alertCondition = "";
                if (alertNums.contains(">")) {
                    alertCondition = ">";
                } else if (alertNums.contains("<")) {
                    alertCondition = "<";
                } else if (alertNums.contains(":")) {
                    alertCondition = ":";
                } else if (alertNums.contains("!")) {
                    alertCondition = "!";
                } else if (alertNums.contains("=")) {
                    alertCondition = "=";
                }
                String[] alertSplit = alertNums.split(alertCondition);
                disPlayAlert.append(AnalysisPageServiceHelper.mapAlertValue(alertSplit[0]));
                disPlayAlert.append(AnalysisPageServiceHelper.mapAlertValue(alertCondition));
                disPlayAlert.append(alertSplit[1]);
                disPlayAlert.append(' ');
                disPlayAlert.append(AnalysisPageServiceHelper.mapAlertValue(";"));
            }
            this.getModel().setValue("alertname", (Object)disPlayAlert.toString());
        }
    }

    private void checkIsPreset() {
        String ispreset = String.valueOf(this.getModel().getValue("ispreset"));
        if (StringUtil.equals((String)"true", (String)ispreset)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"baseinfo", "flexpanelap4", "flexpanelap7", "add", "delete", "moveup", "movedown", "movepage", "flexpanelap2", "flexpanelap3"});
        }
    }

    private String checkPerm() {
        List treeList = (List)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("treelist")), List.class);
        Long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        String nodeId = (String)this.getView().getFormShowParameter().getCustomParam("template");
        String openType = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String msg = "";
        if (StringUtil.equals((String)"addnew", (String)openType)) {
            return msg;
        }
        HashSet<String> nodeIds = new HashSet<String>(16);
        nodeIds.add(nodeId);
        if (treeList != null && treeList.size() != 0) {
            boolean isCataLogOnlyRead = AnalysisPageServiceHelper.isNodeReadOnly(nodeIds, treeList, modelId, this.getUserId());
            if (isCataLogOnlyRead) {
                msg = ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u6ca1\u6709\u8bfb\u5199\u6743\u9650\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"AnaysisHelperEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            } else {
                ArrayList noPermIds = new ArrayList(16);
                boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
                if (adminUserBol) {
                    return msg;
                }
                ArrayListMultimap permMap = PermClassEntityHelper.getPermissionMap((String)"bcm_analysishelper", (String)String.valueOf(modelId), (String)String.valueOf(this.getUserId()));
                noPermIds.addAll(permMap.get((Object)"2"));
                noPermIds.addAll(permMap.get((Object)"1"));
                Long id = LongUtil.toLong((Object)this.getModel().getValue("id"));
                if (noPermIds.contains(id)) {
                    msg = ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u6ca1\u6709\u8bfb\u5199\u6743\u9650\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"AnaysisHelperEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
            }
        }
        return msg;
    }

    private void cacheModelData() {
        HashMap<String, String> checkData = new HashMap<String, String>(16);
        checkData.put(NUMBER, null);
        checkData.put(NAME, null);
        checkData.put(PERMCLASS, null);
        checkData.put(DESCRIPTION, null);
        checkData.put(ANALYSISTYPE, null);
        checkData.put(ISCOMWITHDIMLIST, null);
        checkData.put(ISSHOWDIMLIST, null);
        checkData.put(SHOWPREDIMMEMBER, null);
        checkData.put(SERIESLIMIT, null);
        checkData.put(ALERTNUM, null);
        checkData.put(ANALYSISDIM, null);
        if (this.getModel().getValue(NUMBER) != null) {
            String number = String.valueOf(this.getModel().getValue(NUMBER));
            checkData.put(NUMBER, number);
        }
        if (this.getModel().getValue(NAME) != null) {
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue(NAME);
            checkData.put(NAME, name.getLocaleValue());
        }
        if (this.getModel().getValue(PERMCLASS) != null) {
            String permclassId = ((DynamicObject)this.getModel().getValue(PERMCLASS)).getString("id");
            checkData.put(PERMCLASS, permclassId);
        }
        if (this.getModel().getValue(DESCRIPTION) != null) {
            OrmLocaleValue descriprion = (OrmLocaleValue)this.getModel().getValue(DESCRIPTION);
            checkData.put(DESCRIPTION, descriprion.getLocaleValue());
        }
        if (this.getModel().getValue(ANALYSISTYPE) != null) {
            String analysisType = String.valueOf(this.getModel().getValue(ANALYSISTYPE));
            checkData.put(ANALYSISTYPE, analysisType);
        }
        if (this.getModel().getValue(ISCOMWITHDIMLIST) != null) {
            String iscomwithdimlist = String.valueOf(this.getModel().getValue(ISCOMWITHDIMLIST));
            checkData.put(ISCOMWITHDIMLIST, iscomwithdimlist);
        }
        if (this.getModel().getValue(ISSHOWDIMLIST) != null) {
            String isShowDimList = String.valueOf(this.getModel().getValue(ISSHOWDIMLIST));
            checkData.put(ISSHOWDIMLIST, isShowDimList);
        }
        if (this.getModel().getValue(SHOWPREDIMMEMBER) != null) {
            String showpredimmember = String.valueOf(this.getModel().getValue(SHOWPREDIMMEMBER));
            checkData.put(SHOWPREDIMMEMBER, showpredimmember);
        } else if (!this.isCompared()) {
            checkData.put(SHOWPREDIMMEMBER, PROPORTION_ANALYSISMEMBER_NUM);
        }
        if (this.getModel().getValue(SERIESLIMIT) != null) {
            String serieslimit = String.valueOf(this.getModel().getValue(SERIESLIMIT));
            checkData.put(SERIESLIMIT, serieslimit);
        } else if (!this.isCompared()) {
            checkData.put(SERIESLIMIT, PROPORTION_SERIES_NUM);
        }
        if (this.getModel().getValue(ALERTNUM) != null) {
            String alertnum = String.valueOf(this.getModel().getValue(ALERTNUM));
            checkData.put(ALERTNUM, alertnum);
        }
        if (this.getModel().getValue(ANALYSISDIM) != null) {
            String analysisDim = String.valueOf(this.getModel().getValue(ANALYSISDIM));
            checkData.put(ANALYSISDIM, analysisDim);
        }
        String dataStr = SerializationUtils.toJsonString(checkData);
        this.getView().getPageCache().put(DATAPAGECACHE, dataStr);
    }

    private boolean isDataChange() {
        String dataStr = this.getView().getPageCache().get(DATAPAGECACHE);
        if (dataStr != null) {
            Map checkData = (Map)SerializationUtils.fromJsonString((String)dataStr, Map.class);
            for (Map.Entry data : checkData.entrySet()) {
                if (this.getModel().getValue((String)data.getKey()) == null) continue;
                String curValue = "";
                curValue = NAME.equals(data.getKey()) || DESCRIPTION.equals(data.getKey()) ? ((OrmLocaleValue)this.getModel().getValue((String)data.getKey())).getLocaleValue() : (PERMCLASS.equals(data.getKey()) ? ((DynamicObject)this.getModel().getValue((String)data.getKey())).getString("id") : String.valueOf(this.getModel().getValue((String)data.getKey())));
                if (!Objects.nonNull(curValue) || curValue.equals(data.getValue())) continue;
                return true;
            }
            if ("true".equals(this.getView().getPageCache().get(ISADDRANGEENYRY))) {
                return true;
            }
        }
        return false;
    }

    private void writeLog(boolean isSuccess) {
        String number = "";
        String name = "";
        String openType = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String optionName = "";
        String optionSuccess = "";
        Long modelId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        if (this.getModel().getValue(NUMBER) != null) {
            number = String.valueOf(this.getModel().getValue(NUMBER));
        }
        if (this.getModel().getValue(NAME) != null) {
            name = String.valueOf(this.getModel().getValue(NAME));
        }
        optionName = "edit".equals(openType) ? ResManager.loadKDString((String)"\u4fee\u6539\u5206\u6790\u65b9\u6848", (String)"AnaysisHelperEditPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65b0\u589e\u5206\u6790\u65b9\u6848", (String)"AnaysisHelperEditPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        optionSuccess = isSuccess ? ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"AdjustShareGlobalSettingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"InvrelationSearchSetPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String optionDescrioprion = number + ";" + name + " " + optionSuccess;
        OperationLogUtil.writeOperationLog((String)optionName, (String)optionDescrioprion, (Long)modelId, (String)"bcm_analysishelper");
    }

    private void setBlingMember(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"isbling"});
        this.getModel().setValue("isbling", (Object)(flag ? "1" : "0"));
    }

    private void setSeriesLimitAndDitail(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{SHOWPREDIMMEMBER});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{SERIESLIMIT});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{ISSHOWDIMLIST});
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{SHOWPREDIMMEMBER});
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{SERIESLIMIT});
        if (!flag) {
            this.getModel().setValue(SHOWPREDIMMEMBER, null);
            this.getModel().setValue(SERIESLIMIT, null);
        }
    }

    private boolean isCompared() {
        return !StringUtils.equals((CharSequence)"2", (CharSequence)String.valueOf(this.getModel().getValue(ANALYSISTYPE)));
    }
}

