/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.analysishelper.AnalysisPageServiceHelper;
import kd.fi.bcm.formplugin.template.AbstractTemplateTreePlugin;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.TemplateConstant;
import kd.fi.bcm.spread.common.util.StringUtil;

public class AnaysisHelperSettingPlugin
extends AbstractTemplateTreePlugin {
    private static final String BILL_LIST_AP = "billlistap";
    private static final String ADDNEWANALYSISHELPER = "addnewanalysis";
    private static final String DELETEANALYSISHELPER = "deleteAnalysisHelper";
    private static final String TREENODEID = "focusnodeid";
    private static final String READONLY = "readOnlyList";
    private static final String TREENODEPERM = "treenodeperm";

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.setBillFormId("bcm_analysishelper");
        billList.addHyperClickListener(this::hyperLinkClick);
        billList.addSetFilterListener(this::setFilter);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl("templatecatalog");
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                AnaysisHelperSettingPlugin.this.cacheTreeNodePerm(evt.getNodeId().toString());
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        String userSelectModel = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model");
        if (Objects.isNull(userSelectModel) || "O".equals(userSelectModel)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AnaysisHelperSettingPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = Long.parseLong(userSelectModel);
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", userSelectModel);
        AnalysisPageServiceHelper.initStaticAnalysisTemp(modelId);
        super.afterCreateNewData(e);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String opKey;
        super.itemClick(evt);
        switch (opKey = evt.getItemKey()) {
            case "bar_add": {
                if (this.getPageCache().get(TREENODEID) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u5206\u7c7b\u3002", (String)"AnaysisHelperSettingPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showAnaysisHelper();
                break;
            }
            case "bar_refresh": {
                this.refrushTree();
                this.refreshPermCache();
                this.refrushBillList();
                break;
            }
            case "move": {
                this.showMovePage();
                break;
            }
            case "bar_enable": {
                this.setStatus(true);
                break;
            }
            case "bar_disable": {
                this.setDisable();
                break;
            }
            case "bar_delete": {
                this.deleteAnalysisHelperConfirm();
                break;
            }
            case "bar_copy": {
                this.copyTempalte();
                this.refrushBillList();
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String nodeId = this.getPageCache().get(TREENODEID);
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "deletecatalog": {
                if (Objects.isNull(nodeId)) {
                    return;
                }
                if (StringUtils.equals((CharSequence)nodeId, (CharSequence)this.getPageCache().get("headnodeid"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"AbstractTemplateTreePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u65b9\u6848\u5206\u7c7b\u88ab\u5220\u9664\u540e\uff0c\u8be5\u5206\u7c7b\u4e0b\u7684\u65b9\u6848\u5c06\u79fb\u81f3\u5176\u76f4\u63a5\u4e0a\u7ea7\u65b9\u6848\u5206\u7c7b\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"AnaysisHelperSettingPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deletecatalog_comfirm", (IFormPlugin)this));
                break;
            }
        }
    }

    private void setDisable() {
        Object[] selectedIds = this.getSelectedIds();
        if (selectedIds != null && selectedIds.length > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u7981\u7528\uff1f", (String)"AnaysisHelperSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("disable_comfirm", (IFormPlugin)this));
        }
    }

    private void setStatus(boolean status) {
        DynamicObject[] tempObjs = this.getSelectedPlan(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"AnaysisHelperSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (tempObjs != null) {
            if (tempObjs.length > 1) {
                for (DynamicObject tempObj : tempObjs) {
                    tempObj.set("status", (Object)(status ? "1" : "0"));
                }
            } else if (tempObjs.length == 1) {
                if (status && tempObjs[0].getBoolean("status")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u52a9\u624b\u65b9\u6848\u201c%s\u201d\u5df2\u542f\u7528\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\u3002", (String)"AnaysisHelperSettingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[]{tempObjs[0].getString("number")}));
                    return;
                }
                if (!status && !tempObjs[0].getBoolean("status")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u52a9\u624b\u65b9\u6848\u201c%s\u201d\u5df2\u7981\u7528\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\u3002", (String)"AnaysisHelperSettingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[]{tempObjs[0].getString("number")}));
                    return;
                }
                tempObjs[0].set("status", (Object)(status ? "1" : "0"));
            }
            SaveServiceHelper.save((DynamicObject[])tempObjs);
            this.showNotifiction(status, tempObjs);
            this.refrushBillList();
        }
    }

    private void showNotifiction(boolean status, DynamicObject[] tempObjs) {
        if (status) {
            this.writeLog(Arrays.asList(tempObjs), ResManager.loadKDString((String)"\u542f\u7528", (String)"TemplateListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"AnaysisHelperSettingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"AnaysisHelperSettingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            this.writeLog(Arrays.asList(tempObjs), ResManager.loadKDString((String)"\u7981\u7528", (String)"TemplateListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"AnaysisHelperSettingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"AnaysisHelperSettingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    protected DynamicObject[] getSelectedPlan(String noSelectedMsg) {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (billList.getSelectedRows().size() == 0) {
            if (StringUtils.isNotEmpty((CharSequence)noSelectedMsg)) {
                this.getView().showTipNotification(noSelectedMsg);
            }
            return null;
        }
        return BusinessDataServiceHelper.load((Object[])billList.getSelectedRows().getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "bcm_anaysiscatalog": {
                Map returnData = (Map)evt.getReturnData();
                if (Objects.nonNull(returnData) && !returnData.isEmpty()) {
                    OperationStatus status = (OperationStatus)returnData.get("status");
                    List ids = (List)returnData.get("ids");
                    if (ids != null && ids.size() > 0) {
                        this.refrushTree();
                        String nodeid = ids.get(0).toString();
                        List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
                        for (Map m : treeList) {
                            if (!nodeid.equals(m.get("id"))) continue;
                            TreeNode node = new TreeNode((String)m.get("parentid"), (String)m.get("id"), (String)m.get("name"));
                            ((TreeView)this.getControl("templatecatalog")).focusNode(node);
                            this.getPageCache().put(TREENODEID, nodeid);
                            this.getPageCache().put("parent", (String)m.get("parentid"));
                        }
                        if (OperationStatus.EDIT == status) {
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"AbstractTemplateTreePlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        } else if (OperationStatus.ADDNEW == status) {
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f\u3002", (String)"AbstractTemplateTreePlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        }
                    }
                }
                this.refrushBillList();
                break;
            }
            case "bcm_templatemove": {
                if (!Objects.nonNull(evt.getReturnData())) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u6210\u529f\u3002", (String)"AnaysisHelperSettingPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.refrushBillList();
                break;
            }
            case "addnewanalysis": 
            case "bcm_analysishelper": {
                this.refrushBillList();
                break;
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            switch (callBackId) {
                case "deleteAnalysisHelper": {
                    this.deleteAnalysisHelper();
                    this.refrushBillList();
                    break;
                }
                case "disable_comfirm": {
                    this.setStatus(false);
                    break;
                }
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("model".equals(name)) {
            if (this.getModel().getValue("model") != null) {
                String modelId = ((DynamicObject)this.getModel().getValue("model")).getString("id");
                this.getPageCache().put("KEY_MODEL_ID", modelId);
                this.getPageCache().remove(TREENODEID);
                AnalysisPageServiceHelper.initStaticAnalysisTemp(LongUtil.toLong((Object)modelId));
                this.refrushTree();
                this.refreshPermCache();
                this.refrushBillList();
            } else {
                this.getModel().setValue("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (billList.getSelectedRows().size() > 0 && !StringUtil.equals((String)"true", (String)this.getPageCache().get(TREENODEPERM))) {
            Object[] selectNodeIds = billList.getSelectedRows().getPrimaryKeyValues();
            String catalogSelectField = "id,templatecatalog";
            QFBuilder catalogFilter = new QFBuilder();
            catalogFilter.add("id", "in", (Object)selectNodeIds);
            DynamicObject[] catalog = BusinessDataServiceHelper.load((String)"bcm_analysishelper", (String)catalogSelectField, (QFilter[])catalogFilter.toArray());
            HashSet<String> cataLogIds = new HashSet<String>(catalog.length);
            for (DynamicObject module : catalog) {
                String cataLogId = module.getString("templatecatalog.id");
                cataLogIds.add(cataLogId);
            }
            boolean isCatalogOnlyRead = this.isNodeReadOnly(cataLogIds);
            if (isCatalogOnlyRead) {
                this.controlButtonEnable(Boolean.FALSE, Boolean.FALSE);
            } else {
                ArrayList readOnlyPerms = new ArrayList();
                readOnlyPerms.addAll(PermClassEntityHelper.getPermissionMap((String)"bcm_analysishelper", (String)String.valueOf(this.getModelId()), (String)String.valueOf(this.getUserId())).get((Object)"2"));
                this.controlButtonEnable(Boolean.TRUE, Boolean.FALSE);
                for (DynamicObject module : catalog) {
                    Long moduleId = module.getLong("id");
                    if (!readOnlyPerms.contains(moduleId)) continue;
                    this.controlButtonEnable(Boolean.FALSE, Boolean.FALSE);
                    break;
                }
            }
        } else if (billList.getSelectedRows().size() == 0 && !StringUtil.equals((String)"true", (String)this.getPageCache().get(TREENODEPERM))) {
            this.controlButtonEnable(Boolean.TRUE, Boolean.FALSE);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg) {
        if (arg.getFieldName().equals("number")) {
            ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)arg).getCurrentRow();
            Long selectRowId = (Long)currentRow.getPrimaryKeyValue();
            IFormView mainview = this.getView().getMainView();
            String pageid = "bcm_analysishelper" + selectRowId + mainview.getPageId() + this.getBizAppId();
            BaseShowParameter bs = new BaseShowParameter();
            bs.setFormId("bcm_analysishelper");
            bs.setPageId(pageid);
            bs.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bs.setCustomParam("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            bs.setCustomParam("template", (Object)this.getPageCache().get(TREENODEID));
            bs.setCustomParam("treelist", (Object)this.getPageCache().get("treelist"));
            bs.setCustomParam("type", (Object)"edit");
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_analysishelper");
            bs.setCloseCallBack(closeCallBack);
            bs.setPkId((Object)selectRowId);
            bs.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)bs);
            this.getView().sendFormAction(this.getView());
        }
    }

    @Override
    protected String getTemplateCataLogEntryEntity() {
        return "bcm_anaysiscatalog";
    }

    @Override
    protected String getSelectFields() {
        return "id,name,number,parent";
    }

    @Override
    protected String getRootName() {
        return ResManager.loadKDString((String)"\u65b9\u6848\u5206\u7c7b", (String)"AnaysisHelperSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected void newTemplateCatalog(String nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("model", this.getPageCache().get("KEY_MODEL_ID"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_anaysiscatalog");
        if (isAddNew) {
            long id = Long.parseLong(nodeId);
            params.put("parent", id);
            params.put("type", "add");
            this.showForm(this.getTemplateCataLogEntryEntity(), params, closeCallBack, ShowType.Modal, 0L);
        } else {
            long id = Long.parseLong(nodeId);
            params.put("parent", this.getPageCache().get("parent"));
            params.put("type", "edit");
            this.showForm(this.getTemplateCataLogEntryEntity(), params, closeCallBack, ShowType.Modal, id);
        }
    }

    @Override
    protected void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, long id) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        params.put("entity", this.getTemplateCataLogEntryEntity());
        param.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u5206\u7c7b", (String)"AnaysisHelperSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    private void showAnaysisHelper() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("bcm_analysishelper");
        formShowParameter.setCustomParam("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        formShowParameter.setCustomParam("classname", (Object)AnaysisHelperSettingPlugin.class.getName());
        formShowParameter.setCustomParam("template", (Object)this.getPageCache().get(TREENODEID));
        formShowParameter.setCustomParam("treelist", (Object)this.getPageCache().get("treelist"));
        formShowParameter.setCustomParam("type", (Object)"addnew");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDNEWANALYSISHELPER));
        this.getView().showForm(formShowParameter);
    }

    @Override
    protected void refrushBillList() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.setClearSelection(true);
        billList.refresh();
    }

    @Override
    public String getModelSign() {
        return "model";
    }

    public void setFilter(SetFilterEvent e) {
        if (this.getModel().getValue("model") != null && this.getPageCache().get(TREENODEID) != null) {
            BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
            billList.setClearSelection(true);
            Long modelId = LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
            Long focusTreeNodeId = LongUtil.toLong((Object)this.getPageCache().get(TREENODEID));
            List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(TemplateConstant.TREELIST), List.class);
            ArrayList<String> list = new ArrayList<String>(16);
            this.queryAllChildNodeList(String.valueOf(focusTreeNodeId), treeList, list);
            list.add(String.valueOf(focusTreeNodeId));
            QFilter filter = new QFilter("model", "=", (Object)modelId).and(new QFilter("templatecatalog", "in", (Object)LongUtil.toLongList(list)));
            boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(modelId));
            if (!adminUserBol) {
                HashSet<Long> noPermId = new HashSet<Long>(16);
                noPermId.addAll(AnalysisPageServiceHelper.getPermCataLogIds("bcm_analysishelper", LongUtil.toLong((Object)modelId), String.valueOf(this.getUserId()), "1"));
                if (noPermId.size() != 0) {
                    filter.and(new QFilter("id", "not in", noPermId));
                }
            }
            e.getQFilters().add(filter);
            e.setOrderBy("createtime");
        } else {
            e.getQFilters().add(new QFilter("1", "!=", (Object)1));
        }
    }

    private void showMovePage() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u52a9\u624b\u65b9\u6848\u3002", (String)"AnaysisHelperSettingPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bcm_templatemove");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        para.setCustomParam("entryentity", (Object)"bcm_analysishelper");
        para.setCustomParam("cataLogEntryentity", (Object)"bcm_anaysiscatalog");
        para.setCustomParam("pluginName", (Object)this.getPluginName());
        para.setCustomParam("cataLogType", (Object)this.getCatalogtypeQFilter().recombine());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_templatemove");
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private void deleteAnalysisHelperConfirm() {
        Object[] selectedIds = this.getSelectedIds();
        if (selectedIds != null && selectedIds.length > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"AnaysisHelperSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETEANALYSISHELPER, (IFormPlugin)this));
        }
    }

    private void deleteAnalysisHelper() {
        Object[] selectIds = this.getSelectedIds();
        if (selectIds == null) {
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)selectIds);
        Collection<DynamicObject> dys = BusinessDataServiceHelper.loadFromCache((Object[])selectIds, (String)"bcm_analysishelper").values();
        for (DynamicObject dy : dys) {
            boolean status = dy.getBoolean("status");
            if (!status) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u7684\u52a9\u624b\u65b9\u6848\u4e0d\u53ef\u5220\u9664\u3002", (String)"AnaysisHelperSettingPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        int issuccess = DeleteServiceHelper.delete((String)"bcm_analysishelper", (QFilter[])filter.toArray());
        if (issuccess != 0) {
            this.writeOpLog(dys, true);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"FormListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private Object[] getSelectedIds() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"AnaysisHelperSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return null;
        }
        return billList.getSelectedRows().getPrimaryKeyValues();
    }

    private SetMultimap<Long, Long> buildRelationMap() {
        HashMultimap relationMap = HashMultimap.create();
        List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
        for (Map tree : treeList) {
            Long parent = LongUtil.toLong(tree.get("parentid"));
            relationMap.put((Object)parent, (Object)LongUtil.toLong(tree.get("id")));
        }
        return relationMap;
    }

    private Set<Long> findLeafNodeList(Long focusNodeId, SetMultimap<Long, Long> relationMap) {
        HashSet<Long> leafNodeId = new HashSet<Long>(16);
        if (relationMap.get((Object)focusNodeId) != null && relationMap.get((Object)focusNodeId).size() != 0) {
            Set childNodeList = relationMap.get((Object)focusNodeId);
            for (Long childNode : childNodeList) {
                leafNodeId.addAll(this.findLeafNodeList(childNode, relationMap));
            }
        } else {
            leafNodeId.add(focusNodeId);
        }
        return leafNodeId;
    }

    private void copyTempalte() {
        if (Objects.isNull(this.getPageCache().get("KEY_MODEL_ID"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AnaysisHelperSettingPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] tempDy = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"DiscTemplateListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (tempDy != null && tempDy.length > 0) {
            ArrayList<DynamicObject> saveDy = new ArrayList<DynamicObject>(tempDy.length);
            CloneUtils cloneUtils = new CloneUtils(true, true);
            Date date = new Date();
            Long currentUserId = RequestContext.get().getCurrUserId();
            for (DynamicObject obj : tempDy) {
                String newNumber = obj.getString("number") + "copy";
                if (newNumber.length() > 100) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u590d\u5236\u65f6\u7f16\u7801\u8d85\u957f\uff0c\u8bf7\u5148\u4fee\u6539\u7f16\u7801\u3002", (String)"AnaysisHelperSettingPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), newNumber));
                    return;
                }
                String newName = obj.getString("name") + "copy";
                if (newName.length() > 100) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u590d\u5236\u65f6\u540d\u79f0\u8d85\u957f\uff0c\u8bf7\u5148\u4fee\u6539\u540d\u79f0\u3002", (String)"AnaysisHelperSettingPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), newNumber));
                    return;
                }
                QFilter numberFilter = new QFilter("number", "=", (Object)newNumber).and(new QFilter("model", "=", (Object)obj.getLong("model.id")));
                if (QueryServiceHelper.exists((String)"bcm_analysishelper", (QFilter[])new QFilter[]{numberFilter})) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u65b9\u6848\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"AnaysisHelperSettingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), newNumber));
                    continue;
                }
                QFilter nameFilter = new QFilter("name", "=", (Object)newName).and(new QFilter("model", "=", (Object)obj.getLong("model.id")));
                if (QueryServiceHelper.exists((String)"bcm_analysishelper", (QFilter[])new QFilter[]{nameFilter})) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u65b9\u6848\u540d\u79f0\u201d\u5df2\u5b58\u5728\u3002", (String)"AnaysisHelperSettingPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), newName));
                    continue;
                }
                DynamicObject newTemp = (DynamicObject)cloneUtils.clone((IDataEntityBase)obj);
                newTemp.set("number", (Object)newNumber);
                newTemp.set("name", (Object)newName);
                newTemp.set("creator", (Object)currentUserId);
                newTemp.set("modifier", (Object)currentUserId);
                newTemp.set("createtime", (Object)date);
                newTemp.set("modifytime", (Object)date);
                newTemp.set("status", (Object)"0");
                newTemp.set("ispreset", (Object)false);
                saveDy.add(newTemp);
            }
            DynamicObject[] dyArr = new DynamicObject[saveDy.size()];
            DynamicObject[] successSave = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])saveDy.toArray(dyArr));
            Long modelId = Long.valueOf(this.getPageCache().get("KEY_MODEL_ID"));
            PermClassEntityHelper.saveBathPermClass(saveDy, (long)modelId, (String)"permclass");
            String optionName = ResManager.loadKDString((String)"\u590d\u5236", (String)"TemplateListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String successOp = ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"TemplateListPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            HashSet<String> successNumbers = new HashSet<String>();
            for (DynamicObject success : successSave) {
                String number = success.getString("number");
                if (number.length() < 4) continue;
                successNumbers.add(number.substring(0, number.length() - 4));
            }
            if (successSave.length <= 0) {
                successOp = ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\u3002", (String)"AnaysisHelperSettingPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.writeLog(Arrays.asList(tempDy), optionName, successOp);
                return;
            }
            this.writeCopyLog(tempDy, successNumbers, optionName, successOp);
        }
    }

    private void writeCopyLog(DynamicObject[] tempDy, Set<String> successNumbers, String optionName, String successOp) {
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>(tempDy.length);
        ArrayList<DynamicObject> faildList = new ArrayList<DynamicObject>(tempDy.length);
        for (DynamicObject dy : tempDy) {
            if (successNumbers.contains(dy.getString("number"))) {
                successList.add(dy);
                continue;
            }
            faildList.add(dy);
        }
        if (successList.size() > 0) {
            this.writeLog(successList, optionName, successOp);
        }
        if (faildList.size() > 0) {
            String faildOp = ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\u3002", (String)"AnaysisHelperSettingPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.writeLog(faildList, optionName, faildOp);
        }
    }

    private void writeLog(Collection<DynamicObject> dys, String optionName, String successOp) {
        if (dys.isEmpty()) {
            return;
        }
        ArrayList<String> opDescriptions = new ArrayList<String>(16);
        for (DynamicObject dy : dys) {
            String option = dy.getString("number") + ";" + dy.getString("name") + " " + successOp;
            opDescriptions.add(option);
        }
        OperationLogUtil.batchWriteOperationLog((String)optionName, opDescriptions, (Long)this.getModelId(), (String)"bcm_analysishelper");
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.addClickListeners("deletecatalog");
    }

    @Override
    public void checkPerm(String opkey) {
        if ((opkey.equals("btn_addnew") || opkey.equals("btn_modify") || opkey.equals("deletecatalog") || opkey.equals("btn_up") || opkey.equals("btn_down")) && StringUtil.equals((String)"true", (String)this.getPageCache().get(TREENODEPERM))) {
            String tips = ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5206\u7c7b\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"AbstractBaseListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            throw new KDBizException(tips);
        }
        super.checkPerm(opkey);
    }

    protected void cacheTreeNodePerm(String treeNodeId) {
        if (!StringUtil.isEmptyString((String)treeNodeId)) {
            HashSet treeNodeList = Sets.newHashSetWithExpectedSize((int)1);
            treeNodeList.add(treeNodeId);
            boolean isNodeOnlyRead = this.isNodeReadOnly(treeNodeList);
            this.getPageCache().put(TREENODEPERM, String.valueOf(isNodeOnlyRead));
            if (isNodeOnlyRead) {
                this.controlButtonEnable(Boolean.FALSE, Boolean.TRUE);
            } else {
                this.controlButtonEnable(Boolean.TRUE, Boolean.TRUE);
            }
        } else {
            this.getPageCache().put(TREENODEPERM, "noperm");
        }
    }

    protected boolean isNodeReadOnly(Set<String> nodeIds) {
        String treeListCache = this.getPageCache().get("treelist");
        if (Objects.nonNull(treeListCache)) {
            List treeList = (List)SerializationUtils.fromJsonString((String)treeListCache, List.class);
            ArrayList<Long> readOnlyIds = new ArrayList<Long>(16);
            if (this.getPageCache().get(READONLY) == null) {
                readOnlyIds.addAll(this.getReadOnlyCataLogIds("bcm_anaysiscatalog", this.getModelId(), String.valueOf(this.getUserId())));
                this.getPageCache().put(READONLY, SerializationUtils.toJsonString(readOnlyIds));
            } else {
                readOnlyIds.addAll((Collection)SerializationUtils.fromJsonString((String)this.getPageCache().get(READONLY), List.class));
            }
            for (Map next : treeList) {
                if (!nodeIds.contains(next.get("id"))) continue;
                if (readOnlyIds.contains(LongUtil.toLong(next.get("id")))) {
                    return true;
                }
                if (!this.hasOnlyReadParentNode(treeList, next, readOnlyIds)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Long> getReadOnlyCataLogIds(String entityName, Long modelId, String userId) {
        ArrayList<Long> readOnlyPerms = new ArrayList<Long>();
        readOnlyPerms.addAll(PermClassEntityHelper.getPermissionMap((String)entityName, (String)String.valueOf(modelId), (String)userId).get((Object)"2"));
        return readOnlyPerms;
    }

    private boolean hasOnlyReadParentNode(List<Map<String, String>> treeList, Map<String, String> node, List<Long> readOnlyIds) {
        for (Map<String, String> next : treeList) {
            if (!node.get("parentid").equals(next.get("id"))) continue;
            if (readOnlyIds.contains(LongUtil.toLong((Object)next.get("id")))) {
                return true;
            }
            return this.hasOnlyReadParentNode(treeList, next, readOnlyIds);
        }
        return false;
    }

    @Override
    public void refrushTree() {
        TreeView Tree = (TreeView)this.getControl("templatecatalog");
        Tree.deleteAllNodes();
        this.initTree();
    }

    private void refreshPermCache() {
        this.getPageCache().remove(READONLY);
        this.cacheTreeNodePerm(this.getPageCache().get(TREENODEID));
    }

    protected void controlButtonEnable(Boolean status, Boolean isTreeClick) {
        this.getView().setEnable(status, new String[]{"bar_copy", "bar_delete", "bar_enable", "bar_disable", "move"});
        if (isTreeClick.booleanValue()) {
            this.getView().setEnable(status, new String[]{"bar_add"});
        }
    }

    @Override
    protected String getEntryEntity() {
        return "bcm_analysishelper";
    }

    private void writeOpLog(Collection<DynamicObject> dys, boolean issuccess) {
        String optionSuccess = "";
        optionSuccess = issuccess ? ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"RptAdjustdListPlugin_54", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"RptAdjustdListPlugin_55", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        ArrayList<String> opDescriptions = new ArrayList<String>(dys.size());
        for (DynamicObject dy : dys) {
            String option;
            String number = dy.getString("number");
            String name = dy.getString("name");
            if (Objects.nonNull(name)) {
                option = number + ";" + name + " " + optionSuccess;
                opDescriptions.add(option);
                continue;
            }
            option = number + optionSuccess;
            opDescriptions.add(option);
        }
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
        OperationLogUtil.batchWriteOperationLog((String)ResManager.loadKDString((String)"\u5220\u9664\u5206\u6790\u65b9\u6848", (String)"AnaysisHelperEditPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opDescriptions, (Long)modelId, (String)"bcm_analysishelper");
    }
}

