/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper.ai;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class GptUtils {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(GptUtils.class);

    public static String invoke(String promptNumber, String input, Map<String, String> variableMap) {
        return GptUtils.invoke(null, promptNumber, input, variableMap);
    }

    public static String invoke(String chatSessionId, String promptNumber, String input, Map<String, String> variableMap) {
        DynamicObject prompt;
        try {
            prompt = QueryServiceHelper.queryOne((String)"gai_prompt", (String)"id,number,name", (QFilter[])new QFilter("number", "=", (Object)promptNumber).toArray());
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u4e0d\u5b58\u5728GPT\u63d0\u793a\u8bed\u8868\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AnalysisPageServiceHelper_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (prompt == null) {
            logger.error("AnalysisHelper promptNumber not exists promptNumber:" + promptNumber);
            throw new KDBizException("PromptNumber:" + promptNumber + " not exists!");
        }
        JSONObject result = null;
        result = Objects.isNull(chatSessionId) ? GptUtils.invokeSyncService(prompt.getLong("id"), input, variableMap) : GptUtils.invokeSyncCallUseHistoryService(chatSessionId, prompt.getLong("id"), input, variableMap);
        if (result != null) {
            if (result.getBoolean("status").booleanValue()) {
                if (result.getJSONObject("data") != null && result.getJSONObject("data").getString("llmValue") != null) {
                    return result.getJSONObject("data").getString("llmValue");
                }
                throw new KDBizException("Ai Result is Empty!");
            }
            throw new KDBizException(result.getString("errMsg"));
        }
        logger.error("GptUtils result is null");
        return "";
    }

    private static JSONObject invokeSyncService(Long promptId, String input, Map<String, String> variableMap) {
        if (variableMap == null) {
            variableMap = new HashMap<String, String>(2);
        }
        Object[] params = new Object[]{promptId, input, variableMap};
        Object result = DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])params);
        logger.info("dm.gpt  invokeSyncService1:" + SerializationUtils.toJsonString((Object)result));
        return JSON.parseObject((String)JSON.toJSONString((Object)result));
    }

    private static JSONObject invokeSyncCallUseHistoryService(String chatSessionId, Long promptId, String input, Map<String, String> variableMap) {
        if (variableMap == null) {
            variableMap = new HashMap<String, String>(2);
        }
        Object[] params = new Object[]{chatSessionId, promptId, input, variableMap};
        Object result = DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCallUseHistoryMsg", (Object[])params);
        logger.info("dm.gpt  invokeSyncService1:" + SerializationUtils.toJsonString((Object)result));
        return JSON.parseObject((String)JSON.toJSONString((Object)result));
    }
}

