/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper.chartconfig;

import kd.bos.form.chart.Chart;
import kd.fi.bcm.formplugin.analysishelper.chartenums.ChartType;
import kd.fi.bcm.formplugin.analysishelper.charts.abstractchart.AnalysisChart;
import kd.fi.bcm.formplugin.analysishelper.charts.bar.BarChart;
import kd.fi.bcm.formplugin.analysishelper.charts.bar.ColumnBarChart;
import kd.fi.bcm.formplugin.analysishelper.charts.line.LineChart;
import kd.fi.bcm.formplugin.analysishelper.charts.line.StackedAreaChart;
import kd.fi.bcm.formplugin.analysishelper.charts.pie.CircularPieChart;
import kd.fi.bcm.formplugin.analysishelper.charts.pie.PieChart;

public class AnalysisChartsFactory {
    public static AnalysisChart getChartInstace(Chart chart, ChartType chartType, boolean isDisplayDetail) {
        String type = chartType.getType();
        AnalysisChart analysisChart = null;
        switch (type) {
            case "1": {
                analysisChart = AnalysisChartsFactory.getPieChartInstance(chart, isDisplayDetail);
                break;
            }
            case "2": {
                analysisChart = AnalysisChartsFactory.getCircularPieChartInstance(chart, isDisplayDetail);
                break;
            }
            case "3": {
                analysisChart = AnalysisChartsFactory.getBarChartInstance(chart, isDisplayDetail);
                break;
            }
            case "4": {
                analysisChart = AnalysisChartsFactory.getColumnBarChartInstance(chart, isDisplayDetail);
                break;
            }
            case "5": {
                analysisChart = AnalysisChartsFactory.getLineChartInstance(chart, isDisplayDetail);
                break;
            }
            case "6": {
                analysisChart = AnalysisChartsFactory.getStackedAreaChartInstance(chart, isDisplayDetail);
                break;
            }
            default: {
                analysisChart = AnalysisChartsFactory.getPieChartInstance(chart, isDisplayDetail);
            }
        }
        return analysisChart;
    }

    public static PieChart getPieChartInstance(Chart chart, boolean isDisplayDetail) {
        return new PieChart(chart, isDisplayDetail);
    }

    public static CircularPieChart getCircularPieChartInstance(Chart chart, boolean isDisplayDetail) {
        return new CircularPieChart(chart, isDisplayDetail);
    }

    public static BarChart getBarChartInstance(Chart chart, boolean isDisplayDetail) {
        return new BarChart(chart, isDisplayDetail);
    }

    public static LineChart getLineChartInstance(Chart chart, boolean isDisplayDetail) {
        return new LineChart(chart, isDisplayDetail);
    }

    public static ColumnBarChart getColumnBarChartInstance(Chart chart, boolean isDisplayDetail) {
        return new ColumnBarChart(chart, isDisplayDetail);
    }

    public static StackedAreaChart getStackedAreaChartInstance(Chart chart, boolean isDisplayDetail) {
        return new StackedAreaChart(chart, isDisplayDetail);
    }
}

