/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper.chartenums;

import kd.bos.dataentity.utils.StringUtils;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum ChartType {
    PIE(new MultiLangEnumBridge("\u997c\u56fe", "ChartType_1", "fi-bcm-formplugin"), "1", "pie"),
    CIRCULAR_PIE(new MultiLangEnumBridge("\u73af\u5f62\u56fe", "ChartType_2", "fi-bcm-formplugin"), "2", "circular_pie"),
    BAR(new MultiLangEnumBridge("\u6761\u5f62\u56fe", "ChartType_3", "fi-bcm-formplugin"), "3", "bar"),
    COLUMN_BAR(new MultiLangEnumBridge("\u67f1\u72b6\u56fe", "ChartType_4", "fi-bcm-formplugin"), "4", "column_bar"),
    LINE(new MultiLangEnumBridge("\u6298\u7ebf\u56fe", "ChartType_5", "fi-bcm-formplugin"), "5", "line"),
    STACKED_AREA(new MultiLangEnumBridge("\u5806\u79ef\u9762\u79ef\u56fe", "ChartType_6", "fi-bcm-formplugin"), "6", "stacked_area"),
    STACKED_BAR(new MultiLangEnumBridge("\u5806\u79ef\u6761\u5f62\u56fe", "ChartType_7", "fi-bcm-formplugin"), "7", "stacked_bar");

    private final String type;
    private final String number;
    private final MultiLangEnumBridge bridge;

    private ChartType(MultiLangEnumBridge bridge, String type, String number) {
        this.type = type;
        this.bridge = bridge;
        this.number = number;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public String getType() {
        return this.type;
    }

    public String getNumber() {
        return this.number;
    }

    public static ChartType getChartType(String type) {
        ChartType chartType;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return PIE;
        }
        switch (type) {
            case "1": {
                chartType = PIE;
                break;
            }
            case "2": {
                chartType = CIRCULAR_PIE;
                break;
            }
            case "3": {
                chartType = BAR;
                break;
            }
            case "4": {
                chartType = COLUMN_BAR;
                break;
            }
            case "5": {
                chartType = LINE;
                break;
            }
            case "6": {
                chartType = STACKED_AREA;
                break;
            }
            default: {
                chartType = PIE;
            }
        }
        return chartType;
    }
}

