/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper.charts.bar;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Series;
import kd.fi.bcm.formplugin.analysishelper.charts.abstractchart.AnalysisChart;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractBarChart
extends AnalysisChart {
    public String xAxisName;
    public String yAxisName;
    public Axis axis;
    public Axis axisData;
    public boolean isBar = true;

    public AbstractBarChart(Chart chart, boolean isDisplayDetail) {
        super(chart, isDisplayDetail);
    }

    @Override
    public void setChartData(Map<String, LinkedHashMap<String, Number>> chartData) {
        this.clearChartCache();
        this.createXYAxis();
        this.setXYAxisStyle();
        String[] xS = new String[]{};
        boolean flag = true;
        for (Map.Entry<String, LinkedHashMap<String, Number>> entry : chartData.entrySet()) {
            String key = entry.getKey();
            BarSeries barSeries = this.chart.createBarSeries(key);
            this.setItemNormalStyle((Series)barSeries);
            this.setItemCustomStyle((Series)barSeries);
            LinkedHashMap<String, Number> value = entry.getValue();
            if (flag) {
                xS = new String[value.size()];
                flag = false;
            }
            int i = 0;
            for (Map.Entry<String, Number> seriers : value.entrySet()) {
                String x = seriers.getKey();
                Number value1 = seriers.getValue();
                barSeries.addData(value1);
                xS[i] = x;
                ++i;
            }
            this.buildCustomBarAxisData((Series)barSeries, xS);
        }
        this.axis.setCategorys(xS);
        this.chart.refresh();
    }

    public void buildCustomBarAxisData(Series barSeries, String[] xS) {
        if (CollectionUtils.isEmpty((Collection)this.blingMembers)) {
            return;
        }
        List data = barSeries.getData();
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            Object value = data.get(0);
            HashMap<String, Object> newDataModel = new HashMap<String, Object>(2);
            newDataModel.put("value", value);
            HashMap itemStyle = new HashMap(2);
            HashMap<String, Object> normal = new HashMap<String, Object>(2);
            normal.put("borderColor", "white");
            normal.put("borderWidth", 1.2);
            normal.put("shadowColor", "rgba(0,0,0,0.8)");
            normal.put("shadowBlur", 6);
            itemStyle.put("normal", normal);
            if (this.blingMembers.contains(xS[i])) {
                newDataModel.put("itemStyle", itemStyle);
            }
            data.add(newDataModel);
            data.remove(0);
        }
    }

    public void setXYAxis(String xAxisName, String yAxisName) {
        this.xAxisName = xAxisName;
        this.yAxisName = yAxisName;
    }

    protected void createXYAxis() {
        if (this.isBar) {
            this.axis = this.chart.createYAxis(this.xAxisName, AxisType.category);
            this.axisData = this.chart.createXAxis(this.yAxisName, AxisType.value);
        } else {
            this.axis = this.chart.createXAxis(this.xAxisName, AxisType.category);
            this.axisData = this.chart.createYAxis(this.yAxisName, AxisType.value);
        }
    }

    @Override
    public void setXYAxisStyle() {
        super.setXYAxisStyle();
        String fun = "function(name) { return name.length > 5 ? (name.slice(0, 5) + '...') : name; }";
        ArrayList<String> addFunctions = new ArrayList<String>();
        addFunctions.add("legend");
        addFunctions.add("formatter");
        this.chart.setLegendPropValue("formatter", (Object)fun);
        if (!this.isDisplayDetail) {
            this.chart.setLegendPropValue("type", (Object)"scroll");
            this.chart.setLegendPropValue("width", (Object)"85%");
        }
        this.chart.addFuncPath(addFunctions);
        if (this.isPercentage) {
            HashMap prop = Maps.newHashMapWithExpectedSize((int)1);
            prop.put("formatter", "{value}%");
            this.axisData.setPropValue("axisLabel", (Object)prop);
        }
        String funAxisLabel = "function(value) { return value.length > 5 ? (value.slice(0, 5) + '...') : value;}";
        if (this.isDisplayDetail) {
            funAxisLabel = "function(value) { return value.length > 7 ? (value.slice(0, 7) + '...') : value;}";
        }
        HashMap prop = Maps.newHashMapWithExpectedSize((int)1);
        prop.put("formatter", funAxisLabel);
        this.axis.setPropValue("axisLabel", (Object)prop);
        ArrayList<Object> addFunctions1 = new ArrayList<Object>();
        if (this.isBar) {
            addFunctions1.add("yAxis");
        } else {
            addFunctions1.add("xAxis");
        }
        addFunctions1.add(0);
        addFunctions1.add("axisLabel");
        addFunctions1.add("formatter");
        this.chart.addFuncPath(addFunctions1);
        if (this.isPercentage) {
            String toolTipsFun = " function(params) { var tooltipHtml = '';\n      for (var i = 0; i < params.length; i++) {\n        tooltipHtml += params[i].marker + params[i].seriesName + ': ' + '<b>' + echarts.format.addCommas(params[i].value) + '%' + '<b/>' + '<br/>';\n      }\n      return params[0].name + '<br/>' + tooltipHtml;\n    }";
            ArrayList<String> toolTipsFunArrays = new ArrayList<String>();
            this.chart.addTooltip("formatter", (Object)toolTipsFun);
            toolTipsFunArrays.add("tooltip");
            toolTipsFunArrays.add("formatter");
            this.chart.addFuncPath(toolTipsFunArrays);
        }
        if (!this.isPercentage) {
            HashMap<String, String> sbText = new HashMap<String, String>();
            sbText.put("subtext", this.subText);
            sbText.put("top", "-10px");
            sbText.put("right", "10px");
            this.chart.addProperty("title", sbText);
        }
    }

    @Override
    public void setItemNormalStyle(Series series) {
        HashMap prop = Maps.newHashMapWithExpectedSize((int)1);
        prop.put("show", false);
        if (this.isDisplayDetail) {
            prop.put("show", true);
            if (this.isPercentage) {
                prop.put("formatter", "{@" + series.getName() + "}%");
            }
        }
        series.setPropValue("label", (Object)prop);
    }

    @Override
    public void setItemCustomStyle(Series series) {
    }

    @Override
    public void setLegendStyle() {
    }

    @Override
    public void setOption() {
        super.setOption();
    }

    @Override
    public void refresh() {
        this.chart.refresh();
    }
}

