/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper.charts.line;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.fi.bcm.formplugin.analysishelper.charts.line.AbstractLineChart;
import org.apache.commons.collections.CollectionUtils;

public class StackedAreaChart
extends AbstractLineChart {
    public StackedAreaChart(Chart chart, boolean isDisplayDetail) {
        super(chart, isDisplayDetail);
    }

    @Override
    public void setXYAxisStyle() {
        super.setXYAxisStyle();
        this.xAxis.setPropValue("boundaryGap", (Object)true);
    }

    @Override
    public void setItemNormalStyle(Series series) {
        super.setItemNormalStyle(series);
        HashMap lable = Maps.newHashMapWithExpectedSize((int)2);
        lable.put("show", true);
        lable.put("position", "top");
        series.setPropValue("stack", (Object)"Total");
        if (this.isDisplayDetail) {
            series.setPropValue("label", (Object)lable);
        }
    }

    @Override
    public void setItemCustomStyle(Series series) {
        super.setItemCustomStyle(series);
        HashMap axisPointer = Maps.newHashMapWithExpectedSize((int)2);
        HashMap color = Maps.newHashMapWithExpectedSize((int)1);
        color.put("backgroundColor", "#6a7985");
        axisPointer.put("type", "cross");
        axisPointer.put("label", color);
        HashMap arae = Maps.newHashMapWithExpectedSize((int)1);
        series.setPropValue("areaStyle", (Object)arae);
        HashMap emphasis = Maps.newHashMapWithExpectedSize((int)1);
        emphasis.put("focus", "series");
        if (this.isDisplayDetail) {
            this.chart.addTooltip("axisPointer", (Object)axisPointer);
            this.chart.addTooltip("trigger", (Object)"axis");
            series.setPropValue("emphasis", (Object)emphasis);
        } else {
            this.chart.setMargin(Position.top, "10%");
        }
        if (!CollectionUtils.isEmpty((Collection)this.alterNum)) {
            HashMap markLine = Maps.newHashMapWithExpectedSize((int)4);
            HashMap lineStyle = Maps.newHashMapWithExpectedSize((int)1);
            lineStyle.put("color", "red");
            ArrayList<HashMap> hashMaps = new ArrayList<HashMap>(this.alterNum.size());
            for (String num : this.alterNum) {
                HashMap data = Maps.newHashMapWithExpectedSize((int)2);
                data.put("name", "AlterNum1");
                if (!StringUtils.isNotEmpty((CharSequence)num)) continue;
                data.put("yAxis", new BigDecimal(num));
                hashMaps.add(data);
            }
            markLine.put("data", hashMaps);
            markLine.put("animation", true);
            markLine.put("animationDuration", 2000);
            markLine.put("lineStyle", lineStyle);
            series.setPropValue("markLine", (Object)markLine);
            this.alterNum.clear();
        }
    }
}

