/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper.charts.pie;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Series;
import kd.fi.bcm.formplugin.analysishelper.charts.abstractchart.AnalysisChart;
import org.apache.commons.collections.MapUtils;

public abstract class AbstractPieChart
extends AnalysisChart {
    public int CurSeriesSize;

    public AbstractPieChart(Chart chart, boolean isDisplayDetail) {
        super(chart, isDisplayDetail);
    }

    @Override
    public void setChartData(Map<String, LinkedHashMap<String, Number>> chartData) {
        this.clearChartCache();
        Map<String, LinkedHashMap<String, Number>> transformPieData = this.transformPieData(chartData);
        this.CurSeriesSize = transformPieData.size();
        this.setLegendStyle();
        int index = 0;
        for (Map.Entry<String, LinkedHashMap<String, Number>> outerMap : transformPieData.entrySet()) {
            String key = outerMap.getKey();
            PieSeries pieSeries = this.chart.createPieSeries(key);
            pieSeries.setName(key);
            this.setChartDrawingStyle((Series)pieSeries, index);
            this.setItemNormalStyle((Series)pieSeries);
            this.setItemCustomStyle((Series)pieSeries);
            LinkedHashMap<String, Number> itemValues = outerMap.getValue();
            ItemValue[] itemValue = this.builderItemValues(itemValues);
            pieSeries.setData(itemValue);
            ++index;
        }
        this.refresh();
    }

    @Override
    public void setLegendStyle() {
        String fun = "function(name) { return name.length > 5 ? (name.slice(0, 5) + '...') : name; }";
        ArrayList<String> addFunctions = new ArrayList<String>();
        addFunctions.add("legend");
        addFunctions.add("formatter");
        this.chart.setLegendPropValue("formatter", (Object)fun);
        if (!this.isDisplayDetail) {
            this.chart.setLegendPropValue("type", (Object)"scroll");
            this.chart.setLegendPropValue("width", (Object)"80%");
        }
        this.chart.addFuncPath(addFunctions);
    }

    public void setChartDrawingStyle(Series series, int index) {
    }

    @Override
    public void setItemNormalStyle(Series series) {
    }

    @Override
    public void setItemCustomStyle(Series series) {
    }

    @Override
    public void setOption() {
        super.setOption();
    }

    @Override
    public void refresh() {
        this.chart.refresh();
    }

    public Map<String, LinkedHashMap<String, Number>> transformPieData(Map<String, LinkedHashMap<String, Number>> sourceData) {
        if (MapUtils.isEmpty(sourceData)) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap transformChartData = Maps.newLinkedHashMapWithExpectedSize((int)12);
        for (Map.Entry<String, LinkedHashMap<String, Number>> hashMapEntry : sourceData.entrySet()) {
            String outerKey = hashMapEntry.getKey();
            LinkedHashMap<String, Number> valueMap = hashMapEntry.getValue();
            for (Map.Entry<String, Number> numberEntry : valueMap.entrySet()) {
                String innerKey = numberEntry.getKey();
                Number innerValue = numberEntry.getValue();
                if (!transformChartData.containsKey(innerKey)) {
                    transformChartData.put(innerKey, new LinkedHashMap(12));
                }
                ((LinkedHashMap)transformChartData.get(innerKey)).put(outerKey, innerValue);
            }
        }
        return transformChartData;
    }

    private ItemValue[] builderItemValues(LinkedHashMap<String, Number> map) {
        ItemValue[] itemValues = new ItemValue[map.size()];
        int i = 0;
        for (Map.Entry<String, Number> objectEntry : map.entrySet()) {
            String key = objectEntry.getKey();
            Number value = objectEntry.getValue();
            itemValues[i] = new ItemValue(key, value);
            ++i;
        }
        return itemValues;
    }
}

