/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper.charts.pie;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Series;
import kd.fi.bcm.formplugin.analysishelper.charts.pie.AbstractPieChart;

public class CircularPieChart
extends AbstractPieChart {
    private static List<List<String[]>> CIRCULAR_PIE_DRAWING = new ArrayList<List<String[]>>(3);

    public CircularPieChart(Chart chart, boolean isDisplayDetail) {
        super(chart, isDisplayDetail);
    }

    @Override
    public void setChartDrawingStyle(Series series, int index) {
        super.setChartDrawingStyle(series, index);
        List<String[]> curStyleType = CIRCULAR_PIE_DRAWING.get(this.CurSeriesSize - 1);
        String[] style = curStyleType.get(index);
        PieSeries pieSeries = (PieSeries)series;
        pieSeries.setRadius(style[0], style[1]);
        this.setCirPieLabelStyle(pieSeries, index);
    }

    @Override
    public void setItemNormalStyle(Series cirseries) {
        this.chart.setShowLegend(true);
        Map itemNormalStyle = cirseries.getItemNormalStyle();
        itemNormalStyle.put("borderRadius", 10);
        itemNormalStyle.put("borderColor", "#fff");
        itemNormalStyle.put("borderWidth", "0");
    }

    @Override
    public void setItemCustomStyle(Series cirseries) {
        this.chart.addTooltip("show", (Object)true);
        this.chart.addTooltip("trigger", (Object)"item");
        this.chart.addTooltip("formatter", (Object)"{a}</br>{b}: {c}%");
        this.chart.setShowTooltip(true);
        if (!this.isDisplayDetail) {
            cirseries.setPropValue("top", (Object)30);
        }
    }

    private void setCirPieLabelStyle(PieSeries series, int index) {
        String circlePieLabel = "function(params) { var text = String(params.name);  return text.length > 4 ? (text.slice(0, 4) + '...') : text; }";
        if (this.isDisplayDetail) {
            circlePieLabel = "function(params) { var text = String(params.name);  return text.length > 6 ? (text.slice(0, 6) + '...') : text; }";
        }
        HashMap<String, Object> LabelParam = new HashMap<String, Object>();
        LabelParam.put("show", index == 0);
        LabelParam.put("formatter", circlePieLabel);
        series.setPropValue("label", LabelParam);
        ArrayList<String> circleFunctions = new ArrayList<String>();
        circleFunctions.add("label");
        circleFunctions.add("formatter");
        series.addFuncPath(circleFunctions);
        if (index != 0) {
            this.setInnerCirclePieStyle(series);
        }
    }

    private void setInnerCirclePieStyle(PieSeries cirSeries) {
        HashMap propLabel = Maps.newHashMapWithExpectedSize((int)1);
        HashMap propLabelContents = Maps.newHashMapWithExpectedSize((int)3);
        propLabelContents.put("show", true);
        propLabelContents.put("fontSize", 15);
        if (this.isDisplayDetail) {
            propLabelContents.put("fontSize", 20);
        }
        propLabelContents.put("fontWeight", "bold");
        propLabel.put("label", propLabelContents);
        cirSeries.setPropValue("emphasis", (Object)propLabel);
        HashMap propLabelPositon = Maps.newHashMapWithExpectedSize((int)2);
        propLabelPositon.put("show", false);
        propLabelPositon.put("position", "center");
        cirSeries.setPropValue("label", (Object)propLabelPositon);
        cirSeries.setPropValue("avoidLabelOverlap", (Object)false);
    }

    static {
        ArrayList<String[]> firstCirPie = new ArrayList<String[]>(1);
        ArrayList<String[]> secondCirPie = new ArrayList<String[]>(2);
        ArrayList<String[]> threeCirPie = new ArrayList<String[]>(3);
        firstCirPie.add(new String[]{"30%", "65%"});
        secondCirPie.add(new String[]{"60%", "75%"});
        secondCirPie.add(new String[]{"25%", "40%"});
        threeCirPie.add(new String[]{"65%", "75%"});
        threeCirPie.add(new String[]{"45%", "55%"});
        threeCirPie.add(new String[]{"25%", "35%"});
        CIRCULAR_PIE_DRAWING.add(firstCirPie);
        CIRCULAR_PIE_DRAWING.add(secondCirPie);
        CIRCULAR_PIE_DRAWING.add(threeCirPie);
    }
}

