/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper.charts.pie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Series;
import kd.fi.bcm.formplugin.analysishelper.charts.pie.AbstractPieChart;

public class PieChart
extends AbstractPieChart {
    private static List<List<String[]>> PIE_DRAWING = new ArrayList<List<String[]>>(3);

    public PieChart(Chart chart, boolean isDisplayDetail) {
        super(chart, isDisplayDetail);
    }

    @Override
    public void setChartDrawingStyle(Series series, int index) {
        super.setChartDrawingStyle(series, index);
        List<String[]> curStyleType = PIE_DRAWING.get(this.CurSeriesSize - 1);
        String[] style = curStyleType.get(index);
        PieSeries pieSeries = (PieSeries)series;
        pieSeries.setRadius(style[0]);
        pieSeries.setCenter(style[1], style[2]);
    }

    @Override
    public void setItemNormalStyle(Series series) {
        super.setItemNormalStyle(series);
        this.chart.setShowLegend(true);
        this.chart.addTooltip("show", (Object)true);
        this.chart.addTooltip("trigger", (Object)"item");
        this.chart.addTooltip("formatter", (Object)"{a}</br>{b}: {c}%");
        this.chart.setShowTooltip(true);
        if (!this.isDisplayDetail) {
            series.setPropValue("top", (Object)20);
        }
    }

    @Override
    public void setItemCustomStyle(Series series) {
        super.setItemCustomStyle(series);
        String fun = "function(params) { var text = String(params.name);  return text.length > 4 ? (text.slice(0, 4) + '...') : text; }";
        if (this.isDisplayDetail) {
            fun = "function(params) { var text = String(params.name);  return text.length > 6 ? (text.slice(0, 6) + '...') : text; }";
        }
        HashMap<String, Object> labelParam = new HashMap<String, Object>();
        labelParam.put("show", this.CurSeriesSize != 3);
        labelParam.put("formatter", fun);
        series.setPropValue("label", labelParam);
        ArrayList<String> addFunctions = new ArrayList<String>();
        addFunctions.add("label");
        addFunctions.add("formatter");
        series.addFuncPath(addFunctions);
    }

    static {
        ArrayList<String[]> firstPie = new ArrayList<String[]>(1);
        ArrayList<String[]> secondPie = new ArrayList<String[]>(2);
        ArrayList<String[]> threePie = new ArrayList<String[]>(3);
        firstPie.add(new String[]{"65%", "50%", "50%"});
        secondPie.add(new String[]{"50%", "25%", "50%"});
        secondPie.add(new String[]{"50%", "75%", "50%"});
        threePie.add(new String[]{"45%", "30%", "75%"});
        threePie.add(new String[]{"45%", "50%", "35%"});
        threePie.add(new String[]{"45%", "70%", "75%"});
        PIE_DRAWING.add(firstPie);
        PIE_DRAWING.add(secondPie);
        PIE_DRAWING.add(threePie);
    }
}

