/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.formplugin.analysishelper.datatable.ComparedDataTable;
import kd.fi.bcm.formplugin.analysishelper.datatable.ProportionDataTable;
import kd.fi.bcm.formplugin.analysishelper.utils.ChartDataServiceHelper;

public class CalServiceHelper {
    public static final String MONEY = "money";
    public static final String BALANCE = "balance";
    public static final String VARIABLEPROPORTION = "varaibleproportion";
    public static final String CHARTDATA = "CHARTDATA";
    public static final String TABLEDATA = "TABLEDATA";

    public static Map<String, Object> calComparedData(Object data, boolean displayName) {
        HashMap dataMap = (HashMap)data;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(12);
        LinkedHashMap echartsResult = new LinkedHashMap(12);
        LinkedHashMap moneyMap = new LinkedHashMap(12);
        LinkedHashMap<String, LinkedHashMap<String, Number>> balanceMap = new LinkedHashMap<String, LinkedHashMap<String, Number>>(12);
        LinkedHashMap<String, LinkedHashMap<String, Number>> variableRateMap = new LinkedHashMap<String, LinkedHashMap<String, Number>>(12);
        ArrayList<ComparedDataTable> comparedDataTableList = new ArrayList<ComparedDataTable>(12);
        for (Map.Entry cellData : dataMap.entrySet()) {
            String[] changeDimStr = ((String)cellData.getKey()).split("/", 2);
            List analysisDataList = (List)cellData.getValue();
            LinkedHashMap<String, Object> analysisMoneyMap = new LinkedHashMap<String, Object>(analysisDataList.size());
            LinkedHashMap<String, Number> analysisBalanceMap = new LinkedHashMap<String, Number>(analysisDataList.size());
            LinkedHashMap<String, Number> analysisVariableRateMap = new LinkedHashMap<String, Number>(analysisDataList.size());
            BigDecimal lastValue = null;
            for (Pair analysisData : analysisDataList) {
                String[] analysisStr = ((String)analysisData.p1).split("/", 2);
                String analysisNameOrNumber = displayName ? analysisStr[1] : analysisStr[0];
                analysisMoneyMap.put(analysisNameOrNumber, analysisData.p2);
                ComparedDataTable comparedDataRow = CalServiceHelper.getComparedDataRow(changeDimStr, (Pair<String, BigDecimal>)analysisData);
                CalServiceHelper.buildComparedData(analysisBalanceMap, analysisVariableRateMap, lastValue, (Pair<String, BigDecimal>)analysisData, comparedDataRow, analysisNameOrNumber);
                lastValue = (BigDecimal)analysisData.p2;
                comparedDataTableList.add(comparedDataRow);
            }
            if (analysisDataList.size() == 0) continue;
            moneyMap.put(displayName ? changeDimStr[1] : changeDimStr[0], analysisMoneyMap);
            balanceMap.put(displayName ? changeDimStr[1] : changeDimStr[0], analysisBalanceMap);
            variableRateMap.put(displayName ? changeDimStr[1] : changeDimStr[0], analysisVariableRateMap);
        }
        echartsResult.put(MONEY, moneyMap);
        echartsResult.put(BALANCE, balanceMap);
        echartsResult.put(VARIABLEPROPORTION, variableRateMap);
        result.put(CHARTDATA, echartsResult);
        result.put(TABLEDATA, comparedDataTableList);
        return result;
    }

    private static ComparedDataTable getComparedDataRow(String[] changeDimStr, Pair<String, BigDecimal> analysisData) {
        ComparedDataTable comparedDataRow = new ComparedDataTable();
        String[] analysisStr = ((String)analysisData.p1).split("/", 2);
        comparedDataRow.setChagedimension(changeDimStr[0]);
        comparedDataRow.setChagedimensionName(changeDimStr[1]);
        comparedDataRow.setAnalysismember(analysisStr[0]);
        comparedDataRow.setAnalysismemberName(analysisStr[1]);
        comparedDataRow.setFmoneyData(String.valueOf(analysisData.p2));
        return comparedDataRow;
    }

    private static void buildComparedData(LinkedHashMap<String, Number> balanceMap, LinkedHashMap<String, Number> variableRateMap, BigDecimal lastValue, Pair<String, BigDecimal> analysisData, ComparedDataTable comparedDataRow, String analysisNameOrNumber) {
        if (Objects.nonNull(lastValue)) {
            BigDecimal balance = ((BigDecimal)analysisData.p2).subtract(lastValue);
            balanceMap.put(analysisNameOrNumber, balance.setScale(2, RoundingMode.HALF_UP));
            comparedDataRow.setBalanceData(String.valueOf(balance.setScale(2, RoundingMode.HALF_UP)));
            if (lastValue.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal variableRate4 = balance.divide(lastValue, 4, RoundingMode.HALF_UP);
                BigDecimal multiplyVariableRate = variableRate4.multiply(BigDecimal.valueOf(100L));
                BigDecimal variablePercentage = multiplyVariableRate.setScale(2);
                comparedDataRow.setPercentageData(String.valueOf(variablePercentage));
                variableRateMap.put(analysisNameOrNumber, variablePercentage);
            } else {
                variableRateMap.put(analysisNameOrNumber, BigDecimal.ZERO);
                comparedDataRow.setPercentageData("-");
            }
        } else {
            balanceMap.put(analysisNameOrNumber, BigDecimal.ZERO);
            comparedDataRow.setBalanceData("-");
            variableRateMap.put(analysisNameOrNumber, BigDecimal.ZERO);
            comparedDataRow.setPercentageData("-");
        }
    }

    public static Map<String, Object> calProportionData(Object data, boolean displayName) {
        Map dataMap = (Map)data;
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedHashMap<String, LinkedHashMap<String, Number>> chartResult = new LinkedHashMap<String, LinkedHashMap<String, Number>>(dataMap.size());
        ArrayList<ProportionDataTable> dataTableList = new ArrayList<ProportionDataTable>(18);
        for (Map.Entry<String, List<Pair<String, BigDecimal>>> entry : dataMap.entrySet()) {
            LinkedHashMap<String, Number> memberMap = new LinkedHashMap<String, Number>(12);
            String[] outerMapKey = ((String)entry.getKey()).split("/", 2);
            String changeDimNameOrNumber = displayName ? outerMapKey[1] : outerMapKey[0];
            CalServiceHelper.buildProportionData(displayName, dataTableList, entry, memberMap, outerMapKey);
            chartResult.put(changeDimNameOrNumber, memberMap);
        }
        result.put(CHARTDATA, ChartDataServiceHelper.transformAxisData(chartResult));
        result.put(TABLEDATA, dataTableList);
        return result;
    }

    private static void buildProportionData(boolean displayName, List<ProportionDataTable> dataTableList, Map.Entry<String, List<Pair<String, BigDecimal>>> outerMap, LinkedHashMap<String, Number> memberMap, String[] outerMapKey) {
        BigDecimal sumResult = new BigDecimal(0);
        for (Pair<String, BigDecimal> valuePair : outerMap.getValue()) {
            sumResult = sumResult.add(((BigDecimal)valuePair.p2).abs());
        }
        for (Pair<String, BigDecimal> valuePair : outerMap.getValue()) {
            String[] valueStr = ((String)valuePair.p1).split("/", 2);
            String analysisDimMember = displayName ? valueStr[1] : valueStr[0];
            BigDecimal calValue = BigDecimal.ZERO;
            if (sumResult.compareTo(BigDecimal.ZERO) != 0) {
                calValue = ((BigDecimal)valuePair.p2).divide(sumResult, 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2);
            }
            memberMap.put(analysisDimMember, calValue);
            dataTableList.add(new ProportionDataTable(outerMapKey[0], outerMapKey[1], valueStr[0], valueStr[1], String.valueOf(valuePair.p2), String.valueOf(sumResult), String.valueOf(calValue)));
        }
    }
}

