/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper.utils;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class ChartDataServiceHelper {
    private static final int MAX_SIZE = 3;

    public static Map<String, LinkedHashMap<String, Number>> transformAxisData(Map<String, LinkedHashMap<String, Number>> sourceData) {
        if (MapUtils.isEmpty(sourceData)) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap transformChartData = Maps.newLinkedHashMapWithExpectedSize((int)12);
        for (Map.Entry<String, LinkedHashMap<String, Number>> hashMapEntry : sourceData.entrySet()) {
            String outerKey = hashMapEntry.getKey();
            LinkedHashMap<String, Number> valueMap = hashMapEntry.getValue();
            for (Map.Entry<String, Number> numberEntry : valueMap.entrySet()) {
                String innerKey = numberEntry.getKey();
                Number innerValue = numberEntry.getValue();
                if (!transformChartData.containsKey(innerKey)) {
                    transformChartData.put(innerKey, new LinkedHashMap(12));
                }
                ((LinkedHashMap)transformChartData.get(innerKey)).put(outerKey, innerValue);
            }
        }
        return transformChartData;
    }

    public static Map<String, LinkedHashMap<String, Number>> buildLimitedSeriesData(Map<String, LinkedHashMap<String, Number>> sourceData) {
        LinkedHashMap limitedSeriesChartData = Maps.newLinkedHashMapWithExpectedSize((int)3);
        int count = 0;
        for (Map.Entry<String, LinkedHashMap<String, Number>> outerMap : sourceData.entrySet()) {
            if (count >= 3) break;
            limitedSeriesChartData.put(outerMap.getKey(), outerMap.getValue());
            ++count;
        }
        return limitedSeriesChartData;
    }

    public static void main(String[] args) {
        LinkedHashMap<String, LinkedHashMap<String, Number>> data = new LinkedHashMap<String, LinkedHashMap<String, Number>>(2);
        LinkedHashMap<String, Integer> innerMap1 = new LinkedHashMap<String, Integer>();
        innerMap1.put("m", 120);
        innerMap1.put("n", 10);
        innerMap1.put("w", 20);
        innerMap1.put("x", 220);
        LinkedHashMap<String, Integer> innerMap2 = new LinkedHashMap<String, Integer>();
        innerMap2.put("m", 140);
        innerMap2.put("n", 110);
        innerMap2.put("w", 50);
        innerMap2.put("x", 280);
        data.put("A", innerMap1);
        data.put("B", innerMap2);
        System.out.println("====> " + data);
        Map<String, LinkedHashMap<String, Number>> transform = ChartDataServiceHelper.transformAxisData(data);
        System.out.println("====> " + transform);
        Map<String, LinkedHashMap<String, Number>> limitedSeriesData = ChartDataServiceHelper.buildLimitedSeriesData(transform);
        System.out.println("====> " + limitedSeriesData);
    }
}

