/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper.utils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.fi.bcm.formplugin.analysishelper.AnalysisPageServiceHelper;
import kd.fi.bcm.formplugin.analysishelper.datatable.ComparedDataTable;
import kd.fi.bcm.formplugin.analysishelper.datatable.ProportionDataTable;

public class DataTableUtils {
    private static String CurrChartType = "CurrChartType";
    private static String CurrAnalysisSchemeType = "CurrAnalysisSchemeType";
    private static String CurrAnalysisDataType = "CurrAnalysisDataType";
    private static String DataAlterValue = "DataAlterValue";
    private static String CTL_COMPARED_DATATABLE = "compared_datatable";
    private static String CTL_PROPORTION_DATATABLE = "proportion_datatable";

    public static void buildComparedDataTable(IFormView view, List<ComparedDataTable> dataTableSource, Set<Integer> alterSet, Map<String, List> alertNumPair) {
        IDataModel dataModel = view.getModel();
        dataModel.batchCreateNewEntryRow(CTL_COMPARED_DATATABLE, dataTableSource.size());
        boolean flag = true;
        if (alertNumPair == null) {
            flag = false;
        }
        int i = 0;
        for (ComparedDataTable comparedDataTable : dataTableSource) {
            dataModel.setValue("analysismember", (Object)comparedDataTable.getAnalysismember(), i);
            dataModel.setValue("analysismembername", (Object)comparedDataTable.getAnalysismemberName(), i);
            dataModel.setValue("chagedimension", (Object)comparedDataTable.getChagedimension(), i);
            dataModel.setValue("chagedimensionname", (Object)comparedDataTable.getChagedimensionName(), i);
            dataModel.setValue("fmoneydata", (Object)comparedDataTable.getFmoneyData(), i);
            dataModel.setValue("balancedata", (Object)(StringUtils.equals((CharSequence)"-", (CharSequence)comparedDataTable.getBalanceData()) ? "-" : comparedDataTable.getBalanceData()), i);
            dataModel.setValue("percentagedata", (Object)(StringUtils.equals((CharSequence)"-", (CharSequence)comparedDataTable.getPercentageData()) ? "-" : comparedDataTable.getPercentageData() + "%"), i);
            String dataType = view.getPageCache().get(CurrAnalysisDataType);
            if (flag) {
                if (StringUtils.equals((CharSequence)"1", (CharSequence)dataType)) {
                    if (!StringUtils.equals((CharSequence)"-", (CharSequence)comparedDataTable.getFmoneyData())) {
                        BigDecimal moneyDataValue = new BigDecimal(comparedDataTable.getFmoneyData());
                        if (DataTableUtils.isAlert(alertNumPair.get("p1"), alertNumPair.get("p2"), moneyDataValue)) {
                            alterSet.add(i);
                        }
                    }
                } else if (StringUtils.equals((CharSequence)"2", (CharSequence)dataType)) {
                    if (!StringUtils.equals((CharSequence)"-", (CharSequence)comparedDataTable.getBalanceData())) {
                        BigDecimal balanceDataValue = new BigDecimal(comparedDataTable.getBalanceData());
                        if (DataTableUtils.isAlert(alertNumPair.get("p1"), alertNumPair.get("p2"), balanceDataValue)) {
                            alterSet.add(i);
                        }
                    }
                } else if (StringUtils.equals((CharSequence)"3", (CharSequence)dataType) && !StringUtils.equals((CharSequence)"-", (CharSequence)comparedDataTable.getPercentageData())) {
                    BigDecimal percentageDataValue = new BigDecimal(comparedDataTable.getPercentageData());
                    if (DataTableUtils.isAlert(alertNumPair.get("p1"), alertNumPair.get("p2"), percentageDataValue)) {
                        alterSet.add(i);
                    }
                }
            }
            ++i;
        }
    }

    public static void buildProportionDataTable(IFormView view, List<ProportionDataTable> dataTableSource, Set<Integer> alterSet, Map<String, List> alertNumPair) {
        boolean flag = true;
        if (alertNumPair == null) {
            flag = false;
        }
        IDataModel dataModel = view.getModel();
        dataModel.batchCreateNewEntryRow(CTL_PROPORTION_DATATABLE, dataTableSource.size());
        int i = 0;
        for (ProportionDataTable proportionDataTable : dataTableSource) {
            dataModel.setValue("selectedmember", (Object)proportionDataTable.getSelectedMember(), i);
            dataModel.setValue("selectedmembername", (Object)proportionDataTable.getSelectedMemberName(), i);
            dataModel.setValue("analysisnumber", (Object)proportionDataTable.getAnalysisNumber(), i);
            dataModel.setValue("analysisname", (Object)proportionDataTable.getAnalysisName(), i);
            dataModel.setValue("selecteddata", (Object)proportionDataTable.getSelectedData(), i);
            dataModel.setValue("otherdata", (Object)proportionDataTable.getOtherdata(), i);
            dataModel.setValue("percentage", (Object)(StringUtils.equals((CharSequence)"-", (CharSequence)proportionDataTable.getPercentage()) ? "-" : proportionDataTable.getPercentage() + "%"), i);
            if (flag && !StringUtils.equals((CharSequence)"-", (CharSequence)proportionDataTable.getPercentage())) {
                BigDecimal moneyDataValue = new BigDecimal(proportionDataTable.getPercentage());
                if (DataTableUtils.isAlert(alertNumPair.get("p1"), alertNumPair.get("p2"), moneyDataValue)) {
                    alterSet.add(i);
                }
            }
            ++i;
        }
    }

    private static boolean isAlert(List<Map<String, String>> p1, List<String> p2, BigDecimal num) {
        for (Map<String, String> pair : p1) {
            boolean inRange = AnalysisPageServiceHelper.isInRange(pair.get("p1").toString(), pair.get("p2").toString(), num);
            if (!inRange) continue;
            return true;
        }
        for (String p : p2) {
            if (num.compareTo(new BigDecimal(p)) != 0) continue;
            return true;
        }
        return false;
    }
}

