/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analysishelper.utils;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.bcm.common.Pair;

public class NumberDecimalUtils {
    public static void valDecimalFormatter(Object sourceData, String unitInfo) {
        BigDecimal unit = NumberDecimalUtils.getUnitSize(unitInfo);
        if (Objects.isNull(unit)) {
            return;
        }
        Map dataMap = (Map)sourceData;
        for (Map.Entry outerMap : dataMap.entrySet()) {
            List pairList = (List)outerMap.getValue();
            ArrayList newPairList = Lists.newArrayListWithExpectedSize((int)pairList.size());
            for (Pair pair : pairList) {
                BigDecimal newVal = BigDecimal.ZERO.compareTo((BigDecimal)pair.p2) == 0 ? BigDecimal.ZERO : ((BigDecimal)pair.p2).divide(unit);
                newPairList.add(Pair.onePair((Object)pair.p1, (Object)newVal));
            }
            dataMap.put(outerMap.getKey(), newPairList);
        }
    }

    private static BigDecimal getUnitSize(String UnitInfo) {
        if (StringUtils.isEmpty((CharSequence)UnitInfo) || Integer.parseInt(UnitInfo) == 0) {
            return null;
        }
        return BigDecimal.TEN.pow(Integer.parseInt(UnitInfo));
    }

    public static String getDisplayUnit(String unitInfo) {
        if (StringUtils.isEmpty((CharSequence)unitInfo) || Integer.parseInt(unitInfo) == 0) {
            return "";
        }
        String unitName = "";
        int dataUnit = Integer.parseInt(unitInfo);
        switch (dataUnit) {
            case 3: {
                unitName = ResManager.loadKDString((String)"\u5343", (String)"AbstractMultiReportPlugin_167", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case 4: {
                unitName = ResManager.loadKDString((String)"\u4e07", (String)"AbstractMultiReportPlugin_168", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case 6: {
                unitName = ResManager.loadKDString((String)"\u767e\u4e07", (String)"AbstractMultiReportPlugin_169", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case 7: {
                unitName = ResManager.loadKDString((String)"\u5343\u4e07", (String)"AbstractMultiReportPlugin_237", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case 8: {
                unitName = ResManager.loadKDString((String)"\u4ebf", (String)"AbstractMultiReportPlugin_170", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
            case 10: {
                unitName = ResManager.loadKDString((String)"\u767e\u4ebf", (String)"AbstractMultiReportPlugin_171", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return String.format(ResManager.loadKDString((String)"\u5355\u4f4d\uff1a%s", (String)"AbstractMultiReportPlugin_2024", (String)"fi-bcm-formplugin", (Object[])new Object[0]), unitName);
    }
}

