/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.chkcheck.task.ChkCheckTask;
import kd.fi.bcm.business.extdata.ExtDataQueryFactory;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.extdata.ExtFieldMappedService;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.db.DataSetUtil;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.analytics.service.AnalyticsDimMemService;
import kd.fi.bcm.formplugin.analytics.service.AnalyticsSolutionService;
import kd.fi.bcm.formplugin.analytics.vo.AnalysisTaskResult;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalysisTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ChkCheckTask.class);
    private static final List<String> DIM_KEYS = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Scenario.getSign(), SysDimensionEnum.Year.getSign(), SysDimensionEnum.Period.getSign(), SysDimensionEnum.Currency.getSign()});

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u67e5\u8be2\u6570\u636e\u2026\u2026", (String)"AdjustBatchExportTask_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        AnalysisTaskResult taskResult = new AnalysisTaskResult();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        String message = "";
        Boolean success = Boolean.TRUE;
        try {
            DynamicObject extDim;
            List fmoneyNumbers;
            DynamicObjectCollection fmoneyDys;
            List fmoneyIds;
            String fmoneyIdStr;
            String type;
            DynamicObject dim;
            String number;
            Object solution;
            if (this.isStop()) {
                this.stop();
            }
            if ((solution = params.get("solution")) == null || StringUtils.isEmpty((CharSequence)solution.toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u65b9\u6848\u3002", (String)"QueryAnalysisPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            DynamicObject so = (DynamicObject)ObjectSerialUtil.deSerializedBytes((String)solution.toString());
            String solutionName = so.getString("solutionname");
            result.put("solutionname", solutionName);
            if (!(params.get("modelId") instanceof Long)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u65b9\u6848\u3002", (String)"QueryAnalysisPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            long modelId = (Long)params.get("modelId");
            DynamicObjectCollection pageDimList = so.getDynamicObjectCollection("pagedim");
            DynamicObjectCollection rowDimList = so.getDynamicObjectCollection("rowdim");
            DynamicObjectCollection colDimList = so.getDynamicObjectCollection("coldim");
            if (CollectionUtils.isEmpty((Collection)rowDimList) || CollectionUtils.isEmpty((Collection)colDimList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ed9\u884c\u5217\u7ef4\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u3002", (String)"QueryAnalysisPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            ThreadCache.put((Object)"from_btn_refresh", (Object)true);
            String processNumber = "";
            String auditNumber = "";
            ArrayList<String> scenarios = new ArrayList<String>(8);
            ArrayList<String> entities = new ArrayList<String>(16);
            ArrayList<String> years = new ArrayList<String>(16);
            ArrayList<String> periods = new ArrayList<String>(16);
            ArrayList<String> currencies = new ArrayList<String>(16);
            HashMap<String, List<Long>> entityNumMap = new HashMap<String, List<Long>>(16);
            ArrayList<String> fmoneyNums = new ArrayList<String>(16);
            boolean fmoneyInPage = false;
            boolean fmoneyInRow = false;
            boolean resourceOrgInCol = false;
            boolean resourceOrgInRow = false;
            long extModelid = so.getLong("extmodel.id");
            for (DynamicObject dy : pageDimList) {
                DynamicObject dim2;
                String type2 = dy.getString("datatype");
                if ("1".equals(type2)) {
                    Object extDim2 = dy.get("extdimid");
                    if (extDim2 instanceof DynamicObject) {
                        fmoneyNums.add(((DynamicObject)extDim2).getString("number"));
                        fmoneyInPage = true;
                        fmoneyInRow = false;
                    } else {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryAnalysisPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                }
                if ((dim2 = dy.getDynamicObject("dimid")) == null) continue;
                long memberid = dy.getLong("menberid");
                String dimNum = dim2.getString("number");
                if (ExtDataUtil.fixDims.contains(dimNum) && memberid == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u56fa\u5b9a\u9875\u9762\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryAnalysisPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), (Long)memberid);
                if ("Process".equals(dimNum)) {
                    processNumber = member.getNumber();
                    continue;
                }
                if ("Scenario".equals(dimNum)) {
                    scenarios.add(member.getNumber());
                    continue;
                }
                if ("AuditTrail".equals(dimNum)) {
                    auditNumber = member.getNumber();
                    continue;
                }
                if ("Period".equals(dimNum)) {
                    periods.add(member.getNumber());
                    continue;
                }
                if ("Year".equals(dimNum)) {
                    years.add(member.getNumber());
                    continue;
                }
                if ("Currency".equals(dimNum)) {
                    currencies.add(member.getNumber());
                    continue;
                }
                if (!"Entity".equals(dimNum)) continue;
                entities.add(member.getId().toString());
            }
            ArrayList<String> selects = new ArrayList<String>(16);
            ArrayList<String> rowExtSelects = new ArrayList<String>(16);
            ArrayList<String> rowDimSelects = new ArrayList<String>(16);
            ArrayList<String> colExtSelects = new ArrayList<String>(16);
            ArrayList<String> colDimSelects = new ArrayList<String>(16);
            for (DynamicObject row : rowDimList) {
                number = "";
                dim = row.getDynamicObject("rowdimid");
                if (dim != null) {
                    number = dim.getString("number");
                    if (number.equals("Entity")) {
                        rowDimSelects.add("org");
                        continue;
                    }
                    rowDimSelects.add(number);
                    continue;
                }
                type = row.getString("rowdatatype");
                if ("1".equals(type)) {
                    fmoneyIdStr = row.getString("rowextdims");
                    if (StringUtils.isEmpty((CharSequence)fmoneyIdStr)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryAnalysisPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    fmoneyIds = (List)JSON.parseObject((String)fmoneyIdStr, List.class);
                    if (CollectionUtils.isEmpty((Collection)fmoneyIds)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryAnalysisPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    fmoneyDys = QueryServiceHelper.query((String)"bcm_structofextend", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)fmoneyIds)});
                    if (CollectionUtils.isNotEmpty((Collection)fmoneyDys)) {
                        fmoneyNumbers = fmoneyDys.stream().map(e -> e.getString("number")).collect(Collectors.toList());
                        fmoneyNums.addAll(fmoneyNumbers);
                    }
                    fmoneyInPage = false;
                    fmoneyInRow = true;
                    continue;
                }
                if ("2".equals(type)) {
                    resourceOrgInRow = true;
                    rowDimSelects.add("Entity");
                    continue;
                }
                extDim = row.getDynamicObject("rowextdimid");
                if (extDim != null) {
                    number = extDim.getString("number");
                }
                if (!StringUtils.isNotEmpty((CharSequence)number)) continue;
                rowExtSelects.add(number);
                selects.add(number);
            }
            for (DynamicObject col : colDimList) {
                number = "";
                dim = col.getDynamicObject("columndimid");
                if (dim != null) {
                    number = dim.getString("number");
                    if (number.equals("Entity")) {
                        colDimSelects.add("org");
                        continue;
                    }
                    colDimSelects.add(number);
                    continue;
                }
                type = col.getString("coldatatype");
                if ("1".equals(type)) {
                    fmoneyIdStr = col.getString("colextdims");
                    if (StringUtils.isEmpty((CharSequence)fmoneyIdStr)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryAnalysisPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    fmoneyIds = (List)JSON.parseObject((String)fmoneyIdStr, List.class);
                    if (CollectionUtils.isEmpty((Collection)fmoneyIds)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryAnalysisPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    fmoneyDys = QueryServiceHelper.query((String)"bcm_structofextend", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)fmoneyIds)});
                    if (CollectionUtils.isNotEmpty((Collection)fmoneyDys)) {
                        fmoneyNumbers = fmoneyDys.stream().map(e -> e.getString("number")).collect(Collectors.toList());
                        fmoneyNums.addAll(fmoneyNumbers);
                    }
                    fmoneyInPage = false;
                    fmoneyInRow = false;
                    continue;
                }
                if ("2".equals(type)) {
                    resourceOrgInCol = true;
                    colDimSelects.add("Entity");
                    continue;
                }
                extDim = col.getDynamicObject("columnextdimid");
                if (extDim != null) {
                    number = extDim.getString("number");
                }
                if (!StringUtils.isNotEmpty((CharSequence)number)) continue;
                selects.add(number);
                colExtSelects.add(number);
            }
            selects.addAll(fmoneyNums);
            ArrayList<String> dimSelects = new ArrayList<String>(16);
            dimSelects.addAll(rowDimSelects);
            dimSelects.addAll(colDimSelects);
            EdQueryComInfo edQueryComInfo = this.buildQueryCommand(modelId, entities, processNumber, scenarios, years, periods, currencies, auditNumber, entityNumMap, extModelid);
            edQueryComInfo.setExtselects(selects.toArray(new String[0]));
            edQueryComInfo.setDimselects(dimSelects.toArray(new String[0]));
            ExtendsModel extendsModel = new ExtendsModel().getExtendsModel(Long.valueOf(extModelid));
            LinkedHashMap<String, DynaEntityObject> rowCols = new LinkedHashMap<String, DynaEntityObject>(16);
            HashSet<String> dimFields = new HashSet<String>(16);
            HashSet<String> extFields = new HashSet<String>(16);
            HashMap<String, String> dimFields2name = new HashMap<String, String>(16);
            HashMap<String, String> extdimFields2name = new HashMap<String, String>(16);
            AnalyticsSolutionService.getAnalyticsSolutionService().collectFields(extendsModel, rowCols, dimFields, extFields, dimFields2name, extdimFields2name);
            String extendsgroup = extendsModel.getExtendsGroupNumber();
            ExtFieldMappedService fieldMappedService = new ExtFieldMappedService(Long.valueOf(modelId), extendsgroup);
            Map colsFieldMapped = fieldMappedService.getColsFieldMapped(extFields.toArray(new String[0]));
            Map dimsFieldMapped = fieldMappedService.getDimsFieldMapped(dimFields.toArray(new String[0]));
            DynamicObjectCollection filters = so.getDynamicObjectCollection("filter");
            this.setCustomerFilter(edQueryComInfo, pageDimList, filters, colsFieldMapped, dimsFieldMapped, modelId);
            try (DataSet rows = ExtDataQueryFactory.getQueryService((EdQueryComInfo)edQueryComInfo).queryNewDataSet(edQueryComInfo);){
                String dataKey = DataSetUtil.cacheDataSet((DataSet)rows);
                taskResult.setCacheId(dataKey);
                RowMeta rowMeta = rows.getRowMeta();
                Field[] fields = rowMeta.getFields();
                List<String> fieldList = Arrays.stream(fields).map(e -> e.getAlias()).collect(Collectors.toList());
                taskResult.setFieldList(fieldList);
                taskResult.setRowDimSelects(rowDimSelects);
                taskResult.setColDimSelects(colDimSelects);
                taskResult.setColsFieldMapped(colsFieldMapped);
                taskResult.setDimsFieldMapped(dimsFieldMapped);
                taskResult.setRowExtSelects(rowExtSelects);
                taskResult.setColExtSelects(colExtSelects);
                taskResult.setFmoneyNums(fmoneyNums);
                taskResult.setFmoneyInPage(fmoneyInPage);
                taskResult.setFmoneyInRow(fmoneyInRow);
                taskResult.setResourceOrgInCol(resourceOrgInCol);
                taskResult.setResourceOrgInRow(resourceOrgInRow);
            }
            catch (Exception e2) {
                log.error((Throwable)e2);
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\u3002", (String)"QueryAnalysisPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e3) {
            message = e3.getMessage();
            success = Boolean.FALSE;
            log.error((Throwable)e3);
        }
        finally {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u6b63\u5728\u67e5\u8be2\u6570\u636e\u2026\u2026", (String)"AdjustBatchExportTask_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        }
        result.put("success", success);
        result.put("message", message);
        result.put("result", ObjectSerialUtil.toByteSerialized((Object)taskResult));
        this.feedbackCustomdata(result);
    }

    private EdQueryComInfo buildQueryCommand(long modelId, List<String> entities, String processNumber, List<String> scenarios, List<String> years, List<String> periods, List<String> currencies, String auditNumber, Map<String, List<Long>> entityNumMap, long extModelId) {
        ExtendsModel extendsModel = new ExtendsModel().getExtendsModel(Long.valueOf(extModelId));
        String modelShowNum = MemberReader.findModelSNumberById((Object)modelId);
        EdQueryComInfo queryComInfo = new EdQueryComInfo(modelShowNum, extendsModel.getExtendsGroupNumber(), extendsModel.getNumber());
        if (CollectionUtils.isNotEmpty(entities)) {
            queryComInfo.addDimFilter(DimTypesEnum.ENTITY.getNumber(), (String[])entities.stream().map(ent -> MemberReader.findEntityMemberById((Long)modelId, (Long)LongUtil.toLong((Object)ent)).getNumber()).toArray(String[]::new));
        }
        queryComInfo.addDimFilter(DimTypesEnum.SCENARIO.getNumber(), scenarios.toArray(new String[0]));
        if (CollectionUtils.isNotEmpty(years)) {
            queryComInfo.addDimFilter(DimTypesEnum.YEAR.getNumber(), years.toArray(new String[0]));
        }
        if (CollectionUtils.isNotEmpty(periods)) {
            queryComInfo.addDimFilter(DimTypesEnum.PERIOD.getNumber(), periods.toArray(new String[0]));
        }
        if (CollectionUtils.isNotEmpty(currencies)) {
            queryComInfo.addDimFilter(DimTypesEnum.CURRENCY.getNumber(), currencies.toArray(new String[0]));
        }
        queryComInfo.addDimFilter(DimTypesEnum.PROCESS.getNumber(), new String[]{processNumber});
        queryComInfo.addDimFilter(DimTypesEnum.AUDITTRIAL.getNumber(), new String[]{auditNumber});
        queryComInfo.setMulOrgNumMap(entityNumMap);
        queryComInfo.setNeedSum(false);
        List<String> dimList = extendsModel.getDimFieldEntry().stream().map(ext -> ext.getDimension().getNumber()).collect(Collectors.toList());
        for (String dimKey : DIM_KEYS) {
            SysDimensionEnum dimEnum = SysDimensionEnum.getEnumByLowerCaseNumber((String)dimKey);
            if (dimEnum == null) continue;
            dimList.add(dimEnum.getNumber());
        }
        dimList.add("org");
        dimList.add(DimTypesEnum.ENTITY.getNumber());
        if (CollectionUtils.isNotEmpty(dimList)) {
            queryComInfo.setDimselects(dimList.toArray(new String[0]));
        }
        queryComInfo.setMultiOrg(true);
        queryComInfo.setNeedSum(true);
        return queryComInfo;
    }

    private void setCustomerFilter(EdQueryComInfo edQueryComInfo, DynamicObjectCollection pageDimList, DynamicObjectCollection filters, Map<String, String> colsFieldMapped, Map<String, String> dimsFieldMapped, long modelId) {
        QFilter qf = new QFilter("1", "=", (Object)1);
        for (DynamicObject pageDim : pageDimList) {
            Object v;
            String type = pageDim.getString("datatype");
            if ("1".equals(type)) continue;
            if ("2".equals(type)) {
                long sourceOrgId = pageDim.getLong("menberid");
                if (sourceOrgId == 0L) continue;
                qf.and("entity", "=", (Object)MemberReader.findEntityMemberById((Long)modelId, (Long)sourceOrgId).getNumber());
                continue;
            }
            DynamicObject dimDy = pageDim.getDynamicObject("dimid");
            if (dimDy != null) {
                String dimNum = dimDy.getString("number");
                if (ExtDataUtil.fixDims.contains(dimNum)) continue;
                long memberid = pageDim.getLong("menberid");
                IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), (Long)memberid);
                String dimField = dimsFieldMapped.get(dimNum);
                if (!StringUtils.isNotEmpty((CharSequence)dimField) || member == IDNumberTreeNode.NotFoundTreeNode) continue;
                qf.and(dimField, "=", (Object)member.getNumber());
                continue;
            }
            DynamicObject extDimDy = pageDim.getDynamicObject("extdimid");
            if (extDimDy == null) continue;
            String value = pageDim.getString("dimmem");
            String extdimNum = extDimDy.getString("number");
            String extField = colsFieldMapped.get(extdimNum);
            if (!StringUtils.isNotEmpty((CharSequence)extField) || !StringUtils.isNotEmpty((CharSequence)value) || (v = this.getValueWithOutCondition(extField, value, "")) == null) continue;
            qf.and(extField, "=", v);
        }
        String resourceOrgSign = "resourceorg|ext";
        for (DynamicObject filter : filters) {
            List<IDNumberTreeNode> resultCol;
            List<String> nums;
            String fieldNumSign = filter.getString("number");
            String conditonValue = filter.getString("condition");
            if (StringUtils.isEmpty((CharSequence)conditonValue)) continue;
            if (fieldNumSign.endsWith("|ext") && !resourceOrgSign.equals(fieldNumSign)) {
                String fieldNum = fieldNumSign.substring(0, fieldNumSign.indexOf("|ext"));
                String extField = colsFieldMapped.get(fieldNum);
                if (!StringUtils.isNotEmpty((CharSequence)extField)) continue;
                QFilter filterFromCondition = this.getFilterFromCondition(extField, conditonValue);
                qf.and(filterFromCondition);
                continue;
            }
            if (resourceOrgSign.equals(fieldNumSign)) {
                fieldNumSign = "Entity";
            }
            if (CollectionUtils.isEmpty(nums = (resultCol = AnalyticsDimMemService.getDimInfoFromDB("rowdimid", modelId, null, false, conditonValue, fieldNumSign)).stream().map(e -> e.getNumber()).collect(Collectors.toList()))) continue;
            if (ExtDataUtil.fixDims.contains(fieldNumSign) && edQueryComInfo.getDimFilter().get(fieldNumSign) == null) {
                edQueryComInfo.addDimFilter(fieldNumSign, nums.toArray(new String[0]));
                continue;
            }
            String dimNum = dimsFieldMapped.get(fieldNumSign);
            if (resourceOrgSign.equals(fieldNumSign)) {
                dimNum = "entity";
            }
            if (!StringUtils.isNotEmpty((CharSequence)dimNum)) continue;
            qf.and(dimNum, "in", nums);
        }
        for (String fixDim : ExtDataUtil.fixDims) {
            if (edQueryComInfo.getDimFilter().get(fixDim) != null) continue;
            List<IDNumberTreeNode> resultCol = AnalyticsDimMemService.getDimInfoFromDB("", modelId, null, false, "", fixDim);
            List<String> nums = resultCol.stream().map(e -> e.getNumber()).collect(Collectors.toList());
            edQueryComInfo.addDimFilter(fixDim, nums.toArray(new String[0]));
        }
        edQueryComInfo.setCustomFilter(qf);
    }

    private Object getValueWithOutCondition(String field, String v, String qcp) {
        if (v.length() <= qcp.length()) {
            log.error(String.format(ResManager.loadKDString((String)"'%s'\u6761\u4ef6\u8bf7\u8bbe\u7f6e\u5177\u4f53\u503c\u3002", (String)"FormulaConditionPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), v));
            return null;
        }
        String value = v.substring(qcp.length());
        if (field.startsWith("numext") && NumberUtils.isNumber((String)value)) {
            return new BigDecimal(value);
        }
        if (field.startsWith("date")) {
            try {
                Date date = value.length() == 8 ? DateTimeUtils.parseDate((String)value, (String)"yyyyMMdd") : DateTimeUtils.parseStrDate2((String)value);
                return date;
            }
            catch (ParseException e) {
                log.error((Throwable)e);
            }
        }
        if (field.startsWith("text")) {
            return value;
        }
        return null;
    }

    private QFilter getFilterFromCondition(String field, String condition) {
        QFilter qfBuilder = new QFilter("1", "!=", (Object)1);
        if (StringUtils.isEmpty((CharSequence)condition)) {
            return qfBuilder;
        }
        String[] split = condition.split(",");
        ArrayList<Object> values = new ArrayList<Object>(16);
        for (String s : split) {
            Object value;
            if (s.startsWith("=")) {
                value = this.getValueWithOutCondition(field, s, "=");
                if (value == null) continue;
                qfBuilder.or(field, "=", value);
                continue;
            }
            if (s.startsWith(">=")) {
                value = this.getValueWithOutCondition(field, s, ">=");
                if (value == null) continue;
                qfBuilder.or(field, ">=", value);
                continue;
            }
            if (s.startsWith("<=")) {
                value = this.getValueWithOutCondition(field, s, "<=");
                if (value == null) continue;
                qfBuilder.or(field, "<=", value);
                continue;
            }
            if (s.startsWith(">")) {
                value = this.getValueWithOutCondition(field, s, ">");
                if (value == null) continue;
                qfBuilder.or(field, ">", value);
                continue;
            }
            if (s.startsWith("<")) {
                value = this.getValueWithOutCondition(field, s, "<");
                if (value == null) continue;
                qfBuilder.or(field, "<", value);
                continue;
            }
            if (s.startsWith("%")) {
                value = this.getValueWithOutCondition(field, s, "%");
                if (value == null) continue;
                qfBuilder.or(field, "like", (Object)("%" + value + "%"));
                continue;
            }
            value = this.getValueWithOutCondition(field, s, "");
            if (value == null) continue;
            values.add(value);
        }
        if (values.size() > 0) {
            qfBuilder.or(field, "in", values);
        }
        return qfBuilder;
    }
}

