/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.analytics.MDQADataQueryHelper;
import kd.fi.bcm.formplugin.analytics.service.AnalyticsDimMemService;
import kd.fi.bcm.formplugin.analytics.service.IQuickAnalyticsService;
import kd.fi.bcm.formplugin.analytics.service.QuickAnalysticFactory;
import kd.fi.bcm.formplugin.analytics.vo.SolutionRowColOrder;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.formplugin.util.TemplateUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.dao.Tuple;
import kd.fi.bcm.spread.util.SpreadMemberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalyticsSolutionHelper {
    private static final int initMaxColumnCount = 150;
    public static final String ROW_DIM = "rowdim";
    public static final String COL_DIM = "coldim";
    public static final Map<String, List<String>> EXCLUDETYPE_DIM = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
        {
            this.put("ORG", Collections.singletonList("Entity"));
            this.put("Period", Collections.singletonList("Period"));
            this.put("Year", Collections.singletonList("Year"));
            this.put("ORG_PERIOD", Arrays.asList("Entity", "Period"));
            this.put("ORG_YEAR", Arrays.asList("Year", "Entity"));
            this.put("YEAR_PERIOD", Arrays.asList("Year", "Period"));
            this.put("ORG_YEAR_PERIOD", Arrays.asList("Year", "Period", "Entity"));
        }
    });
    private static final Map<String, String> DIMID_NAME = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put(AnalyticsSolutionHelper.ROW_DIM, "rowdimid");
            this.put(AnalyticsSolutionHelper.COL_DIM, "columndimid");
        }
    });
    private static final Map<String, String> ORDERINDEX_NAME = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put(AnalyticsSolutionHelper.ROW_DIM, "roworderindex");
            this.put(AnalyticsSolutionHelper.COL_DIM, "colorderindex");
        }
    });
    private static final Map<String, String> MEMBERID_NAME = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put(AnalyticsSolutionHelper.ROW_DIM, "rowmenberid");
            this.put(AnalyticsSolutionHelper.COL_DIM, "columnmenberid");
        }
    });

    public static DynamicObject buildSolution(long modelId, long userId, Map<String, List<String>> selectDimMemberInfoMap, Map<String, String> commonMemberMap, Collection<String> rowDims, String type) {
        IQuickAnalyticsService instance = QuickAnalysticFactory.newInstance(type);
        DynamicObject solution = instance.buildSolution(modelId, selectDimMemberInfoMap, commonMemberMap, rowDims);
        return solution;
    }

    private static String getDimMemNumber(Map<String, List<String>> selectDimMemberInfoMap, Map<String, String> commonMemberMap, String dim) {
        String sceneNumber = commonMemberMap.get(dim);
        if (StringUtil.isEmptyString((String)sceneNumber)) {
            sceneNumber = selectDimMemberInfoMap.get(dim).get(0);
        }
        return sceneNumber;
    }

    public static SolutionRowColOrder buildRolColForSolution(long modelId, Map<String, List<String>> selectDimMemberInfoMap, DynamicObject solutionDy, Map<String, DynamicObject> allDimMap, List<String> rowColDimNumberList, Collection<String> rowDims, List<String> excludeDims) {
        int total = 1;
        int orderRow = 0;
        int orderCol = 0;
        ArrayList<Map.Entry<String, List<String>>> list = new ArrayList<Map.Entry<String, List<String>>>(selectDimMemberInfoMap.entrySet());
        list.sort(Comparator.comparingInt(o -> ((List)o.getValue()).size()));
        boolean hasExcludDims = CollectionUtils.isNotEmpty(excludeDims);
        for (Map.Entry entry : list) {
            String dimNumber = (String)entry.getKey();
            List memberNums = (List)entry.getValue();
            if (rowColDimNumberList.contains(dimNumber) || hasExcludDims && excludeDims.contains(dimNumber)) continue;
            rowColDimNumberList.add(dimNumber);
            if (rowDims.contains(dimNumber)) {
                AnalyticsSolutionHelper.buildRowDim(modelId, solutionDy, allDimMap, dimNumber, memberNums, orderRow);
                ++orderRow;
                continue;
            }
            AnalyticsSolutionHelper.buildColDim(modelId, solutionDy, allDimMap, dimNumber, memberNums, orderCol);
            ++orderCol;
            total *= memberNums.size();
        }
        return new SolutionRowColOrder(total, orderRow, orderCol);
    }

    public static void buildPageDimForSolution(long modelId, Map<String, String> commonMemberMap, DynamicObject solutionDy, DynamicObjectCollection allDimList, Map<String, DynamicObject> allDimMap, List<String> rowColDimNumberList) {
        int order = 0;
        for (DynamicObject dim : allDimList) {
            String dimNum = dim.getString("number");
            if (rowColDimNumberList.contains(dimNum)) continue;
            String memberNumber = commonMemberMap.get(dimNum);
            AnalyticsSolutionHelper.buildPageDim(modelId, solutionDy, allDimMap, dimNum, memberNumber, order);
            ++order;
        }
    }

    public static DynamicObject genNewSolutin(long modelId, long userId) {
        Date now = TimeServiceHelper.now();
        DynamicObject solutionDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_analyticssoluentry");
        solutionDy.set("createuserid", (Object)userId);
        solutionDy.set("createtime", (Object)now);
        solutionDy.set("updateuserid", (Object)userId);
        solutionDy.set("updatetime", (Object)now);
        solutionDy.set("solutionnumber", (Object)CodeRuleUtil.getCodeRuleNumber("bcm_analyticssoluentry", "createtime"));
        solutionDy.set("model", (Object)modelId);
        solutionDy.set("turnstatus", (Object)0);
        solutionDy.set("scope", (Object)Character.valueOf('1'));
        return solutionDy;
    }

    public static DynamicObjectCollection getAllDimdyByModelid(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection allDimList = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name,shortnumber,issysdimension", (QFilter[])new QFilter[]{qFilter}, (String)"number desc");
        return allDimList;
    }

    public static Map<String, DynamicObject> getDimNum2Dimdy(DynamicObjectCollection allDimList) {
        HashMap<String, DynamicObject> allDimMap = new HashMap<String, DynamicObject>();
        for (DynamicObject dim : allDimList) {
            allDimMap.put(dim.getString("number"), dim);
        }
        return allDimMap;
    }

    public static boolean chekcNeedDealMem(Map<String, String> commonMemberMap, Map<String, List<String>> selectDimMemberInfoMap, String dim, String dimType, String cube) {
        boolean needDeal = false;
        if (selectDimMemberInfoMap.containsKey(dim)) {
            String mem;
            IDNumberTreeNode memberByNumber;
            boolean leaf;
            needDeal = true;
            List<String> dimMems = selectDimMemberInfoMap.get(dim);
            if (dimMems != null && dimMems.size() == 1 && (leaf = (memberByNumber = MemberReader.findMemberByNumber((String)cube, (String)dimType, (String)(mem = dimMems.get(0)))).isLeaf())) {
                selectDimMemberInfoMap.remove(dim);
                commonMemberMap.put(dim, mem);
            }
        } else {
            boolean leaf;
            IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)cube, (String)dimType, (String)commonMemberMap.get(dim));
            needDeal = leaf = memberByNumber.isLeaf();
        }
        return needDeal;
    }

    public static void buildYearDim(long modelId, DynamicObject solutionDy, Map<String, DynamicObject> allDimMap, List<String> rowColDimNumberList, int orderCol, int total, String rowcol, String yearNum) {
        if (!rowColDimNumberList.contains("Year")) {
            ArrayList<String> years = new ArrayList<String>(16);
            DynamicObjectCollection allYear = AnalyticsSolutionHelper.getAllYear(modelId);
            if ((total *= allYear.size()) > 150) {
                years.add(yearNum);
            } else {
                for (DynamicObject year : allYear) {
                    String temp = year.getString("number");
                    if (years.contains(temp)) continue;
                    years.add(temp);
                }
            }
            if (COL_DIM.equals(rowcol)) {
                AnalyticsSolutionHelper.buildColDim(modelId, solutionDy, allDimMap, "Year", years, orderCol);
            } else {
                AnalyticsSolutionHelper.buildRowDim(modelId, solutionDy, allDimMap, "Year", years, orderCol);
            }
            rowColDimNumberList.add("Year");
        }
    }

    public static void buildPeriodDim(long modelId, DynamicObject solutionDy, Map<String, DynamicObject> allDimMap, List<String> rowColDimNumberList, int orderCol, int total, String rowcol, String sceneNum, String periodNum) {
        if (!rowColDimNumberList.contains("Period")) {
            DynamicObjectCollection periodCollection = AnalyticsSolutionHelper.getAllPeriod(modelId, sceneNum);
            ArrayList<String> periods = new ArrayList<String>(16);
            if (periodCollection != null && !periodCollection.isEmpty()) {
                if ((total *= periodCollection.size()) > 150) {
                    periods.add(periodNum);
                } else {
                    for (DynamicObject period : periodCollection) {
                        String temp = period.getString("number");
                        if (periods.contains(temp)) continue;
                        periods.add(temp);
                    }
                }
            }
            if (COL_DIM.equals(rowcol)) {
                AnalyticsSolutionHelper.buildColDim(modelId, solutionDy, allDimMap, "Period", periods, orderCol);
            } else {
                AnalyticsSolutionHelper.buildRowDim(modelId, solutionDy, allDimMap, "Period", periods, orderCol);
            }
            rowColDimNumberList.add("Period");
        }
    }

    public static void buildDimByPeriod(long modelId, DynamicObject obj, Map<String, DynamicObject> allDimMap, String sceneNumber, String rowcol) {
        DynamicObject dimMember = AnalyticsSolutionHelper.buildSaveDimOfDimInfo(obj, allDimMap, rowcol, "Period", DIMID_NAME.get(rowcol), ORDERINDEX_NAME.get(rowcol), 0);
        DynamicObjectCollection periodCollection = AnalyticsSolutionHelper.getAllPeriod(modelId, sceneNumber);
        if (periodCollection != null && !periodCollection.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DynamicObject member : periodCollection) {
                stringBuilder.append(member.getLong("id")).append(';').append(10).append(',');
            }
            dimMember.set(MEMBERID_NAME.get(rowcol), (Object)stringBuilder.substring(0, stringBuilder.length() - 1));
        }
    }

    public static void buildPeriodInCol(DynamicObject solution, Map<String, DynamicObject> allDimMap, List<String> rowColList, DynamicObjectCollection periodCollection) {
        DynamicObject dimMember = AnalyticsSolutionHelper.buildSaveDimOfDimInfo(solution, allDimMap, COL_DIM, "Period", DIMID_NAME.get(COL_DIM), ORDERINDEX_NAME.get(COL_DIM), 0);
        if (periodCollection != null && !periodCollection.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DynamicObject member : periodCollection) {
                stringBuilder.append(member.getLong("id")).append(';').append(10).append(',');
            }
            dimMember.set(MEMBERID_NAME.get(COL_DIM), (Object)stringBuilder.substring(0, stringBuilder.length() - 1));
            rowColList.add("Period");
        }
    }

    public static void buildDimByOrg(long modelId, DynamicObject solutionDy, Map<String, DynamicObject> allDimMap, Map<String, String> commonMemberMap, Map<String, List<String>> selectDimMemberInfoMap, List<String> rowColDimNumberList, boolean needDealAt, boolean needDealProcess, String rowcol) {
        List<String> entitys = AnalyticsSolutionHelper.getValueSetByDimNumber("Entity", commonMemberMap, selectDimMemberInfoMap);
        boolean isCol = COL_DIM.equals(rowcol);
        if (isCol) {
            AnalyticsSolutionHelper.buildColDim(modelId, solutionDy, allDimMap, "Entity", entitys, 0);
        } else {
            AnalyticsSolutionHelper.buildRowDim(modelId, solutionDy, allDimMap, "Entity", entitys, 0);
        }
        rowColDimNumberList.add("Entity");
        if (!needDealProcess) {
            List<String> processSet = AnalyticsSolutionHelper.getValueSetByDimNumber("Process", commonMemberMap, selectDimMemberInfoMap);
            if (isCol) {
                AnalyticsSolutionHelper.buildColDim(modelId, solutionDy, allDimMap, "Process", processSet, 1);
            } else {
                AnalyticsSolutionHelper.buildRowDim(modelId, solutionDy, allDimMap, "Process", processSet, 1);
            }
            rowColDimNumberList.add("Process");
        }
        if (!needDealAt && MemberReader.isExistAuditTrailDimension((long)modelId)) {
            List<String> auditSet = AnalyticsSolutionHelper.getValueSetByDimNumber("AuditTrail", commonMemberMap, selectDimMemberInfoMap);
            if (isCol) {
                AnalyticsSolutionHelper.buildColDim(modelId, solutionDy, allDimMap, "AuditTrail", auditSet, 2);
            } else {
                AnalyticsSolutionHelper.buildRowDim(modelId, solutionDy, allDimMap, "AuditTrail", auditSet, 2);
            }
            rowColDimNumberList.add("AuditTrail");
        }
    }

    private static List<String> getValueSetByDimNumber(String key, Map<String, String> commonMemberMap, Map<String, List<String>> selectDimMemberInfoMap) {
        String value = commonMemberMap.get(key);
        if (value != null) {
            return Collections.singletonList(value);
        }
        return selectDimMemberInfoMap.get(key);
    }

    private static DynamicObjectCollection getAllPeriod(Long modelId, String sceneNumber) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "=", (Object)sceneNumber);
        DynamicObject sceneDy = BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"id,number,sceneperiod", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection periodCollection = sceneDy.getDynamicObjectCollection("sceneperiod");
        HashSet<Long> periodIdSet = new HashSet<Long>();
        if (periodCollection != null && !periodCollection.isEmpty()) {
            for (DynamicObject member : periodCollection) {
                periodIdSet.add(member.getLong("fbasedataid_id"));
            }
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId).and("id", "in", periodIdSet);
        DynamicObjectCollection periodArray = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,number", (QFilter[])new QFilter[]{filter}, (String)"dseq");
        List<DynamicObject> periods = AnalyticsSolutionHelper.sortPeriodNums(modelId, DimTypesEnum.PERIOD.getNumber(), periodArray);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.addAll(periods);
        return collection;
    }

    public static List<DynamicObject> sortPeriodNums(long modelId, String dimnum, DynamicObjectCollection periodArray) {
        Map<String, Integer> periodSort = AnalyticsDimMemService.getMemberSort(modelId, dimnum, null);
        return periodArray.stream().sorted(Comparator.comparing(e -> (Integer)periodSort.get(e.getString("number")), Comparator.nullsLast(Integer::compareTo))).collect(Collectors.toList());
    }

    public static void buildDimByYear(long modelId, DynamicObject obj, Map<String, DynamicObject> allDimMap, String rowcol) {
        DynamicObject dimMember = AnalyticsSolutionHelper.buildSaveDimOfDimInfo(obj, allDimMap, rowcol, "Year", DIMID_NAME.get(rowcol), ORDERINDEX_NAME.get(rowcol), 0);
        DynamicObjectCollection members = AnalyticsSolutionHelper.getAllYear(modelId);
        if (CollectionUtils.isNotEmpty((Collection)members)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DynamicObject member : members) {
                stringBuilder.append(member.getLong("id")).append(';').append(10).append(',');
            }
            dimMember.set(MEMBERID_NAME.get(rowcol), (Object)stringBuilder.substring(0, stringBuilder.length() - 1));
        }
    }

    private static DynamicObjectCollection getAllYear(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("isleaf", "=", (Object)Character.valueOf('1')).and("number", "!=", (Object)"LastYear").and("number", "!=", (Object)"CurrentYear");
        return QueryServiceHelper.query((String)"bcm_fymembertree", (String)"id,number", (QFilter[])new QFilter[]{qFilter}, (String)"number");
    }

    private static void buildRowDim(long modelId, DynamicObject obj, Map<String, DynamicObject> allDimMap, String dimNumber, List<String> memberNumberSet, int order) {
        DynamicObject dimMember = AnalyticsSolutionHelper.buildSaveDimOfDimInfo(obj, allDimMap, ROW_DIM, dimNumber, "rowdimid", "roworderindex", order);
        if ("Entity".equalsIgnoreCase(dimNumber)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(memberNumberSet.get(0)).append(';').append(10);
            dimMember.set("rowmenberid", (Object)stringBuilder);
        } else {
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            StringBuilder stringBuilder = new StringBuilder();
            for (String memNum : memberNumberSet) {
                IDNumberTreeNode node = BcmThreadCache.findMemberByNum((String)modelNum, (String)dimNumber, (String)memNum);
                if (node == IDNumberTreeNode.NotFoundTreeNode) continue;
                stringBuilder.append(node.getId()).append(';').append(10).append(',');
            }
            dimMember.set("rowmenberid", (Object)stringBuilder.substring(0, stringBuilder.length() - 1));
        }
    }

    private static void buildColDim(long modelId, DynamicObject obj, Map<String, DynamicObject> allDimMap, String dimNumber, List<String> memberNumberSet, int order) {
        DynamicObject dimMember = AnalyticsSolutionHelper.buildSaveDimOfDimInfo(obj, allDimMap, COL_DIM, dimNumber, "columndimid", "colorderindex", order);
        if ("Entity".equalsIgnoreCase(dimNumber)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(memberNumberSet.get(0)).append(';').append(10);
            dimMember.set("columnmenberid", (Object)stringBuilder);
        } else {
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            StringBuilder stringBuilder = new StringBuilder();
            for (String memNum : memberNumberSet) {
                IDNumberTreeNode node = BcmThreadCache.findMemberByNum((String)modelNum, (String)dimNumber, (String)memNum);
                if (node == IDNumberTreeNode.NotFoundTreeNode) continue;
                stringBuilder.append(node.getId()).append(';').append(10).append(',');
            }
            if (stringBuilder.length() != 0) {
                dimMember.set("columnmenberid", (Object)stringBuilder.substring(0, stringBuilder.length() - 1));
            }
        }
    }

    private static void buildPageDim(long modelId, DynamicObject obj, Map<String, DynamicObject> allDimMap, String dimNumber, String memNumber, int order) {
        DynamicObject dimMember = AnalyticsSolutionHelper.buildSaveDimOfDimInfo(obj, allDimMap, "pagedim", dimNumber, "dimid", "orderindex", order);
        if ("entity".equalsIgnoreCase(dimNumber)) {
            dimMember.set("menberid", (Object)memNumber);
        } else {
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)dimNumber, (String)memNumber);
            if (node != IDNumberTreeNode.NotFoundTreeNode) {
                dimMember.set("menberid", (Object)node.getId());
            }
        }
    }

    private static DynamicObject buildSaveDimOfDimInfo(DynamicObject obj, Map<String, DynamicObject> allDimMap, String dimPanel, String dimNumber, String dimIdName, String orderIndexName, int order) {
        DynamicObjectCollection dimCol = obj.getDynamicObjectCollection(dimPanel);
        DynamicObject dimMember = dimCol.addNew();
        DynamicObject dim = allDimMap.get(dimNumber);
        dimMember.set(dimIdName, (Object)dim);
        dimMember.set(orderIndexName, (Object)order);
        return dimMember;
    }

    public static boolean checkSheetSize(List<IDNumberTreeNode>[] dimAndMember, Sheet sheet, boolean isH) {
        int othersize = isH ? sheet.getMaxRowCount() : sheet.getMaxColumnCount();
        int focussize = 1;
        for (List<IDNumberTreeNode> mems : dimAndMember) {
            focussize *= mems.size();
        }
        return AnalyticsSolutionHelper.checkSize(othersize * focussize);
    }

    public static boolean checkSize(int num) {
        return num > 1000000 && !ThreadCache.exists((Object)"isDoubleClick");
    }

    public static void collectCellDimMember(long modelId, Map<DimTypesEnum, Object> params, Map<DimTypesEnum, Object> paramIds, SpreadManager sm, SpreadSelector selector, Map<String, List<String>> selectDimMemberInfoMap, Map<String, String> commonMemberMap, Set<String> rowDims) {
        RangeModel rangeModel;
        Sheet sheet = sm.getBook().getSheet(0);
        List selectorSelections = selector.getSelections();
        ArrayList<Long> orgList = new ArrayList<Long>(16);
        boolean isHeaderMode = sheet.getMaxRowHeaderSize() > 0 && sheet.getMaxColHeaderSize() > 0;
        RangeModel rangeModel2 = rangeModel = isHeaderMode ? AnalyticsSolutionHelper.getDataRangeModel(sm) : null;
        if (CollectionUtils.isNotEmpty((Collection)selectorSelections)) {
            for (Map selection : selectorSelections) {
                Integer row = (Integer)selection.get("row");
                Integer col = (Integer)selection.get("col");
                AnalyticsSolutionHelper.collectSingleCellDimMems(sheet.getCell(row.intValue(), col.intValue()), modelId, params, sm, selectDimMemberInfoMap, rowDims, orgList, isHeaderMode, rangeModel);
            }
        } else {
            sheet.iteratorRangeCells(new RangeModel(selector.getRangePosition()), false, cell -> AnalyticsSolutionHelper.collectSingleCellDimMems(cell, modelId, params, sm, selectDimMemberInfoMap, rowDims, orgList, isHeaderMode, rangeModel));
        }
        if (selectDimMemberInfoMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u5143\u683c\u65e0\u6709\u6548\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"AbstractMultiReportPlugin_189", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        ArrayList<Long> orgList_copy = new ArrayList<Long>(16);
        if (!orgList.isEmpty()) {
            long scenarioId = AnalyticsSolutionHelper.getMemberId(modelNum, PresetConstant.SCENE_DIM, (String)params.get(DimTypesEnum.SCENARIO));
            long periodId = AnalyticsSolutionHelper.getMemberId(modelNum, PresetConstant.PERIOD_DIM, (String)params.get(DimTypesEnum.PERIOD));
            String yearNum = (String)params.get(DimTypesEnum.YEAR);
            String originNumber = MemberReader.findEntityMemberById((String)modelNum, (Long)((Long)paramIds.get(DimTypesEnum.ENTITY))).getNumber();
            for (Long orgId : orgList) {
                String number = MemberReader.findEntityMemberById((String)modelNum, (Long)orgId).getNumber();
                if (number.equals(originNumber)) {
                    orgList_copy.add((Long)paramIds.get(DimTypesEnum.ENTITY));
                    continue;
                }
                orgList_copy.add(orgId);
            }
            orgList.clear();
            orgList.addAll(orgList_copy);
            List disableOrg = EntityVersioningUtil.getOrgsByVersion((long)modelId, (long)scenarioId, (String)yearNum, (long)periodId, orgList);
            if (CollectionUtils.isNotEmpty((Collection)disableOrg)) {
                for (Long id : disableOrg) {
                    if (!orgList.contains(id)) continue;
                    IDNumberTreeNode treeNode = BcmThreadCache.findNodeById((String)modelNum, (String)PresetConstant.ENTITY_DIM, (long)id);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u5143\u683c\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u53ef\u7528\u3002", (String)"AbstractMultiReportPlugin_236", (String)"fi-bcm-formplugin", (Object[])new Object[0]), treeNode != null ? treeNode.getName() : id));
                }
            }
            selectDimMemberInfoMap.put(PresetConstant.ENTITY_DIM, orgList.stream().map(c -> Long.toString(c)).collect(Collectors.toList()));
        }
        if (MapUtils.isNotEmpty(selectDimMemberInfoMap)) {
            AnalyticsSolutionHelper.fillDimMemToMap(sm.getFilter().getPageDomain().getAllMembers(), commonMemberMap);
            AnalyticsSolutionHelper.fillDimMemToMap(sm.getFilter().getViewPointDomain().getAllMembers(), commonMemberMap);
            selectDimMemberInfoMap.forEach((k, v) -> {
                if (PresetConstant.FY_DIM.equals(k) || PresetConstant.PERIOD_DIM.equals(k)) {
                    String pageParam = (String)commonMemberMap.get(k);
                    if (CollectionUtils.isNotEmpty((Collection)v) && StringUtils.isNotEmpty((CharSequence)pageParam) && (!v.contains(pageParam) || v.size() > 1)) {
                        commonMemberMap.remove(k);
                        if (PresetConstant.PERIOD_DIM.equals(k) && rowDims.contains(PresetConstant.FY_DIM)) {
                            rowDims.add(PresetConstant.PERIOD_DIM);
                        }
                        if (PresetConstant.FY_DIM.equals(k) && rowDims.contains(PresetConstant.PERIOD_DIM)) {
                            rowDims.add(PresetConstant.FY_DIM);
                        }
                    }
                }
            });
            commonMemberMap.forEach((k, v) -> {
                List cfr_ignored_0 = (List)selectDimMemberInfoMap.remove(k);
            });
            String orgNum = commonMemberMap.get(PresetConstant.ENTITY_DIM);
            if (StringUtils.isNotEmpty((CharSequence)orgNum)) {
                commonMemberMap.put(PresetConstant.ENTITY_DIM, Long.toString(AnalyticsSolutionHelper.getMemberId(modelNum, PresetConstant.ENTITY_DIM, orgNum)));
            }
        }
    }

    private static void fillDimMemToMap(List<IDimMember> dimMembers, Map<String, String> commonMemberMap) {
        dimMembers.forEach(d -> {
            String dimNum = d.getDimension().getNumber();
            if (PresetConstant.ENTITY_DIM.equals(dimNum)) {
                commonMemberMap.put(dimNum, StringUtils.isNotEmpty((CharSequence)d.getPar_SonNum()) ? d.getPar_SonNum() : d.getNumber());
            } else {
                commonMemberMap.put(dimNum, d.getNumber());
            }
        });
    }

    private static long getMemberId(String modelNum, String dimNum, String memNum) {
        IDNumberTreeNode node = BcmThreadCache.findMemberByNum((String)modelNum, (String)dimNum, (String)memNum);
        long id = 0L;
        if (node != IDNumberTreeNode.NotFoundTreeNode) {
            id = node.getId();
        }
        return id;
    }

    private static void collectSingleCellDimMems(Cell cell, long modelId, Map<DimTypesEnum, Object> params, SpreadManager sm, Map<String, List<String>> selectDimMemberInfoMap, Set<String> rowDims, List<Long> orgList, boolean isHeaderMode, RangeModel rangeModel) {
        if (cell.isMdDataDomain() || isHeaderMode) {
            String modelNum = (String)ThreadCache.get((Object)String.join((CharSequence)"_", "collectSingleCellDimMems", modelId + ""), () -> MemberReader.findModelNumberById((Object)modelId));
            if (CollectionUtils.isEmpty(rowDims)) {
                if (isHeaderMode) {
                    rowDims.addAll(sm.getBook().getSheet(0).getRowHeader().getDimNums());
                } else {
                    AnalyticsSolutionHelper.fillRowDims(cell.getRow(), cell.getCol(), sm, rowDims);
                }
            }
            Map<String, String> cellDimMemberMap = new HashMap(16);
            if (isHeaderMode) {
                HashMap<String, String> pageMemberMap = new HashMap<String, String>(16);
                AnalyticsSolutionHelper.fillDimMemToMap(sm.getFilter().getPageDomain().getAllMembers(), pageMemberMap);
                AnalyticsSolutionHelper.fillDimMemToMap(sm.getFilter().getViewPointDomain().getAllMembers(), pageMemberMap);
                Map<String, Object> cellInfo = MDQADataQueryHelper.getCellInfo(modelId, sm.getBook().getSheet(0), cell.getRow(), cell.getCol(), pageMemberMap, rangeModel);
                if (MapUtils.isNotEmpty(cellInfo)) {
                    cellDimMemberMap = (LinkedHashMap)cellInfo.get("dimNumber2MembNumber");
                }
            } else {
                cellDimMemberMap = SpreadMemberUtil.getCellDimMemberMap((SpreadManager)sm, params, (Cell)cell, (long)modelId, (boolean)true);
            }
            cellDimMemberMap.forEach((k, v) -> {
                long memberId;
                List mems = selectDimMemberInfoMap.computeIfAbsent((String)k, c -> new ArrayList(16));
                if (!mems.contains(v)) {
                    mems.add(v);
                }
                if (PresetConstant.ENTITY_DIM.equals(k) && (memberId = AnalyticsSolutionHelper.getMemberId(modelNum, k, v)) != 0L) {
                    orgList.add(memberId);
                }
            });
        }
    }

    public static String getPeriodNums(long modelId, Map<DimTypesEnum, Object> params, SpreadManager sm, SpreadSelector selector) {
        RangeModel rangeModel;
        Sheet sheet = sm.getBook().getSheet(0);
        List selectorSelections = selector.getSelections();
        HashMap<String, String> commonMemberMap = new HashMap<String, String>(16);
        AnalyticsSolutionHelper.fillDimMemToMap(sm.getFilter().getPageDomain().getAllMembers(), commonMemberMap);
        AnalyticsSolutionHelper.fillDimMemToMap(sm.getFilter().getViewPointDomain().getAllMembers(), commonMemberMap);
        if (!commonMemberMap.containsKey(PresetConstant.PERIOD_DIM) || commonMemberMap.containsKey(PresetConstant.FY_DIM)) {
            return null;
        }
        String curPeriodNum = (String)commonMemberMap.get(PresetConstant.PERIOD_DIM);
        ArrayList<Long> orgList = new ArrayList<Long>(16);
        HashSet<String> rowDims = new HashSet<String>(16);
        HashMap<String, List<String>> selectDimMemberInfoMap = new HashMap<String, List<String>>(16);
        boolean isHeaderMode = sheet.getMaxRowHeaderSize() > 0 && sheet.getMaxColHeaderSize() > 0;
        RangeModel rangeModel2 = rangeModel = isHeaderMode ? AnalyticsSolutionHelper.getDataRangeModel(sm) : null;
        if (CollectionUtils.isNotEmpty((Collection)selectorSelections)) {
            for (Map selection : selectorSelections) {
                Integer row = (Integer)selection.get("row");
                Integer col = (Integer)selection.get("col");
                AnalyticsSolutionHelper.collectSingleCellDimMems(sheet.getCell(row.intValue(), col.intValue()), modelId, params, sm, selectDimMemberInfoMap, rowDims, orgList, isHeaderMode, rangeModel);
            }
        } else {
            sheet.iteratorRangeCells(new RangeModel(selector.getRangePosition()), false, cell -> AnalyticsSolutionHelper.collectSingleCellDimMems(cell, modelId, params, sm, selectDimMemberInfoMap, rowDims, orgList, isHeaderMode, rangeModel));
        }
        List periods = (List)selectDimMemberInfoMap.get(PresetConstant.PERIOD_DIM);
        if (CollectionUtils.isNotEmpty((Collection)periods) && periods.size() == 1) {
            return periods.contains(curPeriodNum) ? null : (String)periods.get(0);
        }
        return "";
    }

    public static RangeModel getDataRangeModel(SpreadManager sm) {
        RangeModel rangeModel = new RangeModel("A1");
        Pair<Point, Point> pair = AnalyticsSolutionHelper.getAreaRange(sm);
        if (pair != null && pair.p1 != null && pair.p2 != null) {
            rangeModel = new RangeModel(pair.p1 + ":" + pair.p2);
        }
        return rangeModel;
    }

    private static Pair<Point, Point> getAreaRange(SpreadManager spreadManager) {
        Point startPoint = null;
        Point endPoint = null;
        for (PositionInfo ps : spreadManager.getAreaManager().getPostionInfoSet()) {
            String areaRange = ps.getAreaRange();
            String[] split = areaRange.split(":");
            Point currentStartPoint = ExcelUtils.pos2Point((String)split[0]);
            Point currentEndPoint = ExcelUtils.pos2Point((String)split[1]);
            if (startPoint == null || endPoint == null) {
                startPoint = currentStartPoint;
                endPoint = currentEndPoint;
                continue;
            }
            if (startPoint.y > currentStartPoint.y) {
                startPoint = currentStartPoint;
            }
            if (endPoint.y >= currentEndPoint.y) continue;
            endPoint = currentEndPoint;
        }
        if (startPoint != null && endPoint != null) {
            Sheet sheet = spreadManager.getBook().getSheet(0);
            startPoint = AnalyticsSolutionHelper.correnctAreaRange(sheet, startPoint);
            endPoint = AnalyticsSolutionHelper.correnctAreaRange(sheet, endPoint);
        }
        return Pair.onePair(startPoint, endPoint);
    }

    private static Point correnctAreaRange(Sheet sheet, Point point) {
        if (point != null) {
            int row = point.y;
            int col = point.x;
            int maxRowCount = sheet.getMaxRowCount();
            int maxColumnCount = sheet.getMaxColumnCount();
            boolean isNeedCo = false;
            if (row > maxRowCount - 1) {
                row = maxRowCount - 1;
                isNeedCo = true;
            }
            if (col > maxColumnCount - 1) {
                col = maxColumnCount - 1;
                isNeedCo = true;
            }
            if (isNeedCo) {
                return ExcelUtils.pos2Point((String)ExcelUtils.xy2Pos((int)col, (int)row));
            }
        }
        return point;
    }

    private static void fillRowDims(int r, int c, SpreadManager sm, Set<String> rowDims) {
        Tuple rcDomainByPosition;
        PositionInfo position = TemplateUtil.getOverlapPosition(r, c, sm);
        if (position != null && (rcDomainByPosition = sm.getAreaManager().getRowAndColDomainByPosition(position)) != null && rcDomainByPosition.k != null) {
            ((RowDimDomain)rcDomainByPosition.k).getDimensions().forEach(d -> rowDims.add(d.getNumber()));
        }
    }
}

