/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.AnalyticsSolutionScopeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.analytics.QueryAnalysisPermHelper;
import kd.fi.bcm.formplugin.analytics.SearchHelper;
import kd.fi.bcm.formplugin.analytics.service.AnalyticsSolutionService;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalyticsSolutionSaveOtherPlugin
extends AbstractBaseFormPlugin {
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_CATALOG = "catalog";
    private static final String SCOPE = "scope";
    private static final String SCOPE_BY_PERM_CLASS = "2";
    private static final String PERM_CLASS = "permclass";
    private static final String EXTMODEL = "extmodel";
    public static final Set<String> PAGEDIMS = Sets.newHashSet((Object[])new String[]{"Entity", "Scenario", "Year", "Period", "Currency", "Process", "AuditTrail"});

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit extmodel;
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(BTN_CATALOG);
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((extmodel = (BasedataEdit)this.getControl(EXTMODEL)) != null) {
            extmodel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(BTN_CANCEL, BTN_SAVE, BTN_CATALOG);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl(PERM_CLASS)), (Object)this.getModelId());
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        boolean isSupportXDataQuery;
        String itemKey;
        boolean isFromSaveAs;
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String modelId = customParams.get("model").toString();
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        this.getModel().setValue("model", (Object)modelId);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        boolean editFlag = status == OperationStatus.EDIT;
        Object solutionId = customParams.get("solutionId");
        if (solutionId != null && editFlag) {
            SearchHelper.setObjectCache(this.getView(), "solutionId", solutionId);
        }
        boolean bl = isFromSaveAs = StringUtil.equals((String)"btn_saveother", (String)(itemKey = (String)this.getView().getFormShowParameter().getCustomParam("ItemKey"))) || StringUtil.equals((String)"save_other", (String)itemKey);
        if (editFlag || isFromSaveAs) {
            DynamicObject solution;
            if (editFlag) {
                SearchHelper.setObjectCache(this.getView(), "solutionId", customParams.get("solutionId"));
            }
            if ((solution = this.getCurrentAnalyticsSolution()) != null) {
                if (editFlag) {
                    this.getModel().setValue("solutionname", (Object)solution.getString("solutionname"));
                    this.getModel().setValue(SCOPE, (Object)solution.getString(SCOPE));
                    this.getModel().setValue("explanation", (Object)solution.getString("explanation"));
                    this.getModel().setValue(BTN_CATALOG, solution.get(BTN_CATALOG));
                    this.setPermClassValue(solution);
                    this.setEnableFields(solution.getString("solutionname"));
                    if (QueryAnalysisPermHelper.isNoPermEdit(this.getModelId(), solution, this.getBizAppId())) {
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{"solutionname", SCOPE, PERM_CLASS, "explanation", BTN_CATALOG});
                    }
                }
                String solutionType = solution.getString("solutiontype");
                this.getModel().setValue("solutiontype", (Object)solutionType);
                if (!"0".equals(solutionType)) {
                    this.getModel().setValue(EXTMODEL, (Object)solution.getLong("extmodel.id"));
                }
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"solutiontype"});
            }
            this.setVisibleByIsHwApp();
        }
        if (!(isSupportXDataQuery = ConfigServiceHelper.getBoolParam((Long)LongUtil.toLong((Object)modelId), (String)"isSupportXDataQuery"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"solutiontype"});
        }
        this.setPermClassVisibleStatus(SCOPE_BY_PERM_CLASS.equals(this.getValue(SCOPE)));
        this.setExtModelEnable("1".equals(this.getValue("solutiontype")) && !editFlag && !isFromSaveAs);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_CATALOG});
    }

    private void setEnableFields(String solutionname) {
        if (solutionname.equals(ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848", (String)"AnalyticsSolutionSaveOtherPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"solutionname", SCOPE});
        }
    }

    private void setVisibleByIsHwApp() {
        boolean isHwApp = ConfigServiceHelper.isHwApp();
        if (!isHwApp) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CATALOG});
        }
    }

    private void setPermClassValue(DynamicObject solution) {
        DynamicObject permClass;
        if (SCOPE_BY_PERM_CLASS.equals(this.getValue(SCOPE)) && (permClass = PermClassEntityHelper.getPermissionClassEntity((String)"bcm_analyticssoluentry", (Long)solution.getLong("id"), (Object)this.getModelId())) != null) {
            this.getModel().setValue(PERM_CLASS, (Object)permClass.getLong("permclass.id"));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changePropertyName = e.getProperty().getName();
        if (SCOPE.equals(changePropertyName)) {
            if (SCOPE_BY_PERM_CLASS.equals(this.getValue(SCOPE))) {
                this.setPermClassVisibleStatus(true);
            } else {
                this.setPermClassVisibleStatus(false);
                this.getModel().setValue(PERM_CLASS, null);
            }
        } else if ("solutiontype".equals(changePropertyName)) {
            if ("0".equals(this.getValue("solutiontype"))) {
                this.setExtModelEnable(false);
                this.getModel().setValue(EXTMODEL, null);
            } else {
                this.setExtModelEnable(true);
            }
        }
    }

    private void setExtModelEnable(boolean aBoolean) {
        this.getView().setEnable(Boolean.valueOf(aBoolean), new String[]{EXTMODEL});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_SAVE.equals(key)) {
            QueryAnalysisPermHelper.checkItemPerm(this.getModelId(), key, this.getBizAppId());
            this.saveOrUpdateInfo();
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (BTN_CATALOG.equals(key)) {
            beforeF7SelectEvent.setCancel(true);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_filelistentitytree");
            showParameter.setCaption(ResManager.loadKDString((String)"\u5206\u7c7b", (String)"AnalyticsSolutionSaveOtherPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_filelistentitytree");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else if (EXTMODEL.equals(key)) {
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            qFilter.and("extendsgroup.number", "!=", (Object)"INVEST");
            beforeF7SelectEvent.getCustomQFilters().add(qFilter);
        }
        super.beforeF7Select(beforeF7SelectEvent);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "bcm_filelistentitytree": {
                Map result = (Map)evt.getReturnData();
                if (result == null) {
                    return;
                }
                long catalogId = Long.parseLong(result.get("id").toString());
                DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)catalogId, (String)"bcm_templatecatalog");
                this.getModel().setValue(BTN_CATALOG, (Object)dy);
            }
        }
    }

    private DynamicObject getCurrentAnalyticsSolution() {
        DynamicObject solution;
        Long solutionId = (Long)SearchHelper.getObjectCache(this.getView(), "solutionId");
        if (solutionId != null && solutionId > 0L) {
            solution = BusinessDataServiceHelper.loadSingle((Object)solutionId, (String)"bcm_analyticssoluentry");
        } else {
            String solutionSerial = (String)this.getFormCustomParam("solutionSerial");
            solution = (DynamicObject)this.deSerializedBytes(solutionSerial);
        }
        return solution;
    }

    private void saveOrUpdateInfo() {
        DynamicObject solution;
        Object extmodel;
        String solutionName = (String)this.getModel().getValue("solutionname");
        if (StringUtil.isEmptyString((String)solutionName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnalyticsSolutionSaveOtherPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String solutionType = (String)this.getModel().getValue("solutiontype");
        if (!"0".equals(solutionType) && (extmodel = this.getModel().getValue(EXTMODEL)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnalyticsSolutionSaveOtherPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String scope = (String)this.getModel().getValue(SCOPE);
        if (StringUtil.equals((String)(AnalyticsSolutionScopeEnum.PERM_CLASS.getKey() + ""), (String)scope) && this.getValue(PERM_CLASS) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnalyticsSolutionSaveOtherPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String opName = "";
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!this.validataBeforeSave(status, solutionName, (solution = this.getCurrentAnalyticsSolution()).getLong("id"))) {
            return;
        }
        if (status == OperationStatus.EDIT) {
            String tips = QueryAnalysisPermHelper.beforeModifyData(this.getPageCache(), Lists.newArrayList((Object[])new DynamicObject[]{solution}), this.getModelId());
            if (StringUtils.isNotEmpty((CharSequence)tips)) {
                this.getView().showTipNotification(tips);
                return;
            }
            solution.set("updateuserid", (Object)this.getUserId());
            solution.set("updatetime", (Object)TimeServiceHelper.now());
            solution.set("solutionname", (Object)solutionName);
            solution.set(SCOPE, this.getModel().getValue(SCOPE));
            solution.set("explanation", this.getModel().getValue("explanation"));
            solution.set(BTN_CATALOG, this.getModel().getValue(BTN_CATALOG));
            SaveServiceHelper.update((DynamicObject)solution);
            PermClassEntityHelper.savePermClass((IDataModel)this.getModel(), (String)solution.getDataEntityType().getExtendName(), (Long)((Long)solution.getPkValue()), (Object)this.getModelId(), (OperationStatus)status);
            opName = ResManager.loadKDString((String)"\u7f16\u8f91\u65b9\u6848", (String)"AnalyticsSolutionSaveOtherPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        } else if (status == OperationStatus.ADDNEW) {
            String itemKey;
            boolean isSameType = ObjectUtils.equals((Object)solutionType, (Object)solution.get("solutiontype"));
            if (!isSameType && "0".equals(solutionType)) {
                AnalyticsSolutionService.getAnalyticsSolutionService();
                solution = AnalyticsSolutionService.getDefaultSolutionDy(this.getModelId());
                if (solution == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848\u4e3a\u7a7a\u3002", (String)"AnalyticsSolutionSaveOtherPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            Date now = TimeServiceHelper.now();
            CloneUtils cloneUtils = new CloneUtils(true, true);
            DynamicObject newSolution = (DynamicObject)cloneUtils.clone(solution.getDataEntityType(), (Object)solution);
            newSolution.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            newSolution.set("createtime", (Object)now);
            newSolution.set("updatetime", (Object)now);
            newSolution.set("createuserid", (Object)this.getUserId());
            newSolution.set("updateuserid", (Object)this.getUserId());
            newSolution.set("solutionnumber", (Object)CodeRuleUtil.getCodeRuleNumber("bcm_analyticssoluentry", "createtime"));
            LocaleString ls_solutionName = new LocaleString();
            ls_solutionName.put("zh_CN", (Object)solutionName);
            ls_solutionName.put("en_US", (Object)solutionName);
            ls_solutionName.put("zh_TW", (Object)solutionName);
            newSolution.set("solutionname", (Object)ls_solutionName);
            newSolution.set("turnstatus", (Object)0);
            newSolution.set(SCOPE, this.getModel().getValue(SCOPE) == null ? "1" : Character.valueOf(this.getModel().getValue(SCOPE).toString().charAt(0)));
            newSolution.set("explanation", this.getModel().getValue("explanation"));
            solution.set(BTN_CATALOG, this.getModel().getValue(BTN_CATALOG));
            newSolution.set("solutiontype", (Object)solutionType);
            if ("0".equals(solutionType)) {
                this.dimSolutionPageRowCol(newSolution);
            } else {
                boolean isFromSaveAs;
                itemKey = (String)this.getView().getFormShowParameter().getCustomParam("ItemKey");
                boolean bl = isFromSaveAs = StringUtil.equals((String)"btn_saveother", (String)itemKey) || StringUtil.equals((String)"save_other", (String)itemKey);
                if (!isFromSaveAs) {
                    this.dealExtSolution(newSolution);
                } else {
                    AnalyticsSolutionService.dealExtSolution4Save(newSolution);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newSolution});
            if (this.getValue(PERM_CLASS) != null) {
                PermClassEntityHelper.savePermClass((IDataModel)this.getModel(), (String)newSolution.getDataEntityType().getExtendName(), (Long)((Long)newSolution.getPkValue()), (Object)this.getModelId(), (OperationStatus)status);
            }
            opName = StringUtil.equals((String)"btn_saveother", (String)(itemKey = (String)this.getView().getFormShowParameter().getCustomParam("ItemKey"))) ? ResManager.loadKDString((String)"\u65b9\u6848\u53e6\u5b58\u4e3a", (String)"AnalyticsSolutionSaveOtherPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65b0\u589e\u65b9\u6848", (String)"AnalyticsSolutionSaveOtherPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.getView().returnDataToParent((Object)newSolution.getLong("id"));
            this.getView().getParentView().getFormShowParameter().setCustomParam("model", (Object)this.getModelId());
            this.getView().getParentView().getFormShowParameter().setCustomParam("solutionSerial", (Object)this.toByteSerialized(newSolution));
            this.getView().close();
        }
        if (!StringUtil.isEmptyString((String)opName)) {
            String opDescribe = String.format(ResManager.loadKDString((String)"%s\u4fdd\u5b58\u6210\u529f", (String)"AnalyticsSolutionSaveOtherPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), solutionName);
            this.writeLog(opName, opDescribe, "bcm_analyticssolutiondata");
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AnalyticsSolutionSaveOtherPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void dealExtSolution(DynamicObject newSolution) {
        long modelId = this.getModelId();
        Object extModel = this.getModel().getValue(EXTMODEL);
        long extModelId = ((DynamicObject)extModel).getLong("id");
        Map<String, String> userSelectNumber = AnalyticsSolutionService.getAnalyticsSolutionService().getUserSelectNumber(this.getView(), modelId);
        this.extModelSolutionPageRowCol(modelId, newSolution, userSelectNumber, extModelId);
        newSolution.set(EXTMODEL, extModel);
    }

    private void dimSolutionPageRowCol(DynamicObject newSolution) {
        DynamicObjectCollection pageDim = newSolution.getDynamicObjectCollection("pagedim");
        Map dimValueMap = (Map)this.getView().getFormShowParameter().getCustomParam("pageDimValueMap");
        for (Object dynamic : pageDim) {
            long dimId = dynamic.getDynamicObject("dimid").getLong("id");
            dynamic.set("dimid", (Object)dimId);
            dynamic.set("dimid_id", (Object)dimId);
            dynamic.set("orderindex_id", (Object)dynamic.getInt("orderindex"));
            Long memberId = (Long)dimValueMap.get(dimId);
            if (memberId == null) {
                dynamic.set("menberid", null);
                continue;
            }
            dynamic.set("menberid", (Object)memberId);
        }
        DynamicObjectCollection rowDim = newSolution.getDynamicObjectCollection("rowdim");
        for (DynamicObject dim : rowDim) {
            long dimId = dim.getDynamicObject("rowdimid").getLong("id");
            dim.set("rowdimid", (Object)dimId);
            dim.set("rowdimid_id", (Object)dimId);
            dim.set("roworderindex_id", (Object)dim.getInt("roworderindex"));
        }
        DynamicObjectCollection coldim = newSolution.getDynamicObjectCollection("coldim");
        for (DynamicObject dim : coldim) {
            long dimId = dim.getDynamicObject("columndimid").getLong("id");
            dim.set("columndimid", (Object)dimId);
            dim.set("columndimid_id", (Object)dimId);
            dim.set("colorderindex_id", (Object)dim.getInt("colorderindex"));
        }
    }

    private void extModelSolutionPageRowCol(Long modelId, DynamicObject newSolution, Map<String, String> useSelectMap, Long extModelId) {
        AnalyticsSolutionService.getAnalyticsSolutionService().setDefaultPageRowColDim4extSolution(modelId, newSolution, useSelectMap, extModelId);
    }

    private void setPermClassVisibleStatus(boolean flag) {
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{PERM_CLASS});
    }

    private boolean validataBeforeSave(OperationStatus opStatus, String solutionName, Long solutionId) {
        QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
        if (opStatus == OperationStatus.EDIT) {
            qf.and("solutionname", "=", (Object)solutionName);
            qf.and("id", "!=", (Object)solutionId);
            if (QueryServiceHelper.exists((String)"bcm_analyticssoluentry", (QFilter[])qf.toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"AnalyticsSolutionSaveOtherPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (opStatus == OperationStatus.ADDNEW) {
            qf.and("solutionname", "=", (Object)solutionName);
            if (QueryServiceHelper.exists((String)"bcm_analyticssoluentry", (QFilter[])qf.toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"AnalyticsSolutionSaveOtherPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }
}

