/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.AnalyticsSolutionScopeEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.analytics.QueryAnalysisPermHelper;
import org.apache.commons.lang3.StringUtils;

public class AnalyticsSolutionsListPlugin
extends AbstractBaseListPlugin {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(AnalyticsSolutionsListPlugin.class);
    private static final String modelCacheKey = "KEY_MODEL_ID";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String BTN_CHANGE = "btn_change";
    private static final String BTN_DELETE = "btn_delete";

    private String getOperationStstusDelete() {
        return ResManager.loadKDString((String)"\u5220\u9664", (String)"AnalyticsSolutionsListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"AnalyticsSolutionsListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusDeleteCase() {
        return ResManager.loadKDString((String)"\u5220\u9664\u65b9\u6848", (String)"AnalyticsSolutionsListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
        EntryGrid eg = (EntryGrid)this.getView().getControl("solutionslist");
        eg.addHyperClickListener(this::hyperLinkClick);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_CANCEL, BTN_CHANGE, BTN_DELETE);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = this.getView().getFormShowParameter().getCustomParam("model").toString();
        this.getModel().beginInit();
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put(modelCacheKey, modelId);
        this.getModel().setDataChanged(false);
        this.getModel().endInit();
        this.buildAllData();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_CANCEL.equals(key)) {
            this.getView().close();
        }
        if (BTN_CHANGE.equals(key)) {
            EntryGrid eg = (EntryGrid)this.getView().getControl("solutionslist");
            int[] selectRows = eg.getSelectRows();
            if (selectRows.length == 1) {
                if (this.getModel().getEntryEntity("solutionslist") != null && this.getModel().getEntryEntity("solutionslist").size() <= selectRows[0]) {
                    return;
                }
                DynamicObject selectRowObj = (DynamicObject)this.getModel().getEntryEntity("solutionslist").get(selectRows[0]);
                DynamicObject md = (DynamicObject)this.getModel().getValue("model");
                this.getView().getParentView().getFormShowParameter().setCustomParam("model", md.get("id"));
                this.getView().getParentView().getFormShowParameter().setCustomParam("modelNumber", md.get("number"));
                this.getView().returnDataToParent((Object)selectRowObj.getLong("id"));
                DynamicObject solution = BusinessDataServiceHelper.loadSingle((Object)selectRowObj.getLong("id"), (String)"bcm_analyticssoluentry");
                this.getView().getParentView().getFormShowParameter().setCustomParam("solutionSerial", (Object)this.toByteSerialized(solution));
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u3002", (String)"AnalyticsSolutionsListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        if (BTN_DELETE.equals(key)) {
            QueryAnalysisPermHelper.checkItemPerm(this.getModelId(), key, this.getBizAppId());
            this.askDeleteSolution();
        }
    }

    private void askDeleteSolution() {
        EntryGrid eg = (EntryGrid)this.getView().getControl("solutionslist");
        int[] selectRows = eg.getSelectRows();
        if (selectRows.length > 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_DELETE);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u9009\u4e2d\u7684\u65b9\u6848\u5417\uff1f", (String)"AnalyticsSolutionsListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"AnalyticsSolutionsListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void deleteSolution() {
        EntryGrid eg = (EntryGrid)this.getView().getControl("solutionslist");
        int[] selectRows = eg.getSelectRows();
        DynamicObjectCollection solutionslist = this.getModel().getEntryEntity("solutionslist");
        ArrayList<DynamicObject> dyos = new ArrayList<DynamicObject>(16);
        String tips = QueryAnalysisPermHelper.beforeDeleteData(this.getPageCache(), selectRows, solutionslist, this.getModelId(), dyos);
        int selectRow = selectRows.length;
        if (StringUtils.isNotEmpty((CharSequence)tips)) {
            this.getView().showTipNotification(tips);
        }
        if (dyos.isEmpty()) {
            return;
        }
        Long currentUseSolutionId = (Long)this.getView().getFormShowParameter().getCustomParam("solutionId");
        if (currentUseSolutionId == null) {
            currentUseSolutionId = 0L;
        }
        HashSet<Long> ids = new HashSet<Long>(dyos.size());
        ArrayList<DynamicObject> deleteDyos = new ArrayList<DynamicObject>(dyos.size());
        for (DynamicObject obj : dyos) {
            long id = obj.getLong("id");
            String solutionName = obj.getString("solutionname");
            if (id == currentUseSolutionId) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u5f53\u524d\u4f7f\u7528\u7684\u65b9\u6848\u3002", (String)"AnalyticsSolutionsListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (solutionName.equals(ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848", (String)"AnalyticsSolutionsListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u9ed8\u8ba4\u65b9\u6848\u3002", (String)"AnalyticsSolutionsListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                continue;
            }
            ids.add(id);
            deleteDyos.add(obj);
        }
        if (!ids.isEmpty()) {
            DeleteServiceHelper.delete((String)"bcm_analyticssoluentry", (QFilter[])new QFilter("id", "in", ids).toArray());
            this.writeDelLog(deleteDyos);
            if (ids.size() != selectRow) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210\uff0c\u4ec5\u5220\u9664\u4e86\u6709\u4fee\u6539\u6743\u9650\u7684\u65b9\u6848\u3002", (String)"AnalyticsSolutionsListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AnalyticsSolutionsListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.buildAllData();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (BTN_DELETE.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.deleteSolution();
        }
    }

    private void writeDelLog(Collection<DynamicObject> delDoc) {
        for (DynamicObject dy : delDoc) {
            String solutionName = dy.getLocaleString("solutionname").getLocaleValue();
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664\u65b9\u6848", "AnalyticsSolutionsListPlugin_3", "fi-bcm-formplugin", "delete solution"), new OPDescMultiLangEnumBridge("%s \u5220\u9664\u6210\u529f", "AnalyticsSolutionsListPlugin_14", "fi-bcm-formplugin", new String[]{solutionName}));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("refreshList")) {
            this.buildAllData();
        }
    }

    private void buildAllData() {
        DynamicObject md = (DynamicObject)this.getModel().getValue("model");
        if (md == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnalyticsSolutionsListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qf = new QFilter("model", "=", md.get("id"));
        if (!MemberPermHelper.isModelManager((Long)this.getModelId())) {
            qf.and(new QFilter("scope", "in", (Object)AnalyticsSolutionScopeEnum.getScopValues()).or(new QFilter("createuserid", "=", (Object)this.getUserId())));
        }
        qf.and(new QFilter("turnstatus", "!=", (Object)"2"));
        boolean isSupportXDataQuery = ConfigServiceHelper.getBoolParam((Long)LongUtil.toLong((Object)this.getModelId()), (String)"isSupportXDataQuery");
        if (!isSupportXDataQuery) {
            qf.and("solutiontype", "!=", (Object)"1");
        }
        QFilter[] memberFilters = new QFilter[]{qf};
        DynamicObjectCollection soluList = QueryServiceHelper.query((String)"bcm_analyticssoluentry", (String)"id,solutionnumber,solutionname,createuserid,createtime,updateuserid,updatetime,scope,explanation,solutiontype,extmodel.id", (QFilter[])memberFilters, (String)"updatetime desc");
        this.setSoluListInfo(soluList);
    }

    private void setSoluListInfo(DynamicObjectCollection soluList) {
        TableValueSetter values = new TableValueSetter(new String[0]);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.setFilterByPermClass(soluList);
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject obj : soluList) {
            idSet.add(obj.getLong("createuserid"));
            idSet.add(obj.getLong("updateuserid"));
        }
        DynamicObjectCollection userList = QueryServiceHelper.query((String)"bos_user", (String)"id, name", (QFilter[])new QFilter("id", "in", idSet).toArray());
        HashMap idNameMap = new HashMap(16);
        userList.forEach(e -> idNameMap.put(e.getLong("id"), e.getString("name")));
        for (int i = 0; i < soluList.size(); ++i) {
            DynamicObject obj = (DynamicObject)soluList.get(i);
            values.set("solutionname", (Object)obj.getString("solutionname"), i);
            values.set("solutionnumber", (Object)obj.getString("solutionnumber"), i);
            values.set("scope", (Object)AnalyticsSolutionScopeEnum.getNameByKey((int)Integer.parseInt(obj.get("scope").toString())), i);
            values.set("explanation", obj.get("explanation"), i);
            values.set("lastusername", idNameMap.get(obj.getLong("updateuserid")), i);
            values.set("lasttime", (Object)sdf.format(obj.get("updatetime")), i);
            values.set("username", idNameMap.get(obj.getLong("createuserid")), i);
            values.set("createtime", (Object)sdf.format(obj.get("createtime")), i);
            values.set("id", (Object)obj.getString("id"), i);
            String solutiontype = obj.getString("solutiontype");
            values.set("solutiontype", (Object)solutiontype, i);
            if (!"1".equals(solutiontype)) continue;
            values.set("extmodel", (Object)obj.getString("extmodel.id"), i);
        }
        this.getModel().deleteEntryData("solutionslist");
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("solutionslist", values);
        if (!soluList.isEmpty()) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("solutionslist");
            entryGrid.setPageIndex(1);
        }
        this.getView().updateView("solutionslist");
    }

    private void setFilterByPermClass(DynamicObjectCollection solutionList) {
        if (MemberPermHelper.isModelManager((Long)this.getModelId())) {
            return;
        }
        PermClassCache.cacheNewPermission((IPageCache)this.getPageCache(), (String)"bcm_analyticssoluentry", (String)Long.toString(this.getModelId()));
        List noPerms = PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)"bcm_analyticssoluentry", (DataTypeEnum)DataTypeEnum.NO);
        Iterator solutionIterator = solutionList.iterator();
        while (solutionIterator.hasNext()) {
            DynamicObject aSolution = (DynamicObject)solutionIterator.next();
            if (!noPerms.contains(aSolution.getLong("id"))) continue;
            solutionIterator.remove();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        DynamicObject obj = (DynamicObject)this.getModel().getEntryEntity("solutionslist").get(e.getRowIndex());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCustomParam("solutionId", (Object)obj.getLong("id"));
        showParameter.setFormId("bcm_saveothersolution");
        showParameter.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u57fa\u672c\u4fe1\u606f", (String)"AnalyticsSolutionsListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshList"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        try {
            if (e.getChangeSet()[0].getNewValue() == null) {
                DynamicObject obj = (DynamicObject)e.getChangeSet()[0].getOldValue();
                this.getModel().setValue(e.getProperty().toString(), (Object)obj.getLong("id"));
            } else {
                this.buildAllData();
            }
        }
        catch (Exception ex) {
            log.error("property change error", (Throwable)ex);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
    }
}

