/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.util.DataQueryAnalyticsHelper;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;

public class DataAnalyticsSchemeListPlugin
extends AbstractBaseListPlugin {
    protected static final String BILLLIST_AP = "billlistap";
    protected static final String BTN_OK = "btnok";
    protected static final String BTN_DEL = "delete";
    protected static final String BTN_CLO = "close";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK, BTN_DEL, BTN_CLO);
    }

    @Override
    public void bcmPreOpen(PreOpenFormEventArgs e) {
        super.bcmPreOpen(e);
        FormShowParameter parameter = (FormShowParameter)e.getSource();
        long modelId = LongUtil.toLong((Object)parameter.getCustomParam("model"));
        if (modelId == 0L) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u4efb\u4f55\u62a5\u8868\u4f53\u7cfb\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u4f53\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UserSelectUtil_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((BasedataEdit)evt.getSource()).getKey();
        if ("model".equals(key) && StringUtils.isNotEmpty((String)"model") && this.getControl("model") != null) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("model")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            qFilterList.addAll(ModelUtil.getModelFilter(this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("model", this.getView().getFormShowParameter().getCustomParam("model"));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("model".equals(name)) {
            BillList billList = (BillList)this.getControl(BILLLIST_AP);
            billList.clearSelection();
            billList.refresh();
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.applayScheme(key);
        } else if (BTN_DEL.equals(key)) {
            this.deleteScheme();
        } else if (BTN_CLO.equals(key)) {
            this.closeView(key);
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        Object modelDy = this.getModel().getValue("model");
        if (modelDy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExtendDataRptFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)this.getControl(BILLLIST_AP);
        long schemeId = (Long)billList.getFocusRowPkId();
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_analyticsscheme");
        param.setCustomParam("model", (Object)((DynamicObject)modelDy).getLong("id"));
        param.setCustomParam("schemeId", (Object)schemeId);
        param.setCustomParam("sign", (Object)"list");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "scheme_save"));
        this.getView().showForm(param);
        evt.setCancel(Boolean.TRUE.booleanValue());
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        Set havePermSchemeIds = DataQueryAnalyticsHelper.getHavePermSchemeIds((long)modelId, (long)RequestContext.get().getCurrUserId());
        QFilter qf = new QFilter("id", "in", (Object)havePermSchemeIds);
        e.getQFilters().add(qf);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("scheme_save".equals(actionId) && (returnData = evt.getReturnData()) != null) {
            this.setDyValues((Map)returnData);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataAnalyticsSchemeListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        this.applayScheme(BTN_OK);
    }

    private void setDyValues(Map<String, Object> returnData) {
        BillList billList = (BillList)this.getControl(BILLLIST_AP);
        long focusRowPkId = (Long)billList.getFocusRowPkId();
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"bcm_analyticsscheme_base");
        if (scheme == null) {
            return;
        }
        scheme.set("name", returnData.get("name"));
        scheme.set("description", returnData.get("description"));
        scheme.set("permrange", returnData.get("permrange"));
        scheme.set("modifier", (Object)RequestContext.get().getUserId());
        scheme.set("modifytime", (Object)TimeServiceHelper.now());
        try (TXHandle tx = TX.required();){
            try {
                Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
                Object permclass = returnData.get("permclass");
                if (permclass != null) {
                    PermClassEntityHelper.savePermClass((String)"bcm_analyticsscheme_base", (Object)((DynamicObject)result[0]).getPkValue(), (Object)this.getModelId(), (Object)permclass);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        billList.refresh();
    }

    private void deleteScheme() {
        BillList billList = (BillList)this.getControl(BILLLIST_AP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"DataAnalyticsSchemeListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Set schemeIds = selectedRows.stream().map(x -> (Long)x.getPrimaryKeyValue()).collect(Collectors.toSet());
        Map results = DataQueryAnalyticsHelper.isHavePermOfBatchSchemeOfWrite(schemeIds, (long)this.getModelId(), (long)RequestContext.get().getCurrUserId());
        HashSet hasPermsSchemeIds = new HashSet(10);
        results.forEach((k, v) -> {
            if (v.booleanValue()) {
                hasPermsSchemeIds.add(k);
            }
        });
        if (hasPermsSchemeIds.size() > 0) {
            QFilter qf = new QFilter("id", "in", hasPermsSchemeIds);
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_analyticsscheme_base", (String)"number", (QFilter[])qf.toArray());
            DeleteServiceHelper.delete((String)"bcm_analyticsscheme_base", (QFilter[])qf.toArray());
            billList.setClearSelection(Boolean.TRUE.booleanValue());
            billList.refresh();
            String numStr = String.join((CharSequence)",", dys.stream().map(x -> x.getString("number")).collect(Collectors.toSet()));
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664\u65b9\u6848", "DataQueryAnalyticsPlugin_11", "fi-bcm-formplugin", "delete scheme"), new OPDescMultiLangEnumBridge("\u5220\u9664%s\u65b9\u6848\u6210\u529f", "DataQueryAnalyticsPlugin_12", "fi-bcm-formplugin", new String[]{numStr}));
        }
        String msg = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DataAnalyticsSchemeListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        if (schemeIds.size() != hasPermsSchemeIds.size()) {
            msg = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff0c\u5df2\u8fc7\u6ee4\u6389\u65e0\u6743\u65b9\u6848\u3002", (String)"DataAnalyticsSchemeListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        this.getView().showSuccessNotification(msg);
    }

    private void applayScheme(String key) {
        BillList billList = (BillList)this.getControl(BILLLIST_AP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5e94\u7528\u7684\u65b9\u6848\u3002", (String)"DataAnalyticsSchemeListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u3002", (String)"DataAnalyticsSchemeListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        long schemeId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("schemeId", schemeId);
        returnData.put("type", key);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void closeView(String key) {
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        returnData.put("type", key);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

