/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.util.DataQueryAnalyticsHelper;
import kd.fi.bcm.common.enums.AnalyticsQueryTypeEnum;
import kd.fi.bcm.common.enums.CslSchemeScopeEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.PermRangeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class DataAnalyticsSchemePlugin
extends AbstractBaseFormPlugin {
    protected static final String MODEL_DY = "model";
    protected static final String NUMBER = "number";
    protected static final String COMBO_FIELD = "combofield";
    protected static final String EXT_MODEL = "extmodel";
    protected static final String PERM_RANGE = "permrange";
    protected static final String PERM_CLASS = "permclass";
    private static Pattern pattern = Pattern.compile("[A-Za-z0-9_]+");

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit extendModel = (BasedataEdit)this.getControl(EXT_MODEL);
        extendModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners("btnok");
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl(PERM_CLASS)), (Object)this.getView().getFormShowParameter().getCustomParam(MODEL_DY));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((BasedataEdit)evt.getSource()).getKey();
        if (EXT_MODEL.equals(key)) {
            String modelId = this.getPageCache().get("KEY_MODEL_ID");
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setListFilterParameter(new ListFilterParameter(Arrays.asList(new QFilter(MODEL_DY, "=", (Object)Long.parseLong(modelId)), new QFilter("extendsgroup.grouptype", "in", this.getNoEquityExtendGroupType())), null));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf((Long)param.getCustomParam(MODEL_DY)));
        Object schemeId = param.getCustomParam("schemeId");
        if (schemeId != null && (Long)schemeId != 0L) {
            this.queryAndSetValue((Long)schemeId);
        } else {
            String sign = (String)param.getCustomParam("sign");
            if ("saveasscheme".equals(sign)) {
                this.getModel().setValue(COMBO_FIELD, param.getCustomParam(COMBO_FIELD));
                this.getModel().setValue(EXT_MODEL, param.getCustomParam(EXT_MODEL));
                this.getView().setEnable(Boolean.FALSE, new String[]{COMBO_FIELD, EXT_MODEL});
            } else {
                Object value = this.getModel().getValue(COMBO_FIELD);
                this.getView().setEnable(Boolean.valueOf(AnalyticsQueryTypeEnum.ExtData.getIndex().equals(value)), new String[]{EXT_MODEL});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{PERM_CLASS});
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            String msg = this.validate();
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
                return;
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            IDataModel model = this.getModel();
            returnData.put(NUMBER, model.getValue(NUMBER));
            returnData.put("name", model.getValue("name"));
            returnData.put(COMBO_FIELD, model.getValue(COMBO_FIELD));
            returnData.put(EXT_MODEL, model.getValue(EXT_MODEL));
            returnData.put(PERM_RANGE, model.getValue(PERM_RANGE));
            returnData.put(PERM_CLASS, model.getValue(PERM_CLASS));
            returnData.put("description", model.getValue("description"));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (COMBO_FIELD.equals(name)) {
            String value = (String)this.getModel().getValue(COMBO_FIELD);
            if (AnalyticsQueryTypeEnum.ExtData.getIndex().equals(value)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{EXT_MODEL});
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl(EXT_MODEL);
                basedataEdit.setMustInput(Boolean.TRUE.booleanValue());
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{EXT_MODEL});
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl(EXT_MODEL);
                basedataEdit.setMustInput(Boolean.FALSE.booleanValue());
            }
        } else if (PERM_RANGE.equals(name)) {
            String value = (String)this.getModel().getValue(PERM_RANGE);
            if (PermRangeEnum.PERMCLASS.getValue().equals(value)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{PERM_CLASS});
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl(PERM_CLASS);
                basedataEdit.setMustInput(Boolean.TRUE.booleanValue());
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{PERM_CLASS});
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl(PERM_CLASS);
                basedataEdit.setMustInput(Boolean.FALSE.booleanValue());
            }
        }
    }

    private List<String> getNoEquityExtendGroupType() {
        return Arrays.stream(ExtendDimGroupType.values()).filter(value -> value != ExtendDimGroupType.EQUITY).map(ExtendDimGroupType::getIndex).collect(Collectors.toList());
    }

    private String validate() {
        long modelId = this.getModelId();
        DynamicObject dyObj = this.getModel().getDataEntity();
        String number = dyObj.getString(NUMBER);
        String name = dyObj.getString("name");
        if (StringUtils.isEmpty((CharSequence)number) || StringUtils.isEmpty((CharSequence)number.trim())) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7f16\u7801\u3002", (String)"EADataPushSchemBasePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (!"list".equals(this.getView().getFormShowParameter().getCustomParam("sign"))) {
            QFilter qf = new QFilter(NUMBER, "=", (Object)number);
            if (QueryServiceHelper.exists((String)"bcm_analyticsscheme_base", (QFilter[])qf.toArray())) {
                return ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"DataAnalyticsSchemePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        } else {
            Object schemeId = this.getView().getFormShowParameter().getCustomParam("schemeId");
            if (!DataQueryAnalyticsHelper.isHavePermOfSchemeOfWrite((long)((Long)schemeId), (long)modelId, (long)RequestContext.get().getCurrUserId())) {
                return ResManager.loadKDString((String)"\u65e0\u8be5\u65b9\u6848\u7684\u7f16\u8f91\u6743\u9650\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"DataAnalyticsSchemePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        }
        if (StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)name.trim())) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0\u3002", (String)"EADataPushSchemBasePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (AnalyticsQueryTypeEnum.ExtData.getIndex().equals(dyObj.getString(COMBO_FIELD)) && dyObj.get(EXT_MODEL) == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62d3\u5c55\u6a21\u578b\u3002", (String)"DataQueryAnalyticsPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (AnalyticsQueryTypeEnum.ExtData.getIndex().equals(dyObj.getString(PERM_RANGE)) && dyObj.get(PERM_CLASS) == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6743\u9650\u7c7b\u3002", (String)"DataAnalyticsSchemePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (!this.formatYes(number)) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u6570\u5b57\uff0c\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\u3002", (String)"EADataPushSchemBasePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private boolean formatYes(String number) {
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            return false;
        }
        return !number.contains("..") && !number.startsWith(".");
    }

    private void queryAndSetValue(long schemeId) {
        QFilter qf = new QFilter(MODEL_DY, "=", (Object)this.getModelId());
        qf.and("id", "=", (Object)schemeId);
        String selectedFields = "id, number, name, combofield, extmodel, permrange, description";
        DynamicObject[] results = BusinessDataServiceHelper.load((String)"bcm_analyticsscheme_base", (String)selectedFields, (QFilter[])qf.toArray());
        if (results.length > 0) {
            DynamicObject dy = results[0];
            this.getModel().setValue(NUMBER, dy.get(NUMBER));
            this.getModel().setValue("name", dy.get("name"));
            this.getModel().setValue(COMBO_FIELD, dy.get(COMBO_FIELD));
            this.getModel().setValue(EXT_MODEL, dy.get(EXT_MODEL));
            this.getModel().setValue(PERM_RANGE, dy.get(PERM_RANGE));
            this.getModel().setValue("description", dy.get("description"));
            DynamicObject permClass = this.getPermClass(this.getModelId(), schemeId);
            if (permClass != null) {
                this.getModel().setValue(PERM_CLASS, (Object)permClass.getLong("permclass.id"));
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{COMBO_FIELD, EXT_MODEL, NUMBER});
            this.getView().setEnable(Boolean.valueOf(CslSchemeScopeEnum.isPermClassControl((String)dy.getString(PERM_RANGE))), new String[]{PERM_CLASS});
        }
    }

    public DynamicObject getPermClass(Object modelId, long schemeId) {
        QFilter qf = new QFilter(MODEL_DY, "=", (Object)LongUtil.toLong((Object)modelId));
        qf.and("entityid", "=", (Object)schemeId);
        qf.and("entityname", "=", (Object)"bcm_analyticsscheme_base");
        return QueryServiceHelper.queryOne((String)"bcm_permclass_entity", (String)"permclass.id", (QFilter[])qf.toArray());
    }
}

