/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.Style;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.basedata.MultiF7Result;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.BaseEditElement;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.PageBasicInfo;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.util.DragUtil;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.analytics.SearchHelper;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;

public class DimDesignerControlPlugin
extends AbstractBaseFormPlugin
implements DynamicPage,
SubPage {
    protected Long modelId;
    protected static final String SOLUTION_SERIAL = "solution_serial";
    protected static final String model = "model";
    protected static final String pagePanel = "pagepanel";
    protected static final String rowPanel = "rowpanel";
    protected static final String colPanel = "colpanel";
    protected static final String pageDim = "pagedim";
    protected static final String rowDim = "rowdim";
    protected static final String colDim = "coldim";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("bcm_analyticssolutiondata", "true");
        this.modelId = (Long)this.getView().getFormShowParameter().getCustomParam(model);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.modelId));
        this.buildAllData();
        this.registerTreeF7();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_ok");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String controlKey = e.getProperty().getName();
        if ("scenario".equals(controlKey)) {
            DimDesignerControlPlugin dp = this;
            Page page = dp.getPage(this.getPlugin().getView());
            if (page != null) {
                Element ele = page.findElementBySign("period");
                Element elemul = page.findElementBySign("periodmul");
                if (ele != null) {
                    this.getModel().setValue("period", null);
                    ele.setValue(this.getPageCache(), null);
                    this.getView().updateView("period");
                }
                if (elemul != null) {
                    this.getModel().getDataEntity().set("periodmul", null);
                    elemul.setValue(this.getPageCache(), null);
                    this.getView().updateView("periodmul");
                }
                this.setPage(this.getView(), page);
            }
        } else if (controlKey.toLowerCase(Locale.ENGLISH).endsWith("mul")) {
            this.getPageCache().remove(controlKey);
            this.getPageCache().remove(controlKey + "Cache");
        }
    }

    protected void registerTreeF7() {
        HashMap map = new HashMap(16);
        Map<String, String> dimIgnoreCaseMap = DimensionUtil.getDimIgnoreCaseMapByModelId(this.getModelId());
        if (dimIgnoreCaseMap != null) {
            this.asMapF7toType(Lists.newArrayList(dimIgnoreCaseMap.keySet()), SingleF7TypeEnum.ROOT, map);
            this.initSingleMemberF7(map);
        }
    }

    @Override
    public void click(EventObject evt) {
        Element c;
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_ok".equals(key)) {
            this.applySolution();
        } else if (this.getPage(this.getView()) != null && (c = this.getPage(this.getView()).findElementBySign(key)) != null) {
            this.showMulTiF7(key, ((TextEditElement)c).getNumber());
        }
    }

    private void applySolution() {
        boolean canSaveData = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM008");
        if (this.getView().getParentView() != null) {
            OperationLogUtil.writeOperationLog((IFormView)this.getView().getParentView(), (String)(OpItemEnum.APPLY.getName() + OpItemEnum.QUERY.getName()), (String)(OpItemEnum.QUERY.getName() + ResultStatusEnum.SUCCESS.getName()), (Long)this.getModelId());
        }
        if (this.isModified() && canSaveData) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u53d1\u751f\u53d8\u5316,\u662f\u5426\u8fdb\u884c\u4fdd\u5b58\uff1f", (String)"DimDesignerControlPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("btn_ok_cf", (IFormPlugin)this));
        } else {
            this.doRefresh();
        }
    }

    protected void doRefresh() {
        if (this.checkSaveContent()) {
            return;
        }
        DynamicObject solution = this.updateSolution();
        CommandParam commandParam = new CommandParam("bcm_analyticsdimdesign", "bcm_analyticssolutiondata", "dimdesigner", this.toByteSerialized(solution));
        this.sendMsg(this.getView(), commandParam);
    }

    protected boolean checkSaveContent() {
        try {
            boolean isExitNullRowMember = this.getPage(this.getView()).findAreaBySign(rowPanel).getElementListList().stream().anyMatch(t -> StringUtils.isEmpty((String)((String)t.getValue(null))));
            if (this.getPage(this.getView()).findAreaBySign(rowPanel).getElementListList().isEmpty() || isExitNullRowMember) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ed9\u884c\u7ef4\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u3002", (String)"DimDesignerControlPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return true;
            }
            boolean isExitNullColMember = this.getPage(this.getView()).findAreaBySign(colPanel).getElementListList().stream().anyMatch(t -> StringUtils.isEmpty((String)((String)t.getValue(null))));
            if (this.getPage(this.getView()).findAreaBySign(colPanel).getElementListList().isEmpty() || isExitNullColMember) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ed9\u5217\u7ef4\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u3002", (String)"DimDesignerControlPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return true;
            }
            boolean isExitNullPageMember = this.getPage(this.getView()).findAreaBySign(pagePanel).getElementListList().stream().anyMatch(t -> Objects.isNull(t.getValue(this.getPageCache())));
            if (isExitNullPageMember) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ed9\u9875\u9762\u7ef4\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u3002", (String)"DimDesignerControlPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return false;
    }

    protected DynamicObject updateSolution() {
        DynamicObject so = this.getCurrentAnalyticsSolution();
        Date now = TimeServiceHelper.now();
        so.set("updateuserid", (Object)this.getUserId());
        so.set("updatetime", (Object)now);
        so.set(model, this.getView().getFormShowParameter().getCustomParam(model));
        this.buildSaveDim(so, pageDim, pagePanel, "dimid", "menberid", "orderindex");
        this.buildSaveDim(so, rowDim, rowPanel, "rowdimid", "rowmenberid", "roworderindex");
        this.buildSaveDim(so, colDim, colPanel, "columndimid", "columnmenberid", "colorderindex");
        return so;
    }

    protected void buildSaveDim(DynamicObject obj, String dimPanel, String areaPanel, String dimIdName, String memberIdName, String orderIndexName) {
        DynamicObjectCollection dimCol = obj.getDynamicObjectCollection(dimPanel);
        dimCol.clear();
        int orderIndex = 1;
        for (Element e : this.getPage(this.getView()).findAreaBySign(areaPanel).getElementListList()) {
            DynamicObject dimMember = dimCol.addNew();
            String dimNumber = e instanceof TextEditElement ? ((TextEditElement)e).getNumber() : e.getSign();
            DynamicObject dim = QueryDimensionServiceHelper.getMsgByNumberIgnoreCase((long)this.getModelId(), (String)dimNumber);
            dimMember.set(dimIdName, (Object)dim);
            dimMember.set(orderIndexName, (Object)orderIndex);
            ++orderIndex;
            if (pagePanel.equals(areaPanel)) {
                DynamicObject col = (DynamicObject)this.getValue(e.getSign());
                if (col == null) continue;
                dimMember.set(memberIdName, (Object)col.getLong("id"));
                continue;
            }
            dimMember.set(memberIdName, (Object)this.getPageCache().get(e.getSign() + "Cache"));
        }
    }

    protected void buildAllData() {
        this.buildUpdatePage();
    }

    protected DynamicObject getCurrentAnalyticsSolution() {
        String solutionSerial = this.getView().getParentView().getPageCache().get(SOLUTION_SERIAL);
        if (StringUtils.isEmpty((String)solutionSerial)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u7236\u9875\u9762\u7f13\u5b58\u65b9\u6848\u6570\u636e\u3002", (String)"DimDesignerControlPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return (DynamicObject)this.deSerializedBytes(solutionSerial);
    }

    protected void buildUpdatePage() {
        DynamicObject so = this.getCurrentAnalyticsSolution();
        DynamicObjectCollection pageDimList = so.getDynamicObjectCollection(pageDim);
        DynamicObjectCollection rowDimList = so.getDynamicObjectCollection(rowDim);
        DynamicObjectCollection colDimList = so.getDynamicObjectCollection(colDim);
        pageDimList.sort(SearchHelper.getCompareMethod("orderindex_id"));
        rowDimList.sort(SearchHelper.getCompareMethod("roworderindex_id"));
        colDimList.sort(SearchHelper.getCompareMethod("colorderindex_id"));
        SearchHelper.dealNewDim(pageDimList, rowDimList, colDimList, this.modelId);
        Page page = new Page();
        this.buildUpdateAreaPanel(pageDimList, page, pagePanel, "dimid", "menberid");
        this.buildUpdateAreaPanel(rowDimList, page, rowPanel, "rowdimid", "rowmenberid");
        this.buildUpdateAreaPanel(colDimList, page, colPanel, "columndimid", "columnmenberid");
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        DragUtil.allDrag((IFormView)this.getView(), (Page)page);
        this.setValue("solutionnumber", so.getString("solutionnumber"));
        this.setValue("solutionname", so.getString("solutionname"));
        this.setUpdateDimValue(pagePanel);
        this.setUpdateDimValue(rowPanel);
        this.setUpdateDimValue(colPanel);
    }

    protected void setUpdateDimValue(String areaPanel) {
        Map dimHideDefaultMap = QueryDimensionServiceHelper.getDimensionHideDefaultItem((Long)this.modelId);
        Map numberAndDimIDMap = QueryDimensionServiceHelper.getNumberAndDimIDMap((long)this.modelId);
        for (Element e : this.getPage(this.getView()).findAreaBySign(areaPanel).getElementListList()) {
            String sign = e.getSign();
            this.fillDimMem(areaPanel, dimHideDefaultMap, numberAndDimIDMap, e, sign);
        }
    }

    protected void fillDimMem(String areaPanel, Map<Long, Pair<Boolean, String>> dimHideDefaultMap, Map<String, Long> numberAndDimIDMap, Element e, String sign) {
        String[] memList = (String[])e.getUserObject("memList");
        if (memList[0].length() > 0) {
            if (pagePanel.equals(areaPanel)) {
                if ("entity".equalsIgnoreCase(sign)) {
                    DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(memList[0]), (String)"bcm_entitymembertree");
                    DynamicObject parent = org.getDynamicObject("parent");
                    if (parent != null) {
                        String code = parent.getString("number") + "_" + org.getString("number");
                        org.set("number", (Object)code);
                    }
                    this.setValue(sign, org);
                } else {
                    Pair<Boolean, String> pair = dimHideDefaultMap.get(numberAndDimIDMap.get(sign));
                    if (pair != null && ((Boolean)pair.p1).booleanValue()) {
                        this.setValue(sign, pair.p2);
                    } else {
                        this.setValue(sign, Long.valueOf(memList[0]));
                    }
                }
            } else {
                this.loadDataToPage(memList, sign, ((TextEditElement)e).getNumber());
            }
        }
    }

    protected void loadDataToPage(String[] memList, String sign, String dimNum) {
        this.setValueForRCDim(MultiF7Results.buildMultiF7Results((String[])memList, (long)this.getModelId(), (String)dimNum), sign);
    }

    protected void setValueForRCDim(MultiF7Results f7Results, String sign) {
        List list = new ArrayList(16);
        String value = null;
        String ids = null;
        if (f7Results != null) {
            long id;
            list = f7Results.toList();
            value = f7Results.getShowText(true);
            ids = f7Results.getMemberSettingForMDQA();
            if (!f7Results.getList().isEmpty() && (id = ((MultiF7Result)f7Results.getList().get(0)).getCslscheme()) != 0L) {
                this.getPageCache().put("cslscheme", Long.toString(id));
            }
        }
        this.setValue(sign, value);
        this.getPageCache().put(sign, SerializationUtils.toJsonString(list));
        this.getPageCache().put(sign + "Cache", ids);
    }

    protected void buildUpdateAreaPanel(DynamicObjectCollection pageDimList, Page page, String areaPanel, String dimIdName, String memIdName) {
        Area area = new Area(areaPanel);
        Style sl = SearchHelper.getStyle();
        Map dimHideDefaultMap = QueryDimensionServiceHelper.getDimensionHideDefaultItem((Long)this.getModelId());
        for (DynamicObject obj : pageDimList) {
            DynamicObject dim = obj.getDynamicObject(dimIdName);
            if (dim == null) continue;
            this.addDimElement(areaPanel, obj.getString(memIdName), area, sl, dimHideDefaultMap, dim);
        }
        page.addArea(area);
    }

    protected void addDimElement(String areaPanel, String memIdScope, Area area, Style sl, Map<Long, Pair<Boolean, String>> dimHideDefaultMap, DynamicObject dim) {
        BaseEditElement f7;
        String number = dim.getString("number");
        if (pagePanel.equals(areaPanel)) {
            String sign = number.toLowerCase(Locale.ENGLISH);
            f7 = new BaseEditElement(dim.getString("shortnumber"), sign, DimEntityNumEnum.getEntieyNumByNumber((String)number));
            f7.setDisplayProp("number,name");
            f7.setNumber(number);
        } else {
            String sign = number.toLowerCase(Locale.ENGLISH) + "mul";
            f7 = new TextEditElement(dim.getString("shortnumber"), sign, DimEntityNumEnum.getEntieyNumByNumber((String)number));
            ((TextEditElement)f7).setNumber(number);
        }
        String[] memList = memIdScope.split(",");
        f7.addUserObject("memList", (Object)memList);
        f7.addUserObject("id", (Object)dim.getLong("id"));
        f7.setLabelWidth(new LocaleString("30px"));
        f7.setHeight(new LocaleString("28px"));
        f7.setStyle(sl);
        f7.setWidth(new LocaleString("260px"));
        f7.setFontSize(12);
        f7.setFieldTextAlign("left");
        Pair<Boolean, String> pair = dimHideDefaultMap.get(dim.getLong("id"));
        if (pagePanel.equals(areaPanel) && pair != null && ((Boolean)pair.p1).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{number.toLowerCase(Locale.ENGLISH)});
        }
        area.addElement((Element)f7);
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String sign;
        Element c;
        super.onGetControl(e);
        if (this.getPage(this.getView()) != null && (c = this.getPage(this.getView()).findElementBySign(e.getKey())) != null && (sign = c.getSign()).toLowerCase(Locale.ENGLISH).endsWith("mul")) {
            TextEdit edit = new TextEdit();
            edit.setKey(e.getKey());
            edit.setModel(this.getModel());
            edit.setView(this.getView());
            edit.addClickListener((ClickListener)this);
            e.setControl((Control)edit);
        }
        this.handleMemberAuthorityFilter(e, "period");
    }

    protected void handleMemberAuthorityFilter(OnGetControlArgs e, String ... f7Keys) {
        Control control = e.getControl();
        if (control instanceof BasedataEditSingleMemberF7 && Arrays.asList(f7Keys).contains(e.getKey())) {
            ((BasedataEditSingleMemberF7)control).addBasedataFuzzySearchListener(event -> {
                List queryData = event.getQueryData();
                long fModelId = this.getModelId();
                SysDimensionEnum entityEnum = SysDimensionEnum.getEnumByLowerCaseNumber((String)e.getKey());
                HashSet ids = new HashSet(queryData.size());
                queryData.stream().forEach(data -> ids.add(ConvertUtil.convertObjToLong(((List)data).get(0))));
                Set permission = PermissionServiceImpl.getInstance((Long)fModelId).matchReadOrWritePermMembers(Long.valueOf(DimensionUtil.getIdByNum("bcm_dimension", fModelId, entityEnum.getNumber())), entityEnum.getMemberTreemodel(), ids);
                queryData = queryData.stream().filter(data -> permission.contains(ConvertUtil.convertObjToLong(((List)data).get(0)))).collect(Collectors.toList());
                event.setQueryData(queryData);
            });
        }
    }

    @Override
    protected void initBasedataEditSingleMemberF7(String f7Key, BasedataEditSingleMemberF7 f7) {
        super.initBasedataEditSingleMemberF7(f7Key, f7);
        HashMap<String, Object> customParam = new HashMap<String, Object>(16);
        customParam.put("queryExchangeRate", "false");
        customParam.put("showCurrencyPC", "true");
        customParam.put("from", "DimDesignerControlPlugin");
        f7.setCustomData(customParam);
    }

    protected void showMulTiF7(String key, String number) {
        FormShowParameter para = new FormShowParameter();
        DimensionMsgCache dmc = new DimensionMsgCache(this.getModelId());
        para.setFormId("bcm_mulmemberf7base_tem");
        para.getOpenStyle().setShowType(ShowType.Modal);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("dimension", String.valueOf(dmc.getSeq(number)));
        params.put("sign", key);
        params.put("isUpDownBtn", true);
        params.put("isExchangeRate", "1");
        params.put("isfromDimDesigner", "true");
        params.put("f7modelId", this.getModelId());
        if (DimTypesEnum.ENTITY.getNumber().equals(number) && StringUtils.isNotEmpty((String)this.getPageCache().get("cslscheme"))) {
            params.put("cslscheme", this.getPageCache().get("cslscheme"));
        }
        para.setCustomParams(params);
        para.setCustomParam("isincludeorg", (Object)ResManager.loadKDString((String)"\u5408\u5e76\u5f55\u5165,\u4e2a\u522b\u62a5\u8868,\u5408\u5e76\u62a5\u8868", (String)"DimDesignerControlPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        para.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"DimDesignerControlPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dmc.getName(number)));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    public void closedCallBack(ClosedCallBackEvent cb) {
        Map map;
        super.closedCallBack(cb);
        String key = cb.getActionId();
        if (cb.getReturnData() != null && (map = (Map)cb.getReturnData()) != null) {
            long cslId = 0L;
            DynamicObjectCollection doc = (DynamicObjectCollection)map.get("doc");
            if (map.get("cslscheme") != null && StringUtils.isNotEmpty((String)map.get("cslscheme").toString())) {
                cslId = LongUtil.toLong(map.get("cslscheme"));
            }
            this.setValueForRCDim(MultiF7Results.buildMultiF7Results((DynamicObjectCollection)doc, (long)cslId), key);
        }
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        try {
            if ("drop".equals(name)) {
                String exchange;
                String eventArgs = e.getEventArgs();
                Page page = this.getPage(this.getView());
                boolean rebuildPageState = this.rebuildPage(page, eventArgs);
                if (rebuildPageState) {
                    this.setStyle(page, SearchHelper.getStyle());
                    page.updatePage(this.getView());
                    this.setPage(this.getView(), page);
                    DragUtil.allDrag((IFormView)this.getView(), (Page)page);
                }
                if ((exchange = this.getPageCache().get("EXCHANGE")) != null) {
                    String[] msg = DragUtil.translateMessage((String)eventArgs);
                    String sign = msg[1];
                    if (this.getPageCache().get("EXCHANGE_MUL_VALUE_CACHE") != null && this.getPageCache().get("EXCHANGE_MUL_VALUE") != null && exchange.equals("MulToMul")) {
                        this.setValue(sign, this.getPageCache().get("EXCHANGE_MUL_ELEMEMT_VALUE"));
                        this.getPageCache().put(sign + "Cache", this.getPageCache().get("EXCHANGE_MUL_VALUE_CACHE"));
                        this.getPageCache().put(sign, this.getPageCache().get("EXCHANGE_MUL_VALUE"));
                        this.getView().updateView(sign);
                    } else {
                        String memberId = this.getPageCache().get("EXCHANGE_VALUE");
                        if (memberId != null) {
                            if (exchange.equals("SingleToMul")) {
                                String[] memList = new String[]{memberId};
                                this.loadDataToPage(memList, sign + "mul", ThreadCache.get((Object)"selectdimnum") != null ? ThreadCache.get((Object)"selectdimnum").toString() : sign);
                            } else if (!exchange.equals("SingleToSingle")) {
                                String newSign = sign.substring(0, sign.length() - 3);
                                this.setValue(newSign, memberId);
                            }
                        }
                    }
                    this.getPageCache().remove("EXCHANGE");
                    this.getPageCache().remove("EXCHANGE_VALUE");
                    this.getPageCache().remove("EXCHANGE_MUL_VALUE");
                    this.getPageCache().remove("EXCHANGE_MUL_VALUE_CACHE");
                    this.getPageCache().remove("EXCHANGE_MUL_ELEMEMT_VALUE");
                    if (exchange.equals("MulToSingle")) {
                        this.getView().updateView(sign.substring(0, sign.length() - 3));
                        this.getView().updateView(sign);
                    } else if (exchange.equals("SingleToMul")) {
                        this.getView().updateView(sign);
                        this.getView().updateView(sign + "mul");
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error("\u7ef4\u5ea6f7\u62d6\u62fd\u5f02\u5e38\uff0c\u4e0d\u80fd\u79fb\u52a8\uff0c\u81f3\u5c11\u4fdd\u7559\u4e00\u4e2a\u7ef4\u5ea6\u3002", (Throwable)ex);
        }
    }

    protected boolean rebuildPage(Page page, String command) {
        Area targetArea;
        String[] msg = DragUtil.translateMessage((String)command);
        PageBasicInfo target = page.seaechSign(msg[0]);
        Element source = (Element)page.seaechSign(msg[1]);
        String dropSign = source.getSign();
        Area sourceArea = source.getArea();
        boolean targetIsArea = true;
        if (target instanceof Area) {
            targetArea = (Area)target;
        } else {
            targetArea = ((Element)target).getArea();
            targetIsArea = false;
        }
        String sourceAreaSign = sourceArea.getSign();
        String targetAreaSign = targetArea.getSign();
        boolean canDrop = this.checkScenarioCanDrop(dropSign, sourceAreaSign, targetAreaSign);
        if (canDrop) {
            Element dropElement = this.getDropElement((PageBasicInfo)targetArea, source);
            targetArea.removeElememt(dropSign);
            sourceArea.removeElememt(dropSign);
            if (sourceArea.getElementListList().isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u79fb\u52a8\uff0c\u9700\u4fdd\u7559\u81f3\u5c11\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"DimDesignerControlPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
            this.setValue(dropSign, null);
            if (targetIsArea) {
                targetArea.addElement(dropElement);
            } else {
                int i = targetArea.getElementListList().indexOf(target);
                dropElement.setArea(targetArea);
                targetArea.getElementListList().add(i, dropElement);
            }
            return true;
        }
        return false;
    }

    protected boolean checkScenarioCanDrop(String sign, String sourcePanel, String targetPanel) {
        if (pagePanel.equals(sourcePanel) && (rowPanel.equals(targetPanel) || colPanel.equals(targetPanel)) && "scenario".equals(sign)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60c5\u666f\u7ef4\u5ea6\u4e0d\u80fd\u79fb\u52a8\u81f3\u884c\u5217\u7ef4\u4e0a\u3002", (String)"DimDesignerControlPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected Element getDropElement(PageBasicInfo tar, Element sou) {
        String number = sou.getSign();
        String dimNum = "";
        String memberId = null;
        Object oldValue = this.getValue(number);
        if (number.endsWith("mul")) {
            dimNum = ((TextEditElement)sou).getNumber();
            if (oldValue != null) {
                List list;
                if (this.getPageCache().get(number) != null && (list = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(number), Map.class)) != null && !list.isEmpty()) {
                    this.getPageCache().put("EXCHANGE_MUL_VALUE", this.getPageCache().get(number));
                    this.getPageCache().put("EXCHANGE_MUL_VALUE_CACHE", this.getPageCache().get(number + "Cache"));
                    this.getPageCache().put("EXCHANGE_MUL_ELEMEMT_VALUE", oldValue.toString());
                    Map map = (Map)list.get(0);
                    memberId = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)((CharSequence)map.get("pid"))) ? null : (String)map.get("id");
                }
                if (DimTypesEnum.ENTITY.getNumber().equals(dimNum)) {
                    this.getPageCache().remove("cslscheme");
                }
            }
        } else {
            DynamicObject value;
            dimNum = ((BaseEditElement)sou).getNumber();
            if (oldValue instanceof DynamicObject && (value = (DynamicObject)oldValue) != null) {
                memberId = value.getString("id");
            }
        }
        if (oldValue != null) {
            ThreadCache.put((Object)"selectdimnum", (Object)dimNum);
            this.getPageCache().put("EXCHANGE_VALUE", memberId);
        }
        Style style = SearchHelper.getStyle();
        if (tar.getSign().equals(pagePanel)) {
            if (sou instanceof TextEditElement) {
                number = number.substring(0, number.length() - 3);
                BaseEditElement f7 = new BaseEditElement(sou.getName(), number.toLowerCase(Locale.ENGLISH), DimEntityNumEnum.getEntieyNumByNumber((String)number));
                f7.addUserObject("id", sou.getUserObject("id"));
                f7.setWidth(new LocaleString("260px"));
                f7.setHeight(new LocaleString("28px"));
                f7.setLabelWidth(new LocaleString("30px"));
                f7.setStyle(style);
                f7.setFontSize(12);
                f7.setFieldTextAlign("left");
                f7.setDisplayProp("number,name");
                f7.setNumber(dimNum);
                this.getPageCache().put("EXCHANGE", "MulToSingle");
                return f7;
            }
            this.getPageCache().put("EXCHANGE", "SingleToSingle");
            return sou;
        }
        if (number.endsWith("mul")) {
            number = number.substring(0, number.length() - 3);
        }
        if (sou instanceof BaseEditElement) {
            this.getPageCache().put("EXCHANGE", "SingleToMul");
        } else {
            this.getPageCache().put("EXCHANGE", "MulToMul");
        }
        TextEditElement exp_org = new TextEditElement(sou.getName(), number.toLowerCase(Locale.ENGLISH) + "mul", DimEntityNumEnum.getEntieyNumByNumber((String)number));
        exp_org.setNumber(dimNum);
        exp_org.setWidth(new LocaleString("260px"));
        exp_org.setHeight(new LocaleString("28px"));
        exp_org.setLabelWidth(new LocaleString("30px"));
        exp_org.addUserObject("id", sou.getUserObject("id"));
        exp_org.setStyle(style);
        exp_org.setFontSize(12);
        exp_org.setFieldTextAlign("left");
        exp_org.setValue(this.getPageCache(), sou.getValue(this.getPageCache()));
        return exp_org;
    }

    protected void setStyle(Page page, Style sl) {
        page.getAreaList().forEach(a -> a.getElementListList().forEach(e -> e.setStyle(sl)));
    }

    @Override
    public void dealMsg(CommandParam com) {
        if ("setModified".equals(com.getOperation())) {
            List<Object> param = com.getParam();
            this.cacheTrueOrFalseFlag("is_modify", (Boolean)param.get(0));
        } else if ("refresh".equals(com.getOperation())) {
            this.doRefresh();
        } else if ("btn_ok".equals(com.getOperation())) {
            this.applySolution();
        }
    }

    protected void setModified(boolean isModified) {
        this.cacheTrueOrFalseFlag("is_modify", isModified);
        CommandParam commandParam = new CommandParam("bcm_analyticsdimdesign", "bcm_analyticssolutiondata", "setModified", isModified);
        this.sendMsg(this.getView(), commandParam);
    }

    protected boolean isModified() {
        boolean canSaveData = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM008");
        return canSaveData && this.isTrueFlagInCache("is_modify");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "btn_ok_cf": {
                if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                    this.checkPerm("btn_savedata", "bcm_analyticssolutiondata");
                    CommandParam commandParam = new CommandParam("bcm_analyticsdimdesign", "bcm_analyticssolutiondata", "savedataAndRefresh", new Object[0]);
                    this.sendMsg(this.getView(), commandParam);
                } else {
                    this.doRefresh();
                }
                this.setModified(false);
                break;
            }
        }
    }
}

