/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.BaseEditElement;
import kd.fi.bcm.business.page.model.ComboEditElement;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.PageBasicInfo;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.util.DragUtil;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.analytics.DimDesignerControlPlugin;
import kd.fi.bcm.formplugin.analytics.SearchHelper;
import kd.fi.bcm.formplugin.analytics.service.AnalyticsSolutionService;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ExtDimDesignerControlPlugin
extends DimDesignerControlPlugin {
    private static final String model = "model";
    private static final String pagePanel = "pagepanel";
    private static final String rowPanel = "rowpanel";
    private static final String colPanel = "colpanel";
    private static final String pageDim = "pagedim";
    private static final String rowDim = "rowdim";
    private static final String colDim = "coldim";
    private static final String MEMBER_NUM = "memberNum";
    private static final String DIM_NAME = "dimName";
    private static final String DIM_NUYBER = "dimNumber";
    private static final String EXT_FMONEY = "extfmoney|ext";
    private static final String EXT_RESOURCEORG = "resourceorg|ext";
    private static final String EXT_FMONEY_COL = "extfmoneycolpanel|ext";
    private static final String EXT_FMONEY_ROW = "extfmoneyrowpanel|ext";
    private static final String EXT_FMONEY_PAGE = "extfmoneypagepanel|ext";
    private static final String CACHE_SUF = "Cache";
    private static final List<String> CANT_DRAG_DIMS = Arrays.asList("scenario", DimTypesEnum.PROCESS.getNumber().toLowerCase(), DimTypesEnum.AUDITTRIAL.getNumber().toLowerCase());
    protected static final String ENTRYENTITY_SHOW_CONDITION = "condition";
    protected static final String ENTRYENTITY_VALUE = "value";
    protected static final String ENTRYENTITY = "entryentity";
    protected static final String ENTRYENTITY_FIELD = "field";

    @Override
    public void initialize() {
        super.initialize();
        HashMap<String, String> f7Key2Dim = new HashMap<String, String>();
        f7Key2Dim.put("resourceorgpagepanel|ext", DimTypesEnum.ENTITY.getNumber());
        f7Key2Dim.put("resourceorgrowpanel|ext", DimTypesEnum.ENTITY.getNumber());
        f7Key2Dim.put("resourceorgcolpanel|ext", DimTypesEnum.ENTITY.getNumber());
        this.getPageCache().put("f7Key2Dim", this.toByteSerialized(f7Key2Dim));
    }

    @Override
    protected void registerTreeF7() {
        HashMap map = new HashMap(16);
        Map<String, String> dimIgnoreCaseMap = DimensionUtil.getDimIgnoreCaseMapByModelId(this.getModelId());
        if (dimIgnoreCaseMap != null) {
            ArrayList dims = Lists.newArrayList(dimIgnoreCaseMap.keySet());
            dims.add("resourceorgpagepanel|ext");
            this.asMapF7toType(dims, SingleF7TypeEnum.ROOT, map);
            this.initSingleMemberF7(map);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (EXT_FMONEY_COL.equals(key) || EXT_FMONEY_ROW.equals(key)) {
            long modelId = this.getModelId();
            QFilter qf = new QFilter(model, "=", (Object)modelId);
            qf.and("parent", "=", (Object)this.getView().getPageCache().get("extModelid"));
            beforeF7SelectEvent.getCustomQFilters().add(qf);
        }
    }

    @Override
    protected void buildUpdatePage() {
        try {
            long modelId = this.getModelId();
            DynamicObject solution = this.getCurrentAnalyticsSolution();
            long extModelid = solution.getLong("extmodel.id");
            this.getView().getPageCache().put("extmodelid", String.valueOf(extModelid));
            ExtendsModel extendsModel = new ExtendsModel().getExtendsModel(Long.valueOf(extModelid));
            long extendsGroup = extendsModel.getExtendsGroup();
            this.getPageCache().put("extendsGroup", String.valueOf(extendsGroup));
            LinkedHashMap<String, DynaEntityObject> rowCols = new LinkedHashMap<String, DynaEntityObject>(16);
            HashSet<String> dimFields = new HashSet<String>(16);
            HashSet<String> extFields = new HashSet<String>(16);
            HashMap<String, String> dimFields2name = new HashMap<String, String>(16);
            HashMap<String, String> extdimFields2name = new HashMap<String, String>(16);
            AnalyticsSolutionService.getAnalyticsSolutionService().collectFields(extendsModel, rowCols, dimFields, extFields, dimFields2name, extdimFields2name);
            this.getPageCache().put("dimFields2name", this.toByteSerialized(dimFields2name));
            this.getPageCache().put("extdimFields2name", this.toByteSerialized(extdimFields2name));
            Set<String> numberNums = AnalyticsSolutionService.getAnalyticsSolutionService().collectNumExtDimNum(modelId, extendsModel, extFields);
            this.getPageCache().put("numberNums", this.toByteSerialized(numberNums));
            QFilter qFilter = new QFilter(model, "=", (Object)modelId).and("parent", "=", (Object)extendsGroup).and(new QFilter("number", "in", numberNums));
            DynamicObjectCollection numExtDims = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
            Map<String, String> numberId2name = numExtDims.stream().collect(Collectors.toMap(e -> e.getString("id"), e -> e.getString("name"), (v1, v2) -> v1));
            this.getPageCache().put("numberId2name", this.toByteSerialized(numberId2name));
            HashSet<String> existDims = new HashSet<String>(16);
            HashSet<String> existExtDims = new HashSet<String>(16);
            this.collectExistDimNum(solution.getDynamicObjectCollection(pageDim), existDims, existExtDims, "dimid", "extdimid");
            this.collectExistDimNum(solution.getDynamicObjectCollection(rowDim), existDims, existExtDims, "rowdimid", "rowextdimid");
            this.collectExistDimNum(solution.getDynamicObjectCollection(colDim), existDims, existExtDims, "columndimid", "columnextdimid");
            ExtDimDesignerControlPlugin.addNewDimInPage(modelId, solution, extendsModel, rowCols, dimFields, extFields, numberNums, existDims, existExtDims);
            DynamicObjectCollection pageDimList = solution.getDynamicObjectCollection(pageDim);
            DynamicObjectCollection rowDimList = solution.getDynamicObjectCollection(rowDim);
            DynamicObjectCollection colDimList = solution.getDynamicObjectCollection(colDim);
            pageDimList.sort(SearchHelper.getCompareMethod("orderindex_id"));
            rowDimList.sort(SearchHelper.getCompareMethod("roworderindex_id"));
            colDimList.sort(SearchHelper.getCompareMethod("colorderindex_id"));
            this.clearFmoneyCache();
            Page page = new Page();
            this.buildUpdateAreaPanelWithExt(pageDimList, page, pagePanel, "dimid", "menberid", "dimmem", "extdimid", "datatype", "");
            this.buildUpdateAreaPanelWithExt(rowDimList, page, rowPanel, "rowdimid", "rowmenberid", "rowdimmem", "rowextdimid", "rowdatatype", "rowextdims");
            this.buildUpdateAreaPanelWithExt(colDimList, page, colPanel, "columndimid", "columnmenberid", "coldimmem", "columnextdimid", "coldatatype", "colextdims");
            this.setPage(this.getView(), page);
            page.updatePage(this.getView());
            DragUtil.allDrag((IFormView)this.getView(), (Page)page);
            this.setValue("solutionnumber", solution.getString("solutionnumber"));
            this.setValue("solutionname", solution.getString("solutionname"));
            this.fillPageElementValue(pagePanel);
            this.fillPageElementValue(rowPanel);
            this.fillPageElementValue(colPanel);
            DynamicObjectCollection filters = solution.getDynamicObjectCollection("filter");
            if (CollectionUtils.isNotEmpty((Collection)filters)) {
                IDataModel model = this.getModel();
                int[] rows = model.batchCreateNewEntryRow(ENTRYENTITY, filters.size());
                for (int i = 0; i < filters.size(); ++i) {
                    int rowNum = rows[i];
                    DynamicObject filter = (DynamicObject)filters.get(i);
                    String number = filter.getString("number");
                    model.setValue(ENTRYENTITY_FIELD, (Object)number, rowNum);
                    String condition = filter.getString(ENTRYENTITY_SHOW_CONDITION);
                    if (StringUtils.isEmpty((CharSequence)condition)) continue;
                    model.setValue(ENTRYENTITY_VALUE, (Object)condition, rowNum);
                    if (!number.endsWith("|ext") || EXT_RESOURCEORG.equals(number)) {
                        String[] split = condition.split(",");
                        if (EXT_RESOURCEORG.equals(number)) {
                            number = "Entity";
                        }
                        MultiF7Results multiF7Results = MultiF7Results.buildMultiF7Results((String[])split, (long)this.getModelId(), (String)number);
                        model.setValue(ENTRYENTITY_SHOW_CONDITION, (Object)multiF7Results.getShowText(), rowNum);
                        continue;
                    }
                    model.setValue(ENTRYENTITY_SHOW_CONDITION, (Object)condition, rowNum);
                }
            }
            AnalyticsSolutionService.getAnalyticsSolutionService().cacheAnalyticsSolutionSerial(this.getPageCache(), solution);
        }
        catch (Exception e2) {
            log.error((Throwable)e2);
            this.getView().showErrorNotification(e2.getMessage());
        }
    }

    private static void addNewDimInPage(long modelId, DynamicObject solution, ExtendsModel extendsModel, Map<String, DynaEntityObject> rowCols, Set<String> dimFields, Set<String> extFields, Set<String> numberNums, HashSet<String> existDims, HashSet<String> existExtDims) {
        HashSet<String> needAddDims = new HashSet<String>(dimFields);
        needAddDims.removeAll(existDims);
        HashSet<String> needAddExtDims = new HashSet<String>(extFields);
        needAddExtDims.removeAll(existExtDims);
        needAddExtDims.removeAll(numberNums);
        int index = solution.getDynamicObjectCollection(pageDim).size();
        if (CollectionUtils.isNotEmpty(needAddDims)) {
            index = AnalyticsSolutionService.getAnalyticsSolutionService().addPageDim4extSolution(modelId, solution, new HashMap<String, String>(16), needAddDims, index);
        }
        if (CollectionUtils.isNotEmpty(needAddExtDims)) {
            AnalyticsSolutionService.getAnalyticsSolutionService().addExtDim4extSolution(modelId, solution, extendsModel, rowCols, numberNums, index, needAddExtDims);
        }
    }

    private void clearFmoneyCache() {
        this.getPageCache().remove("extfmoneycolpanel|extCache");
        this.getPageCache().remove("extfmoneyrowpanel|extCache");
        this.getPageCache().remove("extfmoneypagepanel|extCache");
    }

    private void collectExistDimNum(DynamicObjectCollection dims, HashSet<String> existDims, HashSet<String> existExtDims, String dimidProperty, String extdimProperty) {
        for (DynamicObject dy : dims) {
            Object extdim;
            Object dim = dy.get(dimidProperty);
            if (dim instanceof DynamicObject) {
                existDims.add(((DynamicObject)dim).getString("number"));
            }
            if (!((extdim = dy.get(extdimProperty)) instanceof DynamicObject)) continue;
            existExtDims.add(((DynamicObject)extdim).getString("number"));
        }
    }

    protected void buildUpdateAreaPanelWithExt(DynamicObjectCollection dimList, Page page, String areaPanel, String dimIdProperty, String memIdProperty, String memNumProperty, String extDimProperty, String typeProperty, String fmoneyProperty) {
        Area area = new Area(areaPanel);
        Style sl = SearchHelper.getStyle();
        for (DynamicObject dimDy : dimList) {
            Element element;
            DynamicObject dim = dimDy.getDynamicObject(dimIdProperty);
            DynamicObject extDim = dimDy.getDynamicObject(extDimProperty);
            String dataType = dimDy.getString(typeProperty);
            if ((StringUtils.isEmpty((CharSequence)dataType) || "0".equals(dataType)) && dim == null && extDim == null) continue;
            if (dim != null) {
                element = this.genDimElement4extSolution(areaPanel, dimDy.getString(memIdProperty), sl, dim.getString("number"), dim.getString("shortnumber"), dim.getLong("id"));
            } else if (extDim != null && !"1".equals(dataType)) {
                element = this.genExtDimElement(areaPanel, dimDy.getString(memNumProperty), sl, extDim.getString("number"), extDim.getString("name"), extDim.getLong("id"));
            } else {
                String fmoneyIds = pagePanel.equals(areaPanel) ? "" : dimDy.getString(fmoneyProperty);
                long extDimId = extDim != null ? extDim.getLong("id") : 0L;
                element = this.genOtherExtDimElement(areaPanel, sl, dataType, fmoneyIds, dimDy.getLong(memIdProperty), extDimId);
            }
            if (element == null) continue;
            area.addElement(element);
        }
        page.addArea(area);
    }

    protected Element genDimElement4extSolution(String areaPanel, String memIdScope, Style sl, String dimNumber, String shortNum, Long dimId) {
        Element element = pagePanel.equals(areaPanel) ? this.genDimElement4Page(shortNum, dimNumber, dimNumber.toLowerCase(Locale.ENGLISH), DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber)) : this.genDimElement4RowCol(shortNum, dimNumber, "bcm_dimension", dimNumber.toLowerCase(Locale.ENGLISH) + areaPanel);
        String[] memList = memIdScope.split(",");
        element.addUserObject("memList", (Object)memList);
        element.addUserObject("id", (Object)dimId);
        this.setStyle(areaPanel, sl, element);
        return element;
    }

    private Element genDimElement4Page(String name, String number, String sign, String dimEntity) {
        BaseEditElement element = new BaseEditElement(name, sign, dimEntity);
        element.setDisplayProp("number,name");
        element.setNumber(number);
        element.setLabelWidth(new LocaleString("70px"));
        if (ExtDataUtil.fixDims.stream().anyMatch(sign::equalsIgnoreCase)) {
            element.setMustInput(true);
        }
        return element;
    }

    private Element genExtDimElement(String areaPanel, String memNum, Style sl, String extDimNum, String extDimName, Long extDimId) {
        TextEditElement element;
        if (pagePanel.equals(areaPanel)) {
            String sign = extDimNum.toLowerCase(Locale.ENGLISH) + areaPanel + "|ext";
            element = new TextEditElement(extDimName, sign, "");
            element.setNumber(extDimNum);
            element.setEditStyle(0);
        } else {
            String sign = extDimNum.toLowerCase(Locale.ENGLISH) + areaPanel + "|ext";
            element = new TextEditElement(extDimNum + " " + extDimName, sign, "");
            this.dealTextElement4RowColStyle(extDimNum, (Element)element);
        }
        element.addUserObject(MEMBER_NUM, (Object)memNum);
        element.addUserObject(DIM_NUYBER, (Object)extDimNum);
        element.addUserObject("id", (Object)extDimId);
        this.setStyle(areaPanel, sl, (Element)element);
        return element;
    }

    private void dealTextElement4RowColStyle(String extDimNum, Element element) {
        ((TextEditElement)element).setNumber(extDimNum);
        ((TextEditElement)element).setFieldStyle(0);
        ((TextEditElement)element).setLock("new");
        ((TextEditElement)element).setShowTitle(false);
        element.setShowLabel(false);
    }

    private void hidePageDim(String areaPanel, Map<Long, Pair<Boolean, String>> dimHideDefaultMap, long dimId, String number) {
        Pair<Boolean, String> pair = dimHideDefaultMap.get(dimId);
        if (pagePanel.equals(areaPanel) && pair != null && ((Boolean)pair.p1).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{number.toLowerCase(Locale.ENGLISH)});
        }
    }

    private Element genDimElement4RowCol(String name, String number, String dimEntity, String sign) {
        BaseEditElement element = new BaseEditElement(name, sign, dimEntity);
        element.setDisplayProp("number name");
        element.setNumber(number);
        element.setShowTitle(false);
        element.setShowLabel(false);
        element.setLock("new");
        return element;
    }

    private Element genOtherExtDimElement(String areaPanel, Style sl, String dataType, String fmoneyDimIds, long memberId, long dimId) {
        Element element;
        String number;
        String string = number = "2".equals(dataType) ? "resourceorg" : "extfmoney";
        if (pagePanel.equals(areaPanel)) {
            String sign = number.toLowerCase(Locale.ENGLISH) + areaPanel + "|ext";
            if ("2".equals(dataType)) {
                element = this.genDimElement4Page(ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"ExtDimDesignerControlPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number, sign, "bcm_entitymembertree");
                element.setLabelWidth(new LocaleString("70px"));
                element.addUserObject("memberid", (Object)memberId);
            } else {
                element = this.genFmoneyComBo(areaPanel, ResManager.loadKDString((String)"\u5ea6\u91cf", (String)"ExtDimDesignerControlPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sl);
                element.addUserObject("memberid", (Object)dimId);
            }
        } else if ("2".equals(dataType)) {
            String sign = number.toLowerCase(Locale.ENGLISH) + areaPanel + "|ext";
            element = new TextEditElement(ResManager.loadKDString((String)"SourceEntity \u6765\u6e90\u7ec4\u7ec7", (String)"ExtDimDesignerControlPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sign, "");
            this.dealTextElement4RowColStyle(number, element);
        } else {
            String sign = number.toLowerCase(Locale.ENGLISH) + areaPanel + "|ext";
            element = new TextEditElement(ResManager.loadKDString((String)"\u5ea6\u91cf", (String)"ExtDimDesignerControlPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sign, "bcm_structofextend");
            element.setNumber(number);
            element.setShowLabel(false);
            if (StringUtils.isNotEmpty((CharSequence)fmoneyDimIds)) {
                try {
                    List dimIds = (List)JSON.parseObject((String)fmoneyDimIds, List.class);
                    if (dimIds != null) {
                        this.cacheFmoney4RowCol(this.toByteSerialized(dimIds));
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
        element.addUserObject(DIM_NUYBER, (Object)number);
        this.setStyle(areaPanel, sl, element);
        return element;
    }

    private void setStyle(String areaPanel, Style sl, Element element) {
        if (pagePanel.equals(areaPanel)) {
            element.setWidth(new LocaleString("250px"));
        } else {
            element.setWidth(new LocaleString("260px"));
        }
        element.setStyle(sl);
        element.setHeight(new LocaleString("28px"));
        element.setFontSize(12);
        element.setFieldTextAlign("left");
        element.setLabelWidth(new LocaleString("60px"));
    }

    protected void fillPageElementValue(String areaPanel) {
        Map dimHideDefaultMap = QueryDimensionServiceHelper.getDimensionHideDefaultItem((Long)this.modelId);
        Map numberAndDimIDMap = QueryDimensionServiceHelper.getNumberAndDimIDMap((long)this.modelId);
        Area areaBySign = this.getPage(this.getView()).findAreaBySign(areaPanel);
        if (areaBySign == null) {
            return;
        }
        for (Element e : areaBySign.getElementListList()) {
            String sign = e.getSign();
            if (sign.endsWith("|ext") || !pagePanel.equals(areaPanel)) {
                if (sign.endsWith("|ext")) {
                    if ("extfmoney".equals(e.getNumber())) {
                        if (pagePanel.equals(areaPanel)) {
                            this.setValue(sign, e.getUserObject("memberid"));
                            continue;
                        }
                        this.setFmoneyValue4RowCol(sign);
                        continue;
                    }
                    if ("resourceorg".equals(e.getNumber())) {
                        if (pagePanel.equals(areaPanel)) {
                            this.setValue(sign, e.getUserObject("memberid"));
                            continue;
                        }
                        this.setValue(sign, e.getName());
                        continue;
                    }
                    if (pagePanel.equals(areaPanel)) {
                        Object value = e.getUserObject(MEMBER_NUM);
                        this.setValue(sign, value);
                        continue;
                    }
                    this.setValue(sign, e.getName());
                    continue;
                }
                long dimId = (Long)e.getUserObject("id");
                this.setValue(sign, dimId);
                continue;
            }
            this.fillDimMem(areaPanel, dimHideDefaultMap, numberAndDimIDMap, e, sign);
        }
    }

    private void setFmoneyValue4RowCol(String sign) {
        String idsStr = this.getPageCache().get(sign + CACHE_SUF);
        if (StringUtils.isNotEmpty((CharSequence)idsStr)) {
            List ids = (List)this.deSerializedBytes(idsStr);
            if (CollectionUtils.isNotEmpty((Collection)ids)) {
                DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_structofextend", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
                String name = dys.stream().map(d -> d.getString("name")).collect(Collectors.joining(","));
                this.setValue(sign, name);
            } else {
                this.setValue(sign, "#");
            }
        } else {
            this.setValue(sign, "#");
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(ENTRYENTITY_SHOW_CONDITION);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setComboItems();
    }

    private void setComboItems() {
        ComboEdit memberFields = (ComboEdit)this.getControl(ENTRYENTITY_FIELD);
        if (memberFields != null) {
            Map num2name;
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
            String dimFields2nameStr = this.getPageCache().get("dimFields2name");
            String extdimFields2nameStr = this.getPageCache().get("extdimFields2name");
            if (StringUtils.isNotEmpty((CharSequence)dimFields2nameStr)) {
                num2name = (Map)this.deSerializedBytes(dimFields2nameStr);
                for (Map.Entry entry : num2name.entrySet()) {
                    comboItems.add(new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey()));
                }
            }
            comboItems.add(new ComboItem(new LocaleString(DimEntityNumEnum.ENTITY.getName()), DimEntityNumEnum.ENTITY.getNumber()));
            comboItems.add(new ComboItem(new LocaleString(DimEntityNumEnum.YEAR.getName()), DimEntityNumEnum.YEAR.getNumber()));
            comboItems.add(new ComboItem(new LocaleString(DimEntityNumEnum.PERIOD.getName()), DimEntityNumEnum.PERIOD.getNumber()));
            comboItems.add(new ComboItem(new LocaleString(DimEntityNumEnum.CURRENCY.getName()), DimEntityNumEnum.CURRENCY.getNumber()));
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"ExtDimDesignerControlPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])), EXT_RESOURCEORG));
            if (StringUtils.isNotEmpty((CharSequence)extdimFields2nameStr)) {
                num2name = (Map)this.deSerializedBytes(extdimFields2nameStr);
                for (Map.Entry entry : num2name.entrySet()) {
                    comboItems.add(new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey() + "|ext"));
                }
            }
            memberFields.setComboItems(comboItems);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] data;
        Object newValue;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ((EXT_FMONEY_COL.equals(key) || EXT_FMONEY_PAGE.equals(key) || EXT_FMONEY_ROW.equals(key)) && ((newValue = (data = e.getChangeSet())[0].getNewValue()) == null || StringUtils.isEmpty((CharSequence)newValue.toString()))) {
            this.clearFmoneyCache();
        }
        EntryGrid conditions = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = conditions.getSelectRows();
        if ((ENTRYENTITY_FIELD.equals(key) || ENTRYENTITY_SHOW_CONDITION.equals(key)) && selectRows.length > 0) {
            int selectRow = selectRows[0];
            IDataModel model = this.getView().getModel();
            Object newValue2 = e.getChangeSet()[0].getNewValue();
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (newValue2 == null || StringUtils.isBlank((CharSequence)newValue2.toString())) {
                model.setValue(ENTRYENTITY_SHOW_CONDITION, (Object)"", selectRow);
                model.setValue(ENTRYENTITY_VALUE, (Object)"", selectRow);
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        Element element;
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_ok".equals(key)) {
            if (this.getView().getParentView() != null) {
                OperationLogUtil.writeOperationLog((IFormView)this.getView().getParentView(), (String)(OpItemEnum.APPLY.getName() + OpItemEnum.QUERY.getName()), (String)(OpItemEnum.QUERY.getName() + ResultStatusEnum.SUCCESS.getName()), (Long)this.getModelId());
            }
            this.applySolution();
        } else if (ENTRYENTITY_SHOW_CONDITION.equals(key)) {
            EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
            int index = grid.getSelectRows()[0];
            Object v = this.getModel().getValue(ENTRYENTITY_FIELD, index);
            if (v == null) {
                return;
            }
            String rowValue = v.toString();
            if (!rowValue.endsWith("|ext") || EXT_RESOURCEORG.equals(rowValue)) {
                this.openMultiF7(rowValue);
            } else {
                Object value = this.getModel().getValue(ENTRYENTITY_VALUE, index);
                int indexOf = rowValue.indexOf("|ext");
                if (indexOf != -1) {
                    rowValue = rowValue.substring(0, indexOf);
                }
                this.openConditionForm(rowValue, value.toString());
            }
        } else if ((EXT_FMONEY_COL.equals(key) || EXT_FMONEY_PAGE.equals(key) || EXT_FMONEY_ROW.equals(key)) && this.getPage(this.getView()) != null && (element = this.getPage(this.getView()).findElementBySign(key)) != null) {
            ListShowParameter para = new ListShowParameter();
            para.setLookUp(true);
            para.setCaption(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6210\u5458`\u9009\u62e9", (String)"ExtDimDesignerControlPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            para.setFormId("bos_listf7");
            para.setBillFormId("bcm_structofextend");
            para.setShowUsed(true);
            para.setMultiSelect(true);
            QFilter qf = new QFilter(model, "=", (Object)this.getModelId());
            String numberNums = this.getPageCache().get("numberNums");
            HashSet numbers = new HashSet(16);
            if (StringUtils.isNotEmpty((CharSequence)numberNums)) {
                numbers.addAll((Collection)this.deSerializedBytes(numberNums));
            }
            qf.and("parent", "=", (Object)LongUtil.toLong((Object)this.getView().getPageCache().get("extendsGroup")));
            qf.and("number", "in", numbers);
            para.setListFilterParameter(new ListFilterParameter(Collections.singletonList(qf), null));
            para.setShowTitle(false);
            StyleCss css = new StyleCss();
            css.setHeight("580");
            css.setWidth("960");
            para.getOpenStyle().setInlineStyleCss(css);
            para.setHasRight(true);
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setShowApproved(true);
            ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
            String idsStr = this.getView().getPageCache().get(key + CACHE_SUF);
            if (StringUtils.isNotEmpty((CharSequence)idsStr)) {
                List ids = (List)this.deSerializedBytes(idsStr);
                for (Long id : ids) {
                    ListSelectedRow selectedRow = new ListSelectedRow((Object)id);
                    selectedRows.add((Object)selectedRow);
                }
            }
            para.setListSelectedRowCollection(selectedRows);
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            this.getView().showForm((FormShowParameter)para);
        }
    }

    private void applySolution() {
        DynamicObject so = this.getCurrentAnalyticsSolution();
        Date now = TimeServiceHelper.now();
        so.set("updateuserid", (Object)this.getUserId());
        so.set("updatetime", (Object)now);
        so.set(model, this.getView().getFormShowParameter().getCustomParam(model));
        QFilter qFilter = new QFilter(model, "=", (Object)this.getModelId());
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name,shortnumber,issysdimension", (QFilter[])new QFilter[]{qFilter}, (String)"number desc");
        HashMap<String, DynamicObject> allDimMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dim : dims) {
            allDimMap.put(dim.getString("number"), dim);
        }
        qFilter.and("parent", "=", (Object)LongUtil.toLong((Object)this.getView().getPageCache().get("extendsGroup")));
        DynamicObjectCollection extDims = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter}, (String)"number desc");
        HashMap<String, DynamicObject> allExtDimMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dim : extDims) {
            allExtDimMap.put(dim.getString("number"), dim);
        }
        this.buildSaveDim4extSolution(so, pageDim, pagePanel, "dimid", "menberid", "dimmem", "extdimid", "datatype", "", "orderindex", allDimMap, allExtDimMap);
        this.buildSaveDim4extSolution(so, rowDim, rowPanel, "rowdimid", "rowmenberid", "rowdimmem", "rowextdimid", "rowdatatype", "rowextdims", "roworderindex", allDimMap, allExtDimMap);
        this.buildSaveDim4extSolution(so, colDim, colPanel, "columndimid", "columnmenberid", "coldimmem", "columnextdimid", "coldatatype", "colextdims", "colorderindex", allDimMap, allExtDimMap);
        DynamicObjectCollection filter = so.getDynamicObjectCollection("filter");
        filter.clear();
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        int size = grid.getEntryData().getEndIndex();
        for (int index = 0; index < size; ++index) {
            Object field = this.getModel().getValue(ENTRYENTITY_FIELD, index);
            Object v = this.getModel().getValue(ENTRYENTITY_VALUE, index);
            if (field == null || v == null) continue;
            DynamicObject dy = filter.addNew();
            dy.set("number", field);
            dy.set(ENTRYENTITY_SHOW_CONDITION, v);
            dy.set("seq", (Object)index);
        }
        CommandParam commandParam = new CommandParam("bcm_analyticsextdesign", "bcm_analyticssolutiondata", "dimdesigner", this.toByteSerialized(so), "1");
        this.sendMsg(this.getView(), commandParam);
    }

    private void openMultiF7(String dim) {
        FormShowParameter para = new FormShowParameter();
        String captionPrefix = "";
        if (EXT_RESOURCEORG.equals(dim)) {
            dim = DimTypesEnum.ENTITY.getNumber();
            captionPrefix = ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"ExtDimDesignerControlPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        Long dimensionId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)dim);
        DynamicObject dimensionDynById = MemberReader.getDimensionDynById((long)dimensionId);
        String string = captionPrefix = "".equals(captionPrefix) ? dimensionDynById.getString("name") : captionPrefix;
        if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dim)) {
            para.setFormId("bcm_mulmemberf7_tem_ic");
        } else {
            para.setFormId("bcm_mulmemberf7base_tem");
        }
        para.getOpenStyle().setShowType(ShowType.Modal);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        params.put("dimensionid", String.valueOf(dimensionId));
        params.put("sign", dim);
        para.setCustomParams(params);
        para.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"ExtDimDesignerControlPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), captionPrefix));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, dim);
        para.setCloseCallBack(closeCallBack);
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        if (grid.getSelectRows().length > 0) {
            int index = grid.getSelectRows()[0];
            Object value = this.getModel().getValue(ENTRYENTITY_VALUE, index);
            if (value == null || StringUtils.isEmpty((CharSequence)value.toString())) {
                this.getPageCache().put(dim, null);
            } else {
                String[] split = value.toString().split(",");
                MultiF7Results multiF7Results = MultiF7Results.buildMultiF7Results((String[])split, (long)this.getModelId(), (String)dim);
                this.getPageCache().put(dim, SerializationUtils.toJsonString((Object)multiF7Results.toList()));
            }
        }
        this.getView().showForm(para);
    }

    private void openConditionForm(String name, String condition) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bcm_analysisconditon");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam(ENTRYENTITY_SHOW_CONDITION, (Object)condition);
        fsp.setCaption(String.format(ResManager.loadKDString((String)"%s \u6761\u4ef6\u8bbe\u7f6e", (String)"ExtDimDesignerControlPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_analysisconditon"));
        this.getView().showForm(fsp);
    }

    protected void buildSaveDim4extSolution(DynamicObject solution, String dimPanel, String areaPanel, String dimIdProperty, String memIdProperty, String memNumProperty, String extDimProperty, String typeProperty, String fmoneyProperty, String orderIndexName, Map<String, DynamicObject> allDimMap, Map<String, DynamicObject> allExtDimMap) {
        DynamicObjectCollection dimCol = solution.getDynamicObjectCollection(dimPanel);
        dimCol.clear();
        int orderIndex = 1;
        for (Element e : this.getPage(this.getView()).findAreaBySign(areaPanel).getElementListList()) {
            DynamicObject col;
            DynamicObject dimMember = dimCol.addNew();
            String sign = e.getSign();
            if (!sign.endsWith("|ext")) {
                DynamicObject dim = allDimMap.get(e.getNumber());
                if (dim != null) {
                    dimMember.set(dimIdProperty, (Object)dim);
                    if (pagePanel.equals(areaPanel)) {
                        col = (DynamicObject)this.getValue(sign);
                        if (col != null) {
                            dimMember.set(memIdProperty, (Object)col.getLong("id"));
                        } else {
                            this.clearValue(sign);
                        }
                    }
                }
                dimMember.set(typeProperty, (Object)"0");
            } else {
                String number = e.getNumber();
                if ("extfmoney".equals(number)) {
                    if (pagePanel.equals(areaPanel)) {
                        String extId = (String)this.getValue(sign);
                        if (StringUtils.isNotEmpty((CharSequence)extId)) {
                            DynamicObject ext = allExtDimMap.values().stream().filter(d -> extId.equals(d.getString("id"))).findFirst().orElse(null);
                            dimMember.set(extDimProperty, (Object)ext);
                        } else {
                            this.clearValue(sign);
                        }
                    } else {
                        String idsStr = this.getPageCache().get(sign + CACHE_SUF);
                        if (StringUtils.isNotEmpty((CharSequence)idsStr)) {
                            List ids = (List)this.deSerializedBytes(idsStr);
                            dimMember.set(fmoneyProperty, (Object)JSON.toJSONString((Object)ids));
                        }
                    }
                    dimMember.set(typeProperty, (Object)"1");
                } else if ("resourceorg".equals(number)) {
                    dimMember.set(extDimProperty, (Object)0);
                    if (pagePanel.equals(areaPanel)) {
                        col = (DynamicObject)this.getValue(e.getSign());
                        if (col != null) {
                            dimMember.set(memIdProperty, (Object)col.getLong("id"));
                        } else {
                            this.clearValue(sign);
                        }
                    }
                    dimMember.set(typeProperty, (Object)"2");
                } else {
                    DynamicObject extDim = allExtDimMap.get(number);
                    if (extDim != null) {
                        dimMember.set(extDimProperty, (Object)extDim);
                        if (pagePanel.equals(areaPanel)) {
                            Object value = this.getValue(sign);
                            if (value != null) {
                                dimMember.set(memNumProperty, this.getValue(sign));
                            } else {
                                this.clearValue(sign);
                            }
                        }
                    }
                    dimMember.set(typeProperty, (Object)"0");
                }
            }
            dimMember.set(orderIndexName, (Object)orderIndex);
            ++orderIndex;
        }
    }

    private void clearValue(String sign) {
        this.setValue(sign, null);
        this.getView().updateView(sign);
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String sign;
        Element c;
        super.onGetControl(e);
        if (this.getPage(this.getView()) != null && (c = this.getPage(this.getView()).findElementBySign(e.getKey())) != null && (EXT_FMONEY_COL.equals(sign = c.getSign()) || EXT_FMONEY_PAGE.equals(sign) || EXT_FMONEY_ROW.equals(sign))) {
            TextEdit edit = new TextEdit();
            edit.setKey(e.getKey());
            edit.setModel(this.getModel());
            edit.setView(this.getView());
            edit.addClickListener((ClickListener)this);
            e.setControl((Control)edit);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent cb) {
        String key = cb.getActionId();
        if (EXT_FMONEY_COL.equals(key) || EXT_FMONEY_ROW.equals(key)) {
            Object returnData;
            if (cb.getReturnData() != null && (returnData = cb.getReturnData()) instanceof ListSelectedRowCollection) {
                ArrayList<Long> ids = new ArrayList<Long>(16);
                ArrayList<String> names = new ArrayList<String>(16);
                for (ListSelectedRow returnDatum : (ListSelectedRowCollection)returnData) {
                    ids.add(LongUtil.toLong((Object)returnDatum.getPrimaryKeyValue()));
                    names.add(returnDatum.getName());
                }
                this.setValue(key, String.join((CharSequence)",", names));
                this.cacheFmoney4RowCol(this.toByteSerialized(ids));
            }
        } else {
            EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
            if (grid.getSelectRows().length > 0) {
                int index = grid.getSelectRows()[0];
                if (key.equals("bcm_analysisconditon") && Objects.nonNull(cb.getReturnData())) {
                    this.getView().getModel().setValue(ENTRYENTITY_SHOW_CONDITION, cb.getReturnData(), index);
                    this.getView().getModel().setValue(ENTRYENTITY_VALUE, cb.getReturnData(), index);
                } else if (cb.getReturnData() != null) {
                    DynamicObjectCollection doc = (DynamicObjectCollection)cb.getReturnData();
                    MultiF7Results mps = MultiF7Results.buildParam((DynamicObjectCollection)doc);
                    IDataModel model = this.getModel();
                    if (doc.isEmpty()) {
                        model.setValue(ENTRYENTITY_SHOW_CONDITION, null, index);
                        model.setValue(ENTRYENTITY_VALUE, null, index);
                        this.getPageCache().remove(key);
                    } else {
                        model.setValue(ENTRYENTITY_SHOW_CONDITION, (Object)mps.getShowText(), index);
                        String memScope = SerializationUtils.toJsonString((Object)mps.toList());
                        model.setValue(ENTRYENTITY_VALUE, (Object)mps.getMemberSettingForMDQA(), index);
                        this.getPageCache().put(key, memScope);
                    }
                }
            }
        }
    }

    private void cacheFmoney4RowCol(String idsStr) {
        this.getPageCache().put("extfmoneycolpanel|extCache", idsStr);
        this.getPageCache().put("extfmoneyrowpanel|extCache", idsStr);
        this.getPageCache().put("extfmoneypagepanel|extCache", idsStr);
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
    }

    @Override
    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        try {
            if ("drop".equals(name)) {
                String eventArgs = e.getEventArgs();
                Page page = this.getPage(this.getView());
                this.buildPage4drag(page, eventArgs);
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    protected void buildPage4drag(Page page, String command) {
        Area targetArea;
        String[] msg = DragUtil.translateMessage((String)command);
        PageBasicInfo target = page.seaechSign(msg[0]);
        Element source = (Element)page.seaechSign(msg[1]);
        String sourceSign = source.getSign();
        Area sourceArea = source.getArea();
        boolean targetIsArea = true;
        if (target instanceof Area) {
            targetArea = (Area)target;
        } else {
            targetArea = ((Element)target).getArea();
            targetIsArea = false;
        }
        String sourceAreaSign = sourceArea.getSign();
        String targetAreaSign = targetArea.getSign();
        boolean canDrop = this.checkDimCanDrag(sourceSign, sourceAreaSign, targetAreaSign);
        if (canDrop) {
            Element dropElement = this.genDropElement(targetArea.getSign(), source);
            this.setValue(sourceSign, null);
            targetArea.removeElememt(sourceSign);
            sourceArea.removeElememt(sourceSign);
            this.setValue(sourceSign, null);
            if (targetIsArea) {
                targetArea.addElement(dropElement);
            } else {
                int i = targetArea.getElementListList().indexOf(target);
                dropElement.setArea(targetArea);
                targetArea.getElementListList().add(i, dropElement);
            }
            this.setStyle(page, SearchHelper.getStyle());
            this.setPage(this.getView(), page);
            page.updatePage(this.getView());
            DragUtil.allDrag((IFormView)this.getView(), (Page)page);
            if (!pagePanel.equals(targetAreaSign)) {
                String sign = dropElement.getSign();
                if (EXT_FMONEY_COL.equals(sign) || EXT_FMONEY_PAGE.equals(sign) || EXT_FMONEY_ROW.equals(sign)) {
                    this.setFmoneyValue4RowCol(sign);
                } else if (sign.endsWith("|ext")) {
                    this.setValue(sign, dropElement.getName());
                } else {
                    Object id = dropElement.getUserObject("id");
                    if (id != null) {
                        this.setValue(sign, id);
                        this.getView().updateView(sign);
                    }
                }
            }
        }
    }

    protected boolean checkDimCanDrag(String sign, String sourcePanel, String targetPanel) {
        if (pagePanel.equals(sourcePanel) && (rowPanel.equals(targetPanel) || colPanel.equals(targetPanel)) && CANT_DRAG_DIMS.contains(sign)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60c5\u666f/\u8fc7\u7a0b/\u5ba1\u8ba1\u7ebf\u7d22\u7ef4\u5ea6\u4e0d\u80fd\u79fb\u52a8\u81f3\u884c\u5217\u7ef4\u4e0a\u3002", (String)"DimDesignerControlPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected Element genDropElement(String tarAreaSign, Element sourceElement) {
        Element element;
        String sourceElementSign = sourceElement.getSign();
        Style sl = SearchHelper.getStyle();
        String dimNumber = sourceElement.getNumber();
        if (!sourceElementSign.endsWith("|ext")) {
            Long dimId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)dimNumber);
            element = this.genDimElement4extSolution(tarAreaSign, "", sl, dimNumber, sourceElement.getName(), dimId);
        } else if ("extfmoney".equals(dimNumber) || "resourceorg".equals(dimNumber)) {
            String dataType = "extfmoney".equals(dimNumber) ? "1" : "2";
            element = this.genOtherExtDimElement(tarAreaSign, sl, dataType, "", 0L, 0L);
        } else {
            long dimId = 0L;
            QFilter modelQf = new QFilter(model, "=", (Object)this.getModelId());
            modelQf.and("parent", "=", (Object)LongUtil.toLong((Object)this.getView().getPageCache().get("extendsGroup")));
            modelQf.and("number", "=", (Object)dimNumber);
            DynamicObject extDim = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"id,name", (QFilter[])new QFilter[]{modelQf});
            String name = sourceElement.getName();
            if (extDim != null) {
                dimId = extDim.getLong("id");
                name = extDim.getString("name");
            }
            element = this.genExtDimElement(tarAreaSign, "", sl, dimNumber, name, dimId);
        }
        return element;
    }

    private Element genFmoneyComBo(String tarAreaSign, String name, Style sl) {
        Object o;
        String sign = "extfmoney".toLowerCase(Locale.ENGLISH) + tarAreaSign + "|ext";
        ComboEditElement element = new ComboEditElement(sign, name, (List)Lists.newArrayList());
        String numberId2nameStr = this.getPageCache().get("numberId2name");
        HashMap numId2Name = new HashMap(16);
        if (StringUtils.isNotEmpty((CharSequence)numberId2nameStr) && (o = this.deSerializedBytes(numberId2nameStr)) instanceof Map) {
            numId2Name.putAll((Map)o);
        }
        for (Map.Entry num2name : numId2Name.entrySet()) {
            element.getItems().add(new ComboItem(new LocaleString((String)num2name.getValue()), (String)num2name.getKey()));
        }
        element.setMustinput(Boolean.TRUE.booleanValue());
        element.setNumber("extfmoney");
        this.setStyle(tarAreaSign, sl, (Element)element);
        return element;
    }

    @Override
    public void dealMsg(CommandParam com) {
        String operation = com.getOperation();
        if ("btn_ok".equals(operation)) {
            this.applySolution();
        }
    }
}

