/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.extdata.model.DimFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtField;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.dimension.FieldTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class ExtendDataRptFormPlugin
extends AbstractReportFormPlugin
implements SelectRowsEventListener,
BeforeF7SelectListener,
BCMBaseFunction {
    protected static final String MUL = "mul";
    protected static final String ORG = "org";
    protected static final String scenario = "scenario";
    protected static final String year = "year";
    protected static final String period = "period";
    protected static final String model = "model";
    protected static final String cslscheme = "cslscheme";
    protected static final String entity = "entity";
    protected static final String currency = "currency";
    protected static final String process = "process_new";
    protected static final String audittrail = "audittrail";
    private static final List<String> DIM_KEYS = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period", "currency", "entity"});
    private static final List<String> NO_LEAF_KEYS = Lists.newArrayList((Object[])new String[]{"audittrail", "process_new"});
    protected static final String FIX = "_fix";
    protected static final String EXTEND_MODEL = "extendmodel";
    protected static final String FLEX_PANEL_AP2 = "flexpanelap2";
    protected static final String FLEX_PANEL_AP3 = "flexpanelap3";
    protected static final String LIST_MODEL = "listmodel";
    protected static final String ANALYSIS_MODEL = "analysismodel";
    protected Map<String, Control> cacheControls = new CaseInsensitiveMap();
    private Map<String, SingleF7TypeEnum> map;
    protected static final String F7KEY2DIM = "f7Key2Dim";
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ExtendDataRptFormPlugin.class);
    private Map<String, String> mappedToCol = new HashMap<String, String>(8);

    public void initialize() {
        super.initialize();
        HashMap<String, SingleF7TypeEnum> map = new HashMap<String, SingleF7TypeEnum>();
        this.asMapF7toType(NO_LEAF_KEYS, SingleF7TypeEnum.COMMON, map);
        HashMap<String, String> f7Key2Dim = new HashMap<String, String>(16);
        f7Key2Dim.put(process, DimTypesEnum.PROCESS.getNumber());
        this.getPageCache().put(F7KEY2DIM, this.toByteSerialized(f7Key2Dim));
        BCMBaseFunction.super.initSingleMemberF7(map);
        Vector listModel = (Vector)this.getControl(LIST_MODEL);
        listModel.addClickListener((ClickListener)this);
        Vector analysisModel = (Vector)this.getControl(ANALYSIS_MODEL);
        analysisModel.addClickListener((ClickListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(this.getModelSign());
        BasedataEdit extendModel = (BasedataEdit)this.getControl(EXTEND_MODEL);
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (extendModel != null) {
            extendModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        for (String dimKey : DIM_KEYS) {
            MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl(MUL + dimKey);
            mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            QFilter modelFilter = new QFilter(model, "=", (Object)this.getModelId());
            if (dimKey.equals(entity)) {
                mulBasedataEdit.setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{modelFilter}));
                continue;
            }
            mulBasedataEdit.setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{modelFilter, new QFilter("isleaf", "=", (Object)"1")}));
        }
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        String total = this.getPageCache().get("total");
        if ("btn_all".equals(itemKey)) {
            log.info("ExtendDataRptFormPlugin: total: " + total + " pageRows: " + reportList.getEntryState().getPageRows());
            if (StringUtils.isNotEmpty((String)total)) {
                int rows = Integer.parseInt(total);
                int[] selects = IntStream.range(1, rows + 1).toArray();
                reportList.selectRows(selects, rows + 1);
            }
        } else if ("btn_cancel".equals(itemKey) && StringUtils.isNotEmpty((String)total)) {
            int rows = Integer.parseInt(total);
            reportList.selectRows(new int[0], rows);
            try {
                reportList.clearSelection();
            }
            catch (Throwable e) {
                log.error(e.getMessage());
            }
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject rowData = packageDataEvent.getRowData();
        Map<String, String> mappedToCol = this.getMappedToCol();
        for (Map.Entry<String, String> entry : mappedToCol.entrySet()) {
            IDNumberTreeNode member;
            String field = entry.getKey();
            String entityNum = entry.getValue();
            String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
            if (!StringUtils.isNotEmpty((String)rowData.getString(field)) || (member = MemberReader.findMemberByNumber((String)modelNum, (String)entityNum, (String)rowData.getString(field))) == IDNumberTreeNode.NotFoundTreeNode) continue;
            if (entityNum.equals(SysDimensionEnum.Entity.getNumber()) && rowData.getString(field).contains("_")) {
                rowData.set(field, (Object)(rowData.getString(field) + " | " + member.getParent().getName() + "_" + member.getName()));
                continue;
            }
            rowData.set(field, (Object)(rowData.getString(field) + " | " + member.getName()));
        }
    }

    private Map<String, String> getMappedToCol() {
        if (this.mappedToCol.isEmpty()) {
            Map<String, String> dimFieldMapped = this.getDimFieldMapped();
            Object extendmodel = this.getModel().getValue(EXTEND_MODEL);
            if (extendmodel != null) {
                long extendModelId = ((DynamicObject)extendmodel).getLong("id");
                ExtendsModel extendsModel = (ExtendsModel)this.deSerializedBytes(this.getPageCache().get("extendsModel_" + extendModelId));
                for (DimFieldEntry fieldEntry : extendsModel.getDimFieldEntry()) {
                    String mapped = dimFieldMapped.get(fieldEntry.getDimension().getNumber());
                    this.mappedToCol.put(mapped, fieldEntry.getDimension().getNumber());
                }
            }
            this.mappedToCol.put("src_entity", DimTypesEnum.ENTITY.getNumber());
            this.mappedToCol.put(ORG, DimTypesEnum.ENTITY.getNumber());
            for (String dimKey : DIM_KEYS) {
                if (entity.equals(dimKey) || SysDimensionEnum.getEnumByLowerCaseNumber((String)dimKey) == null) continue;
                this.mappedToCol.put(dimKey.toLowerCase(Locale.ENGLISH) + FIX, SysDimensionEnum.getEnumByLowerCaseNumber((String)dimKey).getNumber());
            }
        }
        return this.mappedToCol;
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        ArrayList selRows = (ArrayList)reportList.getEntryState().get("selRows");
        int pageRows = reportList.getEntryState().getPageRows();
        if (!data.isEmpty() && !selRows.isEmpty() && pageRows != selRows.size()) {
            Iterator arg5 = data.iterator();
            while (arg5.hasNext()) {
                DynamicObject dyo = (DynamicObject)arg5.next();
                int fseq = (Integer)dyo.get("fseq");
                if (selRows.contains(fseq)) continue;
                arg5.remove();
            }
        }
        Map<String, String> mappedToCol = this.getMappedToCol();
        for (DynamicObject rowData : data) {
            for (Map.Entry<String, String> entry : mappedToCol.entrySet()) {
                IDNumberTreeNode member;
                String field = entry.getKey();
                String entityNum = entry.getValue();
                String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
                if (!StringUtils.isNotEmpty((String)rowData.getString(field)) || (member = MemberReader.findMemberByNumber((String)modelNum, (String)entityNum, (String)rowData.getString(field))) == IDNumberTreeNode.NotFoundTreeNode) continue;
                rowData.set(field, (Object)(member.getNumber() + " | " + member.getName()));
            }
        }
        this.writeLog(ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"ExtendDataRptFormPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bfc\u51fa\u62d3\u5c55\u6570\u636e\u6210\u529f", (String)"ExtendDataRptFormPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), model);
        if (StringUtils.isNotEmpty((String)modelId)) {
            ApplicationTypeEnum application;
            DynamicObject userSelect;
            this.getModel().beginInit();
            this.getModel().setValue(model, (Object)modelId);
            DynamicObject defaultExtendModel = this.getDefaultExtendModel(modelId);
            if (defaultExtendModel != null) {
                this.getModel().setValue(EXTEND_MODEL, (Object)defaultExtendModel);
            }
            if ((userSelect = UserSelectUtil.getUserSelectDynamicObject("issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel", application = ModelUtil.queryApp((IFormView)this.getView()))) != null && modelId.equals(userSelect.getString(model))) {
                this.getModel().setValue(scenario, (Object)userSelect.getLong(scenario));
                this.getModel().setValue(year, (Object)userSelect.getLong(year));
                this.getModel().setValue(period, (Object)userSelect.getLong(period));
                this.getModel().setValue(currency, (Object)userSelect.getLong(currency));
                if (MemberReader.findEntityMemberById((Long)LongUtil.toLong((Object)modelId), (Long)userSelect.getLong(entity)) != IDNumberTreeNode.NotFoundTreeNode) {
                    this.getModel().setValue(entity, (Object)userSelect.getLong(entity));
                } else {
                    this.getModel().setValue(entity, null);
                }
            }
            this.setDefaultAudittrail(modelId);
            this.getModel().setValue(process, (Object)MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)PresetConstant.PROCESS_DIM, (String)"EIRpt").getId());
            this.getModel().endInit();
        }
    }

    public void beforeBindData(EventObject e) {
        Object extendmodel = this.getModel().getValue(EXTEND_MODEL);
        if (extendmodel != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            long extendModelId = ((DynamicObject)extendmodel).getLong("id");
            ExtendsModel extendsModel = new ExtendsModel(Long.valueOf(extendModelId));
            if (ExtendDimGroupType.EQUITY.getIndex().equals(extendsModel.getExtendsGroupType())) {
                this.getModel().setValue(EXTEND_MODEL, null);
                return;
            }
            this.getView().getPageCache().put("extendsModel_" + extendModelId, this.toByteSerialized(extendsModel));
            String extendDataEntity = "bcm_extenddata";
            if (ExtendDimGroupType.TRANSACTION.getIndex().equals(extendsModel.getExtendsGroupType())) {
                extendDataEntity = "bcm_extenddata_bus";
            }
            this.getView().getPageCache().put("extendDataEntity", extendDataEntity);
            filterGrid.setEntityNumber("random");
            filterGrid.setEntityNumber(extendDataEntity);
            List fieldEntries = extendsModel.getFieldEntry();
            Map<String, String> dimFieldMapped = this.getDimFieldMapped();
            ArrayList<String> keys = new ArrayList<String>(10);
            for (FieldEntry fieldEntry : fieldEntries) {
                String dataField;
                if (FieldTypeEnum.DIM_FIELD.getType() == fieldEntry.getFieldType()) {
                    dataField = dimFieldMapped.get(fieldEntry.getDimension().getNumber());
                    keys.add(dataField);
                    continue;
                }
                if (FieldTypeEnum.EXT_FIELD.getType() != fieldEntry.getFieldType()) continue;
                dataField = fieldEntry.getExtField().getMapped();
                keys.add(dataField);
            }
            filterGrid.setFilterFieldKeys(keys);
        }
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId()).getProperties();
        for (String dimKey : DIM_KEYS) {
            if (!properties.containsKey((Object)dimKey) || !(this.getValue(dimKey) instanceof DynamicObject)) continue;
            DynamicObjectCollection collection = new DynamicObjectCollection();
            DynamicObject tempDyObj = new DynamicObject(this.getModel().getDataEntity(true).getDynamicObjectCollection(MUL + dimKey).getDynamicObjectType());
            DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)MemberReader.getEntityNumberByDim((String)modelNum, (String)dimKey));
            dyn.set("id", ((DynamicObject)this.getValue(dimKey)).getPkValue());
            tempDyObj.set("fbasedataid", (Object)dyn);
            collection.add((Object)tempDyObj);
            this.getModel().setValue(MUL + dimKey, (Object)collection);
            this.getModel().setValue(dimKey, null);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object extendmodel = this.getModel().getValue(EXTEND_MODEL);
        if (extendmodel != null) {
            long extendModelId = ((DynamicObject)extendmodel).getLong("id");
            ExtendsModel extendsModel = (ExtendsModel)this.deSerializedBytes(this.getPageCache().get("extendsModel_" + extendModelId));
            List fieldEntries = extendsModel.getFieldEntry();
            Map<String, String> dimFieldMapped = this.getDimFieldMapped();
            HashMap<String, String> markToNumber = new HashMap<String, String>(16);
            for (FieldEntry fieldEntry : fieldEntries) {
                String dataField = "";
                if (FieldTypeEnum.DIM_FIELD.getType() == fieldEntry.getFieldType()) {
                    dataField = dimFieldMapped.get(fieldEntry.getDimension().getNumber());
                } else if (FieldTypeEnum.EXT_FIELD.getType() == fieldEntry.getFieldType()) {
                    dataField = fieldEntry.getExtField().getMapped();
                }
                markToNumber.put(dataField, fieldEntry.getNumber() + "-" + fieldEntry.getName());
            }
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            List filterColumns = filterGrid.getFilterColumns();
            for (Map col : filterColumns) {
                col.compute("fieldName", (kFN, vFN) -> {
                    String value = (String)markToNumber.get(vFN);
                    if (value != null) {
                        this.setColName(col, dimFieldMapped.containsValue(vFN) ? String.format(ResManager.loadKDString((String)"%s \u7ef4\u5ea6\u6210\u5458\u7f16\u7801", (String)"ExtendDataRptFormPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), value) : String.format(ResManager.loadKDString((String)"%s \u62d3\u5c55\u5b57\u6bb5\u503c", (String)"ExtendDataRptFormPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), value));
                    }
                    return vFN;
                });
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PANEL_AP3});
        this.getPageCache().put("choise_model", LIST_MODEL);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals(EXTEND_MODEL)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            filterGrid.SetValue(new FilterCondition());
            this.getView().updateView();
            this.mappedToCol.clear();
        } else if (name.equals(this.getModelSign())) {
            String modelId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), this.getModelSign());
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), modelId);
            Object newValue = e.getChangeSet()[0].getNewValue();
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (newValue == null) {
                this.setValue(this.getModelSign(), oldValue);
            } else {
                DynamicObject defaultExtendModel = this.getDefaultExtendModel(modelId);
                this.getModel().setValue(EXTEND_MODEL, (Object)defaultExtendModel);
                this.getModel().setValue("mulscenario", null);
                this.getModel().setValue("mulyear", null);
                this.getModel().setValue("mulperiod", null);
                this.getModel().setValue("mulcurrency", null);
                this.getModel().setValue("mulentity", null);
                this.getModel().setValue(audittrail, null);
                this.getModel().setValue(process, null);
                this.setDefaultAudittrail(modelId);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(this.getModelSign())) {
            if (StringUtils.isNotEmpty((String)this.getModelSign()) && this.getControl(this.getModelSign()) != null) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>();
                }
                qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
        } else if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(EXTEND_MODEL)) {
            Object model = this.getModel().getValue(this.getModelSign());
            if (model == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExtendDataRptFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.setListFilterParameter(new ListFilterParameter(Arrays.asList(new QFilter(model, "=", (Object)((DynamicObject)model).getLong("id")), new QFilter("extendsgroup.grouptype", "in", this.getNoEquityExtendGroupType())), null));
            }
        }
    }

    public void onGetControl(final OnGetControlArgs e) {
        super.onGetControl(e);
        String f7Key = e.getKey();
        String pagekey = e.getKey();
        if (this.getDimKeysFromCache().containsKey(f7Key)) {
            Control ctrl;
            SingleF7TypeEnum type = this.getDimKeysFromCache().get(f7Key);
            Map f7Key2Dim = null;
            if (StringUtils.isNotEmpty((String)this.getPageCache().get(F7KEY2DIM))) {
                f7Key2Dim = (Map)this.deSerializedBytes(this.getPageCache().get(F7KEY2DIM));
                String string = f7Key = f7Key2Dim != null && StringUtils.isNotEmpty((String)((String)f7Key2Dim.get(f7Key))) ? (String)f7Key2Dim.get(f7Key) : f7Key;
            }
            if ((ctrl = this.cacheControls.get(f7Key)) != null) {
                e.setControl(ctrl);
            } else {
                BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.getBasedataEditSingleMemberF7((IFormView)this.getView(), this.getModel(), this.getModelId(), f7Key, pagekey, ev -> this.getSingleMemberF7Handle(Lists.newArrayList(this.getDimKeysFromCache().keySet())).beforeSingleMemberF7Select(ev), false, type);
                f7.setDisplayProp("name");
                f7.setCustomData(this.getF7CustomData(f7Key));
                final String finalF7Key = f7Key;
                f7.addBasedataFuzzySearchListener(new BasedataFuzzySearchListener(){

                    public void handleData(BasedataFuzzySearchEvent arg0) {
                        SysDimensionEnum entityEnum;
                        List queryData = arg0.getQueryData();
                        boolean isAdmin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(ExtendDataRptFormPlugin.this.getModelId()));
                        if (!e.getKey().equals("account") && !isAdmin && (entityEnum = SysDimensionEnum.getEnumByLowerCaseNumber((String)finalF7Key)) != null) {
                            List ids = queryData.stream().map(data -> ConvertUtil.convertObjToLong(((List)data).get(0))).collect(Collectors.toList());
                            Set noPermIds = PermissionServiceImpl.getInstance((Long)ExtendDataRptFormPlugin.this.getModelId()).matchNoPermMembers(Long.valueOf(ExtendDataRptFormPlugin.this.getDimId(entityEnum.getNumber())), entityEnum.getMemberTreemodel(), ids);
                            queryData = queryData.stream().filter(data -> !noPermIds.contains(ConvertUtil.convertObjToLong(((List)data).get(0)))).collect(Collectors.toList());
                            arg0.setQueryData(queryData);
                        }
                        if (queryData != null && !queryData.isEmpty()) {
                            queryData.sort(new Comparator<Object>(){

                                @Override
                                public int compare(Object o1, Object o2) {
                                    if (o1 instanceof AbstractList && o2 instanceof AbstractList) {
                                        AbstractList o1temp = (AbstractList)o1;
                                        AbstractList o2temp = (AbstractList)o2;
                                        return ((String)o1temp.get(1)).compareTo((String)o2temp.get(1));
                                    }
                                    return 0;
                                }
                            });
                        }
                    }
                });
                e.setControl((Control)f7);
                this.cacheControls.put(pagekey, (Control)f7);
            }
        }
    }

    public String getModelSign() {
        return model;
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }

    protected Map<String, SingleF7TypeEnum> getDimKeysFromCache() {
        if (this.map == null) {
            String serialDimKeys = this.getPageCache().get("dimKeyMap2Type");
            this.map = StringUtils.isNotEmpty((String)serialDimKeys) ? (Map)this.deSerializedBytes(serialDimKeys) : new HashMap(0);
        }
        return this.map;
    }

    protected Map<String, Object> getF7CustomData(String f7Key) {
        return null;
    }

    private long getDimId(String number) {
        return MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)number);
    }

    private void setColName(Map<String, Object> col, String name) {
        col.compute("fieldCaption", (kFC, vFC) -> new LocaleString(name).getLocaleValue());
    }

    private DynamicObject getDefaultExtendModel(String modelId) {
        DynamicObject defaultExtendModel = null;
        if (StringUtils.isNotEmpty((String)modelId)) {
            defaultExtendModel = BusinessDataServiceHelper.loadSingle((String)"bcm_extendsmodel", (String)"id,number,name", (QFilter[])new QFilter(model, "=", (Object)Long.parseLong(modelId)).and("extendsgroup.grouptype", "in", this.getNoEquityExtendGroupType()).toArray());
        }
        return defaultExtendModel;
    }

    private void setDefaultAudittrail(String modelId) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)modelNum, (String)SysDimensionEnum.AuditTrail.getNumber(), (String)"ATTotal");
        if (memberByNumber != IDNumberTreeNode.NotFoundTreeNode) {
            this.getModel().setValue(audittrail, (Object)memberByNumber.getId());
        }
    }

    private Map<String, String> getDimFieldMapped() {
        Map<String, String> dimsLoadMap;
        LinkedHashMap fieldMapped = Maps.newLinkedHashMap();
        long modelId = this.getModelId();
        QFilter filter = new QFilter(model, "=", (Object)modelId);
        String mappingStr = this.getPageCache().get("dimMapping_" + modelId);
        if (StringUtils.isEmpty((String)mappingStr)) {
            dimsLoadMap = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_dimension", (String)"number, fieldmapped", (QFilter[])new QFilter[]{filter})).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), dynamicObject -> dynamicObject.getString("fieldmapped")));
            this.getPageCache().put("dimMapping_" + modelId, this.toByteSerialized(dimsLoadMap));
        } else {
            dimsLoadMap = (Map<String, String>)this.deSerializedBytes(mappingStr);
        }
        dimsLoadMap.forEach((k, v) -> {
            String mapped = v;
            if (StringUtils.isEmpty((String)v)) {
                mapped = SysDimensionEnum.getEnumByNumber((String)k).getSign();
            }
            fieldMapped.put(k, mapped);
        });
        fieldMapped.put(ORG, ORG);
        return fieldMapped;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        String entityId = this.getView().getEntityId();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (DIM_KEYS.contains(name) || !(property instanceof BasedataProp ? this.getModel().getValue(name) == null : property instanceof MulBasedataProp && (this.getModel().getValue(name) == null || ((DynamicObjectCollection)this.getModel().getValue(name)).isEmpty()))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s", (String)"ExtendDataRptFormPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), property.getDisplayName()));
        }
        Map customParam = queryParam.getCustomParam();
        ExtendsModel extendsModel = (ExtendsModel)this.deSerializedBytes(this.getPageCache().get("extendsModel_" + ((DynamicObject)this.getModel().getValue(EXTEND_MODEL)).getLong("id")));
        customParam.put("extendDataEntity", this.getView().getPageCache().get("extendDataEntity"));
        customParam.put("extendsModel", extendsModel);
        boolean anyMatch = ((DynamicObjectCollection)this.getModel().getValue("mulentity")).stream().anyMatch(ent -> IDNumberTreeNode.NotFoundTreeNode == MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)ent.getLong("fbasedataid_id")));
        if (anyMatch) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7ec4\u7ec7", (String)"ExtendDataRptFormPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Object extendmodel = this.getModel().getValue(EXTEND_MODEL);
        if (extendmodel != null) {
            List fieldEntries = extendsModel.getFieldEntry();
            HashSet<String> fieldMaps = new HashSet<String>();
            for (FieldEntry fieldEntry : fieldEntries) {
                if (FieldTypeEnum.EXT_FIELD.getType() != fieldEntry.getFieldType() || fieldMaps.add(fieldEntry.getExtField().getMapped())) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u5b57\u6bb5\u4e0e\u540e\u53f0\u7269\u7406\u8868\u5b57\u6bb5\u6620\u5c04\u5b58\u5728\u91cd\u590d\u9519\u8bef\u3002", (String)"ExtendDataRptFormPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PANEL_AP3});
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PANEL_AP2});
        this.getPageCache().put("choise_model", LIST_MODEL);
        this.reportListBeforeQuery(queryParam);
    }

    private void reportListBeforeQuery(ReportQueryParam queryParam) {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        try {
            reportList.setSelectedAll(true);
        }
        catch (Throwable e) {
            log.error(e.getMessage());
        }
        List columns = reportList.getColumns();
        ExtendsModel extendsModel = (ExtendsModel)this.getQueryParam().getCustomParam().get("extendsModel");
        Map<String, String> dimFieldMapped = this.getDimFieldMapped();
        columns.add(this.addDefineColumn(ORG, new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ExtendDataRptFormPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "text"));
        columns.add(this.addDefineColumn("src_entity", new LocaleString(ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"ExtendDataRptFormPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "text"));
        for (String dimKey : DIM_KEYS) {
            if (dimKey.equals(entity)) continue;
            columns.add(this.addDefineColumn(dimKey.toLowerCase(Locale.ENGLISH) + FIX, new LocaleString(MemberReader.getDimensionNameById((long)MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)DimEntityNumEnum.getNumberByLowercaseNumber((String)dimKey)))), "text"));
        }
        for (FieldEntry fieldEntry : extendsModel.getFieldEntry()) {
            ReportColumn reportColumn;
            if (FieldTypeEnum.DIM_FIELD.getType() == fieldEntry.getFieldType()) {
                String name = fieldEntry.getDimension().getName();
                reportColumn = this.addDefineColumn(dimFieldMapped.get(fieldEntry.getDimension().getNumber()), new LocaleString(name), "text");
            } else {
                ExtField extField = fieldEntry.getExtField();
                reportColumn = extField.getMapped().contains("numext") ? this.addDefineColumn(extField.getMapped(), new LocaleString(extField.getName()), "decimal") : (extField.getMapped().contains("dateext") ? this.addDefineColumn(extField.getMapped(), new LocaleString(extField.getName()), "date") : this.addDefineColumn(extField.getMapped(), new LocaleString(extField.getName()), "text"));
            }
            columns.add(reportColumn);
        }
        super.beforeQuery(queryParam);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        Object amount = ThreadCache.get((Object)"amount");
        if (amount != null) {
            this.getPageCache().put("total", amount.toString());
        }
        this.writeLog(ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ExtendDataRptFormPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u67e5\u8be2\u62d3\u5c55\u6570\u636e\u6210\u529f", (String)"ExtendDataRptFormPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private List<String> getNoEquityExtendGroupType() {
        return Arrays.stream(ExtendDimGroupType.values()).filter(value -> value != ExtendDimGroupType.EQUITY).map(ExtendDimGroupType::getIndex).collect(Collectors.toList());
    }

    private void writeLog(String opName, String opDescription) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescription, (Long)this.getModelId(), (String)this.getModel().getDataEntityType().getName());
        logService.addLog(logInfo);
    }

    private ReportColumn addDefineColumn(String label, LocaleString localeString, String type) {
        ReportColumn reportColumn = new ReportColumn();
        if ("decimal".equals(type)) {
            reportColumn = new DecimalReportColumn();
            reportColumn.setScale(16);
            reportColumn.setNoDisplayScaleZero(true);
            ((DecimalReportColumn)reportColumn).setSummary(1);
        }
        reportColumn.setCaption(localeString);
        reportColumn.setWidth(new LocaleString("100px"));
        reportColumn.setFieldKey(label);
        reportColumn.setFieldType(type);
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("center");
        reportColumn.setStyle(columnStyle);
        return reportColumn;
    }

    @Override
    public long getModelId() {
        return this.getModel().getValue(model) instanceof DynamicObject ? ((DynamicObject)this.getModel().getValue(model)).getLong("id") : 0L;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "listmodel": {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PANEL_AP3});
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PANEL_AP2});
                this.getPageCache().put("choise_model", LIST_MODEL);
                break;
            }
            case "analysismodel": {
                if (this.getQueryParam().getFilter().getFilterItems().size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u70b9\u51fb\u67e5\u8be2\uff0c\u67e5\u51fa\u5206\u6790\u5fc5\u8981\u7684\u6570\u636e\u3002", (String)"ExtendDataRptFormPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.getQueryParam().getFilter().getFilterItems().stream().filter(x -> x.getPropName().startsWith(MUL) && x.getValue() != null).anyMatch(x -> ((DynamicObjectCollection)x.getValue()).size() > 1)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5206\u6790\u529f\u80fd\u6682\u4e0d\u652f\u6301\u7ef4\u5ea6\u6210\u5458\u591a\u9009\u3002", (String)"ExtendDataRptFormPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PANEL_AP2});
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PANEL_AP3});
                this.getPageCache().put("choise_model", ANALYSIS_MODEL);
                this.showAnalysisView();
                break;
            }
        }
    }

    private void showAnalysisView() {
        List filterItems = this.getQueryParam().getFilter().getFilterItems();
        if (filterItems.size() > 0) {
            HashMap dimMap = new HashMap(16);
            for (FilterItemInfo filterItem : filterItems) {
                Object value;
                String propName = filterItem.getPropName();
                if (process.equals(propName)) {
                    propName = propName.replace("_new", "");
                }
                if (model.equalsIgnoreCase(propName) || EXTEND_MODEL.equalsIgnoreCase(propName) || (value = filterItem.getValue()) == null) continue;
                DynamicObjectCollection dimMems = null;
                if (propName.startsWith(MUL)) {
                    dimMems = (DynamicObjectCollection)value;
                } else {
                    dimMems = new DynamicObjectCollection();
                    dimMems.add((Object)((DynamicObject)value));
                }
                ArrayList list = new ArrayList(10);
                for (DynamicObject dimMem : dimMems) {
                    HashMap<String, String> rangeMap = new HashMap<String, String>(16);
                    rangeMap.put("number", dimMem.getString("number"));
                    rangeMap.put("range", String.valueOf(RangeEnum.VALUE_10.getNumber()));
                    list.add(rangeMap);
                }
                propName = propName.startsWith(MUL) ? propName.substring(3) : propName;
                dimMap.put(SysDimensionEnum.getEnumByNumberIgnoreCase((String)propName).getShortnumber(), list);
            }
            FormShowParameter fs = new FormShowParameter();
            fs.setFormId("far_pivot");
            fs.getOpenStyle().setShowType(ShowType.InContainer);
            fs.getOpenStyle().setTargetKey(FLEX_PANEL_AP3);
            fs.setCustomParam("onlyAnalysis", (Object)Boolean.TRUE);
            Map commFilter = this.getQueryParam().getFilter().getCommFilter();
            if (commFilter.size() > 0) {
                QFilter value = (QFilter)commFilter.entrySet().iterator().next().getValue();
                fs.setCustomParam("filter", (Object)(value == null ? null : value.toSerializedString()));
            }
            fs.setCustomParam("modelId", (Object)this.getModelId());
            fs.setCustomParam("dimMap", dimMap);
            List extFieldEntries = (List)((ExtendsModel)this.getQueryParam().getCustomParam().get("extendsModel")).get("extfieldentry");
            fs.setCustomParam("fmoney", extFieldEntries.stream().map(x -> ((ExtField)x.get("extfield")).get("number").toString()).collect(Collectors.toSet()));
            fs.setCustomParam("extendsModelId", ((ExtendsModel)this.getQueryParam().getCustomParam().get("extendsModel")).get("id"));
            fs.setCustomParam("extendsModelNumber", ((ExtendsModel)this.getQueryParam().getCustomParam().get("extendsModel")).get("number"));
            fs.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
            this.getView().showForm(fs);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (key.equals("close")) {
            this.getView().close();
        }
    }
}

